/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BasicMonitoringAttributes implements MonitoringAttributes
{
    START_DATE(Message.EMPTY, "startTime"),
    CURRENT_DATE(Message.EMPTY, "currentTime"),
    CURRENT_CONNECTIONS(Message.EMPTY, "currentConnections"),
    MAX_CONNECTIONS(Message.EMPTY, "maxConnections"),
    TOTAL_CONNECTIONS(Message.EMPTY, "totalConnections"),
    AVERAGE_REQUEST_BACKLOG(AdminToolMessages.INFO_CTRL_PANEL_AVERAGE_REQUEST_BACKLOG.get(), "averageRequestBacklog"),
    MAX_REQUEST_BACKLOG(AdminToolMessages.INFO_CTRL_PANEL_MAX_REQUEST_BACKLOG.get(), "maxRequestBacklog"),
    CURRENT_REQUEST_BACKLOG(AdminToolMessages.INFO_CTRL_PANEL_CURRENT_REQUEST_BACKLOG.get(), "currentRequestBacklog"),
    REQUESTS_SUBMITTED(AdminToolMessages.INFO_CTRL_PANEL_REQUESTS_SUBMITTED.get(), "requestsSubmitted"),
    REQUESTS_REJECTED(AdminToolMessages.INFO_CTRL_PANEL_REQUESTS_REJECTED.get(), "requestsRejectedDueToQueueFull"),
    ENTRY_CACHE_HITS(AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHE_HITS.get(), "entryCacheHits"),
    CURRENT_ENTRY_CACHE_COUNT(AdminToolMessages.INFO_CTRL_PANEL_CURRENT_ENTRY_CACHE_COUNT.get(), "currentEntryCacheCount"),
    ENTRY_CACHE_TRIES(AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHE_TRIES.get(), "entryCacheTries"),
    ENTRY_CACHE_HIT_RATIO(AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHE_HIT_RATIO.get(), "entryCacheHitRatio"),
    CURRENT_ENTRY_CACHE_SIZE(AdminToolMessages.INFO_CTRL_PANEL_CURRENT_ENTRY_CACHE_SIZE.get(), "currentEntryCacheSize"),
    MAX_ENTRY_CACHE_SIZE(AdminToolMessages.INFO_CTRL_PANEL_MAX_ENTRY_CACHE_SIZE.get(), "maxEntryCacheSize"),
    MAX_ENTRY_CACHE_COUNT(AdminToolMessages.INFO_CTRL_PANEL_MAX_ENTRY_CACHE_COUNT.get(), "maxEntryCacheCount"),
    AVAILABLE_CPUS(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_CPUS.get(), "availableCPUs"),
    SYSTEM_NAME(AdminToolMessages.INFO_CTRL_PANEL_SYSTEM_NAME.get(), "systemName"),
    OPERATING_SYSTEM(AdminToolMessages.INFO_CTRL_PANEL_OPERATING_SYSTEM.get(), "operatingSystem"),
    FREE_USED_MEMORY(AdminToolMessages.INFO_CTRL_PANEL_FREE_USED_MEMORY.get(), "freeUsedMemory"),
    MAX_MEMORY(AdminToolMessages.INFO_CTRL_PANEL_MAX_MEMORY.get(), "maxMemory"),
    USED_MEMORY(AdminToolMessages.INFO_CTRL_PANEL_USED_MEMORY.get(), "usedMemory"),
    CLASS_PATH(AdminToolMessages.INFO_CTRL_PANEL_CLASS_PATH.get(), "classPath"),
    JAVA_VENDOR(AdminToolMessages.INFO_CTRL_PANEL_JAVA_VENDOR.get(), "javaVendor"),
    JVM_VENDOR(AdminToolMessages.INFO_CTRL_PANEL_JVM_VENDOR.get(), "javaVendor"),
    JAVA_VERSION(AdminToolMessages.INFO_CTRL_PANEL_JAVA_VERSION.get(), "javaVersion"),
    JVM_VERSION(AdminToolMessages.INFO_CTRL_PANEL_JVM_VERSION.get(), "jvmVersion"),
    JVM_ARCHITECTURE(AdminToolMessages.INFO_CTRL_PANEL_JVM_ARCHITECTURE.get(), "jvmArchitecture"),
    JVM_ARGUMENTS(AdminToolMessages.INFO_CTRL_PANEL_JVM_ARGUMENTS.get(), "jvmArguments"),
    ADD_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_ADD_REQUESTS_LABEL.get(), "addRequests"),
    ADD_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_ADD_RESPONSES_LABEL.get(), "addResponses"),
    BIND_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_BIND_REQUESTS_LABEL.get(), "bindRequests"),
    BIND_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_BIND_RESPONSES_LABEL.get(), "bindResponses"),
    COMPARE_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_COMPARE_REQUESTS_LABEL.get(), "compareRequests"),
    COMPARE_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_COMPARE_RESPONSES_LABEL.get(), "compareResponses"),
    DELETE_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_DELETE_REQUESTS_LABEL.get(), "deleteRequests"),
    DELETE_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_DELETE_RESPONSES_LABEL.get(), "deleteResponses"),
    EXTENDED_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_EXTENDED_REQUESTS_LABEL.get(), "extendedRequests"),
    EXTENDED_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_EXTENDED_RESPONSES_LABEL.get(), "extendedResponses"),
    MOD_DN_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_MOD_DN_REQUESTS_LABEL.get(), "modifyDNRequests"),
    MOD_DN_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_MOD_DN_RESPONSES_LABEL.get(), "modifyDNResponses"),
    MOD_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_MOD_REQUESTS_LABEL.get(), "modifyRequests"),
    MOD_RESPONSES(AdminToolMessages.INFO_CTRL_PANEL_MOD_RESPONSES_LABEL.get(), "modifyResponses"),
    SEARCH_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_SEARCH_REQUESTS_LABEL.get(), "searchRequests"),
    SEARCH_DONE(AdminToolMessages.INFO_CTRL_PANEL_SEARCH_DONE_LABEL.get(), "searchResultsDone"),
    UNBIND_REQUESTS(AdminToolMessages.INFO_CTRL_PANEL_UNBIND_REQUESTS_LABEL.get(), "unbindRequests");

    private Message msg;
    private String attributeName;
    private boolean isAborted;
    private boolean isNumeric;
    private boolean isGMTDate;
    private boolean isValueInBytes;
    private boolean canHaveAverage;
    private boolean isTime;

    private BasicMonitoringAttributes(Message msg, String attributeName) {
        this.msg = msg;
        this.attributeName = attributeName;
    }

    @Override
    public Message getMessage() {
        return this.msg;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isAborted() {
        return this.isAborted;
    }

    @Override
    public boolean isNumeric() {
        return this.isNumeric;
    }

    @Override
    public boolean isTime() {
        return this.isTime;
    }

    @Override
    public boolean isGMTDate() {
        return this.isGMTDate;
    }

    @Override
    public boolean isValueInBytes() {
        return this.isValueInBytes;
    }

    @Override
    public boolean canHaveAverage() {
        return this.canHaveAverage;
    }

    @Override
    public boolean isNumericDate() {
        return false;
    }

    private void calculateProperties() {
        this.isAborted = this.attributeName.indexOf("ds-mon-aborted-") == 0;
        this.canHaveAverage = this.attributeName.endsWith("total-count") || this.attributeName.endsWith("Requests") || this.attributeName.endsWith("Responses") || this == SEARCH_DONE;
        this.isGMTDate = this == START_DATE || this == CURRENT_DATE;
        this.isValueInBytes = this == FREE_USED_MEMORY || this == MAX_MEMORY || this == USED_MEMORY;
        this.isTime = this.attributeName.indexOf("time") != -1;
        this.isNumeric = !this.isGMTDate() && this != SYSTEM_NAME && this != OPERATING_SYSTEM && this != CLASS_PATH && this != JAVA_VENDOR && this != JVM_VENDOR && this != JAVA_VERSION && this != JVM_VERSION && this != JVM_ARCHITECTURE && this != JVM_ARGUMENTS;
    }

    static {
        for (BasicMonitoringAttributes attr : BasicMonitoringAttributes.values()) {
            attr.calculateProperties();
        }
    }
}

