/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableListModel<T>
extends AbstractListModel {
    private static final long serialVersionUID = 3241258779190228463L;
    private SortedSet<T> data = new TreeSet<T>();

    @Override
    public int getSize() {
        return this.data.size();
    }

    public void setComparator(Comparator<T> comp) {
        SortedSet<T> copy = this.data;
        this.data = new TreeSet<T>(comp);
        this.data.addAll(copy);
    }

    @Override
    public T getElementAt(int i) {
        int index = 0;
        for (Object element : this.data) {
            if (index == i) {
                return (T)element;
            }
            ++index;
        }
        throw new ArrayIndexOutOfBoundsException("The index " + i + " is bigger than the maximum size: " + this.getSize());
    }

    public void add(T value) {
        this.data.add(value);
    }

    public boolean remove(T value) {
        return this.data.remove(value);
    }

    public void clear() {
        this.data.clear();
    }

    public void addAll(Collection<T> newData) {
        this.data.addAll(newData);
    }

    @Override
    public void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    public SortedSet<T> getData() {
        return new TreeSet<T>(this.data);
    }
}

