/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexTableModel;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class VLVIndexTableModel
extends AbstractIndexTableModel {
    private static final long serialVersionUID = 897379916278218775L;

    protected String[] getColumnNames() {
        return new String[]{this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_NAME.get()), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_BASE_DN.get(), 30), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_SCOPE.get()), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_FILTER.get()), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_SORT_ORDER.get(), 30), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_HEADER_REQUIRES_REBUILD.get(), 30)};
    }

    public int compare(AbstractIndexDescriptor index1, AbstractIndexDescriptor index2) {
        VLVIndexDescriptor i1 = (VLVIndexDescriptor)index1;
        VLVIndexDescriptor i2 = (VLVIndexDescriptor)index2;
        int[] possibleResults = new int[]{this.compareNames(i1, i2), this.compareBaseDNs(i1, i2), this.compareScopes(i1, i2), this.compareFilters(i1, i2), this.compareSortOrders(i1, i2), this.compareRebuildRequired(i1, i2)};
        int result = possibleResults[this.sortColumn];
        if (result == 0) {
            for (int i : possibleResults) {
                if (i == 0) continue;
                result = i;
                break;
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    protected String[] getLine(AbstractIndexDescriptor index) {
        VLVIndexDescriptor i = (VLVIndexDescriptor)index;
        return new String[]{i.getName(), this.getDNValue(i), this.getScopeDisplayValue(i), i.getFilter(), this.getSortOrderDisplayValue(i), this.getRebuildRequiredString(i).toString()};
    }

    private String getDNValue(VLVIndexDescriptor i) {
        return Utilities.unescapeUtf8(i.getBaseDN().toString());
    }

    private String getScopeStringValue(VLVIndexDescriptor i) {
        String s;
        switch (i.getScope()) {
            case BASE_OBJECT: {
                s = "Base Object";
                break;
            }
            case SINGLE_LEVEL: {
                s = "Single Level";
                break;
            }
            case WHOLE_SUBTREE: {
                s = "Whole Subtree";
                break;
            }
            case SUBORDINATE_SUBTREE: {
                s = "Subordinate Subtree";
                break;
            }
            default: {
                throw new RuntimeException("Unknown scope: " + (Object)((Object)i.getScope()));
            }
        }
        return s;
    }

    private String getScopeDisplayValue(VLVIndexDescriptor i) {
        return "<html>" + this.getScopeStringValue(i);
    }

    private String getSortOrderStringValue(VLVIndexDescriptor i) {
        StringBuilder sb = new StringBuilder();
        for (VLVSortOrder sortOrder : i.getSortOrder()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sortOrder.getAttributeName());
            if (sortOrder.isAscending()) {
                sb.append(" (ascending)");
                continue;
            }
            sb.append(" (descending)");
        }
        if (sb.length() == 0) {
            sb.append(AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString());
        }
        return sb.toString();
    }

    private String getSortOrderDisplayValue(VLVIndexDescriptor i) {
        return "<html>" + this.getSortOrderStringValue(i).replaceAll(", ", ",<br>");
    }

    private int compareBaseDNs(VLVIndexDescriptor i1, VLVIndexDescriptor i2) {
        return this.getDNValue(i1).compareTo(this.getDNValue(i2));
    }

    private int compareScopes(VLVIndexDescriptor i1, VLVIndexDescriptor i2) {
        return this.getScopeStringValue(i1).compareTo(this.getScopeStringValue(i2));
    }

    private int compareFilters(VLVIndexDescriptor i1, VLVIndexDescriptor i2) {
        return i1.getFilter().compareTo(i2.getFilter());
    }

    private int compareSortOrders(VLVIndexDescriptor i1, VLVIndexDescriptor i2) {
        return this.getSortOrderStringValue(i1).compareTo(this.getSortOrderStringValue(i2));
    }
}

