/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToGroupTask
extends Task {
    private Set<String> backendSet;
    private LinkedHashSet<DN> dns = new LinkedHashSet();
    private LinkedHashSet<DN> groupDns = new LinkedHashSet();

    public AddToGroupTask(ControlPanelInfo info, ProgressDialog dlg, Set<DN> dns, Set<DN> groupDns) {
        super(info, dlg);
        this.backendSet = new HashSet<String>();
        this.dns.addAll(dns);
        this.groupDns.addAll(groupDns);
        for (DN groupDn : groupDns) {
            for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (!groupDn.isDescendantOf(baseDN.getDn())) continue;
                    this.backendSet.add(backend.getBackendID());
                }
            }
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_TASK_DESCRIPTION.get();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            for (final DN groupDn : this.groupDns) {
                final Collection<ModificationItem> modifications = this.getModifications(groupDn, this.dns);
                if (modifications.size() <= 0) continue;
                ModificationItem[] mods = new ModificationItem[modifications.size()];
                modifications.toArray(mods);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AddToGroupTask.this.printEquivalentCommandToModify(groupDn, (Collection<ModificationItem>)modifications, false);
                        AddToGroupTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_ADDING_TO_GROUP.get(groupDn.toString()), ColorAndFontConstants.progressFont));
                    }
                });
                this.getInfo().getDirContext().modifyAttributes(Utilities.getJNDIName(groupDn.toString()), mods);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AddToGroupTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ModificationItem> getModifications(DN groupDn, Set<DN> dns) throws NamingException {
        ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"uniqueMember"});
        String filter = "(|(objectClass=*)(objectClass=ldapsubentry))";
        NamingEnumeration<SearchResult> result = this.getInfo().getDirContext().search(Utilities.getJNDIName(groupDn.toString()), filter, ctls);
        try {
            while (result.hasMore()) {
                SearchResult sr = result.next();
                Set<String> values = ConnectionUtils.getValues(sr, "uniqueMember");
                LinkedHashSet<String> dnsToAdd = new LinkedHashSet<String>();
                if (values != null) {
                    for (DN newDn : dns) {
                        boolean found = false;
                        for (String dn : values) {
                            if (!Utilities.areDnsEqual(dn, newDn.toString())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        dnsToAdd.add(newDn.toString());
                    }
                } else {
                    for (DN newDn : dns) {
                        dnsToAdd.add(newDn.toString());
                    }
                }
                if (dnsToAdd.size() <= 0) continue;
                BasicAttribute attribute = new BasicAttribute("uniqueMember");
                for (String dn : dnsToAdd) {
                    attribute.add(dn);
                }
                modifications.add(new ModificationItem(1, attribute));
            }
        }
        finally {
            result.close();
        }
        return modifications;
    }
}

