/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexTableModel;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.IndexSelectionEvent;
import org.opends.guitools.controlpanel.event.IndexSelectionListener;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.SelectableTableCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public abstract class AbstractBackendIndexesPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 2702054131388877743L;
    private String backendName;
    protected AbstractIndexTableModel tableModel;
    protected JTable table;
    protected JScrollPane tableScroll;
    private Set<IndexSelectionListener> indexListeners = new HashSet<IndexSelectionListener>();
    private int lastRowMouseOver = -1;

    protected AbstractBackendIndexesPanel() {
        this.createLayout();
    }

    public Component getPreferredFocusComponent() {
        return this.table;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        this.update(this.backendName);
    }

    public void update(String backendName) {
        this.backendName = backendName;
        BackendDescriptor backend = null;
        for (BackendDescriptor b : this.getInfo().getServerDescriptor().getBackends()) {
            if (!b.getBackendID().equals(backendName)) continue;
            backend = b;
            break;
        }
        if (backend != null) {
            final BackendDescriptor b = backend;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractBackendIndexesPanel.this.updateTableModel(b);
                    Utilities.updateTableSizes(AbstractBackendIndexesPanel.this.table);
                    Utilities.updateScrollMode(AbstractBackendIndexesPanel.this.tableScroll, AbstractBackendIndexesPanel.this.table);
                }
            });
        } else {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_BACKEND_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_BACKEND_NOT_FOUND_DETAILS.get(backendName), ColorAndFontConstants.defaultFont);
        }
    }

    protected abstract void updateTableModel(BackendDescriptor var1);

    public void okClicked() {
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    public void addIndexSelectionListener(IndexSelectionListener listener) {
        this.indexListeners.add(listener);
    }

    public void removeIndexSelectionListener(IndexSelectionListener listener) {
        this.indexListeners.remove(listener);
    }

    protected abstract AbstractIndexTableModel getIndexTableModel();

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        this.tableModel = this.getIndexTableModel();
        SelectableTableCellRenderer renderer = new SelectableTableCellRenderer();
        this.table = Utilities.createSortableTable(this.tableModel, renderer);
        renderer.setTable(this.table);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDragEnabled(false);
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent ev) {
                int selectedRow = AbstractBackendIndexesPanel.this.table.getSelectedRow();
                if (selectedRow != -1 && AbstractBackendIndexesPanel.this.lastRowMouseOver == selectedRow) {
                    AbstractIndexDescriptor index = AbstractBackendIndexesPanel.this.tableModel.getIndexAt(selectedRow);
                    final IndexSelectionEvent ise = new IndexSelectionEvent(AbstractBackendIndexesPanel.this.table, index);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (IndexSelectionListener listener : AbstractBackendIndexesPanel.this.indexListeners) {
                                listener.indexSelected(ise);
                            }
                        }
                    });
                }
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent ev) {
                AbstractBackendIndexesPanel.this.lastRowMouseOver = AbstractBackendIndexesPanel.this.table.rowAtPoint(ev.getPoint());
            }

            public void mouseDragged(MouseEvent ev) {
                AbstractBackendIndexesPanel.this.lastRowMouseOver = -1;
            }
        });
        this.tableScroll = Utilities.createBorderLessScrollBar(this.table);
        this.tableScroll.getViewport().setOpaque(false);
        this.tableScroll.setOpaque(false);
        this.tableScroll.getViewport().setBackground(ColorAndFontConstants.background);
        this.tableScroll.setBackground(ColorAndFontConstants.background);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.tableScroll, gbc);
    }
}

