/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.types.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 4465529396749593707L;
    protected TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    protected JComboBox attributes = Utilities.createComboBox();
    protected JLabel name = Utilities.createDefaultLabel();
    protected JLabel lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
    protected JLabel backendName = Utilities.createDefaultLabel();
    protected JLabel lAttribute = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_LABEL.get());
    protected JLabel lEntryLimit = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ENTRY_LIMIT_LABEL.get());
    protected JTextField entryLimit = Utilities.createShortTextField();
    protected JLabel lType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INDEX_TYPE_LABEL.get());
    protected JCheckBox approximate = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_APPROXIMATE_LABEL.get());
    protected JCheckBox equality = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_EQUALITY_LABEL.get());
    protected JCheckBox ordering = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ORDERING_LABEL.get());
    protected JCheckBox presence = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_PRESENCE_LABEL.get());
    protected JCheckBox substring = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_SUBSTRING_LABEL.get());
    protected JButton deleteIndex = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_LABEL.get());
    protected JButton saveChanges = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_CHANGES_LABEL.get());
    protected JLabel warning = Utilities.createDefaultLabel();
    protected JPanel typesPanel = new JPanel(new GridBagLayout());
    protected Message NON_CONFIGURABLE_INDEX = AdminToolMessages.INFO_CTRL_PANEL_NON_CONFIGURABLE_INDEX_LABEL.get();
    protected Message INDEX_MODIFIED = AdminToolMessages.INFO_CTRL_PANEL_INDEX_MODIFIED_LABEL.get();
    protected JCheckBox[] types = new JCheckBox[]{this.approximate, this.equality, this.ordering, this.presence, this.substring};
    protected LocalDBIndexCfgDefn.IndexType[] configTypes = new LocalDBIndexCfgDefn.IndexType[]{LocalDBIndexCfgDefn.IndexType.APPROXIMATE, LocalDBIndexCfgDefn.IndexType.EQUALITY, LocalDBIndexCfgDefn.IndexType.ORDERING, LocalDBIndexCfgDefn.IndexType.PRESENCE, LocalDBIndexCfgDefn.IndexType.SUBSTRING};
    protected Message CUSTOM_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_ATTRIBUTES_LABEL.get();
    protected Message STANDARD_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_STANDARD_ATTRIBUTES_LABEL.get();
    protected final int MIN_ENTRY_LIMIT = LocalDBIndexCfgDefn.getInstance().getIndexEntryLimitPropertyDefinition().getLowerLimit();
    protected final int MAX_ENTRY_LIMIT = LocalDBIndexCfgDefn.getInstance().getIndexEntryLimitPropertyDefinition().getUpperLimit();
    protected final int DEFAULT_ENTRY_LIMIT = 4000;

    protected void repopulateTypesPanel(AttributeType attr) {
        this.typesPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        if (attr != null) {
            if (attr.getApproximateMatchingRule() != null) {
                this.typesPanel.add((Component)this.approximate, gbc);
                gbc.insets.top = 10;
                ++gbc.gridy;
            }
            if (attr.getEqualityMatchingRule() != null) {
                this.typesPanel.add((Component)this.equality, gbc);
                gbc.insets.top = 10;
                ++gbc.gridy;
            }
            if (attr.getOrderingMatchingRule() != null) {
                this.typesPanel.add((Component)this.ordering, gbc);
                gbc.insets.top = 10;
                ++gbc.gridy;
            }
            this.typesPanel.add((Component)this.presence, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.typesPanel.add(Box.createHorizontalGlue(), gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.insets.top = 10;
            if (attr.getSubstringMatchingRule() != null) {
                this.typesPanel.add((Component)this.substring, gbc);
                gbc.insets.top = 10;
            }
        }
        this.typesPanel.validate();
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc, boolean nameReadOnly) {
        GridBagConstraints gbc2;
        JPanel p;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(c, gbc);
        if (nameReadOnly) {
            ++gbc.gridy;
            this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_INDEX_DETAILS_LABEL.get());
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets.top = 10;
            gbc.weightx = 1.0;
            p = new JPanel(new GridBagLayout());
            p.setOpaque(false);
            c.add((Component)p, gbc);
            gbc2 = new GridBagConstraints();
            gbc2.weightx = 0.0;
            gbc2.gridwidth = -1;
            p.add((Component)this.titlePanel, gbc2);
            gbc2.gridwidth = 0;
            gbc2.fill = 2;
            gbc2.weightx = 1.0;
            p.add(Box.createHorizontalGlue(), gbc2);
        }
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        c.add((Component)this.lAttribute, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        if (!nameReadOnly) {
            this.attributes.addItemListener(new StatusGenericPanel.IgnoreItemListener(this, this.attributes));
            this.attributes.setRenderer(new CustomListCellRenderer(this.attributes));
            c.add((Component)this.attributes, gbc);
        } else {
            c.add((Component)this.name, gbc);
        }
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        c.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        c.add((Component)this.backendName, gbc);
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        c.add((Component)this.lEntryLimit, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        c.add((Component)p, gbc);
        gbc2 = new GridBagConstraints();
        gbc2.weightx = 0.0;
        gbc2.gridwidth = -1;
        p.add((Component)this.entryLimit, gbc2);
        gbc2.gridwidth = 0;
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        p.add(Box.createHorizontalGlue(), gbc2);
        gbc.gridx = 0;
        gbc.insets.left = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        c.add((Component)this.lType, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        JCheckBox[] types = new JCheckBox[]{this.approximate, this.equality, this.ordering, this.presence, this.substring};
        this.typesPanel.setOpaque(false);
        c.add((Component)this.typesPanel, gbc);
        ++gbc.gridy;
        gbc2 = new GridBagConstraints();
        gbc.gridwidth = 0;
        for (int i = 0; i < types.length; ++i) {
            types[i].setOpaque(false);
            this.typesPanel.add((Component)types[i], gbc2);
            gbc2.anchor = 17;
            gbc2.insets.top = 10;
        }
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.fill = 3;
        c.add(Box.createVerticalGlue(), gbc);
    }

    protected SortedSet<LocalDBIndexCfgDefn.IndexType> getTypes() {
        TreeSet<LocalDBIndexCfgDefn.IndexType> indexTypes = new TreeSet<LocalDBIndexCfgDefn.IndexType>();
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            indexTypes.add(this.configTypes[i]);
        }
        return indexTypes;
    }

    protected List<Message> getErrors() {
        ArrayList<Message> errors = new ArrayList<Message>();
        this.setPrimaryValid(this.lEntryLimit);
        this.setPrimaryValid(this.lType);
        String newEntryLimit = this.entryLimit.getText().trim();
        try {
            int n = Integer.parseInt(newEntryLimit);
            if (n < this.MIN_ENTRY_LIMIT || n > this.MAX_ENTRY_LIMIT) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_ENTRY_LIMIT_LABEL.get(this.MIN_ENTRY_LIMIT, this.MAX_ENTRY_LIMIT));
                this.setPrimaryInvalid(this.lEntryLimit);
            }
        }
        catch (Throwable t) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_ENTRY_LIMIT_LABEL.get(this.MIN_ENTRY_LIMIT, this.MAX_ENTRY_LIMIT));
            this.setPrimaryInvalid(this.lEntryLimit);
        }
        if (this.getTypes().isEmpty()) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_INDEX_TYPE_SELECTED.get());
            this.setPrimaryInvalid(this.lType);
        }
        return errors;
    }
}

