/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.Base64;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFViewEntryPanel
extends ViewEntryPanel {
    private static final long serialVersionUID = 2775960608128921072L;
    private JScrollPane editableScroll;
    private JScrollPane readOnlyScroll;
    private JTextArea editableAttributes;
    private JTextArea readOnlyAttributes;
    private CustomSearchResult searchResult;

    public LDIFViewEntryPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.editableAttributes;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.addTitlePanel(this, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.editableAttributes = Utilities.createTextArea(Message.EMPTY, 20, 30);
        this.editableAttributes.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                LDIFViewEntryPanel.this.notifyListeners();
            }

            public void changedUpdate(DocumentEvent ev) {
                LDIFViewEntryPanel.this.notifyListeners();
            }

            public void removeUpdate(DocumentEvent ev) {
                LDIFViewEntryPanel.this.notifyListeners();
            }
        });
        gbc.weighty = 0.6;
        gbc.fill = 1;
        ++gbc.gridy;
        this.editableScroll = Utilities.createScrollPane(this.editableAttributes);
        this.add((Component)this.editableScroll, gbc);
        gbc.weighty = 0.0;
        gbc.insets.top = 10;
        JLabel lReadOnly = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NON_EDITABLE_ATTRIBUTES.get());
        ++gbc.gridy;
        this.add((Component)lReadOnly, gbc);
        gbc.insets.top = 5;
        this.readOnlyAttributes = Utilities.createNonEditableTextArea(Message.EMPTY, 10, 30);
        gbc.weightx = 1.0;
        gbc.weighty = 0.4;
        gbc.fill = 1;
        ++gbc.gridy;
        this.readOnlyScroll = Utilities.createScrollPane(this.readOnlyAttributes);
        this.add((Component)this.readOnlyScroll, gbc);
    }

    @Override
    public void update(CustomSearchResult sr, boolean isReadOnly, TreePath path) {
        boolean sameEntry = false;
        if (sr != null) {
            sr = this.filterSearchResult(sr);
        }
        if (this.searchResult != null && sr != null) {
            sameEntry = this.searchResult.getDN().equals(sr.getDN());
        }
        this.searchResult = sr;
        this.updateTitle(sr, path);
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + sr.getDN());
        if (isReadOnly) {
            this.editableScroll.setVisible(false);
            for (String attrName : sr.getAttributeNames()) {
                List<Object> values = sr.getAttributeValues(attrName);
                for (Object o : values) {
                    sb.append("\n" + this.getLDIFLine(attrName, o));
                }
            }
            final Point p1 = sameEntry ? this.readOnlyScroll.getViewport().getViewPosition() : new Point(0, 0);
            this.readOnlyAttributes.setText(sb.toString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (p1 != null && LDIFViewEntryPanel.this.readOnlyScroll.getViewport().contains(p1)) {
                        LDIFViewEntryPanel.this.readOnlyScroll.getViewport().setViewPosition(p1);
                    }
                }
            });
        } else {
            this.editableScroll.setVisible(true);
            for (String attrName : sr.getAttributeNames()) {
                if (this.schemaReadOnlyAttributesLowerCase.contains(attrName.toLowerCase())) continue;
                List<Object> values = sr.getAttributeValues(attrName);
                for (Object o : values) {
                    sb.append("\n" + this.getLDIFLine(attrName, o));
                }
            }
            final Point p1 = sameEntry ? this.editableScroll.getViewport().getViewPosition() : new Point(0, 0);
            this.ignoreEntryChangeEvents = true;
            this.editableAttributes.setText(sb.toString());
            this.ignoreEntryChangeEvents = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (p1 != null && LDIFViewEntryPanel.this.editableScroll.getViewport().contains(p1)) {
                        LDIFViewEntryPanel.this.editableScroll.getViewport().setViewPosition(p1);
                    }
                }
            });
            boolean oneLineAdded = false;
            sb = new StringBuilder();
            for (String attrName : this.schemaReadOnlyAttributes) {
                List<Object> values = sr.getAttributeValues(attrName);
                for (Object o : values) {
                    if (oneLineAdded) {
                        sb.append("\n");
                    }
                    oneLineAdded = true;
                    sb.append(this.getLDIFLine(attrName, o));
                }
            }
            final Point p2 = sameEntry ? this.readOnlyScroll.getViewport().getViewPosition() : new Point(0, 0);
            this.readOnlyAttributes.setText(sb.toString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (p2 != null && LDIFViewEntryPanel.this.readOnlyScroll.getViewport().contains(p2)) {
                        LDIFViewEntryPanel.this.readOnlyScroll.getViewport().setViewPosition(p2);
                    }
                }
            });
        }
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    @Override
    protected String getDisplayedDN() {
        int index2;
        String dn = null;
        String ldif = this.getLDIF();
        int index = ldif.toLowerCase().indexOf("dn: ");
        if (index != -1 && (index2 = ldif.indexOf("\n", index)) != -1) {
            dn = ldif.substring(index + 3, index2).trim();
        }
        return dn;
    }

    @Override
    protected List<Object> getValues(String attrName) {
        throw new IllegalStateException("This method should not be called.");
    }

    @Override
    public Entry getEntry() throws OpenDsException {
        Entry entry = null;
        LDIFImportConfig ldifImportConfig = null;
        try {
            String ldif = this.getLDIF();
            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            entry = reader.readEntry(this.checkSchema());
            this.addValuesInRDN(entry);
        }
        catch (IOException ioe) {
            throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()), (Throwable)ioe);
        }
        finally {
            if (ldifImportConfig != null) {
                ldifImportConfig.close();
            }
        }
        return entry;
    }

    private String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.editableAttributes.getText());
        return sb.toString();
    }

    private String getLDIFLine(String attrName, Object o) {
        String attrValue;
        if (o instanceof String) {
            attrValue = (String)o;
        } else if (o instanceof byte[]) {
            attrValue = Base64.encode((byte[])o);
            attrName = attrName + ":";
        } else {
            attrValue = String.valueOf(o);
        }
        return attrName + ": " + attrValue;
    }
}

