/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewOrganizationPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = 6560126551083160773L;
    protected final JLabel lName = Utilities.createPrimaryLabel();
    protected final JLabel lDescription = Utilities.createPrimaryLabel();
    protected final JLabel lDn = Utilities.createPrimaryLabel();
    protected final JLabel[] labels = new JLabel[]{this.lName, this.lDescription, this.lDn};
    protected final JTextField name = Utilities.createLongTextField();
    protected final JTextField description = Utilities.createLongTextField();
    protected final JLabel dn = Utilities.createDefaultLabel();
    protected final Component[] comps = new Component[]{this.name, this.description, this.dn};

    public NewOrganizationPanel() {
        this.createLayout();
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        this.dn.setText("," + parentNode.getDN());
        for (Component comp : this.comps) {
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setText("");
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_NEW_ORGANIZATION_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_NEW_ORGANIZATION_PANEL_TITLE.get();
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        JTextField[] requiredFields = new JTextField[]{this.name};
        Message[] msgs = new Message[]{AdminToolMessages.ERR_CTRL_PANEL_NAME_OF_ORGANIZATION_REQUIRED.get()};
        for (int i = 0; i < requiredFields.length; ++i) {
            String v = requiredFields[i].getText().trim();
            if (v.length() != 0) continue;
            errors.add(msgs[i]);
        }
    }

    private void createLayout() {
        JTextField[] toAddListener;
        GridBagConstraints gbc = new GridBagConstraints();
        Message[] ls = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATION_NAME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATION_DESCRIPTION_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_ORGANIZATION_ENTRY_DN_LABEL.get()};
        int i = 0;
        for (Message l : ls) {
            this.labels[i].setText(l.toString());
            ++i;
        }
        Utilities.setRequiredIcon(this.lName);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        Component[] inlineHelp = new Component[]{null, null, null};
        for (i = 0; i < this.labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            this.add((Component)this.labels[i], gbc);
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            this.add(this.comps[i], gbc);
            if (inlineHelp[i] != null) {
                gbc.insets.top = 3;
                ++gbc.gridy;
                this.add(inlineHelp[i], gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        this.addBottomGlue(gbc);
        DocumentListener listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                NewOrganizationPanel.this.updateDNValue();
            }

            public void changedUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }

            public void removeUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }
        };
        for (JTextField tf : toAddListener = new JTextField[]{this.name}) {
            tf.getDocument().addDocumentListener(listener);
        }
    }

    protected void updateDNValue() {
        String value = this.name.getText().trim();
        if (value.length() > 0) {
            String rdn = Utilities.getRDNString("o", value);
            this.dn.setText(rdn + "," + this.parentNode.getDN());
        } else {
            this.dn.setText("," + this.parentNode.getDN());
        }
    }

    @Override
    protected String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.dn.getText() + "\n");
        String[] attrNames = new String[]{"o", "description"};
        JTextField[] textFields = new JTextField[]{this.name, this.description};
        sb.append("objectclass: top\n");
        sb.append("objectclass: organization\n");
        for (int i = 0; i < attrNames.length; ++i) {
            String value = textFields[i].getText().trim();
            if (value.length() <= 0) continue;
            sb.append(attrNames[i] + ": " + value + "\n");
        }
        return sb.toString();
    }
}

