/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class UnsavedChangesDialog
extends GenericDialog {
    private static final long serialVersionUID = -4436794801035162388L;

    public UnsavedChangesDialog(Component parentDialog, ControlPanelInfo info) {
        super(Utilities.getFrame(parentDialog), UnsavedChangesDialog.getPanel(info));
        Utilities.centerGoldenMean(this, parentDialog);
        this.getRootPane().setDefaultButton(((UnsavedChangesPanel)this.panel).saveButton);
        this.setModal(true);
    }

    public void setMessage(Message title, Message details) {
        this.panel.updateConfirmationPane(this.panel.errorPane, title, ColorAndFontConstants.errorTitleFont, details, ColorAndFontConstants.defaultFont);
        this.invalidate();
        this.pack();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((UnsavedChangesPanel)this.panel).result = Result.CANCEL;
        }
        super.setVisible(visible);
    }

    public Result getResult() {
        return ((UnsavedChangesPanel)this.panel).result;
    }

    private static StatusGenericPanel getPanel(ControlPanelInfo info) {
        UnsavedChangesPanel panel = new UnsavedChangesPanel();
        panel.setInfo(info);
        return panel;
    }

    private static class UnsavedChangesPanel
    extends StatusGenericPanel {
        private static final long serialVersionUID = -1528939816762604059L;
        private JButton saveButton;
        private JButton doNotSaveButton;
        private JButton cancelButton;
        private Result result;

        public UnsavedChangesPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.addErrorPane(gbc);
            this.errorPane.setVisible(true);
            ++gbc.gridy;
            gbc.fill = 3;
            gbc.weighty = 1.0;
            this.add(Box.createVerticalGlue(), gbc);
            gbc.fill = 2;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.createButtonsPanel(), gbc);
        }

        public boolean requiresBorder() {
            return false;
        }

        public boolean requiresScroll() {
            return false;
        }

        private JPanel createButtonsPanel() {
            JPanel buttonsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 1;
            gbc.gridy = 0;
            this.doNotSaveButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DO_NOT_SAVE_BUTTON_LABEL.get());
            this.doNotSaveButton.setOpaque(false);
            gbc.insets = new Insets(10, 10, 10, 10);
            buttonsPanel.add((Component)this.doNotSaveButton, gbc);
            this.doNotSaveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    UnsavedChangesPanel.this.result = Result.DO_NOT_SAVE;
                    UnsavedChangesPanel.this.cancelClicked();
                }
            });
            gbc.weightx = 1.0;
            ++gbc.gridx;
            buttonsPanel.add(Box.createHorizontalStrut(150));
            buttonsPanel.add(Box.createHorizontalGlue(), gbc);
            buttonsPanel.setOpaque(true);
            buttonsPanel.setBackground(ColorAndFontConstants.greyBackground);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            buttonsPanel.add(Box.createHorizontalStrut(100));
            ++gbc.gridx;
            this.cancelButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CANCEL_BUTTON_LABEL.get());
            this.cancelButton.setOpaque(false);
            gbc.insets.right = 0;
            buttonsPanel.add((Component)this.cancelButton, gbc);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    UnsavedChangesPanel.this.result = Result.CANCEL;
                    UnsavedChangesPanel.this.cancelClicked();
                }
            });
            this.saveButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_BUTTON_LABEL.get());
            this.saveButton.setOpaque(false);
            ++gbc.gridx;
            gbc.insets.left = 5;
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.saveButton, gbc);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    UnsavedChangesPanel.this.result = Result.SAVE;
                    UnsavedChangesPanel.this.cancelClicked();
                }
            });
            buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
            return buttonsPanel;
        }

        public Component getPreferredFocusComponent() {
            return this.doNotSaveButton;
        }

        public void okClicked() {
        }

        public Message getTitle() {
            return AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_DIALOG_TITLE.get();
        }

        public void configurationChanged(ConfigurationChangeEvent ev) {
        }

        public GenericDialog.ButtonType getButtonType() {
            return GenericDialog.ButtonType.NO_BUTTON;
        }

        public boolean isDisposeOnClose() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        SAVE,
        DO_NOT_SAVE,
        CANCEL;

    }
}

