/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteIndexTask;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.AbstractVLVIndexPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBVLVIndexCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.cli.CommandBuilder;

public class VLVIndexPanel
extends AbstractVLVIndexPanel {
    private static final long serialVersionUID = 6333337497315464283L;
    private JButton deleteIndex = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_LABEL.get());
    private JButton saveChanges = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_CHANGES_LABEL.get());
    private JLabel warning = Utilities.createDefaultLabel();
    private ScrollPaneBorderListener scrollListener;
    private ModifyVLVIndexTask newModifyTask;
    private boolean ignoreCheckSave;
    private Message INDEX_MODIFIED = AdminToolMessages.INFO_CTRL_PANEL_INDEX_MODIFIED_MESSAGE.get();
    private VLVIndexDescriptor index;

    public VLVIndexPanel() {
        super(null, null);
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_PANEL_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.baseDN;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        final ServerDescriptor desc = ev.getNewDescriptor();
        if (this.updateLayout(desc)) {
            this.updateErrorPaneIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_VLV_INDEX_EDITING.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VLVIndexPanel.this.checkSaveButton();
                    VLVIndexPanel.this.deleteIndex.setEnabled(!VLVIndexPanel.this.authenticationRequired(desc));
                }
            });
        }
    }

    public void okClicked() {
    }

    public boolean mustCheckUnsavedChanges() {
        return this.index != null && this.saveChanges.isVisible() && this.saveChanges.isEnabled();
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog unsavedChangesDlg = new UnsavedChangesDialog((Component)Utilities.getParentDialog(this), this.getInfo());
        unsavedChangesDlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_INDEX_CHANGES_DETAILS.get(this.index.getName()));
        Utilities.centerGoldenMean(unsavedChangesDlg, Utilities.getParentDialog(this));
        unsavedChangesDlg.setVisible(true);
        UnsavedChangesDialog.Result result = unsavedChangesDlg.getResult();
        if (result == UnsavedChangesDialog.Result.SAVE) {
            this.saveIndex(false);
            if (this.newModifyTask == null || this.newModifyTask.getState() != Task.State.FINISHED_SUCCESSFULLY) {
                result = UnsavedChangesDialog.Result.CANCEL;
            }
        }
        return result;
    }

    private void checkSaveButton() {
        if (!this.ignoreCheckSave && this.index != null) {
            this.saveChanges.setEnabled(!this.authenticationRequired(this.getInfo().getServerDescriptor()) && this.isModified());
        }
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        super.createBasicLayout(p, gbc, true);
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets.top = 10;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.warning, gbc);
        Utilities.setWarningLabel(this.warning, this.INDEX_MODIFIED);
        ++gbc.gridy;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)buttonPanel, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.deleteIndex.setOpaque(false);
        gbc.insets.left = 0;
        buttonPanel.add((Component)this.deleteIndex, gbc);
        this.deleteIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                VLVIndexPanel.this.deleteIndex();
            }
        });
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.saveChanges.setOpaque(false);
        gbc.gridx = 3;
        buttonPanel.add((Component)this.saveChanges, gbc);
        this.saveChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                VLVIndexPanel.this.saveIndex(false);
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                VLVIndexPanel.this.checkSaveButton();
            }

            public void changedUpdate(DocumentEvent ev) {
                VLVIndexPanel.this.checkSaveButton();
            }

            public void removeUpdate(DocumentEvent ev) {
                VLVIndexPanel.this.checkSaveButton();
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                VLVIndexPanel.this.checkSaveButton();
            }
        };
        this.baseDNs.addActionListener(actionListener);
        this.baseObject.addActionListener(actionListener);
        this.singleLevel.addActionListener(actionListener);
        this.subordinateSubtree.addActionListener(actionListener);
        this.wholeSubtree.addActionListener(actionListener);
        this.attributes.addActionListener(actionListener);
        this.sortOrder.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                VLVIndexPanel.this.checkSaveButton();
            }

            public void intervalAdded(ListDataEvent e) {
                VLVIndexPanel.this.checkSaveButton();
            }

            public void intervalRemoved(ListDataEvent e) {
                VLVIndexPanel.this.checkSaveButton();
            }
        });
        this.baseDN.getDocument().addDocumentListener(documentListener);
        this.filter.getDocument().addDocumentListener(documentListener);
        this.maxBlockSize.getDocument().addDocumentListener(documentListener);
        this.baseDN.getDocument().addDocumentListener(documentListener);
    }

    private void deleteIndex() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_VLV_INDEX_TITLE.get(), this.getInfo());
        ArrayList<AbstractIndexDescriptor> indexesToDelete = new ArrayList<AbstractIndexDescriptor>();
        indexesToDelete.add(this.index);
        DeleteIndexTask newTask = new DeleteIndexTask(this.getInfo(), dlg, indexesToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            String indexName = this.index.getName();
            String backendName = this.index.getBackend().getBackendID();
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_VLV_INDEX_DELETE_DETAILS.get(indexName, backendName))) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_VLV_INDEX_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_VLV_INDEX_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_VLV_INDEX_SUCCESSFUL.get(indexName, backendName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_VLV_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_VLV_INDEX_ERROR_DETAILS.get(indexName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void saveIndex(boolean modal) {
        this.newModifyTask = null;
        if (!this.isModified()) {
            return;
        }
        List<Message> errors = this.checkErrors(false);
        if (errors.isEmpty()) {
            ProgressDialog dlg = new ProgressDialog(Utilities.getFrame(this), Utilities.getFrame(this), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_TITLE.get(), this.getInfo());
            dlg.setModal(modal);
            this.newModifyTask = new ModifyVLVIndexTask(this.getInfo(), dlg);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(this.newModifyTask, errors);
            }
            if (errors.isEmpty() && this.checkIndexRequired()) {
                String indexName = this.index.getName();
                String backendName = this.index.getBackend().getBackendID();
                this.launchOperation(this.newModifyTask, AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_VLV_INDEX_SUMMARY.get(indexName), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_VLV_INDEX_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_VLV_INDEX_SUCCESSFUL.get(indexName, backendName), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_VLV_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_VLV_INDEX_ERROR_DETAILS.get(indexName), null, dlg);
                this.saveChanges.setEnabled(false);
                dlg.setVisible(true);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public void update(VLVIndexDescriptor index) {
        this.ignoreCheckSave = true;
        this.readOnlyName.setText(index.getName());
        this.titlePanel.setDetails(Message.raw(index.getName(), new Object[0]));
        if (index.getBackend() != null) {
            this.updateBaseDNCombo(index.getBackend());
            this.backendName.setText(index.getBackend().getBackendID());
        }
        String dn = Utilities.unescapeUtf8(index.getBaseDN().toString());
        if (((DefaultComboBoxModel)this.baseDNs.getModel()).getIndexOf(dn) != -1) {
            this.baseDN.setText("");
            this.baseDNs.setSelectedItem(dn);
        } else {
            this.baseDN.setText(dn);
            this.baseDNs.setSelectedItem(this.OTHER_BASE_DN);
        }
        switch (index.getScope()) {
            case BASE_OBJECT: {
                this.baseObject.setSelected(true);
                break;
            }
            case SINGLE_LEVEL: {
                this.singleLevel.setSelected(true);
                break;
            }
            case SUBORDINATE_SUBTREE: {
                this.subordinateSubtree.setSelected(true);
                break;
            }
            case WHOLE_SUBTREE: {
                this.wholeSubtree.setSelected(true);
            }
        }
        this.filter.setText(index.getFilter());
        int[] indexes = new int[this.sortOrderModel.getSize()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        this.sortOrder.setSelectedIndices(indexes);
        this.remove.doClick();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.attributes.getModel();
        block7: for (VLVSortOrder s : index.getSortOrder()) {
            this.sortOrderModel.addElement(s);
            for (int i = 0; i < model.getSize(); ++i) {
                CategorizedComboBoxElement o = (CategorizedComboBoxElement)model.getElementAt(i);
                if (o.getType() != CategorizedComboBoxElement.Type.REGULAR || !o.getValue().equals(s.getAttributeName())) continue;
                model.removeElementAt(i);
                continue block7;
            }
        }
        if (model.getSize() > 1) {
            this.attributes.setSelectedIndex(1);
        }
        if (this.getInfo() != null) {
            if (this.getInfo().mustReindex(index)) {
                Utilities.setWarningLabel(this.warning, this.INDEX_MODIFIED);
                this.warning.setVisible(true);
                this.warning.setVerticalTextPosition(1);
            } else {
                this.warning.setVisible(false);
            }
        }
        this.index = index;
        this.ignoreCheckSave = false;
        this.checkSaveButton();
        this.scrollListener.updateBorder();
    }

    private boolean isModified() {
        try {
            return !this.index.getBaseDN().equals(DN.decode(this.getBaseDN())) || this.getScope() != this.index.getScope() || !this.filter.getText().trim().equals(this.index.getFilter()) || !((Object)this.getSortOrder()).equals(this.index.getSortOrder()) || !String.valueOf(this.index.getMaxBlockSize()).equals(this.maxBlockSize.getText().trim());
        }
        catch (OpenDsException odse) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModifyVLVIndexTask
    extends Task {
        private Set<String> backendSet;
        private String indexName;
        private String baseDN;
        private String filterValue;
        private LocalDBVLVIndexCfgDefn.Scope scope;
        private List<VLVSortOrder> sortOrder;
        private String backendID;
        private String sortOrderStringValue;
        private String ldif;
        private VLVIndexDescriptor indexToModify;
        private int maxBlock;
        private VLVIndexDescriptor modifiedIndex;

        public ModifyVLVIndexTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.backendID = VLVIndexPanel.this.index.getBackend().getBackendID();
            this.backendSet = new HashSet<String>();
            this.backendSet.add(this.backendID);
            this.indexName = VLVIndexPanel.this.index.getName();
            this.sortOrder = VLVIndexPanel.this.getSortOrder();
            this.baseDN = VLVIndexPanel.this.getBaseDN();
            this.filterValue = VLVIndexPanel.this.filter.getText().trim();
            this.scope = VLVIndexPanel.this.getScope();
            this.sortOrderStringValue = VLVIndexPanel.this.getSortOrderStringValue(this.sortOrder);
            this.ldif = VLVIndexPanel.this.getIndexLDIF(this.indexName);
            this.maxBlock = Integer.parseInt(VLVIndexPanel.this.maxBlockSize.getText());
            this.indexToModify = VLVIndexPanel.this.index;
        }

        @Override
        public Task.Type getType() {
            return Task.Type.MODIFY_INDEX;
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_MODIFY_VLV_INDEX_TASK_DESCRIPTION.get(this.indexName, this.backendID);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfiguration() throws OpenDsException {
            boolean configHandlerUpdated = false;
            try {
                if (!this.isServerRunning()) {
                    configHandlerUpdated = true;
                    this.getInfo().stopPooling();
                    if (this.getInfo().mustDeregisterConfig()) {
                        DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                    }
                    DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                    this.getInfo().setMustDeregisterConfig(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            List args = ModifyVLVIndexTask.this.getObfuscatedCommandLineArguments(ModifyVLVIndexTask.this.getDSConfigCommandLineArguments());
                            args.removeAll(ModifyVLVIndexTask.this.getConfigCommandLineArguments());
                            ModifyVLVIndexTask.this.printEquivalentCommandLine(ModifyVLVIndexTask.this.getConfigCommandLineName(), args, AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_MODIFY_VLV_INDEX.get());
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModifyVLVIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_VLV_INDEX_PROGRESS.get(ModifyVLVIndexTask.this.indexName), ColorAndFontConstants.progressFont));
                    }
                });
                if (this.isServerRunning()) {
                    this.modifyIndex(this.getInfo().getDirContext());
                } else {
                    this.modifyIndex();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModifyVLVIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            finally {
                if (configHandlerUpdated) {
                    DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                    this.getInfo().startPooling();
                }
            }
        }

        private void modifyIndex() throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                ldifImportConfig = new LDIFImportConfig(new StringReader(this.ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                Entry newConfigEntry = reader.readEntry();
                Entry oldEntry = DirectoryServer.getConfigEntry(newConfigEntry.getDN()).getEntry();
                DirectoryServer.getConfigHandler().replaceEntry(oldEntry, newConfigEntry, null);
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void modifyIndex(InitialLdapContext ctx) throws OpenDsException {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getConfigCommandLineName());
            List<String> args = this.getObfuscatedCommandLineArguments(this.getDSConfigCommandLineArguments());
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(this.backendID);
            LocalDBVLVIndexCfgClient index = backend.getLocalDBVLVIndex(this.indexName);
            DN b = DN.decode(this.baseDN);
            if (!this.indexToModify.getBaseDN().equals(b)) {
                index.setBaseDN(b);
            }
            if (!this.indexToModify.getFilter().equals(this.filterValue)) {
                index.setFilter(this.filterValue);
            }
            if (this.indexToModify.getScope() != this.scope) {
                index.setScope(this.scope);
            }
            if (!this.indexToModify.getScope().equals(this.sortOrder)) {
                index.setSortOrder(this.sortOrderStringValue);
            }
            index.commit();
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        private String getConfigCommandLineName() {
            if (this.isServerRunning() && VLVIndexPanel.this.isModified()) {
                return this.getCommandLinePath("dsconfig");
            }
            return null;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.updateConfiguration();
                this.modifiedIndex = new VLVIndexDescriptor(this.indexName, this.indexToModify.getBackend(), DN.decode(this.baseDN), this.scope, this.filterValue, this.sortOrder, this.maxBlock);
                this.getInfo().registerModifiedIndex(this.modifiedIndex);
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public void postOperation() {
            if (this.lastException == null && this.state == Task.State.FINISHED_SUCCESSFULLY) {
                VLVIndexPanel.this.rebuildIndexIfNecessary(this.modifiedIndex, this.getProgressDialog());
            }
        }

        private ArrayList<String> getDSConfigCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("set-local-db-vlv-index-prop");
            args.add("--backend-name");
            args.add(this.backendID);
            args.add("--index-name");
            args.add(this.indexName);
            try {
                DN b = DN.decode(this.baseDN);
                if (!this.indexToModify.getBaseDN().equals(b)) {
                    args.add("--set");
                    args.add("base-dn:" + this.baseDN);
                }
            }
            catch (OpenDsException odse) {
                throw new RuntimeException("Unexpected error parsing DN " + VLVIndexPanel.this.getBaseDN() + ": " + odse, odse);
            }
            if (this.indexToModify.getScope() != this.scope) {
                args.add("--set");
                args.add("scope:" + this.scope.toString());
            }
            if (!this.indexToModify.getFilter().equals(this.filterValue)) {
                args.add("--set");
                args.add("filter:" + this.filterValue);
            }
            if (!this.indexToModify.getScope().equals(this.sortOrder)) {
                args.add("--set");
                args.add("sort-order:" + this.sortOrderStringValue);
            }
            args.addAll(this.getConnectionCommandLineArguments());
            args.add(this.getNoPropertiesFileArgument());
            args.add("--no-prompt");
            return args;
        }
    }
}

