/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.event.SuperiorObjectClassesChangedEvent;
import org.opends.guitools.controlpanel.event.SuperiorObjectClassesChangedListener;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.SelectObjectClassesPanel;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperiorObjectClassesEditor
extends JPanel {
    private static final long serialVersionUID = 123123973933568L;
    private Set<ObjectClass> toExclude = new HashSet<ObjectClass>();
    private JComboBox singleSuperior = Utilities.createComboBox();
    private JLabel multipleSuperiors = Utilities.createDefaultLabel();
    private JButton bSpecifyMultiple = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SPECIFY_MULTIPLE_SUPERIORS_LABEL.get());
    private JButton bUpdateMultiple = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_UPDATE_MULTIPLE_SUPERIORS_LABEL.get());
    private SelectObjectClassesPanel superiorsPanel;
    private GenericDialog superiorsDialog;
    private String MULTIPLE = "Multiple";
    private String SINGLE = "Single";
    private CardLayout cardLayout = new CardLayout();
    private boolean isMultiple;
    private Set<ObjectClass> selectedMultipleSuperiors = new HashSet<ObjectClass>();
    private Set<SuperiorObjectClassesChangedListener> listeners = new HashSet<SuperiorObjectClassesChangedListener>();
    private Schema schema;

    public SuperiorObjectClassesEditor() {
        super(new CardLayout());
        this.cardLayout = (CardLayout)this.getLayout();
        this.setOpaque(false);
        this.createLayout();
    }

    public SuperiorObjectClassesEditor(Schema schema) {
        this();
        this.updateWithSchema(schema);
    }

    private void createLayout() {
        this.bSpecifyMultiple.setToolTipText(AdminToolMessages.INFO_CTRL_PANEL_SPECIFY_MULTIPLE_SUPERIORS_TOOLTIP.get().toString());
        this.bSpecifyMultiple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SuperiorObjectClassesEditor.this.specifyMultipleClicked();
            }
        });
        this.bUpdateMultiple.setToolTipText(AdminToolMessages.INFO_CTRL_PANEL_UPDATE_MULTIPLE_SUPERIORS_TOOLTIP.get().toString());
        this.bUpdateMultiple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SuperiorObjectClassesEditor.this.updateMultipleClicked();
            }
        });
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.singleSuperior);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.singleSuperior.setModel(model);
        this.singleSuperior.setRenderer(renderer);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                SuperiorObjectClassesEditor.this.notifyListeners();
            }
        };
        this.singleSuperior.addItemListener(itemListener);
        JPanel singlePanel = new JPanel(new GridBagLayout());
        singlePanel.setOpaque(false);
        JPanel multiplePanel = new JPanel(new GridBagLayout());
        multiplePanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        singlePanel.add((Component)this.singleSuperior, gbc);
        multiplePanel.add((Component)this.multipleSuperiors, gbc);
        ++gbc.gridx;
        gbc.insets.left = 5;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        singlePanel.add((Component)this.bSpecifyMultiple, gbc);
        multiplePanel.add((Component)this.bUpdateMultiple, gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        gbc.fill = 2;
        gbc.weightx = 0.1;
        singlePanel.add(Box.createHorizontalGlue(), gbc);
        multiplePanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)singlePanel, this.SINGLE);
        this.add((Component)multiplePanel, this.MULTIPLE);
        Set<ObjectClass> empty = Collections.emptySet();
        this.setSelectedSuperiors(empty);
    }

    public void setObjectClassesToExclude(Set<ObjectClass> toExclude) {
        this.toExclude.clear();
        this.toExclude.addAll(toExclude);
        this.updateWithSchema(this.schema);
        if (this.superiorsPanel != null) {
            this.superiorsPanel.setObjectClassesToExclude(toExclude);
        }
    }

    public Set<ObjectClass> getObjectClassToExclude() {
        return Collections.unmodifiableSet(this.toExclude);
    }

    public void setSelectedSuperiors(Set<ObjectClass> objectClasses) {
        boolean bl = this.isMultiple = objectClasses.size() > 1;
        if (this.isMultiple) {
            this.cardLayout.show(this, this.MULTIPLE);
            this.selectedMultipleSuperiors.clear();
            this.selectedMultipleSuperiors.addAll(objectClasses);
            this.updateMultipleSuperiorsLabel(this.selectedMultipleSuperiors);
        } else {
            if (objectClasses.size() == 1) {
                this.singleSuperior.setSelectedItem(objectClasses.iterator().next());
            }
            this.cardLayout.show(this, this.SINGLE);
        }
    }

    private void updateMultipleSuperiorsLabel(Set<ObjectClass> superiors) {
        TreeSet<String> orderedOcs = new TreeSet<String>(new LowerCaseComparator());
        for (ObjectClass oc : superiors) {
            orderedOcs.add(oc.getNameOrOID());
        }
        String s = Utilities.getStringFromCollection(orderedOcs, ", ");
        this.multipleSuperiors.setText(s);
    }

    public Set<ObjectClass> getSelectedSuperiors() {
        if (this.isMultiple) {
            return Collections.unmodifiableSet(this.selectedMultipleSuperiors);
        }
        ObjectClass oc = (ObjectClass)this.singleSuperior.getSelectedItem();
        if (oc == null) {
            return Collections.emptySet();
        }
        return Collections.singleton((ObjectClass)this.singleSuperior.getSelectedItem());
    }

    public void setSchema(Schema schema) {
        this.updateWithSchema(schema);
        if (this.superiorsPanel != null) {
            this.superiorsPanel.setSchema(schema);
        }
    }

    private void updateWithSchema(Schema schema) {
        HashMap<String, ObjectClass> objectClassNameMap = new HashMap<String, ObjectClass>();
        for (String key : schema.getObjectClasses().keySet()) {
            ObjectClass oc = schema.getObjectClass(key);
            if (this.toExclude.contains(oc)) continue;
            objectClassNameMap.put(oc.getNameOrOID(), oc);
        }
        TreeSet<String> orderedKeys = new TreeSet<String>(new LowerCaseComparator());
        orderedKeys.addAll(objectClassNameMap.keySet());
        ArrayList newParents = new ArrayList();
        for (String key : orderedKeys) {
            newParents.add(objectClassNameMap.get(key));
        }
        Utilities.updateComboBoxModel(newParents, (DefaultComboBoxModel)this.singleSuperior.getModel());
        if (this.schema == null) {
            ObjectClass topClass = schema.getObjectClass("top");
            this.singleSuperior.setSelectedItem(topClass);
        }
        this.schema = schema;
    }

    public void addParentObjectClassesChangedListener(SuperiorObjectClassesChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeParentObjectClassesChangedListener(SuperiorObjectClassesChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void specifyMultipleClicked() {
        this.updateMultipleClicked();
    }

    private void updateMultipleClicked() {
        Set<ObjectClass> selectedObjectClasses = this.getSelectedSuperiors();
        if (this.superiorsPanel == null) {
            this.superiorsPanel = new SelectObjectClassesPanel();
            this.superiorsPanel.setSchema(this.schema);
            if (!this.toExclude.isEmpty()) {
                this.superiorsPanel.setObjectClassesToExclude(this.toExclude);
            }
            this.superiorsDialog = new GenericDialog(Utilities.getFrame(this), this.superiorsPanel);
            Utilities.centerGoldenMean(this.superiorsDialog, Utilities.getParentDialog(this));
            this.superiorsDialog.setModal(true);
            this.superiorsDialog.pack();
        }
        this.superiorsPanel.setSelectedObjectClasses(selectedObjectClasses);
        this.superiorsDialog.setVisible(true);
        if (!this.superiorsPanel.isCanceled()) {
            this.setSelectedSuperiors(this.superiorsPanel.getSelectedObjectClasses());
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        SuperiorObjectClassesChangedEvent ev = new SuperiorObjectClassesChangedEvent(this, this.getSelectedSuperiors());
        for (SuperiorObjectClassesChangedListener listener : this.listeners) {
            listener.parentObjectClassesChanged(ev);
        }
    }
}

