/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.opends.guitools.controlpanel.ControlPanel;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.event.ClickTooltipDisplayer;
import org.opends.guitools.controlpanel.event.ComboKeySelectionManager;
import org.opends.guitools.controlpanel.event.TextComponentFocusListener;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.components.LabelWithHelpIcon;
import org.opends.guitools.controlpanel.ui.components.SelectableLabelWithHelpIcon;
import org.opends.guitools.controlpanel.ui.renderer.AccessibleTableHeaderRenderer;
import org.opends.guitools.controlpanel.util.ConfigFromDirContext;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static File rootDirectory;
    private static File instanceRootDirectory;
    public static final String OBFUSCATED_VALUE = "********";
    private static String[] attrsToObfuscate;
    private static ImageIcon warningIcon;
    private static ImageIcon requiredIcon;
    private static Message NO_VALUE_SET;
    private static Message NOT_IMPLEMENTED;
    private static final String HTML_SPACE = "&nbsp;";
    private static final String VALID_SCHEMA_SYNTAX = "abcdefghijklmnopqrstuvwxyz0123456789-";
    private static final String[] standardSchemaFileNames;
    private static final String[] configurationSchemaOrigins;
    private static final String[] standardSchemaOrigins;
    private static final String[] configurationSchemaFileNames;
    private static final String[] binarySyntaxOIDs;
    private static final String[] passwordSyntaxOIDs;

    public static boolean isMacOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") != -1;
    }

    public static JComboBox createComboBox() {
        JComboBox combo = new JComboBox();
        if (Utilities.isMacOS()) {
            combo.setOpaque(false);
        }
        combo.setKeySelectionManager(new ComboKeySelectionManager(combo));
        return combo;
    }

    public static JFrame createFrame() {
        JFrame frame = new JFrame();
        frame.setResizable(true);
        org.opends.quicksetup.ui.Utilities.setFrameIcon(frame);
        return frame;
    }

    public static boolean mustObfuscate(String attrName, Schema schema) {
        boolean toObfuscate = false;
        if (schema == null) {
            for (String attr : attrsToObfuscate) {
                if (!attr.equalsIgnoreCase(attrName)) continue;
                toObfuscate = true;
                break;
            }
        } else {
            toObfuscate = Utilities.hasPasswordSyntax(attrName, schema);
        }
        return toObfuscate;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("windows") != -1;
    }

    public static Color deriveColorHSB(Color base, float dH, float dS, float dB) {
        float[] hsb = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), null);
        hsb[0] = hsb[0] + dH;
        hsb[1] = hsb[1] + dS;
        hsb[2] = hsb[2] + dB;
        return Color.getHSBColor(hsb[0] < 0.0f ? 0.0f : (hsb[0] > 1.0f ? 1.0f : hsb[0]), hsb[1] < 0.0f ? 0.0f : (hsb[1] > 1.0f ? 1.0f : hsb[1]), hsb[2] < 0.0f ? 0.0f : (hsb[2] > 1.0f ? 1.0f : hsb[2]));
    }

    public static void displayErrorDialog(Component parentComponent, Collection<Message> errors) {
        ArrayList<String> stringErrors = new ArrayList<String>();
        for (Message err : errors) {
            stringErrors.add(err.toString());
        }
        String msg = Utilities.getStringFromCollection(stringErrors, "<br>");
        String plainText = msg.replaceAll("<br>", ServerConstants.EOL);
        String wrappedText = StaticUtils.wrapText(plainText, 70);
        wrappedText = wrappedText.replaceAll(ServerConstants.EOL, "<br>");
        JOptionPane.showMessageDialog(parentComponent, "<html>" + wrappedText, AdminToolMessages.INFO_CTRL_PANEL_ERROR_DIALOG_TITLE.get().toString(), 0);
    }

    public static boolean displayConfirmationDialog(Component parentComponent, Message title, Message msg) {
        String plainText = msg.toString().replaceAll("<br>", ServerConstants.EOL);
        String wrappedText = StaticUtils.wrapText(plainText, 70);
        wrappedText = wrappedText.replaceAll(ServerConstants.EOL, "<br>");
        return 0 == JOptionPane.showOptionDialog(parentComponent, "<html>" + wrappedText, title.toString(), 0, 3, null, null, null);
    }

    public static void displayWarningDialog(Component parentComponent, Message title, Message msg) {
        String plainText = msg.toString().replaceAll("<br>", ServerConstants.EOL);
        String wrappedText = StaticUtils.wrapText(plainText, 70);
        wrappedText = wrappedText.replaceAll(ServerConstants.EOL, "<br>");
        JOptionPane.showMessageDialog(parentComponent, "<html>" + wrappedText, title.toString(), 2);
    }

    public static JEditorPane makeHtmlPane(String text, Font font) {
        JEditorPane pane = new JEditorPane();
        pane.setContentType("text/html");
        pane.setFont(font);
        if (text != null) {
            pane.setText(Utilities.applyFont(text, font));
        }
        pane.setEditable(false);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        pane.setOpaque(false);
        pane.setFocusCycleRoot(false);
        return pane;
    }

    public static JEditorPane makePlainTextPane(String text, Font font) {
        JEditorPane pane = new JEditorPane();
        pane.setContentType("text/plain");
        if (text != null) {
            pane.setText(text);
        }
        pane.setFont(font);
        pane.setEditable(false);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        pane.setOpaque(false);
        pane.setFocusCycleRoot(false);
        return pane;
    }

    private static String getFontStyle(Font font) {
        StringBuilder buf = new StringBuilder();
        buf.append("font-family:" + font.getName()).append(";font-size:" + font.getSize() + "pt");
        if (font.isItalic()) {
            buf.append(";font-style:italic");
        }
        if (font.isBold()) {
            buf.append(";font-weight:bold;");
        }
        return buf.toString();
    }

    public static Border makeTitledBorder(Message msg) {
        TitledBorder border = new TitledBorder(new EtchedBorder(), " " + msg + " ");
        border.setTitleFont(ColorAndFontConstants.titleFont);
        border.setTitleColor(ColorAndFontConstants.foreground);
        return border;
    }

    public static JScrollPane createBorderLessScrollBar(Component comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.getViewport().setBackground(ColorAndFontConstants.background);
        scroll.setBackground(ColorAndFontConstants.background);
        UIFactory.setScrollIncrementUnit(scroll);
        return scroll;
    }

    public static JScrollPane createScrollPane(Component comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.getViewport().setOpaque(false);
        scroll.setOpaque(false);
        scroll.getViewport().setBackground(ColorAndFontConstants.background);
        scroll.setBackground(ColorAndFontConstants.background);
        UIFactory.setScrollIncrementUnit(scroll);
        return scroll;
    }

    public static JButton createButton(Message text) {
        JButton button = new JButton(text.toString());
        button.setOpaque(false);
        button.setForeground(ColorAndFontConstants.buttonForeground);
        button.getAccessibleContext().setAccessibleName(text.toString());
        return button;
    }

    public static JRadioButton createRadioButton(Message text) {
        JRadioButton button = new JRadioButton(text.toString());
        button.setOpaque(false);
        button.setForeground(ColorAndFontConstants.buttonForeground);
        button.getAccessibleContext().setAccessibleName(text.toString());
        return button;
    }

    public static JCheckBox createCheckBox(Message text) {
        JCheckBox cb = new JCheckBox(text.toString());
        cb.setOpaque(false);
        cb.setForeground(ColorAndFontConstants.buttonForeground);
        cb.getAccessibleContext().setAccessibleName(text.toString());
        return cb;
    }

    public static JMenuItem createMenuItem(Message msg) {
        return new JMenuItem(msg.toString());
    }

    public static JMenu createMenu(Message msg, Message description) {
        JMenu menu = new JMenu(msg.toString());
        menu.getAccessibleContext().setAccessibleDescription(description.toString());
        return menu;
    }

    public static JLabel createPrimaryLabel() {
        return Utilities.createPrimaryLabel(Message.EMPTY);
    }

    public static JLabel createPrimaryLabel(Message text) {
        JLabel label = new JLabel(text.toString());
        label.setFont(ColorAndFontConstants.primaryFont);
        label.setForeground(ColorAndFontConstants.foreground);
        return label;
    }

    public static JLabel createInlineHelpLabel(Message text) {
        JLabel label = new JLabel(text.toString());
        label.setFont(ColorAndFontConstants.inlineHelpFont);
        label.setForeground(ColorAndFontConstants.foreground);
        return label;
    }

    public static JLabel createTitleLabel(Message text) {
        JLabel label = new JLabel(text.toString());
        label.setFont(ColorAndFontConstants.titleFont);
        label.setForeground(ColorAndFontConstants.foreground);
        return label;
    }

    public static JLabel createDefaultLabel() {
        return Utilities.createDefaultLabel(Message.EMPTY);
    }

    public static JLabel createDefaultLabel(Message text) {
        JLabel label = new JLabel(text.toString());
        label.setFont(ColorAndFontConstants.defaultFont);
        label.setForeground(ColorAndFontConstants.foreground);
        return label;
    }

    public static JTable createSortableTable(final SortableTableModel tableModel, TableCellRenderer renderer) {
        final JTable table = new JTable(tableModel);
        table.setShowGrid(true);
        table.setAutoResizeMode(2);
        boolean isMacOS = Utilities.isMacOS();
        table.setGridColor(ColorAndFontConstants.gridColor);
        if (isMacOS) {
            table.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, ColorAndFontConstants.gridColor));
        }
        if (Utilities.isWindows()) {
            table.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, ColorAndFontConstants.gridColor));
        }
        table.getTableHeader().setDefaultRenderer(new AccessibleTableHeaderRenderer(table.getTableHeader().getDefaultRenderer()));
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn col = table.getColumn(table.getColumnName(i));
            col.setCellRenderer(renderer);
        }
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int sortedBy = table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && sortedBy != -1) {
                    tableModel.setSortAscending(!tableModel.isSortAscending());
                    tableModel.setSortColumn(sortedBy);
                    tableModel.forceResort();
                    Utilities.updateTableSizes(table);
                }
            }
        };
        table.getTableHeader().addMouseListener(listMouseListener);
        return table;
    }

    public static JTextArea createTextAreaWithBorder(Message text, int rows, int cols) {
        JTextArea ta = Utilities.createTextArea(text, rows, cols);
        if (ColorAndFontConstants.textAreaBorder != null) {
            Utilities.setBorder(ta, ColorAndFontConstants.textAreaBorder);
        }
        return ta;
    }

    public static JTextArea createNonEditableTextArea(Message text, int rows, int cols) {
        JTextArea ta = Utilities.createTextArea(text, rows, cols);
        ta.setEditable(false);
        ta.setOpaque(false);
        ta.setForeground(ColorAndFontConstants.foreground);
        return ta;
    }

    public static JTextArea createTextArea(Message text, int rows, int cols) {
        JTextArea ta = new JTextArea(text.toString(), rows, cols);
        ta.setFont(ColorAndFontConstants.defaultFont);
        return ta;
    }

    public static JTextField createTextField(String text, int cols) {
        JTextField tf = Utilities.createTextField();
        tf.setText(text);
        tf.setColumns(cols);
        return tf;
    }

    public static JTextField createShortTextField() {
        JTextField tf = Utilities.createTextField();
        tf.setColumns(10);
        return tf;
    }

    public static JTextField createMediumTextField() {
        JTextField tf = Utilities.createTextField();
        tf.setColumns(20);
        return tf;
    }

    public static JTextField createLongTextField() {
        JTextField tf = Utilities.createTextField();
        tf.setColumns(30);
        return tf;
    }

    public static JTextField createTextField() {
        JTextField tf = new JTextField();
        tf.addFocusListener(new TextComponentFocusListener(tf));
        tf.setFont(ColorAndFontConstants.defaultFont);
        return tf;
    }

    public static JPasswordField createPasswordField() {
        JPasswordField pf = new JPasswordField();
        pf.addFocusListener(new TextComponentFocusListener(pf));
        pf.setFont(ColorAndFontConstants.defaultFont);
        return pf;
    }

    public static JPasswordField createPasswordField(int cols) {
        JPasswordField pf = Utilities.createPasswordField();
        pf.setColumns(cols);
        return pf;
    }

    public static void setBorder(JComponent comp, Border border) {
        if (comp.getBorder() == null) {
            comp.setBorder(border);
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder(comp.getBorder(), border));
        }
    }

    public static void updateScrollMode(JScrollPane scroll, JTable table) {
        int width1 = table.getPreferredScrollableViewportSize().width;
        int width2 = scroll.getViewport().getWidth();
        if (width1 > width2) {
            table.setAutoResizeMode(0);
        } else {
            table.setAutoResizeMode(2);
        }
    }

    public static void updateTableSizes(JTable table) {
        Utilities.updateTableSizes(table, -1);
    }

    public static void updateTableSizes(JTable table, int rows) {
        TableCellRenderer renderer;
        int col;
        int horizontalMargin = table.getIntercellSpacing().width;
        int verticalMargin = table.getIntercellSpacing().height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int headerMaxHeight = 5;
        int headerMaxWidth = 0;
        JTableHeader header = table.getTableHeader();
        if (header != null && header.isVisible()) {
            for (col = 0; col < table.getColumnCount(); ++col) {
                TableColumn tcol = table.getColumnModel().getColumn(col);
                TableCellRenderer renderer2 = tcol.getHeaderRenderer();
                if (renderer2 == null) {
                    renderer2 = table.getTableHeader().getDefaultRenderer();
                }
                Component comp = renderer2.getTableCellRendererComponent(table, table.getModel().getColumnName(col), false, false, 0, col);
                int colHeight = comp.getPreferredSize().height + 2 * verticalMargin;
                if (colHeight > screenSize.height) {
                    colHeight = 0;
                }
                headerMaxHeight = Math.max(headerMaxHeight, colHeight);
            }
        }
        for (col = 0; col < table.getColumnCount(); ++col) {
            int colMaxWidth = 8;
            TableColumn tcol = table.getColumnModel().getColumn(col);
            renderer = tcol.getHeaderRenderer();
            if (renderer == null && header != null) {
                renderer = header.getDefaultRenderer();
            }
            if (renderer != null) {
                Component comp = renderer.getTableCellRendererComponent(table, table.getModel().getColumnName(col), false, false, 0, col);
                colMaxWidth = comp.getPreferredSize().width + 2 * horizontalMargin + 8;
            }
            if (colMaxWidth > screenSize.width) {
                colMaxWidth = 8;
            }
            for (int row = 0; row < table.getRowCount(); ++row) {
                renderer = table.getCellRenderer(row, col);
                Component comp = table.prepareRenderer(renderer, row, col);
                int colWidth = comp.getPreferredSize().width + 2 * horizontalMargin;
                colMaxWidth = Math.max(colMaxWidth, colWidth);
            }
            tcol.setPreferredWidth(colMaxWidth);
            headerMaxWidth += colMaxWidth;
        }
        if (header != null && header.isVisible()) {
            header.setPreferredSize(new Dimension(headerMaxWidth, headerMaxHeight));
        }
        int maxRow = table.getRowHeight();
        for (int row = 0; row < table.getRowCount(); ++row) {
            for (int col2 = 0; col2 < table.getColumnCount(); ++col2) {
                renderer = table.getCellRenderer(row, col2);
                Component comp = renderer.getTableCellRendererComponent(table, table.getModel().getValueAt(row, col2), false, false, row, col2);
                int colHeight = comp.getPreferredSize().height + 2 * verticalMargin;
                if (colHeight > screenSize.height) {
                    colHeight = 0;
                }
                maxRow = Math.max(maxRow, colHeight);
            }
        }
        if (maxRow > table.getRowHeight()) {
            table.setRowHeight(maxRow);
        }
        Dimension d1 = rows == -1 ? table.getPreferredSize() : new Dimension(table.getPreferredSize().width, rows * maxRow);
        table.setPreferredScrollableViewportSize(d1);
    }

    public static String applyFont(String html, Font font) {
        StringBuilder buf = new StringBuilder();
        buf.append("<span style=\"").append(Utilities.getFontStyle(font)).append("\">").append(html).append("</span>");
        return buf.toString();
    }

    public static ImageIcon createImageIcon(String path, ClassLoader loader) {
        URL imgURL;
        if (loader == null) {
            loader = ControlPanel.class.getClassLoader();
        }
        if ((imgURL = loader.getResource(path)) != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static ImageIcon createImageIcon(String path) {
        return Utilities.createImageIcon(path, null);
    }

    public static ImageIcon createImageIcon(byte[] bytes, int maxHeight, Message description, boolean useFast) {
        ImageIcon icon = new ImageIcon(bytes, description.toString());
        if (maxHeight > icon.getIconHeight() || icon.getIconHeight() <= 0) {
            return icon;
        }
        int newHeight = maxHeight;
        int newWidth = newHeight * icon.getIconWidth() / icon.getIconHeight();
        int algo = useFast ? 2 : 4;
        Image scaledImage = icon.getImage().getScaledInstance(newWidth, newHeight, algo);
        return new ImageIcon(scaledImage);
    }

    public static void updatePreferredSize(JEditorPane pane, int nCols, String plainText, Font font, boolean applyBackground) {
        String wrappedText = StaticUtils.wrapText(plainText, nCols);
        wrappedText = wrappedText.replaceAll(ServerConstants.EOL, "<br>");
        if (applyBackground) {
            wrappedText = UIFactory.applyErrorBackgroundToHtml(Utilities.applyFont(wrappedText, font));
        }
        JEditorPane pane2 = Utilities.makeHtmlPane(wrappedText, font);
        pane.setPreferredSize(pane2.getPreferredSize());
        JFrame frame = Utilities.getFrame(pane);
        if (frame != null && frame.isVisible()) {
            frame.getRootPane().revalidate();
            frame.getRootPane().repaint();
        }
    }

    public static String stripHtmlToSingleLine(String s) {
        String o = null;
        if (s != null) {
            s = s.replaceAll("<br>", " ");
            o = s.replaceAll("\\<.*?\\>", "");
        }
        return o;
    }

    public static Message wrapHTML(Message msg, int nCols) {
        String s = msg.toString();
        StringBuilder sb = new StringBuilder();
        StringBuilder lastLine = new StringBuilder();
        int lastOpenTag = -1;
        boolean inTag = false;
        int lastSpace = -1;
        int lastLineLengthInLastSpace = 0;
        int lastLineLength = 0;
        for (int i = 0; i < s.length(); ++i) {
            boolean isNormalChar = false;
            char c = s.charAt(i);
            if (c == '<') {
                inTag = true;
                lastOpenTag = i;
                lastLine.append(c);
            } else if (c == '>') {
                if (lastOpenTag != -1) {
                    inTag = false;
                    String tag = s.substring(lastOpenTag, i + 1);
                    lastOpenTag = -1;
                    if (Utilities.isLineBreakTag(tag)) {
                        lastLine.append(c);
                        sb.append((CharSequence)lastLine);
                        lastLine.delete(0, lastLine.length());
                        lastLineLength = 0;
                        lastSpace = -1;
                        lastLineLengthInLastSpace = 0;
                    } else {
                        lastLine.append(c);
                    }
                } else {
                    isNormalChar = true;
                }
            } else if (inTag) {
                lastLine.append(c);
            } else if (c == HTML_SPACE.charAt(0)) {
                if (s.length() >= i + HTML_SPACE.length()) {
                    if (s.substring(i, i + HTML_SPACE.length()).equalsIgnoreCase(HTML_SPACE)) {
                        if (lastLineLength < nCols) {
                            lastLine.append(HTML_SPACE);
                            lastSpace = lastLine.length() - HTML_SPACE.length();
                            lastLineLengthInLastSpace = ++lastLineLength;
                            i += HTML_SPACE.length() - 1;
                        } else {
                            sb.append((CharSequence)lastLine);
                            sb.append("<br>");
                            lastLine.delete(0, lastLine.length());
                            lastLineLength = 0;
                            lastSpace = -1;
                            lastLineLengthInLastSpace = 0;
                            i += HTML_SPACE.length() - 1;
                        }
                    } else {
                        isNormalChar = true;
                    }
                } else {
                    isNormalChar = true;
                }
            } else if (c == ' ') {
                if (lastLineLength < nCols) {
                    lastLine.append(c);
                    lastSpace = lastLine.length() - 1;
                    lastLineLengthInLastSpace = ++lastLineLength;
                } else {
                    sb.append((CharSequence)lastLine);
                    sb.append("<br>");
                    lastLine.delete(0, lastLine.length());
                    lastLineLength = 0;
                    lastSpace = -1;
                    lastLineLengthInLastSpace = 0;
                }
            } else {
                isNormalChar = true;
            }
            if (!isNormalChar) continue;
            if (lastLineLength < nCols) {
                lastLine.append(c);
                ++lastLineLength;
                continue;
            }
            if (lastSpace != -1) {
                sb.append(lastLine.subSequence(0, lastSpace));
                sb.append("<br>");
                lastLine.delete(0, lastSpace + 1);
                lastLine.append(c);
                lastLineLength = lastLineLength - lastLineLengthInLastSpace + 1;
                lastLineLengthInLastSpace = 0;
                lastSpace = -1;
                continue;
            }
            sb.append((CharSequence)lastLine);
            sb.append("<br>");
            lastLine.delete(0, lastLine.length());
            lastLine.append(c);
            lastLineLength = 1;
        }
        if (lastLine.length() > 0) {
            sb.append((CharSequence)lastLine);
        }
        return Message.raw(sb.toString(), new Object[0]);
    }

    private static boolean isLineBreakTag(String tag) {
        return tag.equalsIgnoreCase("<br>") || tag.equalsIgnoreCase("</br>") || tag.equalsIgnoreCase("</div>") || tag.equalsIgnoreCase("<p>") || tag.equalsIgnoreCase("</p>");
    }

    public static void centerOnScreen(Component comp) {
        boolean multipleScreen;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = comp.getPreferredSize().width;
        int height = comp.getPreferredSize().height;
        boolean bl = multipleScreen = screenSize.width / screenSize.height >= 2;
        if (multipleScreen) {
            comp.setLocation(screenSize.width / 4 - width / 2, (screenSize.height - height) / 2);
        } else {
            comp.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        }
    }

    public static void centerGoldenMean(Window comp, Component ref) {
        comp.setLocationRelativeTo(ref);
        if (ref != null && ref.isVisible()) {
            int refY = ref.getY();
            int refHeight = ref.getHeight();
            int compHeight = comp.getPreferredSize().height;
            int newY = refY + (int)((double)refHeight * 0.3819 - (double)compHeight * 0.5);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (newY > 0 && screenSize.height > newY + compHeight) {
                comp.setLocation(comp.getX(), newY);
            }
        }
    }

    public static JFrame getFrame(Component comp) {
        Component parent;
        for (parent = comp; parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (JFrame)parent;
        }
        return null;
    }

    public static Window getParentDialog(Component comp) {
        for (Component parent = comp; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog) && !(parent instanceof JFrame)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static String unescapeUtf8(String v) {
        try {
            byte[] stringBytes = v.getBytes("UTF-8");
            byte[] decodedBytes = new byte[stringBytes.length];
            int pos = 0;
            for (int i = 0; i < stringBytes.length; ++i) {
                if (stringBytes[i] == 92 && i + 2 < stringBytes.length && StaticUtils.isHexDigit(stringBytes[i + 1]) && StaticUtils.isHexDigit(stringBytes[i + 2])) {
                    int b;
                    byte escapedByte1 = stringBytes[++i];
                    switch (escapedByte1) {
                        case 48: {
                            b = 0;
                            break;
                        }
                        case 49: {
                            b = 16;
                            break;
                        }
                        case 50: {
                            b = 32;
                            break;
                        }
                        case 51: {
                            b = 48;
                            break;
                        }
                        case 52: {
                            b = 64;
                            break;
                        }
                        case 53: {
                            b = 80;
                            break;
                        }
                        case 54: {
                            b = 96;
                            break;
                        }
                        case 55: {
                            b = 112;
                            break;
                        }
                        case 56: {
                            b = -128;
                            break;
                        }
                        case 57: {
                            b = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            b = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            b = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            b = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            b = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            b = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            b = -16;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected byte: " + escapedByte1);
                        }
                    }
                    byte escapedByte2 = stringBytes[++i];
                    switch (escapedByte2) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            b = (byte)(b | 1);
                            break;
                        }
                        case 50: {
                            b = (byte)(b | 2);
                            break;
                        }
                        case 51: {
                            b = (byte)(b | 3);
                            break;
                        }
                        case 52: {
                            b = (byte)(b | 4);
                            break;
                        }
                        case 53: {
                            b = (byte)(b | 5);
                            break;
                        }
                        case 54: {
                            b = (byte)(b | 6);
                            break;
                        }
                        case 55: {
                            b = (byte)(b | 7);
                            break;
                        }
                        case 56: {
                            b = (byte)(b | 8);
                            break;
                        }
                        case 57: {
                            b = (byte)(b | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            b = (byte)(b | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            b = (byte)(b | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            b = (byte)(b | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            b = (byte)(b | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            b = (byte)(b | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            b = (byte)(b | 0xF);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected byte: " + escapedByte2);
                        }
                    }
                    decodedBytes[pos++] = b;
                    continue;
                }
                decodedBytes[pos++] = stringBytes[i];
            }
            return new String(decodedBytes, 0, pos, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("UTF-8 encoding not supported", uee);
        }
    }

    public static boolean areDnsEqual(String dn1, String dn2) {
        boolean areDnsEqual = false;
        try {
            LdapName name1 = new LdapName(dn1);
            LdapName name2 = new LdapName(dn2);
            areDnsEqual = name1.equals(name2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return areDnsEqual;
    }

    public static String getRDNString(String attrName, String attrValue) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(attrName);
        AttributeValue value = AttributeValues.create(attrType, attrValue);
        RDN rdn = new RDN(attrType, attrName, value);
        return rdn.toString();
    }

    public static String getAttributeNameWithoutOptions(String attrName) {
        int index = attrName.indexOf(";");
        if (index != -1) {
            attrName = attrName.substring(0, index);
        }
        return attrName;
    }

    public static String getStringFromCollection(Collection<String> col, String separator) {
        StringBuilder msg = new StringBuilder();
        for (String m : col) {
            if (msg.length() > 0) {
                msg.append(separator);
            }
            msg.append(m);
        }
        return msg.toString();
    }

    public static Name getJNDIName(String dn) throws InvalidNameException {
        CompositeName name = new CompositeName();
        if (dn != null && dn.length() > 0) {
            name.add(dn);
        }
        return name;
    }

    public static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    public static String getProgressDone(Font progressFont) {
        return Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_PROGRESS_DONE.get().toString(), progressFont.deriveFont(1));
    }

    public static String getProgressWithPoints(Message plainText, Font progressFont) {
        return Utilities.applyFont(plainText.toString(), progressFont) + Utilities.applyFont("&nbsp;.....&nbsp;", progressFont.deriveFont(1));
    }

    public static String getFormattedError(Message title, Font titleFont, Message details, Font detailsFont) {
        StringBuilder buf = new StringBuilder();
        String space = HTML_SPACE;
        buf.append(UIFactory.getIconHtml(UIFactory.IconType.ERROR_LARGE) + space + space + Utilities.applyFont(title.toString(), titleFont));
        if (details != null) {
            buf.append("<br><br>").append(Utilities.applyFont(details.toString(), detailsFont));
        }
        return "<form>" + UIFactory.applyErrorBackgroundToHtml(buf.toString()) + "</form>";
    }

    public static String getFormattedSuccess(Message title, Font titleFont, Message details, Font detailsFont) {
        StringBuilder buf = new StringBuilder();
        String space = HTML_SPACE;
        buf.append(UIFactory.getIconHtml(UIFactory.IconType.INFORMATION_LARGE) + space + space + Utilities.applyFont(title.toString(), titleFont));
        if (details != null) {
            buf.append("<br><br>").append(Utilities.applyFont(details.toString(), detailsFont));
        }
        return "<form>" + UIFactory.applyErrorBackgroundToHtml(buf.toString()) + "</form>";
    }

    public static String getFormattedConfirmation(Message title, Font titleFont, Message details, Font detailsFont) {
        StringBuilder buf = new StringBuilder();
        String space = HTML_SPACE;
        buf.append(UIFactory.getIconHtml(UIFactory.IconType.WARNING_LARGE) + space + space + Utilities.applyFont(title.toString(), titleFont));
        if (details != null) {
            buf.append("<br><br>").append(Utilities.applyFont(details.toString(), detailsFont));
        }
        return "<form>" + buf.toString() + "</form>";
    }

    public static String getFormattedWarning(Message title, Font titleFont, Message details, Font detailsFont) {
        StringBuilder buf = new StringBuilder();
        String space = HTML_SPACE;
        buf.append(UIFactory.getIconHtml(UIFactory.IconType.WARNING_LARGE) + space + space + Utilities.applyFont(title.toString(), titleFont));
        if (details != null) {
            buf.append("<br><br>").append(Utilities.applyFont(details.toString(), detailsFont));
        }
        return "<form>" + UIFactory.applyErrorBackgroundToHtml(buf.toString()) + "</form>";
    }

    public static void setNotAvailableBecauseServerIsDown(LabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(true);
        l.setHelpTooltip(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_TOOLTIP.get().toString());
    }

    public static void setNotAvailableBecauseAuthenticationIsRequired(LabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(true);
        l.setHelpTooltip(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_TOOLTIP.get().toString());
    }

    public static void setNotAvailableBecauseServerIsDown(SelectableLabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(true);
        l.setHelpTooltip(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_TOOLTIP.get().toString());
    }

    public static void setNotAvailableBecauseAuthenticationIsRequired(SelectableLabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(true);
        l.setHelpTooltip(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_TOOLTIP.get().toString());
    }

    public static void setWarningLabel(JLabel l, Message text) {
        l.setText(text.toString());
        if (warningIcon == null) {
            warningIcon = Utilities.createImageIcon("org/opends/quicksetup/images/warning_medium.gif");
            warningIcon.setDescription(AdminToolMessages.INFO_WARNING_ICON_ACCESSIBLE_DESCRIPTION.get().toString());
            warningIcon.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_WARNING_ICON_ACCESSIBLE_DESCRIPTION.get().toString());
        }
        l.setIcon(warningIcon);
        l.setToolTipText(text.toString());
        l.setHorizontalTextPosition(4);
    }

    public static void setNotAvailable(LabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(false);
        l.setHelpTooltip(null);
    }

    public static void setTextValue(LabelWithHelpIcon l, String text) {
        l.setText(text);
        l.setHelpIconVisible(false);
        l.setHelpTooltip(null);
    }

    public static void setNotAvailable(SelectableLabelWithHelpIcon l) {
        l.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AVAILABLE_LONG_LABEL.get().toString());
        l.setHelpIconVisible(false);
        l.setHelpTooltip(null);
    }

    public static void setTextValue(SelectableLabelWithHelpIcon l, String text) {
        l.setText(text);
        l.setHelpIconVisible(false);
        l.setHelpTooltip(null);
    }

    public static File getServerRootDirectory() {
        if (rootDirectory == null) {
            String installRoot = System.getProperty("org.opends.quicksetup.Root");
            if (installRoot == null) {
                installRoot = Utilities.getInstallPathFromClasspath();
            }
            rootDirectory = new File(installRoot);
        }
        return rootDirectory;
    }

    public static File getInstanceRootDirectory(String installPath) {
        if (instanceRootDirectory == null) {
            instanceRootDirectory = new File(Utils.getInstancePathFromInstallPath(installPath));
        }
        return instanceRootDirectory;
    }

    public static String getInstallPathFromClasspath() {
        String installPath = null;
        String sep = System.getProperty("path.separator");
        String[] classPaths = System.getProperty("java.class.path").split(sep);
        String path = null;
        for (int i = 0; i < classPaths.length && path == null; ++i) {
            for (int j = 0; j < Installation.OPEN_DS_JAR_RELATIVE_PATHS.length && path == null; ++j) {
                String normPath = classPaths[i].replace(File.separatorChar, '/');
                if (!normPath.endsWith(Installation.OPEN_DS_JAR_RELATIVE_PATHS[j])) continue;
                path = classPaths[i];
            }
        }
        if (path != null) {
            File f = new File(path).getAbsoluteFile();
            File librariesDir = f.getParentFile();
            try {
                installPath = librariesDir.getParentFile().getCanonicalPath();
            }
            catch (IOException ioe) {
                installPath = librariesDir.getParent();
            }
        }
        return installPath;
    }

    public static boolean isServerRunning(File serverRootDirectory) {
        boolean isServerRunning;
        String lockFileName = "server.lock";
        String lockPathRelative = "locks";
        File locksPath = new File(serverRootDirectory, lockPathRelative);
        String lockFile = new File(locksPath, lockFileName).getAbsolutePath();
        StringBuilder failureReason = new StringBuilder();
        try {
            if (LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                LockFileManager.releaseLock(lockFile, failureReason);
                isServerRunning = false;
            } else {
                isServerRunning = true;
            }
        }
        catch (Throwable t) {
            isServerRunning = true;
        }
        return isServerRunning;
    }

    public static boolean isValidObjectclassName(String s) {
        boolean isValid;
        if (s == null || s.length() == 0) {
            isValid = false;
        } else {
            isValid = true;
            StringCharacterIterator iter = new StringCharacterIterator(s, 0);
            char c = iter.first();
            while (c != '\uffff' && isValid) {
                if (VALID_SCHEMA_SYNTAX.indexOf(Character.toLowerCase(c)) == -1) {
                    isValid = false;
                }
                c = iter.next();
            }
        }
        return isValid;
    }

    public static boolean isValidAttributeName(String s) {
        return Utilities.isValidObjectclassName(s);
    }

    public static String getVLVNameInCommandLine(VLVIndexDescriptor index) {
        return "vlv." + index.getName();
    }

    public static String getVLVNameInCellRenderer(VLVIndexDescriptor index) {
        return AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_CELL.get(index.getName()).toString();
    }

    public static boolean isStandard(SchemaFileElement fileElement) {
        CommonSchemaElements element;
        String xOrigin;
        boolean isStandard = false;
        String fileName = fileElement.getSchemaFile();
        if (fileName != null) {
            String name;
            String[] arr$ = standardSchemaFileNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(isStandard = fileName.equals(name = arr$[i$])); ++i$) {
            }
            if (!isStandard) {
                isStandard = fileName.toLowerCase().indexOf("-rfc") != -1;
            }
        } else if (fileElement instanceof CommonSchemaElements && (xOrigin = Utilities.getOrigin(element = (CommonSchemaElements)((Object)fileElement))) != null) {
            String name;
            String[] arr$ = standardSchemaOrigins;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(isStandard = xOrigin.equals(name = arr$[i$])); ++i$) {
            }
            if (!isStandard) {
                isStandard = xOrigin.startsWith("RFC ") || xOrigin.startsWith("draft-");
            }
        }
        return isStandard;
    }

    public static boolean isConfiguration(SchemaFileElement fileElement) {
        boolean isConfiguration;
        block3: {
            String name;
            CommonSchemaElements element;
            String xOrigin;
            block2: {
                String name2;
                isConfiguration = false;
                String fileName = fileElement.getSchemaFile();
                if (fileName == null) break block2;
                String[] arr$ = configurationSchemaFileNames;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(isConfiguration = fileName.equals(name2 = arr$[i$])); ++i$) {
                }
                break block3;
            }
            if (!(fileElement instanceof CommonSchemaElements) || (xOrigin = Utilities.getOrigin(element = (CommonSchemaElements)((Object)fileElement))) == null) break block3;
            String[] arr$ = configurationSchemaOrigins;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(isConfiguration = xOrigin.equals(name = arr$[i$])); ++i$) {
            }
        }
        return isConfiguration;
    }

    public static String getOrigin(CommonSchemaElements element) {
        Iterator<String> iterator;
        String xOrigin = null;
        Iterable<String> it = element.getExtraProperty("X-ORIGIN");
        if (it != null && (iterator = it.iterator()).hasNext()) {
            xOrigin = iterator.next();
        }
        return xOrigin;
    }

    public static String getSyntaxText(AttributeSyntax<?> syntax) {
        String syntaxName = syntax.getSyntaxName();
        String syntaxOID = syntax.getOID();
        String returnValue = syntaxName == null ? syntaxOID : syntaxName + " - " + syntaxOID;
        return returnValue;
    }

    public static boolean hasImageSyntax(String attrName, Schema schema) {
        AttributeType attr;
        boolean hasImageSyntax = false;
        if ((attrName = Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase()).equals("photo")) {
            hasImageSyntax = true;
        }
        if (!hasImageSyntax && schema != null && (attr = schema.getAttributeType(attrName)) != null) {
            String syntaxOID = attr.getSyntaxOID();
            hasImageSyntax = "1.3.6.1.4.1.1466.115.121.1.28".equals(syntaxOID);
        }
        return hasImageSyntax;
    }

    public static boolean hasBinarySyntax(String attrName, Schema schema) {
        AttributeType attr;
        boolean hasBinarySyntax;
        boolean bl = hasBinarySyntax = attrName.toLowerCase().indexOf(";binary") != -1;
        if (!hasBinarySyntax && schema != null && (attr = schema.getAttributeType(attrName = Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase())) != null) {
            String syntaxOID = attr.getSyntaxOID();
            for (String oid : binarySyntaxOIDs) {
                if (!oid.equals(syntaxOID)) continue;
                hasBinarySyntax = true;
                break;
            }
        }
        return hasBinarySyntax;
    }

    public static boolean hasPasswordSyntax(String attrName, Schema schema) {
        AttributeType attr;
        boolean hasPasswordSyntax = false;
        if (schema != null && (attr = schema.getAttributeType(attrName = Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase())) != null) {
            String syntaxOID = attr.getSyntaxOID();
            for (String oid : passwordSyntaxOIDs) {
                if (!oid.equals(syntaxOID)) continue;
                hasPasswordSyntax = true;
                break;
            }
        }
        return hasPasswordSyntax;
    }

    public static String getMatchingRuleText(MatchingRule matchingRule) {
        String name = matchingRule.getName();
        String oid = matchingRule.getOID();
        String returnValue = name == null ? oid : name + " - " + oid;
        return returnValue;
    }

    public static InitialLdapContext getAdminDirContext(ControlPanelInfo controlInfo, String bindDN, String pwd) throws NamingException, ConfigReadException {
        String usedUrl = controlInfo.getAdminConnectorURL();
        if (usedUrl == null) {
            throw new ConfigReadException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
        }
        InitialLdapContext ctx = Utils.createLdapsContext(usedUrl, bindDN, pwd, controlInfo.getConnectTimeout(), null, controlInfo.getTrustManager());
        Utilities.checkCanReadConfig(ctx);
        return ctx;
    }

    public static InitialLdapContext getUserDataDirContext(ControlPanelInfo controlInfo, String bindDN, String pwd) throws NamingException, ConfigReadException {
        InitialLdapContext ctx;
        if (controlInfo.connectUsingStartTLS()) {
            String usedUrl = controlInfo.getStartTLSURL();
            if (usedUrl == null) {
                throw new ConfigReadException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            ctx = Utils.createStartTLSContext(usedUrl, bindDN, pwd, controlInfo.getConnectTimeout(), null, controlInfo.getTrustManager(), null);
        } else if (controlInfo.connectUsingLDAPS()) {
            String usedUrl = controlInfo.getLDAPSURL();
            if (usedUrl == null) {
                throw new ConfigReadException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            ctx = Utils.createLdapsContext(usedUrl, bindDN, pwd, controlInfo.getConnectTimeout(), null, controlInfo.getTrustManager());
        } else {
            String usedUrl = controlInfo.getLDAPURL();
            if (usedUrl == null) {
                throw new ConfigReadException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            ctx = Utils.createLdapContext(usedUrl, bindDN, pwd, controlInfo.getConnectTimeout(), null);
        }
        Utilities.checkCanReadConfig(ctx);
        return ctx;
    }

    public static void checkCanReadConfig(InitialLdapContext ctx) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(new String[]{"1.1"});
        ctx.search("cn=config", "objectclass=*", searchControls);
    }

    public static void pingDirContext(InitialLdapContext ctx) throws NamingException {
        SearchControls sc = new SearchControls(0, 0L, 0, new String[0], false, false);
        ctx.search("", "objectClass=*", sc);
    }

    public static void deleteConfigSubtree(ConfigHandler confHandler, DN dn) throws OpenDsException {
        ConfigEntry confEntry = confHandler.getConfigEntry(dn);
        if (confEntry != null) {
            ArrayList childDNs = new ArrayList();
            childDNs.addAll(confEntry.getChildren().keySet());
            for (DN childDN : childDNs) {
                Utilities.deleteConfigSubtree(confHandler, childDN);
            }
            confHandler.deleteEntry(dn, null);
        }
    }

    public static void setRequiredIcon(JLabel label) {
        if (requiredIcon == null) {
            requiredIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/required.gif");
            requiredIcon.setDescription(AdminToolMessages.INFO_REQUIRED_ICON_ACCESSIBLE_DESCRIPTION.get().toString());
            requiredIcon.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_REQUIRED_ICON_ACCESSIBLE_DESCRIPTION.get().toString());
        }
        label.setIcon(requiredIcon);
        label.setHorizontalTextPosition(10);
    }

    public static void updateViewPositions(final ViewPositions pos) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < pos.size(); ++i) {
                    pos.getScrollPane(i).getViewport().setViewPosition(pos.getPoint(i));
                }
            }
        });
    }

    public static ViewPositions getViewPositions(Component comp) {
        ViewPositions pos = new ViewPositions();
        if (comp instanceof Container) {
            Utilities.updateContainedViewPositions((Container)comp, pos);
        }
        return pos;
    }

    public static JScrollPane getContainingScroll(Component comp) {
        JScrollPane scroll = null;
        Container parent = comp.getParent();
        while (scroll == null && parent != null) {
            if (parent instanceof JScrollPane) {
                scroll = (JScrollPane)parent;
                continue;
            }
            parent = parent.getParent();
        }
        return scroll;
    }

    private static void updateContainedViewPositions(Container comp, ViewPositions pos) {
        if (comp instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)comp;
            Point p = scroll.getViewport().getViewPosition();
            pos.add(scroll, p);
        } else {
            for (int i = 0; i < comp.getComponentCount(); ++i) {
                Component child = comp.getComponent(i);
                if (!(child instanceof Container)) continue;
                Utilities.updateContainedViewPositions((Container)child, pos);
            }
        }
    }

    public static Object getFirstMonitoringValue(CustomSearchResult sr, String attrName) {
        List<Object> values;
        Object o = null;
        if (sr != null && (values = sr.getAttributeValues(attrName)) != null && values.size() > 0) {
            o = values.iterator().next();
            try {
                Long l = Long.parseLong(o.toString());
                o = l;
            }
            catch (Throwable t1) {
                try {
                    Double d = Double.parseDouble(o.toString());
                    o = d;
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
        }
        return o;
    }

    public static String getMonitoringValue(MonitoringAttributes attr, CustomSearchResult monitoringEntry) {
        String returnValue;
        Object monitoringValue = Utilities.getFirstMonitoringValue(monitoringEntry, attr.getAttributeName());
        if (monitoringValue == null) {
            returnValue = NO_VALUE_SET.toString();
        } else if (Utilities.isNotImplemented(attr, monitoringEntry)) {
            returnValue = NOT_IMPLEMENTED.toString();
        } else if (attr.isNumericDate()) {
            if ("0".equals(monitoringValue.toString())) {
                returnValue = NO_VALUE_SET.toString();
            } else {
                Long l = Long.parseLong(monitoringValue.toString());
                Date date = new Date(l);
                returnValue = ConfigFromDirContext.formatter.format(date);
            }
        } else if (attr.isTime()) {
            returnValue = "-1".equals(monitoringValue.toString()) ? NO_VALUE_SET.toString() : monitoringValue.toString();
        } else if (attr.isGMTDate()) {
            try {
                Date date = ConfigFromDirContext.utcParser.parse(monitoringValue.toString());
                returnValue = ConfigFromDirContext.formatter.format(date);
            }
            catch (Throwable t) {
                returnValue = monitoringValue.toString();
            }
        } else if (attr.isValueInBytes()) {
            Long l = Long.parseLong(monitoringValue.toString());
            long mb = l / 0x100000L;
            long kbs = (l - mb * 1024L * 1024L) / 1024L;
            returnValue = AdminToolMessages.INFO_CTRL_PANEL_MEMORY_VALUE.get(mb, kbs).toString();
        } else {
            returnValue = monitoringValue.toString();
        }
        return returnValue;
    }

    public static boolean isNotImplemented(MonitoringAttributes attr, CustomSearchResult monitoringEntry) {
        boolean returnValue;
        Object monitoringValue = Utilities.getFirstMonitoringValue(monitoringEntry, attr.getAttributeName());
        if (attr.isNumeric() && monitoringValue != null) {
            try {
                Long.parseLong(String.valueOf(monitoringValue));
                returnValue = false;
            }
            catch (Throwable t) {
                returnValue = true;
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    public static void addClickTooltipListener(JComponent comp) {
        comp.addMouseListener(new ClickTooltipDisplayer());
    }

    public static void updateComboBoxModel(Collection<?> newElements, DefaultComboBoxModel model) {
        Utilities.updateComboBoxModel(newElements, model, null);
    }

    public static void updateComboBoxModel(Collection<?> newElements, DefaultComboBoxModel model, Comparator<Object> comparator) {
        boolean changed;
        boolean bl = changed = newElements.size() != model.getSize();
        if (!changed) {
            int i = 0;
            for (Object newElement : newElements) {
                if (comparator == null) {
                    changed = !newElement.equals(model.getElementAt(i));
                } else {
                    boolean bl2 = changed = comparator.compare(newElement, model.getElementAt(i)) != 0;
                }
                if (changed) break;
                ++i;
            }
        }
        if (changed) {
            Object selected = model.getSelectedItem();
            model.removeAllElements();
            boolean selectDefault = false;
            for (Object newElement : newElements) {
                model.addElement(newElement);
            }
            if (selected != null) {
                if (model.getIndexOf(selected) != -1) {
                    model.setSelectedItem(selected);
                } else {
                    selectDefault = true;
                }
            } else {
                selectDefault = true;
            }
            if (selectDefault) {
                for (int i = 0; i < model.getSize(); ++i) {
                    Object o = model.getElementAt(i);
                    if (o instanceof CategorizedComboBoxElement && ((CategorizedComboBoxElement)o).getType() == CategorizedComboBoxElement.Type.CATEGORY) continue;
                    model.setSelectedItem(o);
                    break;
                }
            }
        }
    }

    static {
        attrsToObfuscate = new String[]{"userpassword"};
        NO_VALUE_SET = AdminToolMessages.INFO_CTRL_PANEL_NO_MONITORING_VALUE.get();
        NOT_IMPLEMENTED = AdminToolMessages.INFO_CTRL_PANEL_NOT_IMPLEMENTED.get();
        standardSchemaFileNames = new String[]{"00-core.ldif", "01-pwpolicy.ldif", "03-changelog.ldif", "03-uddiv3.ldif", "05-solaris.ldif"};
        configurationSchemaOrigins = new String[]{"OpenDS Directory Server", "Sun Directory Server"};
        standardSchemaOrigins = new String[]{"Sun Java System Directory Server", "Solaris Specific", "X.501"};
        configurationSchemaFileNames = new String[]{"02-config.ldif", "06-compat.ldif"};
        binarySyntaxOIDs = new String[]{"1.3.6.1.4.1.1466.115.121.1.5", "1.3.6.1.4.1.1466.115.121.1.28", "1.3.6.1.4.1.1466.115.121.1.8", "1.3.6.1.4.1.1466.115.121.1.40"};
        passwordSyntaxOIDs = new String[]{"1.3.6.1.4.1.26027.1.3.1"};
    }
}

