/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.UserData;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class UninstallerArgumentParser
extends SecureConnectionCliParser {
    private BooleanArgument cliArg;
    private BooleanArgument noPromptArg;
    BooleanArgument forceOnErrorArg;
    private BooleanArgument quietArg;
    private BooleanArgument removeAllArg;
    private BooleanArgument removeServerLibrariesArg;
    private BooleanArgument removeDatabasesArg;
    private BooleanArgument removeLogFilesArg;
    private BooleanArgument removeConfigurationFilesArg;
    private BooleanArgument removeBackupFilesArg;
    private BooleanArgument removeLDIFFilesArg;
    private StringArgument referencedHostNameArg;
    private final boolean alwaysSSL = true;

    public UninstallerArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public void initializeGlobalArguments(OutputStream outStream) throws ArgumentException {
        LinkedHashSet<Argument> args = new LinkedHashSet<Argument>();
        this.cliArg = new BooleanArgument("cli", Character.valueOf('i'), "cli", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_CLI.get());
        args.add(this.cliArg);
        this.removeAllArg = new BooleanArgument("remove-all", Character.valueOf('a'), "remove-all", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_ALL.get());
        args.add(this.removeAllArg);
        this.removeServerLibrariesArg = new BooleanArgument("server-libraries", Character.valueOf('l'), "server-libraries", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_SERVER_LIBRARIES.get());
        args.add(this.removeServerLibrariesArg);
        this.removeDatabasesArg = new BooleanArgument("databases", Character.valueOf('d'), "databases", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_DATABASES.get());
        args.add(this.removeDatabasesArg);
        this.removeLogFilesArg = new BooleanArgument("log-files", Character.valueOf('L'), "log-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_LOG_FILES.get());
        args.add(this.removeLogFilesArg);
        this.removeConfigurationFilesArg = new BooleanArgument("configuration-files", Character.valueOf('c'), "configuration-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_CONFIGURATION_FILES.get());
        args.add(this.removeConfigurationFilesArg);
        this.removeBackupFilesArg = new BooleanArgument("backup-files", Character.valueOf('b'), "backup-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_BACKUP_FILES.get());
        args.add(this.removeBackupFilesArg);
        this.removeLDIFFilesArg = new BooleanArgument("ldif-files", Character.valueOf('e'), "ldif-files", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_REMOVE_LDIF_FILES.get());
        args.add(this.removeLDIFFilesArg);
        this.noPromptArg = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_DESCRIPTION_NO_PROMPT.get());
        args.add(this.noPromptArg);
        this.forceOnErrorArg = new BooleanArgument("forceOnError", Character.valueOf('f'), "forceOnError", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_FORCE.get("--" + this.noPromptArg.getLongIdentifier()));
        args.add(this.forceOnErrorArg);
        this.quietArg = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", AdminToolMessages.INFO_UNINSTALLDS_DESCRIPTION_QUIET.get());
        args.add(this.quietArg);
        for (Argument arg : args) {
            arg.setPropertyName(arg.getLongIdentifier());
        }
        ArrayList<Argument> defaultArgs = new ArrayList<Argument>(this.createGlobalArguments(outStream, true));
        int index = defaultArgs.indexOf(this.secureArgsList.bindDnArg);
        if (index != -1) {
            defaultArgs.add(index, this.secureArgsList.adminUidArg);
            defaultArgs.remove(this.secureArgsList.bindDnArg);
        } else {
            defaultArgs.add(this.secureArgsList.adminUidArg);
        }
        this.secureArgsList.adminUidArg.setHidden(false);
        defaultArgs.remove(this.secureArgsList.hostNameArg);
        defaultArgs.remove(this.secureArgsList.portArg);
        this.referencedHostNameArg = new StringArgument("referencedHostName", Character.valueOf('h'), "referencedHostName", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), UserData.getDefaultHostName(), "referencedHostName", AdminToolMessages.INFO_DESCRIPTION_REFERENCED_HOST.get());
        defaultArgs.add(this.referencedHostNameArg);
        args.addAll(defaultArgs);
        this.initializeGlobalArguments(args);
    }

    public boolean isInteractive() {
        return !this.noPromptArg.isPresent();
    }

    public boolean isForceOnError() {
        return this.forceOnErrorArg.isPresent();
    }

    public boolean isQuiet() {
        return this.quietArg.isPresent();
    }

    public boolean isVerbose() {
        return this.verboseArg.isPresent();
    }

    public boolean removeAll() {
        return this.removeAllArg.isPresent();
    }

    public boolean removeServerLibraries() {
        return this.removeServerLibrariesArg.isPresent();
    }

    public boolean removeDatabases() {
        return this.removeDatabasesArg.isPresent();
    }

    public boolean removeConfigurationFiles() {
        return this.removeConfigurationFilesArg.isPresent();
    }

    public boolean removeBackupFiles() {
        return this.removeBackupFilesArg.isPresent();
    }

    public boolean removeLDIFFiles() {
        return this.removeLDIFFilesArg.isPresent();
    }

    public boolean removeLogFiles() {
        return this.removeLogFilesArg.isPresent();
    }

    public String getDefaultAdministratorUID() {
        return this.secureArgsList.adminUidArg.getDefaultValue();
    }

    public String getReferencedHostName() {
        String hostName = null;
        if (this.referencedHostNameArg.isPresent()) {
            hostName = this.referencedHostNameArg.getValue();
        }
        return hostName;
    }

    public String getDefaultReferencedHostName() {
        return this.referencedHostNameArg.getDefaultValue();
    }

    public int validateGlobalOptions(MessageBuilder buf) {
        if (!this.noPromptArg.isPresent() && this.forceOnErrorArg.isPresent()) {
            Message message = AdminToolMessages.ERR_UNINSTALL_FORCE_REQUIRES_NO_PROMPT.get("--" + this.forceOnErrorArg.getLongIdentifier(), "--" + this.noPromptArg.getLongIdentifier());
            if (buf.length() > 0) {
                buf.append(EOL);
            }
            buf.append(message);
        }
        if (this.removeAllArg.isPresent()) {
            BooleanArgument[] removeArgs = new BooleanArgument[]{this.removeServerLibrariesArg, this.removeDatabasesArg, this.removeLogFilesArg, this.removeConfigurationFilesArg, this.removeBackupFilesArg, this.removeLDIFFilesArg};
            for (int i = 0; i < removeArgs.length; ++i) {
                if (!removeArgs[i].isPresent()) continue;
                Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.removeAllArg.getLongIdentifier(), removeArgs[i].getLongIdentifier());
                if (buf.length() > 0) {
                    buf.append(EOL);
                }
                buf.append(message);
            }
        }
        super.validateGlobalOptions(buf);
        int returnValue = buf.length() > 0 ? DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode() : DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
        return returnValue;
    }

    public boolean isCli() {
        return this.cliArg.isPresent();
    }

    SecureConnectionCliArgs getSecureArgsList() {
        return this.secureArgsList;
    }
}

