/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.Severity;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.InProcessServerController;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.ServerController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHealthChecker {
    private Installation installation = null;
    private List<Message> errors = null;
    private static final String UNHEALTHY_SERVER_LOG_REGEX = ".*(" + Severity.FATAL_ERROR.name() + "|" + Severity.SEVERE_ERROR.name() + ")+.*";

    public ServerHealthChecker(Installation installation) {
        this.installation = installation;
    }

    public void checkServer() throws ApplicationException {
        InProcessServerController control = null;
        try {
            control = new InProcessServerController(this.installation);
            if (this.installation.getStatus().isServerRunning()) {
                new ServerController(this.installation).stopServer(true);
            }
            OperationOutput op = control.startServer();
            this.errors = op.getErrorMessages(UNHEALTHY_SERVER_LOG_REGEX);
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_ERROR_SERVER_HEALTH_CHECK_FAILURE.get(), e);
        }
        finally {
            if (control != null) {
                control.stopServer();
            }
        }
    }

    public List<Message> getProblemMessages() {
        return this.errors;
    }
}

