/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.ldap.Rdn;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.LDAPConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.AdministrationConnectorCfg;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.FileBasedKeyManagerProviderCfg;
import org.opends.server.admin.std.server.FileBasedTrustManagerProviderCfg;
import org.opends.server.admin.std.server.KeyManagerProviderCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SynchronousStrategy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.CertificateManager;
import org.opends.server.util.SetupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdministrationConnector
implements ConfigurationChangeListener<AdministrationConnectorCfg> {
    public static final int DEFAULT_ADMINISTRATION_CONNECTOR_PORT = 4444;
    public static final int ADMIN_CERT_VALIDITY = 730;
    private static final String FRIENDLY_NAME = "Administration Connector";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LDAPConnectionHandler adminConnectionHandler;
    private AdministrationConnectorCfg config;
    private static final String ADMIN_CLASS_NAME = "org.opends.server.protocols.ldap.LDAPConnectionHandler";
    private static final boolean ADMIN_ALLOW_LDAP_V2 = true;
    private static final boolean ADMIN_ALLOW_START_TLS = false;
    private static final SortedSet<AddressMask> ADMIN_ALLOWED_CLIENT = new TreeSet<AddressMask>();
    private static final SortedSet<AddressMask> ADMIN_DENIED_CLIENT = new TreeSet<AddressMask>();
    private static final boolean ADMIN_ENABLED = true;
    private static final boolean ADMIN_KEEP_STATS = true;
    private static final boolean ADMIN_USE_SSL = true;
    private static final int ADMIN_ACCEPT_BACKLOG = 128;
    private static final boolean ADMIN_ALLOW_TCP_REUSE_ADDRESS = true;
    private static final long ADMIN_MAX_BLOCKED_WRITE_TIME_LIMIT = 120000L;
    private static final int ADMIN_MAX_REQUEST_SIZE = 5000000;
    private static final int ADMIN_WRITE_BUFFER_SIZE = 4096;
    private static final int ADMIN_NUM_REQUEST_HANDLERS = 1;
    private static final boolean ADMIN_SEND_REJECTION_NOTICE = true;
    private static final boolean ADMIN_USE_TCP_KEEP_ALIVE = true;
    private static final boolean ADMIN_USE_TCP_NO_DELAY = true;
    private static final LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy ADMIN_SSL_CLIENT_AUTH_POLICY = LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy.DISABLED;
    private static final SortedSet<String> ADMIN_SSL_CIPHER_SUITE = new TreeSet<String>();
    private static final SortedSet<String> ADMIN_SSL_PROTOCOL = new TreeSet<String>();

    public void initializeAdministrationConnector(AdministrationConnectorCfg configuration) throws ConfigException, InitializationException {
        this.config = configuration;
        FakeLDAPConnectionHandlerCfg ldapConnectionHandlerCfg = new FakeLDAPConnectionHandlerCfg(this.config);
        this.createSelfSignedCertifIfNeeded();
        this.adminConnectionHandler = new LDAPConnectionHandler(new SynchronousStrategy(), FRIENDLY_NAME);
        this.adminConnectionHandler.initializeConnectionHandler(ldapConnectionHandlerCfg);
        this.adminConnectionHandler.setAdminConnectionHandler();
        this.config.addChangeListener(this);
    }

    public LDAPConnectionHandler getConnectionHandler() {
        return this.adminConnectionHandler;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AdministrationConnectorCfg configuration, List<Message> unacceptableReasons) {
        FakeLDAPConnectionHandlerCfg cfg = new FakeLDAPConnectionHandlerCfg(configuration);
        return this.adminConnectionHandler.isConfigurationAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AdministrationConnectorCfg configuration) {
        return new ConfigChangeResult(ResultCode.SUCCESS, true, new ArrayList<Message>());
    }

    private void createSelfSignedCertifIfNeeded() throws InitializationException {
        try {
            String certAlias = this.config.getSSLCertNickname();
            KeyManagerProviderCfg keyMgrConfig = this.getAdminConnectorKeyManagerConfig(this.config.getKeyManagerProvider());
            TrustManagerProviderCfg trustMgrConfig = this.getAdminConnectorTrustManagerConfig(this.config.getTrustManagerProvider());
            if (!(keyMgrConfig instanceof FileBasedKeyManagerProviderCfg) || !(trustMgrConfig instanceof FileBasedTrustManagerProviderCfg)) {
                return;
            }
            FileBasedKeyManagerProviderCfg fbKeyManagerConfig = (FileBasedKeyManagerProviderCfg)keyMgrConfig;
            String keystorePath = AdministrationConnector.getFullPath(fbKeyManagerConfig.getKeyStoreFile());
            FileBasedTrustManagerProviderCfg fbTrustManagerConfig = (FileBasedTrustManagerProviderCfg)trustMgrConfig;
            String truststorePath = AdministrationConnector.getFullPath(fbTrustManagerConfig.getTrustStoreFile());
            String pinFilePath = AdministrationConnector.getFullPath(fbKeyManagerConfig.getKeyStorePinFile());
            boolean keystore = false;
            boolean truststore = false;
            boolean pinFile = false;
            int nbFiles = 0;
            if (new File(keystorePath).exists()) {
                keystore = true;
                ++nbFiles;
            }
            if (new File(truststorePath).exists()) {
                truststore = true;
                ++nbFiles;
            }
            if (new File(pinFilePath).exists()) {
                pinFile = true;
                ++nbFiles;
            }
            if (nbFiles == 3) {
                return;
            }
            if (nbFiles != 0) {
                String err = "";
                if (!keystore) {
                    err = err + keystorePath + " ";
                }
                if (!truststore) {
                    err = err + truststorePath + " ";
                }
                if (!pinFile) {
                    err = err + pinFilePath + " ";
                }
                Message message = AdminMessages.ERR_ADMIN_CERTIFICATE_GENERATION_MISSING_FILES.get(err);
                ErrorLogger.logError(message);
                throw new InitializationException(message);
            }
            String pwd = new String(SetupUtils.createSelfSignedCertificatePwd());
            CertificateManager certManager = new CertificateManager(AdministrationConnector.getFullPath(fbKeyManagerConfig.getKeyStoreFile()), fbKeyManagerConfig.getKeyStoreType(), pwd);
            String subjectDN = "cn=" + Rdn.escapeValue(InetAddress.getLocalHost().getHostName()) + ",O=" + FRIENDLY_NAME + " Self-Signed Certificate";
            certManager.generateSelfSignedCertificate(certAlias, subjectDN, 730);
            String tempCertPath = AdministrationConnector.getFullPath("config" + File.separator + "admin-cert.txt");
            SetupUtils.exportCertificate(certManager, certAlias, tempCertPath);
            CertificateManager trustManager = new CertificateManager(truststorePath, "JKS", pwd);
            trustManager.addCertificate(certAlias, new File(tempCertPath));
            if (!new File(pinFilePath).exists()) {
                FileWriter file = new FileWriter(pinFilePath);
                PrintWriter out = new PrintWriter(file);
                out.println(pwd);
                out.flush();
                out.close();
                file.close();
            }
            if (FilePermission.canSetPermissions()) {
                try {
                    if (!FilePermission.setPermissions(new File(pinFilePath), new FilePermission(384))) {
                        Message message = AdminMessages.WARN_ADMIN_SET_PERMISSIONS_FAILED.get(pinFilePath);
                        ErrorLogger.logError(message);
                    }
                }
                catch (DirectoryException e) {
                    Message message = AdminMessages.WARN_ADMIN_SET_PERMISSIONS_FAILED.get(pinFilePath);
                    ErrorLogger.logError(message);
                }
            }
            File f = new File(tempCertPath);
            f.delete();
        }
        catch (ConfigException e) {
            this.handleCertifExceptions(e);
        }
        catch (KeyStoreException e) {
            this.handleCertifExceptions(e);
        }
        catch (IOException e) {
            this.handleCertifExceptions(e);
        }
        catch (CertificateEncodingException e) {
            this.handleCertifExceptions(e);
        }
    }

    private void handleCertifExceptions(Exception e) throws InitializationException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
        Message message = AdminMessages.ERR_ADMIN_CERTIFICATE_GENERATION.get(e.getMessage());
        ErrorLogger.logError(message);
        throw new InitializationException(message);
    }

    private KeyManagerProviderCfg getAdminConnectorKeyManagerConfig(String name) throws ConfigException {
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        return root.getKeyManagerProvider(name);
    }

    private TrustManagerProviderCfg getAdminConnectorTrustManagerConfig(String name) throws ConfigException {
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        return root.getTrustManagerProvider(name);
    }

    private static String getFullPath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            path = DirectoryServer.getInstanceRoot() + File.separator + path;
        }
        return path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeLDAPConnectionHandlerCfg
    implements LDAPConnectionHandlerCfg {
        private final AdministrationConnectorCfg config;

        public FakeLDAPConnectionHandlerCfg(AdministrationConnectorCfg config) {
            this.config = config;
        }

        @Override
        public Class<? extends LDAPConnectionHandlerCfg> configurationClass() {
            return LDAPConnectionHandlerCfg.class;
        }

        @Override
        public void addLDAPChangeListener(ConfigurationChangeListener<LDAPConnectionHandlerCfg> listener) {
        }

        @Override
        public void removeLDAPChangeListener(ConfigurationChangeListener<LDAPConnectionHandlerCfg> listener) {
        }

        @Override
        public int getAcceptBacklog() {
            return 128;
        }

        @Override
        public boolean isAllowLDAPV2() {
            return true;
        }

        @Override
        public boolean isAllowStartTLS() {
            return false;
        }

        @Override
        public boolean isAllowTCPReuseAddress() {
            return true;
        }

        @Override
        public String getJavaClass() {
            return AdministrationConnector.ADMIN_CLASS_NAME;
        }

        @Override
        public boolean isKeepStats() {
            return true;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.config.getKeyManagerProvider();
        }

        @Override
        public DN getKeyManagerProviderDN() {
            return this.config.getKeyManagerProviderDN();
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.config.getListenAddress();
        }

        @Override
        public int getListenPort() {
            return this.config.getListenPort();
        }

        @Override
        public long getMaxBlockedWriteTimeLimit() {
            return 120000L;
        }

        @Override
        public long getMaxRequestSize() {
            return 5000000L;
        }

        @Override
        public long getBufferSize() {
            return 4096L;
        }

        @Override
        public int getNumRequestHandlers() {
            return 1;
        }

        @Override
        public boolean isSendRejectionNotice() {
            return true;
        }

        @Override
        public String getSSLCertNickname() {
            return this.config.getSSLCertNickname();
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return ADMIN_SSL_CIPHER_SUITE;
        }

        @Override
        public LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy getSSLClientAuthPolicy() {
            return ADMIN_SSL_CLIENT_AUTH_POLICY;
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return ADMIN_SSL_PROTOCOL;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.config.getTrustManagerProvider();
        }

        @Override
        public DN getTrustManagerProviderDN() {
            return this.config.getTrustManagerProviderDN();
        }

        @Override
        public boolean isUseSSL() {
            return true;
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return true;
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return true;
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return ADMIN_ALLOWED_CLIENT;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return ADMIN_DENIED_CLIENT;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public DN dn() {
            return this.config.dn();
        }
    }
}

