/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SizeUnit {
    BYTES(1L, "b", "bytes"),
    GIBI_BYTES(0x40000000L, "gib", "gibibytes"),
    GIGA_BYTES(1000000000L, "gb", "gigabytes"),
    KIBI_BYTES(1024L, "kib", "kibibytes"),
    KILO_BYTES(1000L, "kb", "kilobytes"),
    MEBI_BYTES(0x100000L, "mib", "mebibytes"),
    MEGA_BYTES(1000000L, "mb", "megabytes"),
    TEBI_BYTES(0x10000000000L, "tib", "tebibytes"),
    TERA_BYTES(1000000000000L, "tb", "terabytes");

    private static final Map<String, SizeUnit> nameToUnit;
    private final String longName;
    private final String shortName;
    private final long sz;

    public static SizeUnit getBestFitUnit(long bytes) throws IllegalArgumentException {
        if (bytes < 0L) {
            throw new IllegalArgumentException("negative number of bytes: " + bytes);
        }
        if (bytes == 0L) {
            return BYTES;
        }
        SizeUnit[] nonBinary = new SizeUnit[]{TERA_BYTES, GIGA_BYTES, MEGA_BYTES, KILO_BYTES};
        SizeUnit[] binary = new SizeUnit[]{TEBI_BYTES, GIBI_BYTES, MEBI_BYTES, KIBI_BYTES};
        for (int i = 0; i < nonBinary.length; ++i) {
            if (bytes % binary[i].getSize() == 0L) {
                return binary[i];
            }
            if (bytes / nonBinary[i].getSize() <= 0L) continue;
            return nonBinary[i];
        }
        return BYTES;
    }

    public static SizeUnit getBestFitUnitExact(long bytes) throws IllegalArgumentException {
        SizeUnit[] units;
        if (bytes < 0L) {
            throw new IllegalArgumentException("negative number of bytes: " + bytes);
        }
        if (bytes == 0L) {
            return BYTES;
        }
        for (SizeUnit unit : units = new SizeUnit[]{TEBI_BYTES, TERA_BYTES, GIBI_BYTES, GIGA_BYTES, MEBI_BYTES, MEGA_BYTES, KIBI_BYTES, KILO_BYTES}) {
            if (bytes % unit.getSize() != 0L) continue;
            return unit;
        }
        return BYTES;
    }

    public static SizeUnit getUnit(String s) throws IllegalArgumentException {
        SizeUnit unit = nameToUnit.get(s.trim().toLowerCase());
        if (unit == null) {
            throw new IllegalArgumentException("Illegal memory size unit \"" + s + "\"");
        }
        return unit;
    }

    public static long parseValue(String s) throws NumberFormatException {
        return SizeUnit.parseValue(s, null);
    }

    public static long parseValue(String s, SizeUnit defaultUnit) throws NumberFormatException {
        SizeUnit unit;
        double d;
        Pattern p = Pattern.compile("^\\s*(\\d+(\\.\\d+)?)\\s*(\\w+)?\\s*$");
        Matcher m = p.matcher(s);
        if (!m.matches()) {
            throw new NumberFormatException("Invalid size value \"" + s + "\"");
        }
        try {
            d = Double.valueOf(m.group(1));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid size value \"" + s + "\"");
        }
        String unitString = m.group(3);
        if (unitString == null) {
            if (defaultUnit == null) {
                throw new NumberFormatException("Invalid size value \"" + s + "\"");
            }
            unit = defaultUnit;
        } else {
            try {
                unit = SizeUnit.getUnit(unitString);
            }
            catch (IllegalArgumentException e) {
                throw new NumberFormatException("Invalid size value \"" + s + "\"");
            }
        }
        return unit.toBytes(d);
    }

    private SizeUnit(long sz, String shortName, String longName) {
        this.sz = sz;
        this.shortName = shortName;
        this.longName = longName;
    }

    public double fromBytes(long amount) {
        return (double)amount / (double)this.sz;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long getSize() {
        return this.sz;
    }

    public long toBytes(double amount) throws NumberFormatException {
        double value = (double)this.sz * amount;
        if (value > 9.223372036854776E18) {
            throw new NumberFormatException("number too big (exceeded long.MAX_VALUE");
        }
        return (long)value;
    }

    public String toString() {
        return this.shortName;
    }

    static {
        nameToUnit = new HashMap<String, SizeUnit>();
        for (SizeUnit unit : SizeUnit.values()) {
            nameToUnit.put(unit.shortName, unit);
            nameToUnit.put(unit.longName, unit);
        }
    }
}

