/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import java.util.LinkedList;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.ManagedObjectPathSerializer;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LDAPNameBuilder
implements ManagedObjectPathSerializer {
    private final LinkedList<Rdn> rdns = new LinkedList();
    private final LDAPProfile profile;

    public static LdapName create(ManagedObjectPath<?, ?> path, LDAPProfile profile) {
        LDAPNameBuilder builder = new LDAPNameBuilder(profile);
        path.serialize(builder);
        return builder.getInstance();
    }

    public static LdapName create(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> relation, LDAPProfile profile) {
        LDAPNameBuilder builder = new LDAPNameBuilder(profile);
        path.serialize(builder);
        builder.appendManagedObjectPathElement(relation);
        return builder.getInstance();
    }

    public static LdapName create(ManagedObjectPath<?, ?> path, SetRelationDefinition<?, ?> relation, LDAPProfile profile) {
        LDAPNameBuilder builder = new LDAPNameBuilder(profile);
        path.serialize(builder);
        builder.appendManagedObjectPathElement(relation);
        return builder.getInstance();
    }

    public LDAPNameBuilder(LDAPProfile profile) {
        this.profile = profile;
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
        this.appendManagedObjectPathElement(r);
        String type = this.profile.getRelationChildRDNType(r);
        try {
            Rdn rdn = new Rdn(type, name.trim());
            this.rdns.add(rdn);
        }
        catch (InvalidNameException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void appendManagedObjectPathElement(RelationDefinition<?, ?> r) {
        try {
            LdapName tmp = new LdapName(this.profile.getRelationRDNSequence(r));
            this.rdns.addAll(tmp.getRdns());
        }
        catch (InvalidNameException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
        String type = this.profile.getRelationChildRDNType(r);
        try {
            Rdn rdn = new Rdn(type, d.getName());
            this.rdns.add(rdn);
        }
        catch (InvalidNameException e1) {
            throw new RuntimeException(e1);
        }
    }

    public LdapName getInstance() {
        return new LdapName(this.rdns);
    }
}

