/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.AdministrationConnectorCfgClient;
import org.opends.server.admin.std.client.KeyManagerProviderCfgClient;
import org.opends.server.admin.std.client.TrustManagerProviderCfgClient;
import org.opends.server.admin.std.server.AdministrationConnectorCfg;
import org.opends.server.admin.std.server.KeyManagerProviderCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdministrationConnectorCfgDefn
extends ManagedObjectDefinition<AdministrationConnectorCfgClient, AdministrationConnectorCfg> {
    private static final AdministrationConnectorCfgDefn INSTANCE = new AdministrationConnectorCfgDefn();
    private static final AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> PD_KEY_MANAGER_PROVIDER;
    private static final IPAddressPropertyDefinition PD_LISTEN_ADDRESS;
    private static final IntegerPropertyDefinition PD_LISTEN_PORT;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;

    public static AdministrationConnectorCfgDefn getInstance() {
        return INSTANCE;
    }

    private AdministrationConnectorCfgDefn() {
        super("administration-connector", TopCfgDefn.getInstance());
    }

    @Override
    public AdministrationConnectorCfgClient createClientConfiguration(ManagedObject<? extends AdministrationConnectorCfgClient> impl) {
        return new AdministrationConnectorCfgClientImpl(impl);
    }

    @Override
    public AdministrationConnectorCfg createServerConfiguration(ServerManagedObject<? extends AdministrationConnectorCfg> impl) {
        return new AdministrationConnectorCfgServerImpl(impl);
    }

    @Override
    public Class<AdministrationConnectorCfg> getServerConfigurationClass() {
        return AdministrationConnectorCfg.class;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER;
    }

    public IPAddressPropertyDefinition getListenAddressPropertyDefinition() {
        return PD_LISTEN_ADDRESS;
    }

    public IntegerPropertyDefinition getListenPortPropertyDefinition() {
        return PD_LISTEN_PORT;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "key-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("key-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_KEY_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_KEY_MANAGER_PROVIDER.getSourceConstraint());
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "listen-address");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "listen-address"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("0.0.0.0");
        builder.setDefaultBehaviorProvider(provider);
        PD_LISTEN_ADDRESS = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_ADDRESS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "listen-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_LISTEN_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_PORT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdministrationConnectorCfgServerImpl
    implements AdministrationConnectorCfg {
        private ServerManagedObject<? extends AdministrationConnectorCfg> impl;
        private final String pKeyManagerProvider;
        private final SortedSet<InetAddress> pListenAddress;
        private final int pListenPort;
        private final String pSSLCertNickname;
        private final String pTrustManagerProvider;

        private AdministrationConnectorCfgServerImpl(ServerManagedObject<? extends AdministrationConnectorCfg> impl) {
            this.impl = impl;
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pListenAddress = impl.getPropertyValues((PropertyDefinition)INSTANCE.getListenAddressPropertyDefinition());
            this.pListenPort = impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AdministrationConnectorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AdministrationConnectorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.pListenAddress;
        }

        @Override
        public int getListenPort() {
            return this.pListenPort;
        }

        @Override
        public String getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public Class<? extends AdministrationConnectorCfg> configurationClass() {
            return AdministrationConnectorCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdministrationConnectorCfgClientImpl
    implements AdministrationConnectorCfgClient {
        private ManagedObject<? extends AdministrationConnectorCfgClient> impl;

        private AdministrationConnectorCfgClientImpl(ManagedObject<? extends AdministrationConnectorCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.impl.getPropertyValues(INSTANCE.getListenAddressPropertyDefinition());
        }

        @Override
        public void setListenAddress(Collection<InetAddress> values) {
            this.impl.setPropertyValues(INSTANCE.getListenAddressPropertyDefinition(), values);
        }

        @Override
        public Integer getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public void setListenPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getListenPortPropertyDefinition(), value);
        }

        @Override
        public String getSSLCertNickname() {
            return this.impl.getPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(String value) {
            this.impl.setPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition(), value);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends AdministrationConnectorCfgClient, ? extends AdministrationConnectorCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

