/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultManagedObject;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBIndexCfgClient;
import org.opends.server.admin.std.client.LocalDBVLVIndexCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.admin.std.server.LocalDBVLVIndexCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDBBackendCfgDefn
extends ManagedObjectDefinition<LocalDBBackendCfgClient, LocalDBBackendCfg> {
    private static final LocalDBBackendCfgDefn INSTANCE = new LocalDBBackendCfgDefn();
    private static final BooleanPropertyDefinition PD_COMPACT_ENCODING;
    private static final IntegerPropertyDefinition PD_DB_CACHE_PERCENT;
    private static final SizePropertyDefinition PD_DB_CACHE_SIZE;
    private static final SizePropertyDefinition PD_DB_CHECKPOINTER_BYTES_INTERVAL;
    private static final DurationPropertyDefinition PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    private static final IntegerPropertyDefinition PD_DB_CLEANER_MIN_UTILIZATION;
    private static final StringPropertyDefinition PD_DB_DIRECTORY;
    private static final StringPropertyDefinition PD_DB_DIRECTORY_PERMISSIONS;
    private static final BooleanPropertyDefinition PD_DB_EVICTOR_LRU_ONLY;
    private static final IntegerPropertyDefinition PD_DB_EVICTOR_NODES_PER_SCAN;
    private static final SizePropertyDefinition PD_DB_LOG_FILE_MAX;
    private static final BooleanPropertyDefinition PD_DB_LOGGING_FILE_HANDLER_ON;
    private static final StringPropertyDefinition PD_DB_LOGGING_LEVEL;
    private static final IntegerPropertyDefinition PD_DB_NUM_CLEANER_THREADS;
    private static final IntegerPropertyDefinition PD_DB_NUM_LOCK_TABLES;
    private static final BooleanPropertyDefinition PD_DB_RUN_CLEANER;
    private static final BooleanPropertyDefinition PD_DB_TXN_NO_SYNC;
    private static final BooleanPropertyDefinition PD_DB_TXN_WRITE_NO_SYNC;
    private static final BooleanPropertyDefinition PD_ENTRIES_COMPRESSED;
    private static final IntegerPropertyDefinition PD_IMPORT_QUEUE_SIZE;
    private static final IntegerPropertyDefinition PD_IMPORT_THREAD_COUNT;
    private static final IntegerPropertyDefinition PD_INDEX_ENTRY_LIMIT;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_JE_PROPERTY;
    private static final DurationPropertyDefinition PD_PRELOAD_TIME_LIMIT;
    private static final EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> PD_WRITABILITY_MODE;
    private static final InstantiableRelationDefinition<LocalDBIndexCfgClient, LocalDBIndexCfg> RD_LOCAL_DB_INDEXES;
    private static final InstantiableRelationDefinition<LocalDBVLVIndexCfgClient, LocalDBVLVIndexCfg> RD_LOCAL_DB_VLV_INDEXES;

    public static LocalDBBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private LocalDBBackendCfgDefn() {
        super("local-db-backend", BackendCfgDefn.getInstance());
    }

    @Override
    public LocalDBBackendCfgClient createClientConfiguration(ManagedObject<? extends LocalDBBackendCfgClient> impl) {
        return new LocalDBBackendCfgClientImpl(impl);
    }

    @Override
    public LocalDBBackendCfg createServerConfiguration(ServerManagedObject<? extends LocalDBBackendCfg> impl) {
        return new LocalDBBackendCfgServerImpl(impl);
    }

    @Override
    public Class<LocalDBBackendCfg> getServerConfigurationClass() {
        return LocalDBBackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public BooleanPropertyDefinition getCompactEncodingPropertyDefinition() {
        return PD_COMPACT_ENCODING;
    }

    public IntegerPropertyDefinition getDBCachePercentPropertyDefinition() {
        return PD_DB_CACHE_PERCENT;
    }

    public SizePropertyDefinition getDBCacheSizePropertyDefinition() {
        return PD_DB_CACHE_SIZE;
    }

    public SizePropertyDefinition getDBCheckpointerBytesIntervalPropertyDefinition() {
        return PD_DB_CHECKPOINTER_BYTES_INTERVAL;
    }

    public DurationPropertyDefinition getDBCheckpointerWakeupIntervalPropertyDefinition() {
        return PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    }

    public IntegerPropertyDefinition getDBCleanerMinUtilizationPropertyDefinition() {
        return PD_DB_CLEANER_MIN_UTILIZATION;
    }

    public StringPropertyDefinition getDBDirectoryPropertyDefinition() {
        return PD_DB_DIRECTORY;
    }

    public StringPropertyDefinition getDBDirectoryPermissionsPropertyDefinition() {
        return PD_DB_DIRECTORY_PERMISSIONS;
    }

    public BooleanPropertyDefinition getDBEvictorLruOnlyPropertyDefinition() {
        return PD_DB_EVICTOR_LRU_ONLY;
    }

    public IntegerPropertyDefinition getDBEvictorNodesPerScanPropertyDefinition() {
        return PD_DB_EVICTOR_NODES_PER_SCAN;
    }

    public SizePropertyDefinition getDBLogFileMaxPropertyDefinition() {
        return PD_DB_LOG_FILE_MAX;
    }

    public BooleanPropertyDefinition getDBLoggingFileHandlerOnPropertyDefinition() {
        return PD_DB_LOGGING_FILE_HANDLER_ON;
    }

    public StringPropertyDefinition getDBLoggingLevelPropertyDefinition() {
        return PD_DB_LOGGING_LEVEL;
    }

    public IntegerPropertyDefinition getDBNumCleanerThreadsPropertyDefinition() {
        return PD_DB_NUM_CLEANER_THREADS;
    }

    public IntegerPropertyDefinition getDBNumLockTablesPropertyDefinition() {
        return PD_DB_NUM_LOCK_TABLES;
    }

    public BooleanPropertyDefinition getDBRunCleanerPropertyDefinition() {
        return PD_DB_RUN_CLEANER;
    }

    public BooleanPropertyDefinition getDBTxnNoSyncPropertyDefinition() {
        return PD_DB_TXN_NO_SYNC;
    }

    public BooleanPropertyDefinition getDBTxnWriteNoSyncPropertyDefinition() {
        return PD_DB_TXN_WRITE_NO_SYNC;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return BackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getEntriesCompressedPropertyDefinition() {
        return PD_ENTRIES_COMPRESSED;
    }

    public IntegerPropertyDefinition getImportQueueSizePropertyDefinition() {
        return PD_IMPORT_QUEUE_SIZE;
    }

    public IntegerPropertyDefinition getImportThreadCountPropertyDefinition() {
        return PD_IMPORT_THREAD_COUNT;
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PD_INDEX_ENTRY_LIMIT;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getJEPropertyPropertyDefinition() {
        return PD_JE_PROPERTY;
    }

    public DurationPropertyDefinition getPreloadTimeLimitPropertyDefinition() {
        return PD_PRELOAD_TIME_LIMIT;
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    public InstantiableRelationDefinition<LocalDBIndexCfgClient, LocalDBIndexCfg> getLocalDBIndexesRelationDefinition() {
        return RD_LOCAL_DB_INDEXES;
    }

    public InstantiableRelationDefinition<LocalDBVLVIndexCfgClient, LocalDBVLVIndexCfg> getLocalDBVLVIndexesRelationDefinition() {
        return RD_LOCAL_DB_VLV_INDEXES;
    }

    static {
        InstantiableRelationDefinition.Builder<LocalDBVLVIndexCfgClient, LocalDBVLVIndexCfg> builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "compact-encoding");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "compact-encoding"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_COMPACT_ENCODING = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_COMPACT_ENCODING);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-cache-percent");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-percent"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DB_CACHE_PERCENT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_PERCENT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-cache-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-size"));
        provider = new DefinedDefaultBehaviorProvider("0 MB");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("0 MB");
        PD_DB_CACHE_SIZE = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_SIZE);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-checkpointer-bytes-interval");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "db-checkpointer-bytes-interval"));
        provider = new DefinedDefaultBehaviorProvider("100mb");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setUpperLimit("9223372036854775807b");
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("0b");
        PD_DB_CHECKPOINTER_BYTES_INTERVAL = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CHECKPOINTER_BYTES_INTERVAL);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "db-checkpointer-wakeup-interval");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-checkpointer-wakeup-interval"));
        provider = new DefinedDefaultBehaviorProvider("30s");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setUpperLimit("4294");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("1");
        PD_DB_CHECKPOINTER_WAKEUP_INTERVAL = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CHECKPOINTER_WAKEUP_INTERVAL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-cleaner-min-utilization");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cleaner-min-utilization"));
        provider = new DefinedDefaultBehaviorProvider("50");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_DB_CLEANER_MIN_UTILIZATION = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CLEANER_MIN_UTILIZATION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-directory"));
        provider = new DefinedDefaultBehaviorProvider("db");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_DIRECTORY = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory-permissions");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "db-directory-permissions"));
        provider = new DefinedDefaultBehaviorProvider("700");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)((Object)builder)).setPattern("^7[0-7][0-7]$", "MODE");
        PD_DB_DIRECTORY_PERMISSIONS = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY_PERMISSIONS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-evictor-lru-only");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-evictor-lru-only"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_EVICTOR_LRU_ONLY = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_LRU_ONLY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-evictor-nodes-per-scan");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-evictor-nodes-per-scan"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(1000);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DB_EVICTOR_NODES_PER_SCAN = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_NODES_PER_SCAN);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-log-file-max");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-log-file-max"));
        provider = new DefinedDefaultBehaviorProvider("100mb");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setUpperLimit("4gib");
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("1mb");
        PD_DB_LOG_FILE_MAX = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOG_FILE_MAX);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-logging-file-handler-on");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-logging-file-handler-on"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_LOGGING_FILE_HANDLER_ON = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOGGING_FILE_HANDLER_ON);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-logging-level");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-logging-level"));
        provider = new DefinedDefaultBehaviorProvider("CONFIG");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_LOGGING_LEVEL = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOGGING_LEVEL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-num-cleaner-threads");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-num-cleaner-threads"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "db-num-cleaner-threads"));
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DB_NUM_CLEANER_THREADS = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_NUM_CLEANER_THREADS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-num-lock-tables");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-num-lock-tables"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "db-num-lock-tables"));
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit((Integer)Short.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DB_NUM_LOCK_TABLES = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_NUM_LOCK_TABLES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-run-cleaner");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-run-cleaner"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_RUN_CLEANER = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_RUN_CLEANER);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-txn-no-sync");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-txn-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_TXN_NO_SYNC = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_TXN_NO_SYNC);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-txn-write-no-sync");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-txn-write-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DB_TXN_WRITE_NO_SYNC = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_TXN_WRITE_NO_SYNC);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "entries-compressed");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "entries-compressed"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_ENTRIES_COMPRESSED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENTRIES_COMPRESSED);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "import-queue-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "import-queue-size"));
        provider = new DefinedDefaultBehaviorProvider("100");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_IMPORT_QUEUE_SIZE = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_IMPORT_QUEUE_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "import-thread-count");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "import-thread-count"));
        provider = new DefinedDefaultBehaviorProvider("8");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_IMPORT_THREAD_COUNT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_IMPORT_THREAD_COUNT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-entry-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "index-entry-limit"));
        provider = new DefinedDefaultBehaviorProvider("4000");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ENTRY_LIMIT);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.jeb.BackendImpl");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)((Object)builder)).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "je-property");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "je-property"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_JE_PROPERTY = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_JE_PROPERTY);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "preload-time-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "preload-time-limit"));
        provider = new DefinedDefaultBehaviorProvider("0s");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("0");
        PD_PRELOAD_TIME_LIMIT = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRELOAD_TIME_LIMIT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        provider = new DefinedDefaultBehaviorProvider("enabled");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)((Object)builder)).setEnumClass(BackendCfgDefn.WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        builder = new InstantiableRelationDefinition.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(INSTANCE, "local-db-index", "local-db-indexes", LocalDBIndexCfgDefn.getInstance());
        builder.setNamingProperty(LocalDBIndexCfgDefn.getInstance().getAttributePropertyDefinition());
        DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg> dmoBuilder = new DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(LocalDBIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "presence");
        dmoBuilder.setPropertyValues("attribute", "aci");
        builder.setDefaultManagedObject("aci", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(LocalDBIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "entryUUID");
        builder.setDefaultManagedObject("entryUUID", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(LocalDBIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "objectClass");
        builder.setDefaultManagedObject("objectClass", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(LocalDBIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "ordering");
        dmoBuilder.setPropertyValues("attribute", "ds-sync-hist");
        builder.setDefaultManagedObject("ds-sync-hist", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<LocalDBIndexCfgClient, LocalDBIndexCfg>(LocalDBIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "ds-sync-conflict");
        builder.setDefaultManagedObject("ds-sync-conflict", dmoBuilder.getInstance());
        RD_LOCAL_DB_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_LOCAL_DB_INDEXES);
        builder = new InstantiableRelationDefinition.Builder<LocalDBVLVIndexCfgClient, LocalDBVLVIndexCfg>(INSTANCE, "local-db-vlv-index", "local-db-vlv-indexes", LocalDBVLVIndexCfgDefn.getInstance());
        builder.setNamingProperty(LocalDBVLVIndexCfgDefn.getInstance().getNamePropertyDefinition());
        RD_LOCAL_DB_VLV_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_LOCAL_DB_VLV_INDEXES);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDBBackendCfgServerImpl
    implements LocalDBBackendCfg {
        private ServerManagedObject<? extends LocalDBBackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final boolean pCompactEncoding;
        private final int pDBCachePercent;
        private final long pDBCacheSize;
        private final long pDBCheckpointerBytesInterval;
        private final long pDBCheckpointerWakeupInterval;
        private final int pDBCleanerMinUtilization;
        private final String pDBDirectory;
        private final String pDBDirectoryPermissions;
        private final boolean pDBEvictorLruOnly;
        private final int pDBEvictorNodesPerScan;
        private final long pDBLogFileMax;
        private final boolean pDBLoggingFileHandlerOn;
        private final String pDBLoggingLevel;
        private final Integer pDBNumCleanerThreads;
        private final Integer pDBNumLockTables;
        private final boolean pDBRunCleaner;
        private final boolean pDBTxnNoSync;
        private final boolean pDBTxnWriteNoSync;
        private final boolean pEnabled;
        private final boolean pEntriesCompressed;
        private final int pImportQueueSize;
        private final int pImportThreadCount;
        private final int pIndexEntryLimit;
        private final String pJavaClass;
        private final SortedSet<String> pJEProperty;
        private final long pPreloadTimeLimit;
        private final BackendCfgDefn.WritabilityMode pWritabilityMode;

        private LocalDBBackendCfgServerImpl(ServerManagedObject<? extends LocalDBBackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pCompactEncoding = impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
            this.pDBCachePercent = impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
            this.pDBCacheSize = impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
            this.pDBCheckpointerBytesInterval = impl.getPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition());
            this.pDBCheckpointerWakeupInterval = impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
            this.pDBCleanerMinUtilization = impl.getPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition());
            this.pDBDirectory = impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
            this.pDBDirectoryPermissions = impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
            this.pDBEvictorLruOnly = impl.getPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition());
            this.pDBEvictorNodesPerScan = impl.getPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition());
            this.pDBLogFileMax = impl.getPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition());
            this.pDBLoggingFileHandlerOn = impl.getPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition());
            this.pDBLoggingLevel = impl.getPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition());
            this.pDBNumCleanerThreads = impl.getPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition());
            this.pDBNumLockTables = impl.getPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition());
            this.pDBRunCleaner = impl.getPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition());
            this.pDBTxnNoSync = impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
            this.pDBTxnWriteNoSync = impl.getPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pEntriesCompressed = impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
            this.pImportQueueSize = impl.getPropertyValue(INSTANCE.getImportQueueSizePropertyDefinition());
            this.pImportThreadCount = impl.getPropertyValue(INSTANCE.getImportThreadCountPropertyDefinition());
            this.pIndexEntryLimit = impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pJEProperty = impl.getPropertyValues((PropertyDefinition)INSTANCE.getJEPropertyPropertyDefinition());
            this.pPreloadTimeLimit = impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addLocalDBChangeListener(ConfigurationChangeListener<LocalDBBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLocalDBChangeListener(ConfigurationChangeListener<LocalDBBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isCompactEncoding() {
            return this.pCompactEncoding;
        }

        @Override
        public int getDBCachePercent() {
            return this.pDBCachePercent;
        }

        @Override
        public long getDBCacheSize() {
            return this.pDBCacheSize;
        }

        @Override
        public long getDBCheckpointerBytesInterval() {
            return this.pDBCheckpointerBytesInterval;
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.pDBCheckpointerWakeupInterval;
        }

        @Override
        public int getDBCleanerMinUtilization() {
            return this.pDBCleanerMinUtilization;
        }

        @Override
        public String getDBDirectory() {
            return this.pDBDirectory;
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.pDBDirectoryPermissions;
        }

        @Override
        public boolean isDBEvictorLruOnly() {
            return this.pDBEvictorLruOnly;
        }

        @Override
        public int getDBEvictorNodesPerScan() {
            return this.pDBEvictorNodesPerScan;
        }

        @Override
        public long getDBLogFileMax() {
            return this.pDBLogFileMax;
        }

        @Override
        public boolean isDBLoggingFileHandlerOn() {
            return this.pDBLoggingFileHandlerOn;
        }

        @Override
        public String getDBLoggingLevel() {
            return this.pDBLoggingLevel;
        }

        @Override
        public Integer getDBNumCleanerThreads() {
            return this.pDBNumCleanerThreads;
        }

        @Override
        public Integer getDBNumLockTables() {
            return this.pDBNumLockTables;
        }

        @Override
        public boolean isDBRunCleaner() {
            return this.pDBRunCleaner;
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.pDBTxnNoSync;
        }

        @Override
        public boolean isDBTxnWriteNoSync() {
            return this.pDBTxnWriteNoSync;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.pEntriesCompressed;
        }

        @Override
        public int getImportQueueSize() {
            return this.pImportQueueSize;
        }

        @Override
        public int getImportThreadCount() {
            return this.pImportThreadCount;
        }

        @Override
        public int getIndexEntryLimit() {
            return this.pIndexEntryLimit;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<String> getJEProperty() {
            return this.pJEProperty;
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.pPreloadTimeLimit;
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public String[] listLocalDBIndexes() {
            return this.impl.listChildren(INSTANCE.getLocalDBIndexesRelationDefinition());
        }

        @Override
        public LocalDBIndexCfg getLocalDBIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getLocalDBIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addLocalDBIndexAddListener(ConfigurationAddListener<LocalDBIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getLocalDBIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeLocalDBIndexAddListener(ConfigurationAddListener<LocalDBIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getLocalDBIndexesRelationDefinition(), listener);
        }

        @Override
        public void addLocalDBIndexDeleteListener(ConfigurationDeleteListener<LocalDBIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getLocalDBIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeLocalDBIndexDeleteListener(ConfigurationDeleteListener<LocalDBIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getLocalDBIndexesRelationDefinition(), listener);
        }

        @Override
        public String[] listLocalDBVLVIndexes() {
            return this.impl.listChildren(INSTANCE.getLocalDBVLVIndexesRelationDefinition());
        }

        @Override
        public LocalDBVLVIndexCfg getLocalDBVLVIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addLocalDBVLVIndexAddListener(ConfigurationAddListener<LocalDBVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeLocalDBVLVIndexAddListener(ConfigurationAddListener<LocalDBVLVIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void addLocalDBVLVIndexDeleteListener(ConfigurationDeleteListener<LocalDBVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeLocalDBVLVIndexDeleteListener(ConfigurationDeleteListener<LocalDBVLVIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public Class<? extends LocalDBBackendCfg> configurationClass() {
            return LocalDBBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDBBackendCfgClientImpl
    implements LocalDBBackendCfgClient {
        private ManagedObject<? extends LocalDBBackendCfgClient> impl;

        private LocalDBBackendCfgClientImpl(ManagedObject<? extends LocalDBBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public boolean isCompactEncoding() {
            return this.impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
        }

        @Override
        public void setCompactEncoding(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition(), value);
        }

        @Override
        public int getDBCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
        }

        @Override
        public void setDBCachePercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition(), value);
        }

        @Override
        public long getDBCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
        }

        @Override
        public void setDBCacheSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition(), value);
        }

        @Override
        public long getDBCheckpointerBytesInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition());
        }

        @Override
        public void setDBCheckpointerBytesInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition(), value);
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
        }

        @Override
        public void setDBCheckpointerWakeupInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition(), value);
        }

        @Override
        public int getDBCleanerMinUtilization() {
            return this.impl.getPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition());
        }

        @Override
        public void setDBCleanerMinUtilization(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
        }

        @Override
        public void setDBDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
        }

        @Override
        public void setDBDirectoryPermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition(), value);
        }

        @Override
        public boolean isDBEvictorLruOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition());
        }

        @Override
        public void setDBEvictorLruOnly(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition(), value);
        }

        @Override
        public int getDBEvictorNodesPerScan() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition());
        }

        @Override
        public void setDBEvictorNodesPerScan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition(), value);
        }

        @Override
        public long getDBLogFileMax() {
            return this.impl.getPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition());
        }

        @Override
        public void setDBLogFileMax(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition(), value);
        }

        @Override
        public boolean isDBLoggingFileHandlerOn() {
            return this.impl.getPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition());
        }

        @Override
        public void setDBLoggingFileHandlerOn(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition(), value);
        }

        @Override
        public String getDBLoggingLevel() {
            return this.impl.getPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition());
        }

        @Override
        public void setDBLoggingLevel(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition(), value);
        }

        @Override
        public Integer getDBNumCleanerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition());
        }

        @Override
        public void setDBNumCleanerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition(), value);
        }

        @Override
        public Integer getDBNumLockTables() {
            return this.impl.getPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition());
        }

        @Override
        public void setDBNumLockTables(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition(), value);
        }

        @Override
        public boolean isDBRunCleaner() {
            return this.impl.getPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition());
        }

        @Override
        public void setDBRunCleaner(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition(), value);
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
        }

        @Override
        public void setDBTxnNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition(), value);
        }

        @Override
        public boolean isDBTxnWriteNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition());
        }

        @Override
        public void setDBTxnWriteNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
        }

        @Override
        public void setEntriesCompressed(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition(), value);
        }

        @Override
        public int getImportQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getImportQueueSizePropertyDefinition());
        }

        @Override
        public void setImportQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getImportQueueSizePropertyDefinition(), value);
        }

        @Override
        public int getImportThreadCount() {
            return this.impl.getPropertyValue(INSTANCE.getImportThreadCountPropertyDefinition());
        }

        @Override
        public void setImportThreadCount(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getImportThreadCountPropertyDefinition(), value);
        }

        @Override
        public int getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getJEProperty() {
            return this.impl.getPropertyValues(INSTANCE.getJEPropertyPropertyDefinition());
        }

        @Override
        public void setJEProperty(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getJEPropertyPropertyDefinition(), values);
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
        }

        @Override
        public void setPreloadTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(BackendCfgDefn.WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public String[] listLocalDBIndexes() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getLocalDBIndexesRelationDefinition());
        }

        @Override
        public LocalDBIndexCfgClient getLocalDBIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getLocalDBIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends LocalDBIndexCfgClient> M createLocalDBIndex(ManagedObjectDefinition<M, ? extends LocalDBIndexCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((LocalDBIndexCfgClient)this.impl.createChild(INSTANCE.getLocalDBIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeLocalDBIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getLocalDBIndexesRelationDefinition(), name);
        }

        @Override
        public String[] listLocalDBVLVIndexes() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getLocalDBVLVIndexesRelationDefinition());
        }

        @Override
        public LocalDBVLVIndexCfgClient getLocalDBVLVIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends LocalDBVLVIndexCfgClient> M createLocalDBVLVIndex(ManagedObjectDefinition<M, ? extends LocalDBVLVIndexCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((LocalDBVLVIndexCfgClient)this.impl.createChild(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeLocalDBVLVIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getLocalDBVLVIndexesRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends LocalDBBackendCfgClient, ? extends LocalDBBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

