/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ParallelWorkQueueCfgClient;
import org.opends.server.admin.std.meta.WorkQueueCfgDefn;
import org.opends.server.admin.std.server.ParallelWorkQueueCfg;
import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParallelWorkQueueCfgDefn
extends ManagedObjectDefinition<ParallelWorkQueueCfgClient, ParallelWorkQueueCfg> {
    private static final ParallelWorkQueueCfgDefn INSTANCE = new ParallelWorkQueueCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_NUM_WORKER_THREADS;

    public static ParallelWorkQueueCfgDefn getInstance() {
        return INSTANCE;
    }

    private ParallelWorkQueueCfgDefn() {
        super("parallel-work-queue", WorkQueueCfgDefn.getInstance());
    }

    @Override
    public ParallelWorkQueueCfgClient createClientConfiguration(ManagedObject<? extends ParallelWorkQueueCfgClient> impl) {
        return new ParallelWorkQueueCfgClientImpl(impl);
    }

    @Override
    public ParallelWorkQueueCfg createServerConfiguration(ServerManagedObject<? extends ParallelWorkQueueCfg> impl) {
        return new ParallelWorkQueueCfgServerImpl(impl);
    }

    @Override
    public Class<ParallelWorkQueueCfg> getServerConfigurationClass() {
        return ParallelWorkQueueCfg.class;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getNumWorkerThreadsPropertyDefinition() {
        return PD_NUM_WORKER_THREADS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.ParallelWorkQueue");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.WorkQueue");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-worker-threads");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-worker-threads"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "num-worker-threads"));
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_WORKER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_WORKER_THREADS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWorkQueueCfgServerImpl
    implements ParallelWorkQueueCfg {
        private ServerManagedObject<? extends ParallelWorkQueueCfg> impl;
        private final String pJavaClass;
        private final Integer pNumWorkerThreads;

        private ParallelWorkQueueCfgServerImpl(ServerManagedObject<? extends ParallelWorkQueueCfg> impl) {
            this.impl = impl;
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pNumWorkerThreads = impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void addParallelChangeListener(ConfigurationChangeListener<ParallelWorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeParallelChangeListener(ConfigurationChangeListener<ParallelWorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.pNumWorkerThreads;
        }

        @Override
        public Class<? extends ParallelWorkQueueCfg> configurationClass() {
            return ParallelWorkQueueCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWorkQueueCfgClientImpl
    implements ParallelWorkQueueCfgClient {
        private ManagedObject<? extends ParallelWorkQueueCfgClient> impl;

        private ParallelWorkQueueCfgClientImpl(ManagedObject<? extends ParallelWorkQueueCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void setNumWorkerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ParallelWorkQueueCfgClient, ? extends ParallelWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

