/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.net.InetAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.Group;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.extensions.RedirectingByteChannel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.Privilege;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public abstract class ClientConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AuthenticationInfo authenticationInfo;
    protected AtomicBoolean saslBindInProgress;
    protected AtomicBoolean bindOrStartTLSInProgress;
    private boolean finalized = false;
    private HashSet<Privilege> privileges;
    private int sizeLimit;
    private int timeLimit;
    private int lookthroughLimit;
    private final long connectTime = TimeThread.getTime();
    private long idleTimeLimit;
    private Object saslAuthState = null;
    private final String connectTimeString = TimeThread.getGMTTime();
    private final CopyOnWriteArrayList<PersistentSearch> persistentSearches;
    private NetworkGroup networkGroup;
    protected boolean mustEvaluateNetworkGroup;

    protected ClientConnection() {
        this.authenticationInfo = new AuthenticationInfo();
        this.saslBindInProgress = new AtomicBoolean(false);
        this.bindOrStartTLSInProgress = new AtomicBoolean(false);
        this.persistentSearches = new CopyOnWriteArrayList();
        this.sizeLimit = DirectoryServer.getSizeLimit();
        this.timeLimit = DirectoryServer.getTimeLimit();
        this.idleTimeLimit = DirectoryServer.getIdleTimeLimit();
        this.lookthroughLimit = DirectoryServer.getLookthroughLimit();
        this.privileges = new HashSet();
        this.networkGroup = NetworkGroup.getDefaultNetworkGroup();
        this.networkGroup.addConnection(this);
        this.mustEvaluateNetworkGroup = true;
        if (DebugLogger.debugEnabled()) {
            Message message = CoreMessages.INFO_CHANGE_NETWORK_GROUP.get(this.getConnectionID(), "null", this.networkGroup.getID());
            TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
        }
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=true, notes="This method should only be invoked by connection handlers.")
    protected final void finalizeConnectionInternal() {
        block8: {
            if (this.finalized) {
                return;
            }
            this.finalized = true;
            Entry authNEntry = this.authenticationInfo.getAuthenticationEntry();
            Entry authZEntry = this.authenticationInfo.getAuthorizationEntry();
            if (authNEntry != null) {
                if (authZEntry == null || authZEntry.getDN().equals(authNEntry.getDN())) {
                    DirectoryServer.getAuthenticatedUsers().remove(authNEntry.getDN(), this);
                } else {
                    DirectoryServer.getAuthenticatedUsers().remove(authNEntry.getDN(), this);
                    DirectoryServer.getAuthenticatedUsers().remove(authZEntry.getDN(), this);
                }
            } else if (authZEntry != null) {
                DirectoryServer.getAuthenticatedUsers().remove(authZEntry.getDN(), this);
            }
            this.networkGroup.removeConnection(this);
            try {
                this.finalizeClientConnection();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
    protected void finalizeClientConnection() {
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    public final String getConnectTimeString() {
        return this.connectTimeString;
    }

    public abstract long getConnectionID();

    public abstract ConnectionHandler<?> getConnectionHandler();

    public abstract String getProtocol();

    public abstract String getClientAddress();

    public abstract int getClientPort();

    public final String getClientHostPort() {
        int port = this.getClientPort();
        if (port >= 0) {
            return this.getClientAddress() + ":" + port;
        }
        return this.getClientAddress();
    }

    public abstract String getServerAddress();

    public abstract int getServerPort();

    public final String getServerHostPort() {
        int port = this.getServerPort();
        if (port >= 0) {
            return this.getServerAddress() + ":" + port;
        }
        return this.getServerAddress();
    }

    public abstract InetAddress getRemoteAddress();

    public abstract InetAddress getLocalAddress();

    public abstract boolean isSecure();

    public Selector getWriteSelector() {
        return null;
    }

    public long getMaxBlockedWriteTimeLimit() {
        return 0L;
    }

    public abstract long getNumberOfOperations();

    public boolean mustEvaluateNetworkGroup(PreParseOperation operation) {
        if (this.networkGroup == NetworkGroup.getInternalNetworkGroup()) {
            return false;
        }
        if (this.networkGroup == NetworkGroup.getAdminNetworkGroup()) {
            return false;
        }
        if (operation != null && operation.getOperationType() == OperationType.BIND) {
            return true;
        }
        return this.mustEvaluateNetworkGroup;
    }

    public void mustEvaluateNetworkGroup(boolean bool) {
        this.mustEvaluateNetworkGroup = bool;
    }

    public abstract void sendResponse(Operation var1);

    public abstract void sendSearchEntry(SearchOperation var1, SearchResultEntry var2) throws DirectoryException;

    public abstract boolean sendSearchReference(SearchOperation var1, SearchResultReference var2) throws DirectoryException;

    public final boolean sendIntermediateResponse(IntermediateResponse intermediateResponse) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        PluginResult.IntermediateResponse pluginResult = pluginConfigManager.invokeIntermediateResponsePlugins(intermediateResponse);
        boolean continueProcessing = true;
        if (pluginResult.sendResponse()) {
            continueProcessing = this.sendIntermediateResponseMessage(intermediateResponse);
        }
        return continueProcessing && pluginResult.continueProcessing();
    }

    protected abstract boolean sendIntermediateResponseMessage(IntermediateResponse var1);

    public abstract void disconnect(DisconnectReason var1, boolean var2, Message var3);

    public final boolean mustChangePassword() {
        if (this.authenticationInfo == null) {
            return false;
        }
        return this.authenticationInfo.mustChangePassword();
    }

    public final void setMustChangePassword(boolean mustChangePassword) {
        if (this.authenticationInfo == null) {
            this.setAuthenticationInfo(new AuthenticationInfo());
        }
        this.authenticationInfo.setMustChangePassword(mustChangePassword);
    }

    public abstract Collection<Operation> getOperationsInProgress();

    public abstract Operation getOperationInProgress(int var1);

    public abstract boolean removeOperationInProgress(int var1);

    public final List<PersistentSearch> getPersistentSearches() {
        return this.persistentSearches;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public final void registerPersistentSearch(PersistentSearch persistentSearch) {
        this.persistentSearches.add(persistentSearch);
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public final void deregisterPersistentSearch(PersistentSearch persistentSearch) {
        this.persistentSearches.remove(persistentSearch);
    }

    public abstract CancelResult cancelOperation(int var1, CancelRequest var2);

    public abstract void cancelAllOperations(CancelRequest var1);

    public abstract void cancelAllOperationsExcept(CancelRequest var1, int var2);

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        Entry authZEntry;
        Entry authNEntry;
        if (this.authenticationInfo != null) {
            authNEntry = this.authenticationInfo.getAuthenticationEntry();
            authZEntry = this.authenticationInfo.getAuthorizationEntry();
            if (authNEntry != null) {
                if (authZEntry == null || authZEntry.getDN().equals(authNEntry.getDN())) {
                    DirectoryServer.getAuthenticatedUsers().remove(authNEntry.getDN(), this);
                } else {
                    DirectoryServer.getAuthenticatedUsers().remove(authNEntry.getDN(), this);
                    DirectoryServer.getAuthenticatedUsers().remove(authZEntry.getDN(), this);
                }
            } else if (authZEntry != null) {
                DirectoryServer.getAuthenticatedUsers().remove(authZEntry.getDN(), this);
            }
        }
        if (authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
            this.updatePrivileges(null, false);
        } else {
            this.authenticationInfo = authenticationInfo;
            authNEntry = authenticationInfo.getAuthenticationEntry();
            authZEntry = authenticationInfo.getAuthorizationEntry();
            if (authNEntry != null) {
                if (authZEntry == null || authZEntry.getDN().equals(authNEntry.getDN())) {
                    DirectoryServer.getAuthenticatedUsers().put(authNEntry.getDN(), this);
                } else {
                    DirectoryServer.getAuthenticatedUsers().put(authNEntry.getDN(), this);
                    DirectoryServer.getAuthenticatedUsers().put(authZEntry.getDN(), this);
                }
            } else if (authZEntry != null) {
                DirectoryServer.getAuthenticatedUsers().put(authZEntry.getDN(), this);
            }
            this.updatePrivileges(authZEntry, authenticationInfo.isRoot());
        }
    }

    public final void updateAuthenticationInfo(Entry oldEntry, Entry newEntry) {
        Entry authNEntry = this.authenticationInfo.getAuthenticationEntry();
        Entry authZEntry = this.authenticationInfo.getAuthorizationEntry();
        if (authNEntry != null && authNEntry.getDN().equals(oldEntry.getDN())) {
            if (authZEntry == null || !authZEntry.getDN().equals(authNEntry.getDN())) {
                this.setAuthenticationInfo(this.authenticationInfo.duplicate(newEntry, authZEntry));
                this.updatePrivileges(newEntry, this.authenticationInfo.isRoot());
            } else {
                this.setAuthenticationInfo(this.authenticationInfo.duplicate(newEntry, newEntry));
                this.updatePrivileges(newEntry, this.authenticationInfo.isRoot());
            }
        } else if (authZEntry != null && authZEntry.getDN().equals(oldEntry.getDN())) {
            this.setAuthenticationInfo(this.authenticationInfo.duplicate(authNEntry, newEntry));
        }
    }

    public void setUnauthenticated() {
        this.setAuthenticationInfo(new AuthenticationInfo());
        this.sizeLimit = this.networkGroup.getSizeLimit();
        this.timeLimit = this.networkGroup.getTimeLimit();
    }

    public static boolean hasPrivilege(Entry authorizationEntry, Privilege privilege) {
        boolean isRoot = DirectoryServer.isRootDN(authorizationEntry.getDN());
        return ClientConnection.getPrivileges(authorizationEntry, isRoot).contains((Object)privilege) || DirectoryServer.isDisabled(privilege);
    }

    public boolean hasPrivilege(Privilege privilege, Operation operation) {
        boolean result;
        if (privilege == Privilege.PROXIED_AUTH) {
            boolean isRoot;
            Entry authEntry = this.authenticationInfo.getAuthenticationEntry();
            return ClientConnection.getPrivileges(authEntry, isRoot = this.authenticationInfo.isRoot()).contains((Object)Privilege.PROXIED_AUTH) || DirectoryServer.isDisabled(Privilege.PROXIED_AUTH);
        }
        if (operation == null) {
            result = this.privileges.contains((Object)privilege);
            if (DebugLogger.debugEnabled()) {
                DN authDN = this.authenticationInfo.getAuthenticationDN();
                Message message = CoreMessages.INFO_CLIENTCONNECTION_AUDIT_HASPRIVILEGE.get(this.getConnectionID(), -1L, String.valueOf(authDN), privilege.getName(), result);
                TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
            }
        } else if (operation.getAuthorizationDN().equals(this.authenticationInfo.getAuthorizationDN()) || operation.getAuthorizationDN().equals(DN.NULL_DN) && !this.authenticationInfo.isAuthenticated()) {
            boolean bl = result = this.privileges.contains((Object)privilege) || DirectoryServer.isDisabled(privilege);
            if (DebugLogger.debugEnabled()) {
                DN authDN = this.authenticationInfo.getAuthenticationDN();
                Message message = CoreMessages.INFO_CLIENTCONNECTION_AUDIT_HASPRIVILEGE.get(this.getConnectionID(), operation.getOperationID(), String.valueOf(authDN), privilege.getName(), result);
                TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
            }
        } else {
            boolean isRoot;
            Entry authorizationEntry = operation.getAuthorizationEntry();
            result = authorizationEntry == null ? false : ClientConnection.getPrivileges(authorizationEntry, isRoot = DirectoryServer.isRootDN(authorizationEntry.getDN())).contains((Object)privilege) || DirectoryServer.isDisabled(privilege);
        }
        return result;
    }

    public boolean hasAllPrivileges(Privilege[] privileges, Operation operation) {
        HashSet<Privilege> privSet = this.privileges;
        if (DebugLogger.debugEnabled()) {
            for (Privilege p : privileges) {
                if (privSet.contains((Object)p)) continue;
                return false;
            }
            return true;
        }
        boolean result = true;
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < privileges.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(privileges[i].getName());
            if (privSet.contains((Object)privileges[i])) continue;
            result = false;
        }
        buffer.append(" }");
        if (operation == null) {
            DN authDN = this.authenticationInfo.getAuthenticationDN();
            Message message = CoreMessages.INFO_CLIENTCONNECTION_AUDIT_HASPRIVILEGES.get(this.getConnectionID(), -1L, String.valueOf(authDN), buffer.toString(), result);
            TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
        } else {
            DN authDN = this.authenticationInfo.getAuthenticationDN();
            Message message = CoreMessages.INFO_CLIENTCONNECTION_AUDIT_HASPRIVILEGES.get(this.getConnectionID(), operation.getOperationID(), String.valueOf(authDN), buffer.toString(), result);
            TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
        }
        return result;
    }

    private static HashSet<Privilege> getPrivileges(Entry entry, boolean isRoot) {
        AttributeType privType;
        List<Attribute> attrList;
        if (entry == null) {
            return new HashSet<Privilege>(0);
        }
        HashSet<Privilege> newPrivileges = new HashSet<Privilege>();
        HashSet<Privilege> removePrivileges = new HashSet<Privilege>();
        if (isRoot) {
            newPrivileges.addAll(DirectoryServer.getRootPrivileges());
        }
        if ((attrList = entry.getAttribute(privType = DirectoryServer.getAttributeType("ds-privilege-name"))) != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    Privilege p;
                    String privName = StaticUtils.toLowerCase(v.getValue().toString());
                    if (privName.startsWith("-")) {
                        p = Privilege.privilegeForName(privName = privName.substring(1));
                        if (p == null) {
                            newPrivileges.clear();
                            return newPrivileges;
                        }
                        removePrivileges.add(p);
                        continue;
                    }
                    p = Privilege.privilegeForName(privName);
                    if (p == null) continue;
                    newPrivileges.add(p);
                }
            }
        }
        for (Privilege p : removePrivileges) {
            newPrivileges.remove((Object)p);
        }
        return newPrivileges;
    }

    private void updatePrivileges(Entry entry, boolean isRoot) {
        this.privileges = ClientConnection.getPrivileges(entry, isRoot);
    }

    public final Object getSASLAuthStateInfo() {
        return this.saslAuthState;
    }

    public final void setSASLAuthStateInfo(Object saslAuthState) {
        this.saslAuthState = saslAuthState;
    }

    public RedirectingByteChannel getChannel() {
        return null;
    }

    public SocketChannel getSocketChannel() {
        return null;
    }

    public int getAppBufferSize() {
        return 0;
    }

    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public final long getIdleTimeLimit() {
        return this.idleTimeLimit;
    }

    public void setIdleTimeLimit(long idleTimeLimit) {
        this.idleTimeLimit = idleTimeLimit;
    }

    public final int getLookthroughLimit() {
        return this.lookthroughLimit;
    }

    public void setLookthroughLimit(int lookthroughLimit) {
        this.lookthroughLimit = lookthroughLimit;
    }

    public final int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public abstract String getMonitorSummary();

    public boolean isMemberOf(Group<?> group, Operation operation) throws DirectoryException {
        if (operation == null) {
            return group.isMember(this.authenticationInfo.getAuthorizationDN());
        }
        return group.isMember(operation.getAuthorizationDN());
    }

    public Set<Group> getGroups(Operation operation) throws DirectoryException {
        Object authzDN = operation == null ? (this.authenticationInfo == null || !this.authenticationInfo.isAuthenticated() ? null : this.authenticationInfo.getAuthorizationDN()) : operation.getAuthorizationDN();
        if (authzDN == null || ((DN)authzDN).isNullDN()) {
            return Collections.emptySet();
        }
        Entry userEntry = DirectoryServer.getEntry((DN)authzDN);
        if (userEntry == null) {
            return Collections.emptySet();
        }
        HashSet<Group> groupSet = new HashSet<Group>();
        for (Group g : DirectoryServer.getGroupManager().getGroupInstances()) {
            if (!g.isMember(userEntry)) continue;
            groupSet.add(g);
        }
        return groupSet;
    }

    public DN getKeyManagerProviderDN() {
        return null;
    }

    public DN getTrustManagerProviderDN() {
        return null;
    }

    public String getCertificateAlias() {
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public final NetworkGroup getNetworkGroup() {
        return this.networkGroup;
    }

    public final void setNetworkGroup(NetworkGroup networkGroup) {
        if (this.networkGroup != networkGroup) {
            if (DebugLogger.debugEnabled()) {
                Message message = CoreMessages.INFO_CHANGE_NETWORK_GROUP.get(this.getConnectionID(), this.networkGroup.getID(), networkGroup.getID());
                TRACER.debugMessage(DebugLogLevel.INFO, message.toString());
            }
            this.networkGroup.removeConnection(this);
            this.networkGroup = networkGroup;
            this.networkGroup.addConnection(this);
            this.sizeLimit = networkGroup.getSizeLimit();
            this.timeLimit = networkGroup.getTimeLimit();
        }
    }

    public long getIdleTime() {
        return 0L;
    }

    public abstract int getSSF();

    public void finishBindOrStartTLS() {
        this.bindOrStartTLSInProgress.set(false);
    }

    public void finishSaslBind() {
        this.saslBindInProgress.set(false);
    }
}

