/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.InternalDirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.authorization.dseecompat.AciHandler;
import org.opends.server.authorization.dseecompat.AciList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PostSynchronizationDeleteOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciListenerManager
implements BackendInitializationListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.authorization.dseecompat.AciListenerManager";
    private DN configurationDN;
    private boolean inLockDownMode = false;
    private AciList aciList;
    private static SearchFilter aciFilter;
    private final AciChangeListenerPlugin plugin;
    private static LinkedHashSet<String> attrs;

    public AciListenerManager(AciList aciList, DN cfgDN) {
        this.aciList = aciList;
        this.configurationDN = cfgDN;
        this.plugin = new AciChangeListenerPlugin();
        Map<String, Backend> backendMap = DirectoryServer.getBackends();
        if (backendMap != null) {
            for (Backend backend : backendMap.values()) {
                this.performBackendInitializationProcessing(backend);
            }
        }
        DirectoryServer.registerInternalPlugin(this.plugin);
        DirectoryServer.registerBackendInitializationListener(this);
        DirectoryServer.registerAlertGenerator(this);
    }

    public void finalizeListenerManager() {
        DirectoryServer.deregisterInternalPlugin(this.plugin);
        DirectoryServer.deregisterBackendInitializationListener(this);
        DirectoryServer.deregisterAlertGenerator(this);
    }

    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        AttributeType aciType = DirectoryServer.getAttributeType("aci", true);
        if (backend.getEntryCount() > 0L && !backend.isIndexed(aciType, IndexType.PRESENCE)) {
            ErrorLogger.logError(AccessControlMessages.WARN_ACI_ATTRIBUTE_NOT_INDEXED.get(backend.getBackendID(), "aci"));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
        ArrayList<Control> controls = new ArrayList<Control>(1);
        controls.add(new LDAPControl("2.16.840.1.113730.3.4.2", true));
        controls.add(new LDAPControl("1.3.6.1.4.1.26027.1.5.1", false));
        for (DN baseDN : backend.getBaseDNs()) {
            block8: {
                try {
                    if (!backend.entryExists(baseDN)) {
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                continue;
            }
            InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, aciFilter, attrs, null);
            LocalBackendSearchOperation localInternalSearch = new LocalBackendSearchOperation(internalSearch);
            try {
                backend.search(localInternalSearch);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            if (internalSearch.getSearchEntries().isEmpty()) continue;
            int validAcis = this.aciList.addAci(internalSearch.getSearchEntries(), failedACIMsgs);
            if (!failedACIMsgs.isEmpty()) {
                this.logMsgsSetLockDownMode(failedACIMsgs);
            }
            Message message = AccessControlMessages.INFO_ACI_ADD_LIST_ACIS.get(Integer.toString(validAcis), String.valueOf(baseDN));
            ErrorLogger.logError(message);
        }
    }

    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
        this.aciList.removeAci(backend);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configurationDN;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.authentiation.dseecompat.ACIParseFailed", "This alert type will be used to notify administrators if the  dseecompat access control subsystem failed to correctly parse one or more ACI rules when the server is first started.");
        return alerts;
    }

    public void logMsgsSetLockDownMode(LinkedList<Message> failedACIMsgs) {
        for (Message msg : failedACIMsgs) {
            Message message = AccessControlMessages.WARN_ACI_SERVER_DECODE_FAILED.get(msg);
            ErrorLogger.logError(message);
        }
        if (!this.inLockDownMode) {
            this.setLockDownMode();
        }
    }

    private void setLockDownMode() {
        if (!this.inLockDownMode) {
            this.inLockDownMode = true;
            Message lockDownMsg = AccessControlMessages.WARN_ACI_ENTER_LOCKDOWN_MODE.get();
            DirectoryServer.sendAlertNotification(this, "org.opends.server.authentiation.dseecompat.ACIParseFailed", lockDownMsg);
            DirectoryServer.setLockdownMode(true);
        }
    }

    static {
        attrs = new LinkedHashSet();
        try {
            aciFilter = SearchFilter.createFilterFromString("(aci=*)");
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        attrs.add("aci");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AciChangeListenerPlugin
    extends InternalDirectoryServerPlugin {
        private AciChangeListenerPlugin() {
            super(AciListenerManager.this.configurationDN, EnumSet.of(PluginType.POST_SYNCHRONIZATION_ADD, new PluginType[]{PluginType.POST_SYNCHRONIZATION_DELETE, PluginType.POST_SYNCHRONIZATION_MODIFY, PluginType.POST_SYNCHRONIZATION_MODIFY_DN, PluginType.POST_OPERATION_ADD, PluginType.POST_OPERATION_DELETE, PluginType.POST_OPERATION_MODIFY, PluginType.POST_OPERATION_MODIFY_DN}), true);
        }

        @Override
        public void doPostSynchronization(PostSynchronizationAddOperation addOperation) {
            Entry entry = addOperation.getEntryToAdd();
            if (entry != null) {
                this.doPostAdd(entry);
            }
        }

        @Override
        public void doPostSynchronization(PostSynchronizationDeleteOperation deleteOperation) {
            Entry entry = deleteOperation.getEntryToDelete();
            if (entry != null) {
                this.doPostDelete(entry);
            }
        }

        @Override
        public void doPostSynchronization(PostSynchronizationModifyDNOperation modifyDNOperation) {
            Entry entry = modifyDNOperation.getUpdatedEntry();
            if (entry != null) {
                this.doPostModifyDN(entry.getDN(), entry.getDN());
            }
        }

        @Override
        public void doPostSynchronization(PostSynchronizationModifyOperation modifyOperation) {
            Entry entry = modifyOperation.getCurrentEntry();
            Entry modEntry = modifyOperation.getModifiedEntry();
            if (entry != null && modEntry != null) {
                this.doPostModify(modifyOperation.getModifications(), entry, modEntry);
            }
        }

        @Override
        public PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
            this.doPostAdd(addOperation.getEntryToAdd());
            return PluginResult.PostOperation.continueOperationProcessing();
        }

        @Override
        public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
            this.doPostDelete(deleteOperation.getEntryToDelete());
            return PluginResult.PostOperation.continueOperationProcessing();
        }

        @Override
        public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
            this.doPostModifyDN(modifyDNOperation.getOriginalEntry().getDN(), modifyDNOperation.getUpdatedEntry().getDN());
            return PluginResult.PostOperation.continueOperationProcessing();
        }

        @Override
        public PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
            this.doPostModify(modifyOperation.getModifications(), modifyOperation.getCurrentEntry(), modifyOperation.getModifiedEntry());
            return PluginResult.PostOperation.continueOperationProcessing();
        }

        private void doPostAdd(Entry addedEntry) {
            boolean hasGlobalAci = false;
            boolean hasAci = addedEntry.hasOperationalAttribute(AciHandler.aciType);
            if (hasAci || (hasGlobalAci = addedEntry.hasAttribute(AciHandler.globalAciType))) {
                LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
                AciListenerManager.this.aciList.addAci(addedEntry, hasAci, hasGlobalAci, failedACIMsgs);
            }
        }

        private void doPostDelete(Entry deletedEntry) {
            boolean hasGlobalAci = false;
            boolean hasAci = deletedEntry.hasOperationalAttribute(AciHandler.aciType);
            if (hasAci || (hasGlobalAci = deletedEntry.hasAttribute(AciHandler.globalAciType))) {
                AciListenerManager.this.aciList.removeAci(deletedEntry, hasAci, hasGlobalAci);
            }
        }

        private void doPostModifyDN(DN fromDN, DN toDN) {
            AciListenerManager.this.aciList.renameAci(fromDN, toDN);
        }

        private void doPostModify(List<Modification> mods, Entry oldEntry, Entry newEntry) {
            boolean hasAci = false;
            boolean hasGlobalAci = false;
            for (Modification mod : mods) {
                AttributeType attributeType = mod.getAttribute().getAttributeType();
                if (attributeType.equals(AciHandler.aciType)) {
                    hasAci = true;
                } else if (attributeType.equals(AciHandler.globalAciType)) {
                    hasGlobalAci = true;
                }
                if (!hasAci || !hasGlobalAci) continue;
                break;
            }
            if (hasAci || hasGlobalAci) {
                AciListenerManager.this.aciList.modAciOldNewEntry(oldEntry, newEntry, hasAci, hasGlobalAci);
            }
        }
    }
}

