/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.List;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortValues
implements Comparable<SortValues> {
    private AttributeValue[] values;
    private EntryID entryID;
    private SortOrder sortOrder;

    public SortValues(EntryID entryID, AttributeValue[] values, SortOrder sortOrder) {
        this.entryID = entryID;
        this.sortOrder = sortOrder;
        this.values = values;
    }

    public SortValues(EntryID entryID, Entry entry, SortOrder sortOrder) {
        this.entryID = entryID;
        this.sortOrder = sortOrder;
        SortKey[] sortKeys = sortOrder.getSortKeys();
        this.values = new AttributeValue[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            SortKey sortKey = sortKeys[i];
            AttributeType attrType = sortKey.getAttributeType();
            List<Attribute> attrList = entry.getAttribute(attrType);
            if (attrList == null) continue;
            AttributeValue sortValue = null;
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    if (sortValue == null) {
                        sortValue = v;
                        continue;
                    }
                    if (sortKey.compareValues(v, sortValue) >= 0) continue;
                    sortValue = v;
                }
            }
            this.values[i] = sortValue;
        }
    }

    @Override
    public int compareTo(SortValues sortValues) {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        for (int i = 0; i < this.values.length; ++i) {
            int compareValue = sortKeys[i].compareValues(this.values[i], sortValues.values[i]);
            if (compareValue == 0) continue;
            return compareValue;
        }
        long idDifference = this.entryID.longValue() - sortValues.entryID.longValue();
        if (idDifference < 0L) {
            return -1;
        }
        if (idDifference > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(AttributeValue assertionValue) {
        SortKey sortKey = this.sortOrder.getSortKeys()[0];
        return sortKey.compareValues(this.values[0], assertionValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SortValues(");
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        for (int i = 0; i < sortKeys.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            if (sortKeys[i].ascending()) {
                buffer.append("+");
            } else {
                buffer.append("-");
            }
            buffer.append(sortKeys[i].getAttributeType().getNameOrOID());
            buffer.append("=");
            if (this.values[i] == null) {
                buffer.append("null");
                continue;
            }
            buffer.append(this.values[i].getValue().toString());
        }
        buffer.append(", id=");
        buffer.append(this.entryID.toString());
        buffer.append(")");
    }

    public AttributeValue[] getValues() {
        return this.values;
    }

    public long getEntryID() {
        return this.entryID.longValue();
    }
}

