/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class AccountUsableResponseControl
extends Control {
    public static final ControlDecoder<AccountUsableResponseControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte TYPE_SECONDS_BEFORE_EXPIRATION = -128;
    public static final byte TYPE_MORE_INFO = -95;
    public static final byte TYPE_INACTIVE = -128;
    public static final byte TYPE_RESET = -127;
    public static final byte TYPE_EXPIRED = -126;
    public static final byte TYPE_REMAINING_GRACE_LOGINS = -125;
    public static final byte TYPE_SECONDS_BEFORE_UNLOCK = -124;
    private boolean isUsable;
    private boolean isExpired;
    private boolean isInactive;
    private boolean isLocked;
    private boolean isReset;
    private int remainingGraceLogins;
    private int secondsBeforeExpiration;
    private int secondsBeforeUnlock;

    public AccountUsableResponseControl(int secondsBeforeExpiration) {
        this(false, secondsBeforeExpiration);
    }

    public AccountUsableResponseControl(boolean isCritical, int secondsBeforeExpiration) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", isCritical);
        this.secondsBeforeExpiration = secondsBeforeExpiration;
        this.isUsable = true;
        this.isInactive = false;
        this.isReset = false;
        this.isExpired = false;
        this.remainingGraceLogins = -1;
        this.isLocked = false;
        this.secondsBeforeUnlock = 0;
    }

    public AccountUsableResponseControl(boolean isCritical, boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", isCritical);
        this.isInactive = isInactive;
        this.isReset = isReset;
        this.isExpired = isExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.isLocked = isLocked;
        this.secondsBeforeUnlock = secondsBeforeUnlock;
        this.isUsable = false;
        this.secondsBeforeExpiration = -1;
    }

    public AccountUsableResponseControl(boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        this(false, isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock);
    }

    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        if (this.isUsable) {
            writer.writeInteger((byte)-128, this.secondsBeforeExpiration);
        } else {
            writer.writeStartSequence((byte)-95);
            if (this.isInactive) {
                writer.writeBoolean((byte)-128, true);
            }
            if (this.isReset) {
                writer.writeBoolean((byte)-127, true);
            }
            if (this.isExpired) {
                writer.writeBoolean((byte)-126, true);
                if (this.remainingGraceLogins >= 0) {
                    writer.writeInteger((byte)-125, this.remainingGraceLogins);
                }
            }
            if (this.isLocked) {
                writer.writeInteger((byte)-124, this.secondsBeforeUnlock);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public int getSecondsBeforeExpiration() {
        return this.secondsBeforeExpiration;
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public int getRemainingGraceLogins() {
        return this.remainingGraceLogins;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public int getSecondsBeforeUnlock() {
        return this.secondsBeforeUnlock;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AccountUsableResponseControl(isUsable=");
        buffer.append(this.isUsable);
        if (this.isUsable) {
            buffer.append(",secondsBeforeExpiration=");
            buffer.append(this.secondsBeforeExpiration);
        } else {
            buffer.append(",isInactive=");
            buffer.append(this.isInactive);
            buffer.append(",isReset=");
            buffer.append(this.isReset);
            buffer.append(",isExpired=");
            buffer.append(this.isExpired);
            buffer.append(",remainingGraceLogins=");
            buffer.append(this.remainingGraceLogins);
            buffer.append(",isLocked=");
            buffer.append(this.isLocked);
            buffer.append(",secondsBeforeUnlock=");
            buffer.append(this.secondsBeforeUnlock);
        }
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<AccountUsableResponseControl> {
        private Decoder() {
        }

        @Override
        public AccountUsableResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_ACCTUSABLERES_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            try {
                ASN1Reader reader = ASN1.getReader(value);
                switch (reader.peekType()) {
                    case -128: {
                        int secondsBeforeExpiration = (int)reader.readInteger();
                        return new AccountUsableResponseControl(isCritical, secondsBeforeExpiration);
                    }
                    case -95: {
                        boolean isInactive = false;
                        boolean isReset = false;
                        boolean isExpired = false;
                        boolean isLocked = false;
                        int remainingGraceLogins = -1;
                        int secondsBeforeUnlock = 0;
                        reader.readStartSequence();
                        if (reader.hasNextElement() && reader.peekType() == -128) {
                            isInactive = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -127) {
                            isReset = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -126) {
                            isExpired = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -125) {
                            remainingGraceLogins = (int)reader.readInteger();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -124) {
                            isLocked = true;
                            secondsBeforeUnlock = (int)reader.readInteger();
                        }
                        reader.readEndSequence();
                        return new AccountUsableResponseControl(isCritical, isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock);
                    }
                }
                Message message = ProtocolMessages.ERR_ACCTUSABLERES_UNKNOWN_VALUE_ELEMENT_TYPE.get(StaticUtils.byteToHex(reader.peekType()));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_ACCTUSABLERES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.42.2.27.9.5.8";
        }
    }
}

