/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PasswordExpiringControl
extends Control {
    public static final ControlDecoder<PasswordExpiringControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int secondsUntilExpiration;

    public PasswordExpiringControl(int secondsUntilExpiration) {
        this(false, secondsUntilExpiration);
    }

    public PasswordExpiringControl(boolean isCritical, int secondsUntilExpiration) {
        super("2.16.840.1.113730.3.4.5", isCritical);
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeOctetString(String.valueOf(this.secondsUntilExpiration));
    }

    public int getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordExpiringControl(secondsUntilExpiration=");
        buffer.append(this.secondsUntilExpiration);
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<PasswordExpiringControl> {
        private Decoder() {
        }

        @Override
        public PasswordExpiringControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            int secondsUntilExpiration;
            if (value == null) {
                Message message = ProtocolMessages.ERR_PWEXPIRING_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            try {
                secondsUntilExpiration = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_PWEXPIRING_CANNOT_DECODE_SECONDS_UNTIL_EXPIRATION.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new PasswordExpiringControl(isCritical, secondsUntilExpiration);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.5";
        }
    }
}

