/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearchControl
extends Control {
    public static final ControlDecoder<PersistentSearchControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean changesOnly;
    private boolean returnECs;
    private Set<PersistentSearchChangeType> changeTypes;

    public PersistentSearchControl(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        this(true, changeTypes, changesOnly, returnECs);
    }

    public PersistentSearchControl(boolean isCritical, Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        super("2.16.840.1.113730.3.4.3", isCritical);
        this.changeTypes = changeTypes;
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeInteger(PersistentSearchChangeType.changeTypesToInt(this.changeTypes));
        writer.writeBoolean(this.changesOnly);
        writer.writeBoolean(this.returnECs);
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean getChangesOnly() {
        return this.changesOnly;
    }

    public boolean getReturnECs() {
        return this.returnECs;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PersistentSearchControl(changeTypes=\"");
        PersistentSearchChangeType.changeTypesToString(this.changeTypes, buffer);
        buffer.append("\",changesOnly=");
        buffer.append(this.changesOnly);
        buffer.append(",returnECs=");
        buffer.append(this.returnECs);
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<PersistentSearchControl> {
        private Decoder() {
        }

        @Override
        public PersistentSearchControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            boolean returnECs;
            boolean changesOnly;
            Set<PersistentSearchChangeType> changeTypes;
            if (value == null) {
                Message message = ProtocolMessages.ERR_PSEARCH_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                int changeTypesValue = (int)reader.readInteger();
                changeTypes = PersistentSearchChangeType.intToTypes(changeTypesValue);
                changesOnly = reader.readBoolean();
                returnECs = reader.readBoolean();
                reader.readEndSequence();
            }
            catch (LDAPException le) {
                throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_PSEARCH_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new PersistentSearchControl(isCritical, changeTypes, changesOnly, returnECs);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.3";
        }
    }
}

