/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AdministrationDataSync;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.GlobalCfgDefn;
import org.opends.server.admin.std.server.AlertHandlerCfg;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.admin.std.server.AttributeTypeDescriptionAttributeSyntaxCfg;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.CryptoManagerCfg;
import org.opends.server.admin.std.server.DirectoryStringAttributeSyntaxCfg;
import org.opends.server.admin.std.server.JMXAlertHandlerCfg;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.RootDSEBackendCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.admin.std.server.TelephoneNumberAttributeSyntaxCfg;
import org.opends.server.api.AccessControlHandler;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.BackupTaskListener;
import org.opends.server.api.CertificateMapper;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.CompressedSchema;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.api.EntryCache;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.ExportTaskListener;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.ExtensibleMatchingRule;
import org.opends.server.api.Extension;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.InitializationCompletedListener;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.MatchingRuleFactory;
import org.opends.server.api.MonitorProvider;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.api.RestoreTaskListener;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.api.WorkQueue;
import org.opends.server.api.plugin.InternalDirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.backends.RootDSEBackend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.JMXMBean;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AccountStatusNotificationHandlerConfigManager;
import org.opends.server.core.AlertHandlerConfigManager;
import org.opends.server.core.AuthenticatedUsers;
import org.opends.server.core.BackendConfigManager;
import org.opends.server.core.BaseDnRegistry;
import org.opends.server.core.CertificateMapperConfigManager;
import org.opends.server.core.ConnectionHandlerConfigManager;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DefaultCompressedSchema;
import org.opends.server.core.DirectoryServerShutdownHook;
import org.opends.server.core.EntryCacheConfigManager;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ExtendedOperationConfigManager;
import org.opends.server.core.ExtensionConfigManager;
import org.opends.server.core.GroupManager;
import org.opends.server.core.IdentityMapperConfigManager;
import org.opends.server.core.IdleTimeLimitThread;
import org.opends.server.core.KeyManagerProviderConfigManager;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.LogRetentionPolicyConfigManager;
import org.opends.server.core.LogRotationPolicyConfigManager;
import org.opends.server.core.LoggerConfigManager;
import org.opends.server.core.MonitorConfigManager;
import org.opends.server.core.PasswordGeneratorConfigManager;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyConfig;
import org.opends.server.core.PasswordPolicyConfigManager;
import org.opends.server.core.PasswordStorageSchemeConfigManager;
import org.opends.server.core.PasswordValidatorConfigManager;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.RootDNConfigManager;
import org.opends.server.core.SASLConfigManager;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.core.ServerShutdownMonitor;
import org.opends.server.core.SubentryManager;
import org.opends.server.core.SynchronizationProviderConfigManager;
import org.opends.server.core.TrustManagerProviderConfigManager;
import org.opends.server.core.VirtualAttributeConfigManager;
import org.opends.server.core.WorkQueueConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowConfigManager;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.core.networkgroups.NetworkGroupConfigManager;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.crypto.CryptoManagerSync;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.JMXAlertHandler;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.monitors.BackendMonitor;
import org.opends.server.monitors.ConnectionHandlerMonitor;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalConnectionHandler;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.BinarySyntax;
import org.opends.server.schema.BooleanEqualityMatchingRuleFactory;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.CaseExactEqualityMatchingRuleFactory;
import org.opends.server.schema.CaseExactIA5EqualityMatchingRuleFactory;
import org.opends.server.schema.CaseExactIA5SubstringMatchingRuleFactory;
import org.opends.server.schema.CaseExactOrderingMatchingRuleFactory;
import org.opends.server.schema.CaseExactSubstringMatchingRuleFactory;
import org.opends.server.schema.CaseIgnoreEqualityMatchingRuleFactory;
import org.opends.server.schema.CaseIgnoreIA5EqualityMatchingRuleFactory;
import org.opends.server.schema.CaseIgnoreIA5SubstringMatchingRuleFactory;
import org.opends.server.schema.CaseIgnoreOrderingMatchingRuleFactory;
import org.opends.server.schema.CaseIgnoreSubstringMatchingRuleFactory;
import org.opends.server.schema.DirectoryStringSyntax;
import org.opends.server.schema.DistinguishedNameEqualityMatchingRuleFactory;
import org.opends.server.schema.DistinguishedNameSyntax;
import org.opends.server.schema.DoubleMetaphoneApproximateMatchingRuleFactory;
import org.opends.server.schema.GeneralizedTimeEqualityMatchingRuleFactory;
import org.opends.server.schema.GeneralizedTimeOrderingMatchingRuleFactory;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.IA5StringSyntax;
import org.opends.server.schema.IntegerEqualityMatchingRuleFactory;
import org.opends.server.schema.IntegerOrderingMatchingRuleFactory;
import org.opends.server.schema.IntegerSyntax;
import org.opends.server.schema.OIDSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.schema.ObjectIdentifierEqualityMatchingRuleFactory;
import org.opends.server.schema.OctetStringEqualityMatchingRuleFactory;
import org.opends.server.schema.OctetStringOrderingMatchingRuleFactory;
import org.opends.server.schema.OctetStringSubstringMatchingRuleFactory;
import org.opends.server.schema.TelephoneNumberEqualityMatchingRuleFactory;
import org.opends.server.schema.TelephoneNumberSubstringMatchingRuleFactory;
import org.opends.server.schema.TelephoneNumberSyntax;
import org.opends.server.servicetag.ServiceTagRegistration;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.Control;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LockManager;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.Modification;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.MultiOutputStream;
import org.opends.server.util.RuntimeInformation;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.util.Validator;
import org.opends.server.util.VersionCompatibilityIssue;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.workflowelement.WorkflowElement;
import org.opends.server.workflowelement.WorkflowElementConfigManager;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryServer
implements AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.core.DirectoryServer";
    private static DirectoryServer directoryServer = new DirectoryServer();
    private static boolean serverLocked = false;
    private static Message toolDescription = CoreMessages.INFO_DSCORE_TOOL_DESCRIPTION.get();
    private static int NOTHING_TO_DO = 0;
    private static int CHECK_ERROR = 1;
    private static int SERVER_ALREADY_STARTED = 98;
    private static int START_AS_DETACH = 99;
    private static int START_AS_NON_DETACH = 100;
    private static int START_AS_WINDOWS_SERVICE = 101;
    private static int START_AS_DETACH_CALLED_FROM_WINDOWS_SERVICE = 102;
    private static int START_AS_DETACH_QUIET = 103;
    private static int START_AS_NON_DETACH_QUIET = 104;
    private AcceptRejectWarn singleStructuralClassPolicy;
    private AcceptRejectWarn syntaxEnforcementPolicy;
    private AccountStatusNotificationHandlerConfigManager accountStatusNotificationHandlerConfigManager;
    private AttributeSyntax<AttributeSyntaxCfg> defaultBinarySyntax;
    private AttributeSyntax<AttributeSyntaxCfg> defaultBooleanSyntax;
    private AttributeSyntax<AttributeSyntaxCfg> defaultDNSyntax;
    private AttributeSyntax<AttributeSyntaxCfg> defaultIntegerSyntax;
    private AttributeSyntax<DirectoryStringAttributeSyntaxCfg> defaultStringSyntax;
    private AttributeSyntax<DirectoryStringAttributeSyntaxCfg> defaultSyntax;
    private AttributeType objectClassAttributeType;
    private AuthenticatedUsers authenticatedUsers;
    private BackendConfigManager backendConfigManager;
    private boolean addMissingRDNAttributes;
    private boolean allowAttributeNameExceptions;
    private boolean bindWithDNRequiresPassword;
    private boolean checkSchema;
    private boolean isBootstrapped;
    private boolean isRunning;
    private boolean lockdownMode;
    private boolean notifyAbandonedOperations;
    private boolean saveConfigOnSuccessfulStartup;
    private boolean shuttingDown;
    private boolean rejectUnauthenticatedRequests;
    private boolean returnBindErrorMessages;
    private CertificateMapperConfigManager certificateMapperConfigManager;
    private Class configClass;
    private ConfigHandler configHandler;
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> accountStatusNotificationHandlers;
    private ConcurrentHashMap<DN, CertificateMapper> certificateMappers;
    private ConcurrentHashMap<DN, DN> alternateRootBindDNs;
    private ConcurrentHashMap<DN, IdentityMapper> identityMappers;
    private ConcurrentHashMap<DN, JMXMBean> mBeans;
    private ConcurrentHashMap<DN, KeyManagerProvider> keyManagerProviders;
    private ConcurrentHashMap<DN, Extension> extensions;
    private ConcurrentHashMap<DN, PasswordGenerator> passwordGenerators;
    private ConcurrentHashMap<DN, PasswordPolicyConfig> passwordPolicies;
    private ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>> passwordValidators;
    private ConcurrentHashMap<DN, TrustManagerProvider> trustManagerProviders;
    private ConcurrentHashMap<DN, RotationPolicy> rotationPolicies;
    private ConcurrentHashMap<DN, RetentionPolicy> retentionPolicies;
    private ConcurrentHashMap<Integer, List<ConnectionHandler>> supportedLDAPVersions;
    private ConcurrentHashMap<String, ExtendedOperationHandler> extendedOperationHandlers;
    private ConcurrentHashMap<String, MonitorProvider<? extends MonitorProviderCfg>> monitorProviders;
    private ConcurrentHashMap<String, PasswordStorageScheme> authPasswordStorageSchemes;
    private ConcurrentHashMap<String, PasswordStorageScheme> passwordStorageSchemes;
    private ConcurrentHashMap<DN, PasswordStorageScheme> passwordStorageSchemesByDN;
    private ConcurrentHashMap<String, SASLMechanismHandler> saslMechanismHandlers;
    private ConnectionHandlerConfigManager connectionHandlerConfigManager = null;
    private CopyOnWriteArrayList<AlertHandler> alertHandlers;
    private CopyOnWriteArrayList<BackupTaskListener> backupTaskListeners;
    private CopyOnWriteArrayList<ChangeNotificationListener> changeNotificationListeners;
    private CopyOnWriteArrayList<ConnectionHandler> connectionHandlers;
    private CopyOnWriteArrayList<ExportTaskListener> exportTaskListeners;
    private CopyOnWriteArrayList<ImportTaskListener> importTaskListeners;
    private CopyOnWriteArrayList<RestoreTaskListener> restoreTaskListeners;
    private CopyOnWriteArrayList<InitializationCompletedListener> initializationCompletedListeners;
    private CopyOnWriteArrayList<ServerShutdownListener> shutdownListeners;
    private CopyOnWriteArrayList<SynchronizationProvider<SynchronizationProviderCfg>> synchronizationProviders;
    private CopyOnWriteArrayList<VirtualAttributeRule> virtualAttributes;
    private CopyOnWriteArraySet<BackendInitializationListener> backendInitializationListeners;
    private CopyOnWriteArraySet<DN> rootDNs;
    private CoreConfigManager coreConfigManager;
    private CryptoManagerImpl cryptoManager;
    private DefaultCompressedSchema compressedSchema;
    private DirectoryEnvironmentConfig environmentConfig;
    private DirectoryServerShutdownHook shutdownHook;
    private DN defaultPasswordPolicyDN;
    private DN proxiedAuthorizationIdentityMapperDN;
    private DN schemaDN;
    private EntryCache entryCache;
    private EntryCacheConfigManager entryCacheConfigManager;
    private ExtendedOperationConfigManager extendedOperationConfigManager;
    private File configFile;
    private GroupManager groupManager;
    private SubentryManager subentryManager;
    private IdentityMapperConfigManager identityMapperConfigManager;
    private int sizeLimit;
    private int timeLimit;
    private int lookthroughLimit;
    private boolean useNanoTime;
    private KeyManagerProviderConfigManager keyManagerProviderConfigManager;
    private ExtensionConfigManager extensionConfigManager;
    private LinkedHashSet<ClientConnection> establishedConnections;
    private List<Properties> mailServerPropertySets;
    private List<Modification> offlineSchemaChanges;
    private LogRotationPolicyConfigManager rotationPolicyConfigManager;
    private LogRetentionPolicyConfigManager retentionPolicyConfigManager;
    private LoggerConfigManager loggerConfigManager;
    private long currentConnections;
    private long idleTimeLimit;
    private long maxAllowedConnections;
    private long maxConnections;
    private long startUpTime;
    private long totalConnections;
    private MBeanServer mBeanServer;
    private MonitorConfigManager monitorConfigManager;
    private final OperatingSystem operatingSystem;
    private PasswordGeneratorConfigManager passwordGeneratorConfigManager;
    private PasswordPolicyConfig defaultPasswordPolicyConfig;
    private PasswordPolicyConfigManager passwordPolicyConfigManager;
    private PasswordStorageSchemeConfigManager storageSchemeConfigManager;
    private PasswordValidatorConfigManager passwordValidatorConfigManager;
    private PluginConfigManager pluginConfigManager;
    private ResultCode serverErrorResultCode;
    private RootDSEBackend rootDSEBackend;
    private RootDNConfigManager rootDNConfigManager;
    private SASLConfigManager saslConfigManager;
    private Schema schema;
    private SchemaConfigManager schemaConfigManager;
    private Set<Privilege> disabledPrivileges;
    private Set<String> allowedTasks;
    private String startTimeUTC;
    private SynchronizationProviderConfigManager synchronizationProviderConfigManager;
    private BaseDnRegistry baseDnRegistry;
    private TreeMap<String, Backend> backends;
    private ConcurrentHashMap<String, Long> offlineBackendsStateIDs;
    private TreeSet<String> supportedControls;
    private TreeSet<String> supportedFeatures;
    private TrustManagerProviderConfigManager trustManagerProviderConfigManager;
    private VirtualAttributeConfigManager virtualAttributeConfigManager;
    private WorkQueue workQueue;
    private WritabilityMode writabilityMode;
    private final ConcurrentHashMap<String, WorkflowElement> workflowElements = new ConcurrentHashMap();
    private GlobalCfgDefn.WorkflowConfigurationMode workflowConfigurationMode;
    private NetworkGroupConfigManager networkGroupConfigManager;
    private WorkflowConfigManager workflowConfigManager;
    private WorkflowElementConfigManager workflowElementConfigManager;
    private ServiceTagRegistration serviceTagRegistry;
    public static int DEFAULT_TIMEOUT = 200;

    private DirectoryServer() {
        this(new DirectoryEnvironmentConfig());
    }

    private DirectoryServer(DirectoryEnvironmentConfig config) {
        this.environmentConfig = config;
        this.isBootstrapped = false;
        this.isRunning = false;
        this.shuttingDown = false;
        this.lockdownMode = false;
        this.serverErrorResultCode = ResultCode.OTHER;
        this.operatingSystem = OperatingSystem.forName(System.getProperty("os.name"));
    }

    public static DirectoryServer getInstance() {
        return directoryServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryServer getNewInstance(DirectoryEnvironmentConfig config) {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer = new DirectoryServer(config);
            return DirectoryServer.directoryServer;
        }
    }

    public static DirectoryEnvironmentConfig getEnvironmentConfig() {
        return DirectoryServer.directoryServer.environmentConfig;
    }

    public void setEnvironmentConfig(DirectoryEnvironmentConfig config) throws InitializationException {
        if (this.isRunning) {
            throw new InitializationException(CoreMessages.ERR_CANNOT_SET_ENVIRONMENT_CONFIG_WHILE_RUNNING.get());
        }
        this.environmentConfig = config;
    }

    public static boolean isRunning() {
        return DirectoryServer.directoryServer.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrapClient() {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer.syntaxEnforcementPolicy = AcceptRejectWarn.REJECT;
            DirectoryServer.directoryServer.schema = new Schema();
            DirectoryServer.directoryServer.bootstrapMatchingRules();
            DirectoryServer.directoryServer.bootstrapAttributeSyntaxes();
            DirectoryServer.directoryServer.alertHandlers = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.passwordStorageSchemes = new ConcurrentHashMap();
            DirectoryServer.directoryServer.passwordStorageSchemesByDN = new ConcurrentHashMap();
            DirectoryServer.directoryServer.passwordGenerators = new ConcurrentHashMap();
            DirectoryServer.directoryServer.authPasswordStorageSchemes = new ConcurrentHashMap();
            DirectoryServer.directoryServer.passwordValidators = new ConcurrentHashMap();
            DirectoryServer.directoryServer.accountStatusNotificationHandlers = new ConcurrentHashMap();
            DirectoryServer.directoryServer.rootDNs = new CopyOnWriteArraySet();
            DirectoryServer.directoryServer.alternateRootBindDNs = new ConcurrentHashMap();
            DirectoryServer.directoryServer.keyManagerProviders = new ConcurrentHashMap();
            DirectoryServer.directoryServer.extensions = new ConcurrentHashMap();
            DirectoryServer.directoryServer.trustManagerProviders = new ConcurrentHashMap();
            DirectoryServer.directoryServer.rotationPolicies = new ConcurrentHashMap();
            DirectoryServer.directoryServer.retentionPolicies = new ConcurrentHashMap();
            DirectoryServer.directoryServer.certificateMappers = new ConcurrentHashMap();
            DirectoryServer.directoryServer.passwordPolicies = new ConcurrentHashMap();
            DirectoryServer.directoryServer.defaultPasswordPolicyDN = null;
            DirectoryServer.directoryServer.defaultPasswordPolicyConfig = null;
            DirectoryServer.directoryServer.monitorProviders = new ConcurrentHashMap();
            DirectoryServer.directoryServer.backends = new TreeMap();
            DirectoryServer.directoryServer.offlineBackendsStateIDs = new ConcurrentHashMap();
            DirectoryServer.directoryServer.backendInitializationListeners = new CopyOnWriteArraySet();
            DirectoryServer.directoryServer.baseDnRegistry = new BaseDnRegistry();
            DirectoryServer.directoryServer.changeNotificationListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.initializationCompletedListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.shutdownListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.synchronizationProviders = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.supportedControls = new TreeSet();
            DirectoryServer.directoryServer.supportedFeatures = new TreeSet();
            DirectoryServer.directoryServer.supportedLDAPVersions = new ConcurrentHashMap();
            DirectoryServer.directoryServer.virtualAttributes = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.connectionHandlers = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.identityMappers = new ConcurrentHashMap();
            DirectoryServer.directoryServer.extendedOperationHandlers = new ConcurrentHashMap();
            DirectoryServer.directoryServer.saslMechanismHandlers = new ConcurrentHashMap();
            DirectoryServer.directoryServer.authenticatedUsers = new AuthenticatedUsers();
            DirectoryServer.directoryServer.offlineSchemaChanges = new LinkedList<Modification>();
            DirectoryServer.directoryServer.backupTaskListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.restoreTaskListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.exportTaskListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.importTaskListeners = new CopyOnWriteArrayList();
            DirectoryServer.directoryServer.allowedTasks = new LinkedHashSet<String>(0);
            DirectoryServer.directoryServer.disabledPrivileges = new LinkedHashSet<Privilege>(0);
            DirectoryServer.directoryServer.returnBindErrorMessages = false;
            DirectoryServer.directoryServer.idleTimeLimit = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapServer() throws InitializationException {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            if (this.isRunning) {
                Message message = CoreMessages.ERR_CANNOT_BOOTSTRAP_WHILE_RUNNING.get();
                throw new InitializationException(message);
            }
            this.isBootstrapped = false;
            this.shuttingDown = false;
        }
        this.shutdownHook = new DirectoryServerShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        DirectoryServer.initializeJMX();
        ErrorLogger.logError(CoreMessages.INFO_DIRECTORY_BOOTSTRAPPING.get());
        DirectoryServer.bootstrapClient();
        this.establishedConnections = new LinkedHashSet(1000);
        this.currentConnections = 0L;
        this.maxConnections = 0L;
        this.totalConnections = 0L;
        this.pluginConfigManager = new PluginConfigManager();
        directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            this.isBootstrapped = true;
        }
    }

    public static void initializeJMX() throws InitializationException {
        try {
            try {
                DirectoryServer.directoryServer.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.WARNING, e);
                }
                DirectoryServer.directoryServer.mBeanServer = MBeanServerFactory.newMBeanServer();
            }
            DirectoryServer.directoryServer.mBeans = new ConcurrentHashMap();
            DirectoryServer.registerAlertGenerator(directoryServer);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_CREATE_MBEAN_SERVER.get(String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void initializeConfiguration(String configClass, String configFile) throws InitializationException {
        Class<?> cfgClass;
        try {
            cfgClass = Class.forName(configClass);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_LOAD_CONFIG_HANDLER_CLASS.get(configClass, StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        File cfgFile = new File(configFile);
        this.environmentConfig.setConfigClass(cfgClass);
        this.environmentConfig.setConfigFile(cfgFile);
        this.initializeConfiguration();
    }

    public void initializeConfiguration() throws InitializationException {
        this.configClass = this.environmentConfig.getConfigClass();
        this.configFile = this.environmentConfig.getConfigFile();
        ClassLoaderProvider provider = ClassLoaderProvider.getInstance();
        if (!provider.isEnabled()) {
            provider.enable();
        }
        Class handlerClass = this.configClass;
        try {
            this.configHandler = (ConfigHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_INSTANTIATE_CONFIG_HANDLER.get(String.valueOf(this.configClass), e.getLocalizedMessage());
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            String path;
            try {
                path = this.configFile.getCanonicalPath();
            }
            catch (Exception ex) {
                path = this.configFile.getAbsolutePath();
            }
            this.configHandler.initializeConfigHandler(path, false);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw ie;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_INITIALIZE_CONFIG_HANDLER.get(String.valueOf(this.configClass), String.valueOf(this.configFile), e.getLocalizedMessage());
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public static String getConfigFile() {
        return DirectoryServer.directoryServer.configFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() throws ConfigException, InitializationException {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            File serverStartingFile;
            if (!this.isBootstrapped) {
                Message message = CoreMessages.ERR_CANNOT_START_BEFORE_BOOTSTRAP.get();
                throw new InitializationException(message);
            }
            if (this.isRunning) {
                Message message = CoreMessages.ERR_CANNOT_START_WHILE_RUNNING.get();
                throw new InitializationException(message);
            }
            ErrorLogger.logError(CoreMessages.NOTE_DIRECTORY_SERVER_STARTING.get(DirectoryServer.getVersionString(), DynamicConstants.BUILD_ID, DynamicConstants.REVISION_NUMBER));
            if (!serverLocked) {
                String lockFile = LockFileManager.getServerLockFileName();
                try {
                    StringBuilder failureReason = new StringBuilder();
                    if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                        Message message = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, String.valueOf(failureReason));
                        throw new InitializationException(message);
                    }
                    serverLocked = true;
                }
                catch (InitializationException ie) {
                    throw ie;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, StaticUtils.stackTraceToSingleLineString(e));
                    throw new InitializationException(message, (Throwable)e);
                }
            }
            this.startUpTime = System.currentTimeMillis();
            this.startTimeUTC = TimeThread.getGMTTime();
            boolean startConnectionHandlers = !this.environmentConfig.disableConnectionHandlers();
            this.initializeSchema();
            this.pluginConfigManager.initializePluginConfigManager();
            this.initializeVirtualAttributes();
            this.coreConfigManager = new CoreConfigManager();
            this.coreConfigManager.initializeCoreConfig();
            this.initializeCryptoManager();
            this.rotationPolicyConfigManager = new LogRotationPolicyConfigManager();
            this.rotationPolicyConfigManager.initializeLogRotationPolicyConfig();
            this.retentionPolicyConfigManager = new LogRetentionPolicyConfigManager();
            this.retentionPolicyConfigManager.initializeLogRetentionPolicyConfig();
            this.loggerConfigManager = new LoggerConfigManager();
            this.loggerConfigManager.initializeLoggerConfig();
            RuntimeInformation.logInfo();
            this.initializeAlertHandlers();
            this.entryCacheConfigManager = new EntryCacheConfigManager();
            this.entryCacheConfigManager.initializeDefaultEntryCache();
            if (startConnectionHandlers) {
                this.initializeAdministrationConnector();
            }
            this.keyManagerProviderConfigManager = new KeyManagerProviderConfigManager();
            this.keyManagerProviderConfigManager.initializeKeyManagerProviders();
            this.extensionConfigManager = new ExtensionConfigManager();
            this.extensionConfigManager.initializeExtensions();
            this.trustManagerProviderConfigManager = new TrustManagerProviderConfigManager();
            this.trustManagerProviderConfigManager.initializeTrustManagerProviders();
            this.certificateMapperConfigManager = new CertificateMapperConfigManager();
            this.certificateMapperConfigManager.initializeCertificateMappers();
            this.initializeIdentityMappers();
            this.rootDNConfigManager = new RootDNConfigManager();
            this.rootDNConfigManager.initializeRootDNs();
            this.initializeSubentryManager();
            this.initializeGroupManager();
            AccessControlConfigManager.getInstance().initializeAccessControl();
            this.initializeBackends();
            if (DirectoryServer.workflowConfigurationModeIsAuto()) {
                this.createAndRegisterRemainingWorkflows();
            } else {
                this.configureWorkflowsManual();
            }
            this.entryCacheConfigManager.initializeEntryCache();
            DirectoryServer.directoryServer.offlineBackendsStateIDs.clear();
            this.initializeSupportedControls();
            this.initializeSupportedFeatures();
            this.initializeExtendedOperations();
            this.initializeSASLMechanisms();
            if (startConnectionHandlers) {
                this.initializeConnectionHandlers();
            }
            this.monitorConfigManager = new MonitorConfigManager();
            this.monitorConfigManager.initializeMonitorProviders();
            this.initializePasswordPolicyComponents();
            this.pluginConfigManager.initializeUserPlugins(null);
            if (!this.environmentConfig.disableSynchronization()) {
                this.synchronizationProviderConfigManager = new SynchronizationProviderConfigManager();
                this.synchronizationProviderConfigManager.initializeSynchronizationProviders();
            }
            this.workQueue = new WorkQueueConfigManager().initializeWorkQueue();
            PluginResult.Startup startupPluginResult = this.pluginConfigManager.invokeStartupPlugins();
            if (!startupPluginResult.continueProcessing()) {
                Message message = CoreMessages.ERR_STARTUP_PLUGIN_ERROR.get(startupPluginResult.getErrorMessage(), startupPluginResult.getErrorMessage().getDescriptor().getId());
                throw new InitializationException(message);
            }
            for (InitializationCompletedListener initializationCompletedListener : DirectoryServer.directoryServer.initializationCompletedListeners) {
                try {
                    initializationCompletedListener.initializationCompleted();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (startConnectionHandlers) {
                this.startConnectionHandlers();
                new IdleTimeLimitThread().start();
            }
            new CryptoManagerSync();
            if (this.saveConfigOnSuccessfulStartup) {
                this.configHandler.writeSuccessfulStartupConfig();
            }
            this.isRunning = true;
            Message message = CoreMessages.NOTE_DIRECTORY_SERVER_STARTED.get();
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.DirectoryServerStarted", message);
            InternalClientConnection rootConnection = InternalClientConnection.getRootConnection();
            if (!this.environmentConfig.disableAdminDataSynchronization()) {
                AdministrationDataSync admDataSync = new AdministrationDataSync(rootConnection);
                admDataSync.synchronize();
            }
            if ((serverStartingFile = new File(this.configHandler.getInstanceRoot() + File.separator + "logs" + File.separator + "server.starting")).exists()) {
                serverStartingFile.delete();
            }
        }
    }

    private void bootstrapMatchingRules() {
        MatchingRuleFactory[] factories = new MatchingRuleFactory[]{new DoubleMetaphoneApproximateMatchingRuleFactory(), new BooleanEqualityMatchingRuleFactory(), new CaseExactEqualityMatchingRuleFactory(), new CaseExactIA5EqualityMatchingRuleFactory(), new CaseIgnoreEqualityMatchingRuleFactory(), new CaseIgnoreIA5EqualityMatchingRuleFactory(), new DistinguishedNameEqualityMatchingRuleFactory(), new GeneralizedTimeEqualityMatchingRuleFactory(), new IntegerEqualityMatchingRuleFactory(), new OctetStringEqualityMatchingRuleFactory(), new ObjectIdentifierEqualityMatchingRuleFactory(), new TelephoneNumberEqualityMatchingRuleFactory(), new CaseExactOrderingMatchingRuleFactory(), new CaseIgnoreOrderingMatchingRuleFactory(), new GeneralizedTimeOrderingMatchingRuleFactory(), new IntegerOrderingMatchingRuleFactory(), new OctetStringOrderingMatchingRuleFactory(), new CaseExactSubstringMatchingRuleFactory(), new CaseExactIA5SubstringMatchingRuleFactory(), new CaseIgnoreSubstringMatchingRuleFactory(), new CaseIgnoreIA5SubstringMatchingRuleFactory(), new OctetStringSubstringMatchingRuleFactory(), new TelephoneNumberSubstringMatchingRuleFactory()};
        Object currentFactory = null;
        try {
            for (MatchingRuleFactory factory : factories) {
                currentFactory = factory;
                ((MatchingRuleFactory)currentFactory).initializeMatchingRule(null);
                for (MatchingRule matchingRule : ((MatchingRuleFactory)currentFactory).getMatchingRules()) {
                    DirectoryServer.registerMatchingRule(matchingRule, true);
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_BOOTSTRAP_MATCHING_RULE.get(currentFactory.getClass().getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
    }

    private void bootstrapAttributeSyntaxes() {
        Message message;
        AttributeSyntax syntax;
        try {
            syntax = new AttributeTypeSyntax();
            ((AttributeTypeSyntax)syntax).initializeSyntax((AttributeTypeDescriptionAttributeSyntaxCfg)null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(AttributeTypeSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            this.defaultBinarySyntax = new BinarySyntax();
            this.defaultBinarySyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultBinarySyntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(BinarySyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            this.defaultBooleanSyntax = new BooleanSyntax();
            this.defaultBooleanSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultBooleanSyntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(BooleanSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            this.defaultStringSyntax = new DirectoryStringSyntax();
            this.defaultStringSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultStringSyntax, true);
            this.defaultSyntax = this.defaultStringSyntax;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(DirectoryStringSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            this.defaultDNSyntax = new DistinguishedNameSyntax();
            this.defaultDNSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultDNSyntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(DistinguishedNameSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            syntax = new IA5StringSyntax();
            ((IA5StringSyntax)syntax).initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(IA5StringSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            this.defaultIntegerSyntax = new IntegerSyntax();
            this.defaultIntegerSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultIntegerSyntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(IntegerSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            syntax = new GeneralizedTimeSyntax();
            ((GeneralizedTimeSyntax)syntax).initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(GeneralizedTimeSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            syntax = new ObjectClassSyntax();
            ((ObjectClassSyntax)syntax).initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(ObjectClassSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            syntax = new OIDSyntax();
            ((OIDSyntax)syntax).initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(OIDSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        try {
            syntax = new TelephoneNumberSyntax();
            ((TelephoneNumberSyntax)syntax).initializeSyntax((TelephoneNumberAttributeSyntaxCfg)null);
            DirectoryServer.registerAttributeSyntax(syntax, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = CoreMessages.ERR_CANNOT_BOOTSTRAP_SYNTAX.get(TelephoneNumberSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
    }

    public static AuthenticatedUsers getAuthenticatedUsers() {
        return DirectoryServer.directoryServer.authenticatedUsers;
    }

    public void initializeCryptoManager() throws ConfigException, InitializationException {
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        CryptoManagerCfg cryptoManagerCfg = root.getCryptoManager();
        this.cryptoManager = new CryptoManagerImpl(cryptoManagerCfg);
    }

    public static CryptoManagerImpl getCryptoManager() {
        return DirectoryServer.directoryServer.cryptoManager;
    }

    public static boolean mailServerConfigured() {
        return DirectoryServer.directoryServer.mailServerPropertySets != null && !DirectoryServer.directoryServer.mailServerPropertySets.isEmpty();
    }

    public static void setMailServerPropertySets(List<Properties> mailServerPropertySets) {
        DirectoryServer.directoryServer.mailServerPropertySets = mailServerPropertySets;
    }

    public static List<Properties> getMailServerPropertySets() {
        return DirectoryServer.directoryServer.mailServerPropertySets;
    }

    private void initializeAlertHandlers() throws ConfigException, InitializationException {
        new AlertHandlerConfigManager().initializeAlertHandlers();
    }

    public void initializeSchema() throws ConfigException, InitializationException {
        DN dn;
        LinkedHashMap<String, List<ConfigChangeListener>> changeListeners;
        LinkedHashMap<String, List<ConfigDeleteListener>> deleteListeners;
        LinkedHashMap<String, List<ConfigAddListener>> addListeners;
        block19: {
            this.schemaConfigManager = new SchemaConfigManager();
            this.schema = this.schemaConfigManager.getSchema();
            this.schemaConfigManager.initializeMatchingRules();
            this.schemaConfigManager.initializeAttributeSyntaxes();
            this.schemaConfigManager.initializeSchemaFromFiles();
            this.compressedSchema = new DefaultCompressedSchema();
            addListeners = new LinkedHashMap<String, List<ConfigAddListener>>();
            deleteListeners = new LinkedHashMap<String, List<ConfigDeleteListener>>();
            changeListeners = new LinkedHashMap<String, List<ConfigChangeListener>>();
            this.getChangeListeners(this.configHandler.getConfigRootEntry(), addListeners, deleteListeners, changeListeners);
            try {
                this.configHandler.finalizeConfigHandler();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block19;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        try {
            this.configHandler.initializeConfigHandler(this.configFile.getAbsolutePath(), true);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw ie;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_INITIALIZE_CONFIG_HANDLER.get(String.valueOf(this.configClass), String.valueOf(this.configFile), e.getLocalizedMessage());
            throw new InitializationException(message);
        }
        for (String dnStr : addListeners.keySet()) {
            try {
                dn = DN.decode(dnStr);
                for (ConfigAddListener configAddListener : addListeners.get(dnStr)) {
                    this.configHandler.getConfigEntry(dn).registerAddListener(configAddListener);
                }
            }
            catch (DirectoryException de) {
                throw new InitializationException(de.getMessageObject());
            }
        }
        for (String dnStr : deleteListeners.keySet()) {
            try {
                dn = DN.decode(dnStr);
                for (ConfigDeleteListener configDeleteListener : deleteListeners.get(dnStr)) {
                    this.configHandler.getConfigEntry(dn).registerDeleteListener(configDeleteListener);
                }
            }
            catch (DirectoryException de) {
                throw new InitializationException(de.getMessageObject());
            }
        }
        for (String dnStr : changeListeners.keySet()) {
            try {
                dn = DN.decode(dnStr);
                for (ConfigChangeListener configChangeListener : changeListeners.get(dnStr)) {
                    this.configHandler.getConfigEntry(dn).registerChangeListener(configChangeListener);
                }
            }
            catch (DirectoryException de) {
                throw new InitializationException(de.getMessageObject());
            }
        }
    }

    public static CompressedSchema getDefaultCompressedSchema() {
        return DirectoryServer.directoryServer.compressedSchema;
    }

    private void getChangeListeners(ConfigEntry configEntry, LinkedHashMap<String, List<ConfigAddListener>> addListeners, LinkedHashMap<String, List<ConfigDeleteListener>> deleteListeners, LinkedHashMap<String, List<ConfigChangeListener>> changeListeners) {
        CopyOnWriteArrayList<ConfigChangeListener> cfgChangeListeners;
        CopyOnWriteArrayList<ConfigDeleteListener> cfgDeleteListeners;
        CopyOnWriteArrayList<ConfigAddListener> cfgAddListeners = configEntry.getAddListeners();
        if (cfgAddListeners != null && cfgAddListeners.size() > 0) {
            addListeners.put(configEntry.getDN().toString(), cfgAddListeners);
        }
        if ((cfgDeleteListeners = configEntry.getDeleteListeners()) != null && cfgDeleteListeners.size() > 0) {
            deleteListeners.put(configEntry.getDN().toString(), cfgDeleteListeners);
        }
        if ((cfgChangeListeners = configEntry.getChangeListeners()) != null && cfgChangeListeners.size() > 0) {
            changeListeners.put(configEntry.getDN().toString(), cfgChangeListeners);
        }
        for (ConfigEntry child : configEntry.getChildren().values()) {
            this.getChangeListeners(child, addListeners, deleteListeners, changeListeners);
        }
    }

    public static Set<BackendInitializationListener> getBackendInitializationListeners() {
        return DirectoryServer.directoryServer.backendInitializationListeners;
    }

    public static void registerBackendInitializationListener(BackendInitializationListener listener) {
        DirectoryServer.directoryServer.backendInitializationListeners.add(listener);
    }

    public static void deregisterBackendInitializationListener(BackendInitializationListener listener) {
        DirectoryServer.directoryServer.backendInitializationListeners.remove(listener);
    }

    public void initializeBackends() throws ConfigException, InitializationException {
        RootDSEBackendCfg rootDSECfg;
        this.backendConfigManager = new BackendConfigManager();
        this.backendConfigManager.initializeBackendConfig();
        try {
            RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
            rootDSECfg = root.getRootDSEBackend();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_GET_ROOT_DSE_CONFIG_ENTRY.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.rootDSEBackend = new RootDSEBackend();
        this.rootDSEBackend.configureBackend(rootDSECfg);
        this.rootDSEBackend.initializeBackend();
    }

    private static void deregisterWorkflowWithDefaultNetworkGroup(DN baseDN) {
        NetworkGroup defaultNetworkGroup = NetworkGroup.getDefaultNetworkGroup();
        defaultNetworkGroup.deregisterWorkflow(baseDN);
    }

    private static void deregisterWorkflowWithAdminNetworkGroup(DN baseDN) {
        NetworkGroup adminNetworkGroup = NetworkGroup.getAdminNetworkGroup();
        adminNetworkGroup.deregisterWorkflow(baseDN);
    }

    private static void deregisterWorkflowWithInternalNetworkGroup(DN baseDN) {
        NetworkGroup internalNetworkGroup = NetworkGroup.getInternalNetworkGroup();
        Workflow workflow = internalNetworkGroup.deregisterWorkflow(baseDN);
        WorkflowImpl workflowImpl = (WorkflowImpl)workflow;
        workflowImpl.deregister();
    }

    public static void createAndRegisterWorkflowsWithDefaultNetworkGroup(Backend backend) throws DirectoryException {
        for (DN curBaseDN : backend.getBaseDNs()) {
            WorkflowImpl workflowImpl = DirectoryServer.createWorkflow(curBaseDN, backend);
            DirectoryServer.registerWorkflowWithAdminNetworkGroup(workflowImpl);
            DirectoryServer.registerWorkflowWithInternalNetworkGroup(workflowImpl);
            if (curBaseDN.equals(DN.decode("cn=config")) && !DirectoryServer.workflowConfigurationModeIsAuto()) continue;
            DirectoryServer.registerWorkflowWithDefaultNetworkGroup(workflowImpl);
        }
    }

    public static WorkflowImpl createWorkflow(DN baseDN, Backend backend) throws DirectoryException {
        String backendID = backend.getBackendID();
        LocalBackendWorkflowElement rootWE = LocalBackendWorkflowElement.createAndRegister(backendID, backend);
        String workflowID = backend.getBackendID() + "#" + baseDN.toString();
        WorkflowImpl workflowImpl = new WorkflowImpl(workflowID, baseDN, rootWE.getWorkflowElementID(), rootWE);
        workflowImpl.register();
        return workflowImpl;
    }

    private static void registerWorkflowWithDefaultNetworkGroup(WorkflowImpl workflowImpl) throws DirectoryException {
        NetworkGroup defaultNetworkGroup = NetworkGroup.getDefaultNetworkGroup();
        defaultNetworkGroup.registerWorkflow(workflowImpl);
    }

    private static void registerWorkflowWithAdminNetworkGroup(WorkflowImpl workflowImpl) throws DirectoryException {
        NetworkGroup adminNetworkGroup = NetworkGroup.getAdminNetworkGroup();
        adminNetworkGroup.registerWorkflow(workflowImpl);
    }

    private static void registerWorkflowWithInternalNetworkGroup(WorkflowImpl workflowImpl) throws DirectoryException {
        NetworkGroup internalNetworkGroup = NetworkGroup.getInternalNetworkGroup();
        internalNetworkGroup.registerWorkflow(workflowImpl);
    }

    private void createAndRegisterRemainingWorkflows() throws ConfigException {
        try {
            DirectoryServer.createAndRegisterWorkflowsWithDefaultNetworkGroup(this.configHandler);
            DirectoryServer.createAndRegisterWorkflowsWithDefaultNetworkGroup(this.rootDSEBackend);
        }
        catch (DirectoryException de) {
            throw new ConfigException(de.getMessageObject());
        }
    }

    public static void reconfigureWorkflows(GlobalCfgDefn.WorkflowConfigurationMode oldMode, GlobalCfgDefn.WorkflowConfigurationMode newMode) {
        if (oldMode == GlobalCfgDefn.WorkflowConfigurationMode.AUTO && newMode == GlobalCfgDefn.WorkflowConfigurationMode.MANUAL) {
            try {
                DirectoryServer.setWorkflowConfigurationMode(newMode);
                directoryServer.configureWorkflowsManual();
            }
            catch (Exception e) {
                try {
                    DirectoryServer.setWorkflowConfigurationMode(oldMode);
                    directoryServer.configureWorkflowsAuto();
                }
                catch (Exception ee) {
                    Message message = ConfigMessages.ERR_CONFIG_WORKFLOW_CANNOT_CONFIGURE_MANUAL.get();
                    ErrorLogger.logError(message);
                }
            }
        } else if (oldMode == GlobalCfgDefn.WorkflowConfigurationMode.MANUAL && newMode == GlobalCfgDefn.WorkflowConfigurationMode.AUTO) {
            try {
                DirectoryServer.setWorkflowConfigurationMode(newMode);
                directoryServer.configureWorkflowsAuto();
            }
            catch (Exception e) {
                try {
                    DirectoryServer.setWorkflowConfigurationMode(oldMode);
                    directoryServer.configureWorkflowsManual();
                }
                catch (Exception ee) {
                    Message message = ConfigMessages.ERR_CONFIG_WORKFLOW_CANNOT_CONFIGURE_AUTO.get();
                    ErrorLogger.logError(message);
                }
            }
        }
    }

    public void configureWorkflowsManual() throws ConfigException, InitializationException {
        NetworkGroup.resetConfig();
        WorkflowImpl.resetConfig();
        DirectoryServer.directoryServer.workflowElements.clear();
        this.createAndRegisterRemainingWorkflows();
        this.workflowElementConfigManager = new WorkflowElementConfigManager();
        this.workflowElementConfigManager.initializeWorkflowElements();
        this.workflowConfigManager = new WorkflowConfigManager();
        this.workflowConfigManager.initializeWorkflows();
        if (this.networkGroupConfigManager == null) {
            this.networkGroupConfigManager = new NetworkGroupConfigManager();
            this.networkGroupConfigManager.initializeNetworkGroups();
        }
    }

    private void configureWorkflowsAuto() throws ConfigException {
        if (this.networkGroupConfigManager != null) {
            this.networkGroupConfigManager.finalizeNetworkGroups();
            this.networkGroupConfigManager = null;
        }
        NetworkGroup.resetConfig();
        WorkflowImpl.resetConfig();
        DirectoryServer.directoryServer.workflowElements.clear();
        Map<String, Backend> backendMap = DirectoryServer.getBackends();
        for (String backendID : backendMap.keySet()) {
            Backend backend = backendMap.get(backendID);
            for (DN baseDN : backend.getBaseDNs()) {
                try {
                    WorkflowImpl workflowImpl = DirectoryServer.createWorkflow(baseDN, backend);
                    DirectoryServer.registerWorkflowWithInternalNetworkGroup(workflowImpl);
                    DirectoryServer.registerWorkflowWithAdminNetworkGroup(workflowImpl);
                    DirectoryServer.registerWorkflowWithDefaultNetworkGroup(workflowImpl);
                }
                catch (DirectoryException e) {
                    throw new ConfigException(e.getMessageObject());
                }
            }
        }
        this.createAndRegisterRemainingWorkflows();
    }

    public void initializeGroupManager() throws ConfigException, InitializationException {
        this.groupManager = new GroupManager();
        this.groupManager.initializeGroupImplementations();
        this.groupManager.performBackendInitializationProcessing(this.configHandler);
    }

    public static GroupManager getGroupManager() {
        return DirectoryServer.directoryServer.groupManager;
    }

    public static SubentryManager getSubentryManager() {
        return DirectoryServer.directoryServer.subentryManager;
    }

    private void initializeSupportedControls() throws ConfigException, InitializationException {
        this.supportedControls.add("1.3.6.1.1.12");
        this.supportedControls.add("1.3.6.1.1.13.1");
        this.supportedControls.add("1.3.6.1.1.13.2");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.2");
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.12");
        this.supportedControls.add("2.16.840.1.113730.3.4.18");
        this.supportedControls.add("2.16.840.1.113730.3.4.16");
        this.supportedControls.add("1.2.826.0.1.3344810.2.3");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.1");
        this.supportedControls.add("1.3.6.1.4.1.42.2.27.8.5.1");
        this.supportedControls.add("1.2.840.113556.1.4.1413");
        this.supportedControls.add("2.16.840.1.113730.3.4.17");
        this.supportedControls.add("2.16.840.1.113730.3.4.19");
        this.supportedControls.add("1.3.6.1.4.1.42.2.27.9.5.8");
        this.supportedControls.add("2.16.840.1.113730.3.4.4");
        this.supportedControls.add("2.16.840.1.113730.3.4.5");
    }

    private void initializeSupportedFeatures() throws ConfigException, InitializationException {
        this.supportedFeatures.add("1.3.6.1.4.1.4203.1.5.1");
        this.supportedFeatures.add("1.3.6.1.1.14");
        this.supportedFeatures.add("1.3.6.1.4.1.4203.1.5.3");
    }

    private void initializeIdentityMappers() throws ConfigException, InitializationException {
        this.identityMapperConfigManager = new IdentityMapperConfigManager();
        this.identityMapperConfigManager.initializeIdentityMappers();
    }

    private void initializeExtendedOperations() throws ConfigException, InitializationException {
        this.extendedOperationConfigManager = new ExtendedOperationConfigManager();
        this.extendedOperationConfigManager.initializeExtendedOperationHandlers();
    }

    private void initializeSASLMechanisms() throws ConfigException, InitializationException {
        this.saslConfigManager = new SASLConfigManager();
        this.saslConfigManager.initializeSASLMechanismHandlers();
    }

    private void initializeVirtualAttributes() throws ConfigException, InitializationException {
        this.virtualAttributeConfigManager = new VirtualAttributeConfigManager();
        this.virtualAttributeConfigManager.initializeVirtualAttributes();
    }

    private void initializeConnectionHandlers() throws ConfigException, InitializationException {
        if (this.connectionHandlerConfigManager == null) {
            this.connectionHandlerConfigManager = new ConnectionHandlerConfigManager();
        }
        this.connectionHandlerConfigManager.initializeConnectionHandlerConfig();
    }

    public void initializeAdministrationConnector() throws ConfigException, InitializationException {
        if (this.connectionHandlerConfigManager == null) {
            this.connectionHandlerConfigManager = new ConnectionHandlerConfigManager();
        }
        this.connectionHandlerConfigManager.initializeAdministrationConnectorConfig();
    }

    public void initializeSubentryManager() throws InitializationException {
        try {
            this.subentryManager = new SubentryManager();
            this.subentryManager.performBackendInitializationProcessing(this.configHandler);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw new InitializationException(de.getMessageObject());
        }
    }

    public void initializePasswordPolicyComponents() throws ConfigException, InitializationException {
        this.storageSchemeConfigManager = new PasswordStorageSchemeConfigManager();
        this.storageSchemeConfigManager.initializePasswordStorageSchemes();
        this.passwordValidatorConfigManager = new PasswordValidatorConfigManager();
        this.passwordValidatorConfigManager.initializePasswordValidators();
        this.passwordGeneratorConfigManager = new PasswordGeneratorConfigManager();
        this.passwordGeneratorConfigManager.initializePasswordGenerators();
        this.accountStatusNotificationHandlerConfigManager = new AccountStatusNotificationHandlerConfigManager();
        this.accountStatusNotificationHandlerConfigManager.initializeNotificationHandlers();
        this.passwordPolicyConfigManager = new PasswordPolicyConfigManager();
        this.passwordPolicyConfigManager.initializePasswordPolicies();
    }

    public static OperatingSystem getOperatingSystem() {
        return DirectoryServer.directoryServer.operatingSystem;
    }

    public static ConfigHandler getConfigHandler() {
        return DirectoryServer.directoryServer.configHandler;
    }

    public void initializePlugins(Set<PluginType> pluginTypes) throws ConfigException, InitializationException {
        this.pluginConfigManager = new PluginConfigManager();
        this.pluginConfigManager.initializePluginConfigManager();
        this.pluginConfigManager.initializeUserPlugins(pluginTypes);
    }

    public void initializeRootDNConfigManager() throws ConfigException, InitializationException {
        this.rootDNConfigManager = new RootDNConfigManager();
        this.rootDNConfigManager.initializeRootDNs();
    }

    public void initializeRootDSE() throws ConfigException, InitializationException {
        RootDSEBackendCfg rootDSECfg;
        try {
            RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
            rootDSECfg = root.getRootDSEBackend();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CANNOT_GET_ROOT_DSE_CONFIG_ENTRY.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.rootDSEBackend = new RootDSEBackend();
        this.rootDSEBackend.configureBackend(rootDSECfg);
        this.rootDSEBackend.initializeBackend();
    }

    public static PluginConfigManager getPluginConfigManager() {
        return DirectoryServer.directoryServer.pluginConfigManager;
    }

    public static void registerInternalPlugin(InternalDirectoryServerPlugin plugin) {
        DirectoryServer.directoryServer.pluginConfigManager.registerInternalPlugin(plugin);
    }

    public static void deregisterInternalPlugin(InternalDirectoryServerPlugin plugin) {
        DirectoryServer.directoryServer.pluginConfigManager.deregisterInternalPlugin(plugin);
    }

    public static ConfigEntry getConfigEntry(DN entryDN) throws ConfigException {
        return DirectoryServer.directoryServer.configHandler.getConfigEntry(entryDN);
    }

    public static String getServerRoot() {
        if (DirectoryServer.directoryServer.configHandler == null) {
            File serverRoot = DirectoryServer.directoryServer.environmentConfig.getServerRoot();
            if (serverRoot != null) {
                return serverRoot.getAbsolutePath();
            }
            return System.getProperty("user.dir");
        }
        return DirectoryServer.directoryServer.configHandler.getServerRoot();
    }

    public static String getInstanceRoot() {
        if (DirectoryServer.directoryServer.configHandler == null) {
            File instanceRoot;
            File serverRoot = DirectoryServer.directoryServer.environmentConfig.getServerRoot();
            if (serverRoot != null && (instanceRoot = DirectoryEnvironmentConfig.getInstanceRootFromServerRoot(serverRoot)) != null) {
                return instanceRoot.getAbsolutePath();
            }
            return System.getProperty("user.dir");
        }
        return DirectoryServer.directoryServer.configHandler.getInstanceRoot();
    }

    public static long getStartTime() {
        return DirectoryServer.directoryServer.startUpTime;
    }

    public static String getStartTimeUTC() {
        return DirectoryServer.directoryServer.startTimeUTC;
    }

    public static Schema getSchema() {
        return DirectoryServer.directoryServer.schema;
    }

    public static void setSchema(Schema schema) {
        DirectoryServer.directoryServer.schema = schema;
    }

    public static List<Modification> getOfflineSchemaChanges() {
        return DirectoryServer.directoryServer.offlineSchemaChanges;
    }

    public static void setOfflineSchemaChanges(List<Modification> offlineSchemaChanges) {
        Validator.ensureNotNull(offlineSchemaChanges);
        DirectoryServer.directoryServer.offlineSchemaChanges = offlineSchemaChanges;
    }

    public static ConcurrentHashMap<String, MatchingRule> getMatchingRules() {
        return DirectoryServer.directoryServer.schema.getMatchingRules();
    }

    public static LinkedHashSet<AttributeValue> getMatchingRuleSet() {
        return DirectoryServer.directoryServer.schema.getMatchingRuleSet();
    }

    public static MatchingRule getMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getMatchingRule(lowerName);
    }

    public static void registerMatchingRule(MatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerMatchingRule(matchingRule, overwriteExisting);
    }

    public static void deregisterMatchingRule(MatchingRule matchingRule) {
        DirectoryServer.directoryServer.schema.deregisterMatchingRule(matchingRule);
    }

    public static ConcurrentHashMap<String, ApproximateMatchingRule> getApproximateMatchingRules() {
        return DirectoryServer.directoryServer.schema.getApproximateMatchingRules();
    }

    public static ApproximateMatchingRule getApproximateMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getApproximateMatchingRule(lowerName);
    }

    public static void registerApproximateMatchingRule(ApproximateMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerApproximateMatchingRule(matchingRule, overwriteExisting);
    }

    public static void deregisterApproximateMatchingRule(ApproximateMatchingRule matchingRule) {
        DirectoryServer.directoryServer.schema.deregisterApproximateMatchingRule(matchingRule);
    }

    public static ConcurrentHashMap<String, EqualityMatchingRule> getEqualityMatchingRules() {
        return DirectoryServer.directoryServer.schema.getEqualityMatchingRules();
    }

    public static EqualityMatchingRule getEqualityMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getEqualityMatchingRule(lowerName);
    }

    public static void registerEqualityMatchingRule(EqualityMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerEqualityMatchingRule(matchingRule, overwriteExisting);
    }

    public static void deregisterEqualityMatchingRule(EqualityMatchingRule matchingRule) {
        DirectoryServer.directoryServer.schema.deregisterEqualityMatchingRule(matchingRule);
    }

    public static ConcurrentHashMap<String, OrderingMatchingRule> getOrderingMatchingRules() {
        return DirectoryServer.directoryServer.schema.getOrderingMatchingRules();
    }

    public static OrderingMatchingRule getOrderingMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getOrderingMatchingRule(lowerName);
    }

    public static void registerOrderingMatchingRule(OrderingMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerOrderingMatchingRule(matchingRule, overwriteExisting);
    }

    public static void deregisterOrderingMatchingRule(OrderingMatchingRule matchingRule) {
        DirectoryServer.directoryServer.schema.deregisterOrderingMatchingRule(matchingRule);
    }

    public static ConcurrentHashMap<String, SubstringMatchingRule> getSubstringMatchingRules() {
        return DirectoryServer.directoryServer.schema.getSubstringMatchingRules();
    }

    public static SubstringMatchingRule getSubstringMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getSubstringMatchingRule(lowerName);
    }

    public static void registerSubstringMatchingRule(SubstringMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerSubstringMatchingRule(matchingRule, overwriteExisting);
    }

    public static void deregisterSubstringMatchingRule(SubstringMatchingRule matchingRule) {
        DirectoryServer.directoryServer.schema.deregisterSubstringMatchingRule(matchingRule);
    }

    public static Map<String, ExtensibleMatchingRule> getExtensibleMatchingRules() {
        return DirectoryServer.directoryServer.schema.getExtensibleMatchingRules();
    }

    public static ExtensibleMatchingRule getExtensibleMatchingRule(String lowerName) {
        return DirectoryServer.directoryServer.schema.getExtensibleMatchingRule(lowerName);
    }

    public static ConcurrentHashMap<String, ObjectClass> getObjectClasses() {
        return DirectoryServer.directoryServer.schema.getObjectClasses();
    }

    public static LinkedHashSet<AttributeValue> getObjectClassSet() {
        return DirectoryServer.directoryServer.schema.getObjectClassSet();
    }

    public static ObjectClass getObjectClass(String lowerName) {
        return DirectoryServer.directoryServer.schema.getObjectClass(lowerName);
    }

    public static ObjectClass getObjectClass(String lowerName, boolean returnDefault) {
        ObjectClass oc = DirectoryServer.directoryServer.schema.getObjectClass(lowerName);
        if (returnDefault && oc == null) {
            oc = DirectoryServer.getDefaultObjectClass(lowerName);
        }
        return oc;
    }

    public static void registerObjectClass(ObjectClass objectClass, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerObjectClass(objectClass, overwriteExisting);
    }

    public static void deregisterObjectClass(ObjectClass objectClass) {
        DirectoryServer.directoryServer.schema.deregisterObjectClass(objectClass);
    }

    public static ObjectClass getTopObjectClass() {
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass("top");
        if (objectClass == null) {
            String definition = "( 2.5.6.0 NAME 'top' ABSTRACT MUST objectClass X-ORIGIN 'RFC 2256' )";
            objectClass = new ObjectClass(definition, "top", Collections.singleton("top"), "2.5.6.0", "Topmost ObjectClass", null, null, null, ObjectClassType.ABSTRACT, false, null);
        }
        return objectClass;
    }

    public static ObjectClass getDefaultObjectClass(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass(lowerName);
        if (objectClass == null) {
            String oid = lowerName + "-oid";
            String definition = "( " + oid + " NAME '" + name + "' ABSTRACT )";
            objectClass = new ObjectClass(definition, name, Collections.singleton(name), oid, null, Collections.singleton(DirectoryServer.getTopObjectClass()), null, null, ObjectClassType.STRUCTURAL, false, null);
        }
        return objectClass;
    }

    public static ObjectClass getDefaultAuxiliaryObjectClass(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass(lowerName);
        if (objectClass == null) {
            String oid = lowerName + "-oid";
            String definition = "( " + oid + " NAME '" + name + "' ABSTRACT )";
            objectClass = new ObjectClass(definition, name, Collections.singleton(name), oid, null, Collections.singleton(DirectoryServer.getTopObjectClass()), null, null, ObjectClassType.AUXILIARY, false, null);
        }
        return objectClass;
    }

    public static ConcurrentHashMap<String, AttributeType> getAttributeTypes() {
        return DirectoryServer.directoryServer.schema.getAttributeTypes();
    }

    public static LinkedHashSet<AttributeValue> getAttributeTypeSet() {
        return DirectoryServer.directoryServer.schema.getAttributeTypeSet();
    }

    public static AttributeType getAttributeType(String lowerName) {
        return DirectoryServer.directoryServer.schema.getAttributeType(lowerName);
    }

    public static AttributeType getAttributeType(String lowerName, boolean returnDefault) {
        AttributeType type = DirectoryServer.directoryServer.schema.getAttributeType(lowerName);
        if (returnDefault && type == null) {
            type = DirectoryServer.getDefaultAttributeType(lowerName);
        }
        return type;
    }

    public static void registerAttributeType(AttributeType attributeType, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerAttributeType(attributeType, overwriteExisting);
    }

    public static void deregisterAttributeType(AttributeType attributeType) {
        DirectoryServer.directoryServer.schema.deregisterAttributeType(attributeType);
    }

    public static AttributeType getObjectClassAttributeType() {
        block8: {
            if (DirectoryServer.directoryServer.objectClassAttributeType == null) {
                DirectoryServer.directoryServer.objectClassAttributeType = DirectoryServer.directoryServer.schema.getAttributeType("objectclass");
                if (DirectoryServer.directoryServer.objectClassAttributeType == null) {
                    AttributeSyntax oidSyntax;
                    block7: {
                        oidSyntax = DirectoryServer.directoryServer.schema.getSyntax("OID");
                        if (oidSyntax == null) {
                            try {
                                OIDSyntax newOIDSyntax = new OIDSyntax();
                                newOIDSyntax.initializeSyntax(null);
                                oidSyntax = newOIDSyntax;
                                DirectoryServer.directoryServer.schema.registerSyntax(oidSyntax, true);
                            }
                            catch (Exception e) {
                                if (!DebugLogger.debugEnabled()) break block7;
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                        }
                    }
                    String definition = "( 2.5.4.0 NAME 'objectClass' EQUALITY objectIdentifierMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.38 X-ORIGIN 'RFC 2256' )";
                    DirectoryServer.directoryServer.objectClassAttributeType = new AttributeType(definition, "objectClass", Collections.singleton("objectClass"), "2.5.4.0", null, null, oidSyntax, AttributeUsage.USER_APPLICATIONS, false, false, false, false);
                    try {
                        DirectoryServer.directoryServer.schema.registerAttributeType(DirectoryServer.directoryServer.objectClassAttributeType, true);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block8;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return DirectoryServer.directoryServer.objectClassAttributeType;
    }

    public static AttributeType getDefaultAttributeType(String name) {
        return DirectoryServer.getDefaultAttributeType(name, DirectoryServer.getDefaultAttributeSyntax());
    }

    public static AttributeType getDefaultAttributeType(String name, AttributeSyntax syntax) {
        String oid = StaticUtils.toLowerCase(name) + "-oid";
        String definition = "( " + oid + " NAME '" + name + "' SYNTAX " + syntax.getOID() + " )";
        return new AttributeType(definition, name, Collections.singleton(name), oid, null, null, syntax, AttributeUsage.USER_APPLICATIONS, false, false, false, false);
    }

    public static ConcurrentHashMap<String, AttributeSyntax> getAttributeSyntaxes() {
        return DirectoryServer.directoryServer.schema.getSyntaxes();
    }

    public static LinkedHashSet<AttributeValue> getAttributeSyntaxSet() {
        return DirectoryServer.directoryServer.schema.getSyntaxSet();
    }

    public static AttributeSyntax getAttributeSyntax(String oid, boolean allowDefault) {
        AttributeSyntax syntax = DirectoryServer.directoryServer.schema.getSyntax(oid);
        if (syntax == null && allowDefault) {
            return DirectoryServer.getDefaultAttributeSyntax();
        }
        return syntax;
    }

    public static void registerAttributeSyntax(AttributeSyntax syntax, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerSyntax(syntax, overwriteExisting);
    }

    public static void deregisterAttributeSyntax(AttributeSyntax syntax) {
        DirectoryServer.directoryServer.schema.deregisterSyntax(syntax);
    }

    public static AttributeSyntax getDefaultAttributeSyntax() {
        return DirectoryServer.directoryServer.defaultSyntax;
    }

    public static AttributeSyntax getDefaultBinarySyntax() {
        return DirectoryServer.directoryServer.defaultBinarySyntax;
    }

    public static AttributeSyntax getDefaultBooleanSyntax() {
        return DirectoryServer.directoryServer.defaultBooleanSyntax;
    }

    public static AttributeSyntax getDefaultDNSyntax() {
        return DirectoryServer.directoryServer.defaultDNSyntax;
    }

    public static AttributeSyntax getDefaultIntegerSyntax() {
        return DirectoryServer.directoryServer.defaultIntegerSyntax;
    }

    public static AttributeSyntax getDefaultStringSyntax() {
        return DirectoryServer.directoryServer.defaultStringSyntax;
    }

    public static ConcurrentHashMap<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        return DirectoryServer.directoryServer.schema.getMatchingRuleUses();
    }

    public static LinkedHashSet<AttributeValue> getMatchingRuleUseSet() {
        return DirectoryServer.directoryServer.schema.getMatchingRuleUseSet();
    }

    public static MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return DirectoryServer.directoryServer.schema.getMatchingRuleUse(matchingRule);
    }

    public static void registerMatchingRuleUse(MatchingRuleUse matchingRuleUse, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerMatchingRuleUse(matchingRuleUse, overwriteExisting);
    }

    public static void deregisterMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        DirectoryServer.directoryServer.schema.deregisterMatchingRuleUse(matchingRuleUse);
    }

    public static ConcurrentHashMap<ObjectClass, DITContentRule> getDITContentRules() {
        return DirectoryServer.directoryServer.schema.getDITContentRules();
    }

    public static LinkedHashSet<AttributeValue> getDITContentRuleSet() {
        return DirectoryServer.directoryServer.schema.getDITContentRuleSet();
    }

    public static DITContentRule getDITContentRule(ObjectClass objectClass) {
        return DirectoryServer.directoryServer.schema.getDITContentRule(objectClass);
    }

    public static void registerDITContentRule(DITContentRule ditContentRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerDITContentRule(ditContentRule, overwriteExisting);
    }

    public static void deregisterDITContentRule(DITContentRule ditContentRule) {
        DirectoryServer.directoryServer.schema.deregisterDITContentRule(ditContentRule);
    }

    public static ConcurrentHashMap<NameForm, DITStructureRule> getDITStructureRules() {
        return DirectoryServer.directoryServer.schema.getDITStructureRulesByNameForm();
    }

    public static LinkedHashSet<AttributeValue> getDITStructureRuleSet() {
        return DirectoryServer.directoryServer.schema.getDITStructureRuleSet();
    }

    public static DITStructureRule getDITStructureRule(int ruleID) {
        return DirectoryServer.directoryServer.schema.getDITStructureRule(ruleID);
    }

    public static DITStructureRule getDITStructureRule(NameForm nameForm) {
        return DirectoryServer.directoryServer.schema.getDITStructureRule(nameForm);
    }

    public static void registerDITStructureRule(DITStructureRule ditStructureRule, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerDITStructureRule(ditStructureRule, overwriteExisting);
    }

    public static void deregisterDITStructureRule(DITStructureRule ditStructureRule) {
        DirectoryServer.directoryServer.schema.deregisterDITStructureRule(ditStructureRule);
    }

    public static ConcurrentHashMap<ObjectClass, List<NameForm>> getNameForms() {
        return DirectoryServer.directoryServer.schema.getNameFormsByObjectClass();
    }

    public static LinkedHashSet<AttributeValue> getNameFormSet() {
        return DirectoryServer.directoryServer.schema.getNameFormSet();
    }

    public static List<NameForm> getNameForm(ObjectClass objectClass) {
        return DirectoryServer.directoryServer.schema.getNameForm(objectClass);
    }

    public static NameForm getNameForm(String lowerName) {
        return DirectoryServer.directoryServer.schema.getNameForm(lowerName);
    }

    public static void registerNameForm(NameForm nameForm, boolean overwriteExisting) throws DirectoryException {
        DirectoryServer.directoryServer.schema.registerNameForm(nameForm, overwriteExisting);
    }

    public static void deregisterNameForm(NameForm nameForm) {
        DirectoryServer.directoryServer.schema.deregisterNameForm(nameForm);
    }

    public static List<VirtualAttributeRule> getVirtualAttributes() {
        return DirectoryServer.directoryServer.virtualAttributes;
    }

    public static List<VirtualAttributeRule> getVirtualAttributes(Entry entry) {
        LinkedList<VirtualAttributeRule> ruleList = new LinkedList<VirtualAttributeRule>();
        for (VirtualAttributeRule rule : DirectoryServer.directoryServer.virtualAttributes) {
            if (!rule.appliesToEntry(entry)) continue;
            ruleList.add(rule);
        }
        return ruleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerVirtualAttribute(VirtualAttributeRule rule) {
        CopyOnWriteArrayList<VirtualAttributeRule> copyOnWriteArrayList = DirectoryServer.directoryServer.virtualAttributes;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.virtualAttributes.add(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterVirtualAttribute(VirtualAttributeRule rule) {
        CopyOnWriteArrayList<VirtualAttributeRule> copyOnWriteArrayList = DirectoryServer.directoryServer.virtualAttributes;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.virtualAttributes.remove(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceVirtualAttribute(VirtualAttributeRule oldRule, VirtualAttributeRule newRule) {
        CopyOnWriteArrayList<VirtualAttributeRule> copyOnWriteArrayList = DirectoryServer.directoryServer.virtualAttributes;
        synchronized (copyOnWriteArrayList) {
            int pos = DirectoryServer.directoryServer.virtualAttributes.indexOf(oldRule);
            if (pos >= 0) {
                DirectoryServer.directoryServer.virtualAttributes.set(pos, newRule);
                return true;
            }
            return false;
        }
    }

    public static MBeanServer getJMXMBeanServer() {
        return DirectoryServer.directoryServer.mBeanServer;
    }

    public static ConcurrentHashMap<DN, JMXMBean> getJMXMBeans() {
        return DirectoryServer.directoryServer.mBeans;
    }

    public static JMXMBean getJMXMBean(DN configEntryDN) {
        return DirectoryServer.directoryServer.mBeans.get(configEntryDN);
    }

    public static void registerInvokableComponent(InvokableComponent component) {
        DN componentDN = component.getInvokableComponentEntryDN();
        JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(componentDN);
        if (mBean == null) {
            mBean = new JMXMBean(componentDN);
            mBean.addInvokableComponent(component);
            DirectoryServer.directoryServer.mBeans.put(componentDN, mBean);
        } else {
            mBean.addInvokableComponent(component);
        }
    }

    public static void deregisterInvokableComponent(InvokableComponent component) {
        DN componentDN = component.getInvokableComponentEntryDN();
        JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(componentDN);
        if (mBean != null) {
            mBean.removeInvokableComponent(component);
        }
    }

    public static void registerAlertGenerator(AlertGenerator alertGenerator) {
        DN componentDN = alertGenerator.getComponentEntryDN();
        JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(componentDN);
        if (mBean == null) {
            mBean = new JMXMBean(componentDN);
            mBean.addAlertGenerator(alertGenerator);
            DirectoryServer.directoryServer.mBeans.put(componentDN, mBean);
        } else {
            mBean.addAlertGenerator(alertGenerator);
        }
    }

    public static void deregisterAlertGenerator(AlertGenerator alertGenerator) {
        DN componentDN = alertGenerator.getComponentEntryDN();
        JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(componentDN);
        if (mBean != null) {
            mBean.removeAlertGenerator(alertGenerator);
        }
    }

    public static CopyOnWriteArrayList<AlertHandler> getAlertHandlers() {
        return DirectoryServer.directoryServer.alertHandlers;
    }

    public static void registerAlertHandler(AlertHandler alertHandler) {
        DirectoryServer.directoryServer.alertHandlers.add(alertHandler);
    }

    public static void deregisterAlertHandler(AlertHandler alertHandler) {
        DirectoryServer.directoryServer.alertHandlers.remove(alertHandler);
    }

    public static void sendAlertNotification(AlertGenerator generator, String alertType, Message alertMessage) {
        block6: {
            if (DirectoryServer.directoryServer.alertHandlers == null || DirectoryServer.directoryServer.alertHandlers.isEmpty()) {
                if (!DirectoryServer.directoryServer.isRunning) {
                    try {
                        JMXAlertHandler alertHandler = new JMXAlertHandler();
                        alertHandler.initializeAlertHandler((JMXAlertHandlerCfg)null);
                        alertHandler.sendAlertNotification(generator, alertType, alertMessage);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            } else {
                for (AlertHandler alertHandler : DirectoryServer.directoryServer.alertHandlers) {
                    AlertHandlerCfg config = alertHandler.getAlertHandlerConfiguration();
                    SortedSet<String> enabledAlerts = config.getEnabledAlertType();
                    SortedSet<String> disabledAlerts = config.getDisabledAlertType();
                    if (enabledAlerts == null || enabledAlerts.isEmpty() ? disabledAlerts != null && disabledAlerts.contains(alertType) : !enabledAlerts.contains(alertType) || disabledAlerts != null && disabledAlerts.contains(alertType)) continue;
                    alertHandler.sendAlertNotification(generator, alertType, alertMessage);
                }
            }
        }
        Message message = CoreMessages.NOTE_SENT_ALERT_NOTIFICATION.get(generator.getClassName(), alertType, alertMessage != null ? String.valueOf(alertMessage.getDescriptor().getId()) : String.valueOf(-1), alertMessage);
        ErrorLogger.logError(message);
    }

    public static PasswordStorageScheme getPasswordStorageScheme(DN configEntryDN) {
        return DirectoryServer.directoryServer.passwordStorageSchemesByDN.get(configEntryDN);
    }

    public static ConcurrentHashMap<String, PasswordStorageScheme> getPasswordStorageSchemes() {
        return DirectoryServer.directoryServer.passwordStorageSchemes;
    }

    public static PasswordStorageScheme getPasswordStorageScheme(String lowerName) {
        return DirectoryServer.directoryServer.passwordStorageSchemes.get(lowerName);
    }

    public static ConcurrentHashMap<String, PasswordStorageScheme> getAuthPasswordStorageSchemes() {
        return DirectoryServer.directoryServer.authPasswordStorageSchemes;
    }

    public static PasswordStorageScheme getAuthPasswordStorageScheme(String name) {
        return DirectoryServer.directoryServer.authPasswordStorageSchemes.get(name);
    }

    public static void registerPasswordStorageScheme(DN configEntryDN, PasswordStorageScheme scheme) {
        DirectoryServer.directoryServer.passwordStorageSchemesByDN.put(configEntryDN, scheme);
        String name = StaticUtils.toLowerCase(scheme.getStorageSchemeName());
        DirectoryServer.directoryServer.passwordStorageSchemes.put(name, scheme);
        if (scheme.supportsAuthPasswordSyntax()) {
            DirectoryServer.directoryServer.authPasswordStorageSchemes.put(scheme.getAuthPasswordSchemeName(), scheme);
        }
    }

    public static void deregisterPasswordStorageScheme(DN configEntryDN) {
        PasswordStorageScheme scheme = DirectoryServer.directoryServer.passwordStorageSchemesByDN.remove(configEntryDN);
        if (scheme != null) {
            DirectoryServer.directoryServer.passwordStorageSchemes.remove(StaticUtils.toLowerCase(scheme.getStorageSchemeName()));
            if (scheme.supportsAuthPasswordSyntax()) {
                DirectoryServer.directoryServer.authPasswordStorageSchemes.remove(scheme.getAuthPasswordSchemeName());
            }
        }
    }

    public static ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>> getPasswordValidators() {
        return DirectoryServer.directoryServer.passwordValidators;
    }

    public static PasswordValidator<? extends PasswordValidatorCfg> getPasswordValidator(DN configEntryDN) {
        return DirectoryServer.directoryServer.passwordValidators.get(configEntryDN);
    }

    public static void registerPasswordValidator(DN configEntryDN, PasswordValidator<? extends PasswordValidatorCfg> validator) {
        DirectoryServer.directoryServer.passwordValidators.put(configEntryDN, validator);
    }

    public static void deregisterPasswordValidator(DN configEntryDN) {
        DirectoryServer.directoryServer.passwordValidators.remove(configEntryDN);
    }

    public static ConcurrentHashMap<DN, AccountStatusNotificationHandler> getAccountStatusNotificationHandlers() {
        return DirectoryServer.directoryServer.accountStatusNotificationHandlers;
    }

    public static AccountStatusNotificationHandler getAccountStatusNotificationHandler(DN handlerDN) {
        return DirectoryServer.directoryServer.accountStatusNotificationHandlers.get(handlerDN);
    }

    public static void registerAccountStatusNotificationHandler(DN handlerDN, AccountStatusNotificationHandler handler) {
        DirectoryServer.directoryServer.accountStatusNotificationHandlers.put(handlerDN, handler);
    }

    public static void deregisterAccountStatusNotificationHandler(DN handlerDN) {
        DirectoryServer.directoryServer.accountStatusNotificationHandlers.remove(handlerDN);
    }

    public static ConcurrentHashMap<DN, PasswordGenerator> getPasswordGenerators() {
        return DirectoryServer.directoryServer.passwordGenerators;
    }

    public static PasswordGenerator getPasswordGenerator(DN configEntryDN) {
        return DirectoryServer.directoryServer.passwordGenerators.get(configEntryDN);
    }

    public static void registerPasswordGenerator(DN configEntryDN, PasswordGenerator generator) {
        DirectoryServer.directoryServer.passwordGenerators.put(configEntryDN, generator);
    }

    public static void deregisterPasswordGenerator(DN configEntryDN) {
        DirectoryServer.directoryServer.passwordGenerators.remove(configEntryDN);
    }

    public static PasswordPolicy[] getPasswordPolicies() {
        PasswordPolicyConfig[] values = DirectoryServer.directoryServer.passwordPolicies.values().toArray(new PasswordPolicyConfig[0]);
        PasswordPolicy[] policies = new PasswordPolicy[values.length];
        for (int i = 0; i < values.length; ++i) {
            policies[i] = values[i].getPolicy();
        }
        return policies;
    }

    public static PasswordPolicy getPasswordPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        PasswordPolicyConfig config = DirectoryServer.directoryServer.passwordPolicies.get(configEntryDN);
        return null == config ? null : config.getPolicy();
    }

    public static PasswordPolicyConfig getPasswordPolicyConfig(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        return DirectoryServer.directoryServer.passwordPolicies.get(configEntryDN);
    }

    public static void registerPasswordPolicy(DN configEntryDN, PasswordPolicyConfig config) {
        Validator.ensureNotNull(configEntryDN, config);
        DirectoryServer.directoryServer.passwordPolicies.put(configEntryDN, config);
    }

    public static void deregisterPasswordPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        if (DirectoryServer.directoryServer.defaultPasswordPolicyDN.equals(configEntryDN)) {
            DirectoryServer.directoryServer.defaultPasswordPolicyConfig = null;
        }
        DirectoryServer.directoryServer.passwordPolicies.remove(configEntryDN);
    }

    public static DN getDefaultPasswordPolicyDN() {
        return DirectoryServer.directoryServer.defaultPasswordPolicyDN;
    }

    public static void setDefaultPasswordPolicyDN(DN defaultPasswordPolicyDN) {
        DirectoryServer.directoryServer.defaultPasswordPolicyDN = defaultPasswordPolicyDN;
        DirectoryServer.directoryServer.defaultPasswordPolicyConfig = null;
    }

    public static PasswordPolicy getDefaultPasswordPolicy() {
        assert (null != DirectoryServer.directoryServer.passwordPolicies.get(DirectoryServer.directoryServer.defaultPasswordPolicyDN)) : "Internal Error: no default password policy defined.";
        if (DirectoryServer.directoryServer.defaultPasswordPolicyConfig == null && DirectoryServer.directoryServer.defaultPasswordPolicyDN != null) {
            DirectoryServer.directoryServer.defaultPasswordPolicyConfig = DirectoryServer.directoryServer.passwordPolicies.get(DirectoryServer.directoryServer.defaultPasswordPolicyDN);
        }
        assert (DirectoryServer.directoryServer.passwordPolicies.get(DirectoryServer.directoryServer.defaultPasswordPolicyDN) == DirectoryServer.directoryServer.defaultPasswordPolicyConfig) : "Internal Error: inconsistency between defaultPasswordPolicyConfig cache and value in passwordPolicies map.";
        return DirectoryServer.directoryServer.defaultPasswordPolicyConfig.getPolicy();
    }

    public static RotationPolicy getRotationPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        return DirectoryServer.directoryServer.rotationPolicies.get(configEntryDN);
    }

    public static void registerRotationPolicy(DN configEntryDN, RotationPolicy policy) {
        Validator.ensureNotNull(configEntryDN, policy);
        DirectoryServer.directoryServer.rotationPolicies.put(configEntryDN, policy);
    }

    public static void deregisterRotationPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        DirectoryServer.directoryServer.rotationPolicies.remove(configEntryDN);
    }

    public static RetentionPolicy getRetentionPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        return DirectoryServer.directoryServer.retentionPolicies.get(configEntryDN);
    }

    public static void registerRetentionPolicy(DN configEntryDN, RetentionPolicy policy) {
        Validator.ensureNotNull(configEntryDN, policy);
        DirectoryServer.directoryServer.retentionPolicies.put(configEntryDN, policy);
    }

    public static void deregisterRetentionPolicy(DN configEntryDN) {
        Validator.ensureNotNull(configEntryDN);
        DirectoryServer.directoryServer.retentionPolicies.remove(configEntryDN);
    }

    public static ConcurrentHashMap<String, MonitorProvider<? extends MonitorProviderCfg>> getMonitorProviders() {
        return DirectoryServer.directoryServer.monitorProviders;
    }

    public static MonitorProvider<? extends MonitorProviderCfg> getMonitorProvider(String lowerName) {
        return DirectoryServer.directoryServer.monitorProviders.get(lowerName);
    }

    public static void registerMonitorProvider(MonitorProvider<? extends MonitorProviderCfg> monitorProvider) {
        block4: {
            String lowerName = StaticUtils.toLowerCase(monitorProvider.getMonitorInstanceName());
            DirectoryServer.directoryServer.monitorProviders.put(lowerName, monitorProvider);
            try {
                DN monitorDN = DirectoryServer.getMonitorProviderDN(monitorProvider);
                JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(monitorDN);
                if (mBean == null) {
                    mBean = new JMXMBean(monitorDN);
                    mBean.addMonitorProvider(monitorProvider);
                    DirectoryServer.directoryServer.mBeans.put(monitorDN, mBean);
                } else {
                    mBean.addMonitorProvider(monitorProvider);
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void deregisterMonitorProvider(String lowerName) {
        block4: {
            MonitorProvider<? extends MonitorProviderCfg> provider = DirectoryServer.directoryServer.monitorProviders.remove(StaticUtils.toLowerCase(lowerName));
            if (provider != null) {
                try {
                    DN monitorDN = DirectoryServer.getMonitorProviderDN(provider);
                    JMXMBean mBean = DirectoryServer.directoryServer.mBeans.get(monitorDN);
                    if (mBean != null) {
                        mBean.removeMonitorProvider(provider);
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public static EntryCache getEntryCache() {
        return DirectoryServer.directoryServer.entryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEntryCache(EntryCache entryCache) {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer.entryCache = entryCache;
        }
    }

    public static Map<DN, KeyManagerProvider> getKeyManagerProviders() {
        return DirectoryServer.directoryServer.keyManagerProviders;
    }

    public static KeyManagerProvider getKeyManagerProvider(DN providerDN) {
        return DirectoryServer.directoryServer.keyManagerProviders.get(providerDN);
    }

    public static void registerKeyManagerProvider(DN providerDN, KeyManagerProvider provider) {
        DirectoryServer.directoryServer.keyManagerProviders.put(providerDN, provider);
    }

    public static void deregisterKeyManagerProvider(DN providerDN) {
        DirectoryServer.directoryServer.keyManagerProviders.remove(providerDN);
    }

    public static Map<DN, TrustManagerProvider> getTrustManagerProviders() {
        return DirectoryServer.directoryServer.trustManagerProviders;
    }

    public static TrustManagerProvider getTrustManagerProvider(DN providerDN) {
        return DirectoryServer.directoryServer.trustManagerProviders.get(providerDN);
    }

    public static void registerTrustManagerProvider(DN providerDN, TrustManagerProvider provider) {
        DirectoryServer.directoryServer.trustManagerProviders.put(providerDN, provider);
    }

    public static void deregisterTrustManagerProvider(DN providerDN) {
        DirectoryServer.directoryServer.trustManagerProviders.remove(providerDN);
    }

    public static Map<DN, CertificateMapper> getCertificateMappers() {
        return DirectoryServer.directoryServer.certificateMappers;
    }

    public static CertificateMapper getCertificateMapper(DN mapperDN) {
        return DirectoryServer.directoryServer.certificateMappers.get(mapperDN);
    }

    public static void registerCertificateMapper(DN mapperDN, CertificateMapper mapper) {
        DirectoryServer.directoryServer.certificateMappers.put(mapperDN, mapper);
    }

    public static void deregisterCertificateMapper(DN mapperDN) {
        DirectoryServer.directoryServer.certificateMappers.remove(mapperDN);
    }

    public static Set<Privilege> getRootPrivileges() {
        return DirectoryServer.directoryServer.rootDNConfigManager.getRootPrivileges();
    }

    public static CopyOnWriteArraySet<DN> getRootDNs() {
        return DirectoryServer.directoryServer.rootDNs;
    }

    public static boolean isRootDN(DN userDN) {
        return DirectoryServer.directoryServer.rootDNs.contains(userDN);
    }

    public static void registerRootDN(DN rootDN) {
        DirectoryServer.directoryServer.rootDNs.add(rootDN);
    }

    public static void deregisterRootDN(DN rootDN) {
        DirectoryServer.directoryServer.rootDNs.remove(rootDN);
    }

    public static ConcurrentHashMap<DN, DN> getAlternateRootBindDNs() {
        return DirectoryServer.directoryServer.alternateRootBindDNs;
    }

    public static DN getActualRootBindDN(DN alternateRootBindDN) {
        return DirectoryServer.directoryServer.alternateRootBindDNs.get(alternateRootBindDN);
    }

    public static void registerAlternateRootDN(DN actualRootEntryDN, DN alternateRootBindDN) throws DirectoryException {
        DN existingRootEntryDN = DirectoryServer.directoryServer.alternateRootBindDNs.putIfAbsent(alternateRootBindDN, actualRootEntryDN);
        if (existingRootEntryDN != null && !existingRootEntryDN.equals(actualRootEntryDN)) {
            Message message = CoreMessages.ERR_CANNOT_REGISTER_DUPLICATE_ALTERNATE_ROOT_BIND_DN.get(String.valueOf(alternateRootBindDN), String.valueOf(existingRootEntryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
    }

    public static DN deregisterAlternateRootBindDN(DN alternateRootBindDN) {
        return DirectoryServer.directoryServer.alternateRootBindDNs.remove(alternateRootBindDN);
    }

    public static ResultCode getServerErrorResultCode() {
        return DirectoryServer.directoryServer.serverErrorResultCode;
    }

    public static void setServerErrorResultCode(ResultCode serverErrorResultCode) {
        DirectoryServer.directoryServer.serverErrorResultCode = serverErrorResultCode;
    }

    public static boolean addMissingRDNAttributes() {
        return DirectoryServer.directoryServer.addMissingRDNAttributes;
    }

    public static void setAddMissingRDNAttributes(boolean addMissingRDNAttributes) {
        DirectoryServer.directoryServer.addMissingRDNAttributes = addMissingRDNAttributes;
    }

    public static boolean allowAttributeNameExceptions() {
        return DirectoryServer.directoryServer.allowAttributeNameExceptions;
    }

    public static void setAllowAttributeNameExceptions(boolean allowAttributeNameExceptions) {
        DirectoryServer.directoryServer.allowAttributeNameExceptions = allowAttributeNameExceptions;
    }

    public static boolean checkSchema() {
        return DirectoryServer.directoryServer.checkSchema;
    }

    public static void setCheckSchema(boolean checkSchema) {
        DirectoryServer.directoryServer.checkSchema = checkSchema;
    }

    public static AcceptRejectWarn getSingleStructuralObjectClassPolicy() {
        return DirectoryServer.directoryServer.singleStructuralClassPolicy;
    }

    public static void setSingleStructuralObjectClassPolicy(AcceptRejectWarn singleStructuralClassPolicy) {
        DirectoryServer.directoryServer.singleStructuralClassPolicy = singleStructuralClassPolicy;
    }

    public static AcceptRejectWarn getSyntaxEnforcementPolicy() {
        return DirectoryServer.directoryServer.syntaxEnforcementPolicy;
    }

    public static void setSyntaxEnforcementPolicy(AcceptRejectWarn syntaxEnforcementPolicy) {
        DirectoryServer.directoryServer.syntaxEnforcementPolicy = syntaxEnforcementPolicy;
    }

    public static boolean notifyAbandonedOperations() {
        return DirectoryServer.directoryServer.notifyAbandonedOperations;
    }

    public static void setNotifyAbandonedOperations(boolean notifyAbandonedOperations) {
        DirectoryServer.directoryServer.notifyAbandonedOperations = notifyAbandonedOperations;
    }

    public static Map<String, Backend> getBackends() {
        return DirectoryServer.directoryServer.backends;
    }

    public static Backend getBackend(String backendID) {
        return DirectoryServer.directoryServer.backends.get(backendID);
    }

    public static boolean hasBackend(String backendID) {
        return DirectoryServer.directoryServer.backends.containsKey(backendID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBackend(Backend backend) throws DirectoryException {
        Validator.ensureNotNull(backend);
        String backendID = backend.getBackendID();
        Validator.ensureNotNull(backendID);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            TreeMap<String, Backend> newBackends = new TreeMap<String, Backend>((SortedMap<String, Backend>)DirectoryServer.directoryServer.backends);
            if (newBackends.containsKey(backendID)) {
                Message message = CoreMessages.ERR_REGISTER_BACKEND_ALREADY_EXISTS.get(backendID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            newBackends.put(backendID, backend);
            DirectoryServer.directoryServer.backends = newBackends;
            for (String oid : backend.getSupportedControls()) {
                DirectoryServer.registerSupportedControl(oid);
            }
            for (String oid : backend.getSupportedFeatures()) {
                DirectoryServer.registerSupportedFeature(oid);
            }
            BackendMonitor monitor = new BackendMonitor(backend);
            monitor.initializeMonitorProvider(null);
            backend.setBackendMonitor(monitor);
            DirectoryServer.registerMonitorProvider(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterBackend(Backend backend) {
        Validator.ensureNotNull(backend);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            BackendMonitor monitor;
            TreeMap<String, Backend> newBackends = new TreeMap<String, Backend>((SortedMap<String, Backend>)DirectoryServer.directoryServer.backends);
            newBackends.remove(backend.getBackendID());
            DirectoryServer.directoryServer.backends = newBackends;
            if (DirectoryServer.workflowConfigurationModeIsAuto()) {
                LocalBackendWorkflowElement.remove(backend.getBackendID());
            }
            if ((monitor = backend.getBackendMonitor()) != null) {
                String instanceName = StaticUtils.toLowerCase(monitor.getMonitorInstanceName());
                DirectoryServer.deregisterMonitorProvider(instanceName);
                monitor.finalizeMonitorProvider();
                backend.setBackendMonitor(null);
            }
        }
    }

    public static Map<String, Long> getOfflineBackendsStateIDs() {
        return Collections.unmodifiableMap(DirectoryServer.directoryServer.offlineBackendsStateIDs);
    }

    public static void registerOfflineBackendStateID(String backend, long id) {
        if (id != 0L) {
            DirectoryServer.directoryServer.offlineBackendsStateIDs.put(backend, id);
        }
    }

    public static Map<DN, Backend> getBaseDNs() {
        return DirectoryServer.directoryServer.baseDnRegistry.getBaseDnMap();
    }

    public static Backend getBackendWithBaseDN(DN baseDN) {
        return DirectoryServer.directoryServer.baseDnRegistry.getBaseDnMap().get(baseDN);
    }

    public static Backend getBackend(DN entryDN) {
        if (entryDN.isNullDN()) {
            return DirectoryServer.directoryServer.rootDSEBackend;
        }
        Map<DN, Backend> baseDNs = DirectoryServer.directoryServer.baseDnRegistry.getBaseDnMap();
        Backend b = baseDNs.get(entryDN);
        while (b == null) {
            if ((entryDN = entryDN.getParent()) == null) {
                return null;
            }
            b = baseDNs.get(entryDN);
        }
        return b;
    }

    public static BaseDnRegistry copyBaseDnRegistry() {
        return DirectoryServer.directoryServer.baseDnRegistry.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBaseDN(DN baseDN, Backend backend, boolean isPrivate) throws DirectoryException {
        Validator.ensureNotNull(baseDN, backend);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            List<Message> warnings = DirectoryServer.directoryServer.baseDnRegistry.registerBaseDN(baseDN, backend, isPrivate);
            if (warnings != null) {
                for (Message warning : warnings) {
                    ErrorLogger.logError(warning);
                }
            }
            if (DirectoryServer.workflowConfigurationModeIsAuto() && !baseDN.equals(DN.decode("cn=config"))) {
                WorkflowImpl workflowImpl = DirectoryServer.createWorkflow(baseDN, backend);
                DirectoryServer.registerWorkflowWithInternalNetworkGroup(workflowImpl);
                DirectoryServer.registerWorkflowWithAdminNetworkGroup(workflowImpl);
                DirectoryServer.registerWorkflowWithDefaultNetworkGroup(workflowImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterBaseDN(DN baseDN) throws DirectoryException {
        Validator.ensureNotNull(baseDN);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            List<Message> warnings = DirectoryServer.directoryServer.baseDnRegistry.deregisterBaseDN(baseDN);
            if (warnings != null) {
                for (Message error : warnings) {
                    ErrorLogger.logError(error);
                }
            }
            if (DirectoryServer.workflowConfigurationModeIsAuto()) {
                DirectoryServer.deregisterWorkflowWithAdminNetworkGroup(baseDN);
                DirectoryServer.deregisterWorkflowWithDefaultNetworkGroup(baseDN);
                DirectoryServer.deregisterWorkflowWithInternalNetworkGroup(baseDN);
            }
        }
    }

    public static Map<DN, Backend> getPublicNamingContexts() {
        return DirectoryServer.directoryServer.baseDnRegistry.getPublicNamingContextsMap();
    }

    public static Map<DN, Backend> getPrivateNamingContexts() {
        return DirectoryServer.directoryServer.baseDnRegistry.getPrivateNamingContextsMap();
    }

    public static boolean isNamingContext(DN dn) {
        return DirectoryServer.directoryServer.baseDnRegistry.containsNamingContext(dn);
    }

    public static Entry getRootDSE() {
        return DirectoryServer.directoryServer.rootDSEBackend.getRootDSE();
    }

    public static RootDSEBackend getRootDSEBackend() {
        return DirectoryServer.directoryServer.rootDSEBackend;
    }

    public static DN getSchemaDN() {
        return DirectoryServer.directoryServer.schemaDN;
    }

    public static void setSchemaDN(DN schemaDN) {
        DirectoryServer.directoryServer.schemaDN = schemaDN;
    }

    public static Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN.isNullDN()) {
            return DirectoryServer.directoryServer.rootDSEBackend.getRootDSE();
        }
        Backend backend = DirectoryServer.getBackend(entryDN);
        if (backend == null) {
            return null;
        }
        return backend.getEntry(entryDN);
    }

    public static boolean entryExists(DN entryDN) throws DirectoryException {
        if (entryDN.isNullDN()) {
            return true;
        }
        Backend backend = DirectoryServer.getBackend(entryDN);
        if (backend == null) {
            return false;
        }
        return backend.entryExists(entryDN);
    }

    public static TreeSet<String> getSupportedControls() {
        return DirectoryServer.directoryServer.supportedControls;
    }

    public static boolean isSupportedControl(String controlOID) {
        return DirectoryServer.directoryServer.supportedControls.contains(controlOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSupportedControl(String controlOID) {
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedControls;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedControls.add(controlOID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSupportedControl(String controlOID) {
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedControls;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedControls.remove(controlOID);
        }
    }

    public static TreeSet<String> getSupportedFeatures() {
        return DirectoryServer.directoryServer.supportedFeatures;
    }

    public static boolean isSupportedFeature(String featureOID) {
        return DirectoryServer.directoryServer.supportedFeatures.contains(featureOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSupportedFeature(String featureOID) {
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedFeatures;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedFeatures.add(featureOID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSupportedFeature(String featureOID) {
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedFeatures;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedFeatures.remove(featureOID);
        }
    }

    public static ConcurrentHashMap<String, ExtendedOperationHandler> getSupportedExtensions() {
        return DirectoryServer.directoryServer.extendedOperationHandlers;
    }

    public static ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        return DirectoryServer.directoryServer.extendedOperationHandlers.get(oid);
    }

    public static void registerSupportedExtension(String oid, ExtendedOperationHandler handler) {
        DirectoryServer.directoryServer.extendedOperationHandlers.put(StaticUtils.toLowerCase(oid), handler);
    }

    public static void deregisterSupportedExtension(String oid) {
        DirectoryServer.directoryServer.extendedOperationHandlers.remove(StaticUtils.toLowerCase(oid));
    }

    public static ConcurrentHashMap<String, SASLMechanismHandler> getSupportedSASLMechanisms() {
        return DirectoryServer.directoryServer.saslMechanismHandlers;
    }

    public static SASLMechanismHandler getSASLMechanismHandler(String name) {
        return DirectoryServer.directoryServer.saslMechanismHandlers.get(name);
    }

    public static void registerSASLMechanismHandler(String name, SASLMechanismHandler handler) {
        DirectoryServer.directoryServer.saslMechanismHandlers.put(name, handler);
    }

    public static void deregisterSASLMechanismHandler(String name) {
        DirectoryServer.directoryServer.saslMechanismHandlers.remove(name);
    }

    public static Set<Integer> getSupportedLDAPVersions() {
        return DirectoryServer.directoryServer.supportedLDAPVersions.keySet();
    }

    public static synchronized void registerSupportedLDAPVersion(int supportedLDAPVersion, ConnectionHandler connectionHandler) {
        List<ConnectionHandler> handlers = DirectoryServer.directoryServer.supportedLDAPVersions.get(supportedLDAPVersion);
        if (handlers == null) {
            handlers = new LinkedList<ConnectionHandler>();
            handlers.add(connectionHandler);
            DirectoryServer.directoryServer.supportedLDAPVersions.put(supportedLDAPVersion, handlers);
        } else if (!handlers.contains(connectionHandler)) {
            handlers.add(connectionHandler);
        }
    }

    public static synchronized void deregisterSupportedLDAPVersion(int supportedLDAPVersion, ConnectionHandler connectionHandler) {
        List<ConnectionHandler> handlers = DirectoryServer.directoryServer.supportedLDAPVersions.get(supportedLDAPVersion);
        if (handlers != null) {
            handlers.remove(connectionHandler);
            if (handlers.isEmpty()) {
                DirectoryServer.directoryServer.supportedLDAPVersions.remove(supportedLDAPVersion);
            }
        }
    }

    public static ConcurrentHashMap<DN, IdentityMapper> getIdentityMappers() {
        return DirectoryServer.directoryServer.identityMappers;
    }

    public static IdentityMapper getIdentityMapper(DN configEntryDN) {
        return DirectoryServer.directoryServer.identityMappers.get(configEntryDN);
    }

    public static void registerIdentityMapper(DN configEntryDN, IdentityMapper identityMapper) {
        DirectoryServer.directoryServer.identityMappers.put(configEntryDN, identityMapper);
    }

    public static void deregisterIdentityMapper(DN configEntryDN) {
        DirectoryServer.directoryServer.identityMappers.remove(configEntryDN);
    }

    public static DN getProxiedAuthorizationIdentityMapperDN() {
        return DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN;
    }

    public static void setProxiedAuthorizationIdentityMapperDN(DN proxiedAuthorizationIdentityMapperDN) {
        DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN = proxiedAuthorizationIdentityMapperDN;
    }

    public static IdentityMapper getProxiedAuthorizationIdentityMapper() {
        if (DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN == null) {
            return null;
        }
        return DirectoryServer.directoryServer.identityMappers.get(DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN);
    }

    public static CopyOnWriteArrayList<ConnectionHandler> getConnectionHandlers() {
        return DirectoryServer.directoryServer.connectionHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionHandler(ConnectionHandler<? extends ConnectionHandlerCfg> handler) {
        CopyOnWriteArrayList<ConnectionHandler> copyOnWriteArrayList = DirectoryServer.directoryServer.connectionHandlers;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.connectionHandlers.add(handler);
            ConnectionHandlerMonitor monitor = new ConnectionHandlerMonitor(handler);
            monitor.initializeMonitorProvider(null);
            handler.setConnectionHandlerMonitor(monitor);
            DirectoryServer.registerMonitorProvider(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterConnectionHandler(ConnectionHandler handler) {
        CopyOnWriteArrayList<ConnectionHandler> copyOnWriteArrayList = DirectoryServer.directoryServer.connectionHandlers;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.connectionHandlers.remove(handler);
            ConnectionHandlerMonitor monitor = handler.getConnectionHandlerMonitor();
            if (monitor != null) {
                String instanceName = StaticUtils.toLowerCase(monitor.getMonitorInstanceName());
                DirectoryServer.deregisterMonitorProvider(instanceName);
                monitor.finalizeMonitorProvider();
                handler.setConnectionHandlerMonitor(null);
            }
        }
    }

    private void startConnectionHandlers() throws ConfigException {
        LinkedHashSet<HostPort> usedListeners = new LinkedHashSet<HostPort>();
        LinkedHashSet<Message> errorMessages = new LinkedHashSet<Message>();
        for (ConnectionHandler c : this.connectionHandlers) {
            for (HostPort listener : c.getListeners()) {
                if (usedListeners.contains(listener)) {
                    Message message = CoreMessages.ERR_HOST_PORT_ALREADY_SPECIFIED.get(c.getConnectionHandlerName(), listener.toString());
                    ErrorLogger.logError(message);
                    errorMessages.add(message);
                    continue;
                }
                usedListeners.add(listener);
            }
        }
        if (errorMessages.size() > 0) {
            throw new ConfigException(CoreMessages.ERR_ERROR_STARTING_CONNECTION_HANDLERS.get());
        }
        if (this.connectionHandlers.isEmpty()) {
            Message message = CoreMessages.ERR_NOT_AVAILABLE_CONNECTION_HANDLERS.get();
            ErrorLogger.logError(message);
            throw new ConfigException(CoreMessages.ERR_ERROR_STARTING_CONNECTION_HANDLERS.get());
        }
        for (ConnectionHandler c : this.connectionHandlers) {
            c.start();
        }
    }

    public static WorkQueue getWorkQueue() {
        return DirectoryServer.directoryServer.workQueue;
    }

    public static void enqueueRequest(AbstractOperation operation) throws DirectoryException {
        ClientConnection clientConnection = operation.getClientConnection();
        if ((DirectoryServer.directoryServer.rejectUnauthenticatedRequests || DirectoryServer.directoryServer.lockdownMode) && !clientConnection.getAuthenticationInfo().isAuthenticated()) {
            switch (operation.getOperationType()) {
                case ADD: 
                case COMPARE: 
                case DELETE: 
                case SEARCH: 
                case MODIFY: 
                case MODIFY_DN: {
                    if (DirectoryServer.directoryServer.lockdownMode) {
                        Message message = CoreMessages.NOTE_REJECT_OPERATION_IN_LOCKDOWN_MODE.get();
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                    }
                    Message message = CoreMessages.ERR_REJECT_UNAUTHENTICATED_OPERATION.get();
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                case EXTENDED: {
                    ExtendedOperationBasis extOp = (ExtendedOperationBasis)operation;
                    String requestOID = extOp.getRequestOID();
                    if (requestOID != null && requestOID.equals("1.3.6.1.4.1.1466.20037")) break;
                    if (DirectoryServer.directoryServer.lockdownMode) {
                        Message message = CoreMessages.NOTE_REJECT_OPERATION_IN_LOCKDOWN_MODE.get();
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                    }
                    Message message = CoreMessages.ERR_REJECT_UNAUTHENTICATED_OPERATION.get();
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
            }
        }
        if (clientConnection.mustChangePassword()) {
            switch (operation.getOperationType()) {
                case ADD: 
                case COMPARE: 
                case DELETE: 
                case SEARCH: 
                case MODIFY_DN: {
                    for (Control c : operation.getRequestControls()) {
                        if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                        operation.addResponseControl(new PasswordPolicyResponseControl(null, 0, PasswordPolicyErrorType.CHANGE_AFTER_RESET));
                        break;
                    }
                    Message message = CoreMessages.ERR_ENQUEUE_MUST_CHANGE_PASSWORD.get();
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                case EXTENDED: {
                    ExtendedOperationBasis extOp = (ExtendedOperationBasis)operation;
                    String requestOID = extOp.getRequestOID();
                    if (requestOID != null && (requestOID.equals("1.3.6.1.4.1.4203.1.11.1") || requestOID.equals("1.3.6.1.4.1.1466.20037"))) break;
                    for (Control c : operation.getRequestControls()) {
                        if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                        operation.addResponseControl(new PasswordPolicyResponseControl(null, 0, PasswordPolicyErrorType.CHANGE_AFTER_RESET));
                        break;
                    }
                    Message message = CoreMessages.ERR_ENQUEUE_MUST_CHANGE_PASSWORD.get();
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
        }
        DirectoryServer.directoryServer.workQueue.submitOperation(operation);
    }

    public static CopyOnWriteArrayList<ChangeNotificationListener> getChangeNotificationListeners() {
        return DirectoryServer.directoryServer.changeNotificationListeners;
    }

    public static void registerChangeNotificationListener(ChangeNotificationListener changeListener) {
        DirectoryServer.directoryServer.changeNotificationListeners.add(changeListener);
    }

    public static void deregisterChangeNotificationListener(ChangeNotificationListener changeListener) {
        DirectoryServer.directoryServer.changeNotificationListeners.remove(changeListener);
    }

    public static CopyOnWriteArrayList<SynchronizationProvider<SynchronizationProviderCfg>> getSynchronizationProviders() {
        return DirectoryServer.directoryServer.synchronizationProviders;
    }

    public static void registerSynchronizationProvider(SynchronizationProvider<SynchronizationProviderCfg> provider) {
        DirectoryServer.directoryServer.synchronizationProviders.add(provider);
        provider.completeSynchronizationProvider();
    }

    public static void deregisterSynchronizationProvider(SynchronizationProvider provider) {
        DirectoryServer.directoryServer.synchronizationProviders.remove(provider);
    }

    public static Map<DN, Extension> getExtensions() {
        return DirectoryServer.directoryServer.extensions;
    }

    public static Extension getExtension(DN providerDN) {
        return DirectoryServer.directoryServer.extensions.get(providerDN);
    }

    public static void registerExtension(DN providerDN, Extension provider) {
        DirectoryServer.directoryServer.extensions.put(providerDN, provider);
    }

    public static void deregisterExtension(DN providerDN) {
        DirectoryServer.directoryServer.extensions.remove(providerDN);
    }

    public static Set<String> getAllowedTasks() {
        return DirectoryServer.directoryServer.allowedTasks;
    }

    public static void setAllowedTasks(Set<String> allowedTasks) {
        DirectoryServer.directoryServer.allowedTasks = allowedTasks;
    }

    public static Set<Privilege> getDisabledPrivileges() {
        return DirectoryServer.directoryServer.disabledPrivileges;
    }

    public static boolean isDisabled(Privilege privilege) {
        return DirectoryServer.directoryServer.disabledPrivileges.contains((Object)privilege);
    }

    public static void setDisabledPrivileges(Set<Privilege> disabledPrivileges) {
        DirectoryServer.directoryServer.disabledPrivileges = disabledPrivileges;
    }

    public static boolean returnBindErrorMessages() {
        return DirectoryServer.directoryServer.returnBindErrorMessages;
    }

    public static void setReturnBindErrorMessages(boolean returnBindErrorMessages) {
        DirectoryServer.directoryServer.returnBindErrorMessages = returnBindErrorMessages;
    }

    public static long getIdleTimeLimit() {
        return DirectoryServer.directoryServer.idleTimeLimit;
    }

    public static void setIdleTimeLimit(long idleTimeLimit) {
        DirectoryServer.directoryServer.idleTimeLimit = idleTimeLimit;
    }

    public static boolean saveConfigOnSuccessfulStartup() {
        return DirectoryServer.directoryServer.saveConfigOnSuccessfulStartup;
    }

    public static void setSaveConfigOnSuccessfulStartup(boolean saveConfigOnSuccessfulStartup) {
        DirectoryServer.directoryServer.saveConfigOnSuccessfulStartup = saveConfigOnSuccessfulStartup;
    }

    public static void registerBackupTaskListener(BackupTaskListener listener) {
        DirectoryServer.directoryServer.backupTaskListeners.addIfAbsent(listener);
    }

    public static void deregisterBackupTaskListener(BackupTaskListener listener) {
        DirectoryServer.directoryServer.backupTaskListeners.remove(listener);
    }

    public static void notifyBackupBeginning(Backend backend, BackupConfig config) {
        for (BackupTaskListener listener : DirectoryServer.directoryServer.backupTaskListeners) {
            try {
                listener.processBackupBegin(backend, config);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void notifyBackupEnded(Backend backend, BackupConfig config, boolean successful) {
        for (BackupTaskListener listener : DirectoryServer.directoryServer.backupTaskListeners) {
            try {
                listener.processBackupEnd(backend, config, successful);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void registerRestoreTaskListener(RestoreTaskListener listener) {
        DirectoryServer.directoryServer.restoreTaskListeners.addIfAbsent(listener);
    }

    public static void deregisterRestoreTaskListener(RestoreTaskListener listener) {
        DirectoryServer.directoryServer.restoreTaskListeners.remove(listener);
    }

    public static void notifyRestoreBeginning(Backend backend, RestoreConfig config) {
        for (RestoreTaskListener listener : DirectoryServer.directoryServer.restoreTaskListeners) {
            try {
                listener.processRestoreBegin(backend, config);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void notifyRestoreEnded(Backend backend, RestoreConfig config, boolean successful) {
        for (RestoreTaskListener listener : DirectoryServer.directoryServer.restoreTaskListeners) {
            try {
                listener.processRestoreEnd(backend, config, successful);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void registerExportTaskListener(ExportTaskListener listener) {
        DirectoryServer.directoryServer.exportTaskListeners.addIfAbsent(listener);
    }

    public static void deregisterExportTaskListener(ExportTaskListener listener) {
        DirectoryServer.directoryServer.exportTaskListeners.remove(listener);
    }

    public static void notifyExportBeginning(Backend backend, LDIFExportConfig config) {
        for (ExportTaskListener listener : DirectoryServer.directoryServer.exportTaskListeners) {
            try {
                listener.processExportBegin(backend, config);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void notifyExportEnded(Backend backend, LDIFExportConfig config, boolean successful) {
        for (ExportTaskListener listener : DirectoryServer.directoryServer.exportTaskListeners) {
            try {
                listener.processExportEnd(backend, config, successful);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void registerImportTaskListener(ImportTaskListener listener) {
        DirectoryServer.directoryServer.importTaskListeners.addIfAbsent(listener);
    }

    public static void deregisterImportTaskListener(ImportTaskListener listener) {
        DirectoryServer.directoryServer.importTaskListeners.remove(listener);
    }

    public static void notifyImportBeginning(Backend backend, LDIFImportConfig config) {
        for (ImportTaskListener listener : DirectoryServer.directoryServer.importTaskListeners) {
            try {
                listener.processImportBegin(backend, config);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void notifyImportEnded(Backend backend, LDIFImportConfig config, boolean successful) {
        for (ImportTaskListener listener : DirectoryServer.directoryServer.importTaskListeners) {
            try {
                listener.processImportEnd(backend, config, successful);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public static void registerInitializationCompletedListener(InitializationCompletedListener listener) {
        DirectoryServer.directoryServer.initializationCompletedListeners.add(listener);
    }

    public static void deregisterInitializationCompletedListener(InitializationCompletedListener listener) {
        DirectoryServer.directoryServer.initializationCompletedListeners.remove(listener);
    }

    public static void registerShutdownListener(ServerShutdownListener listener) {
        DirectoryServer.directoryServer.shutdownListeners.add(listener);
    }

    public static void deregisterShutdownListener(ServerShutdownListener listener) {
        DirectoryServer.directoryServer.shutdownListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown(String className, Message reason) {
        AccessControlHandler<?> accessControlHandler;
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            if (DirectoryServer.directoryServer.shuttingDown) {
                return;
            }
            DirectoryServer.directoryServer.shuttingDown = true;
        }
        try {
            DirectoryServer.directoryServer.configHandler.getConfigRootEntry();
        }
        catch (Exception e) {
            // empty catch block
        }
        Message message = CoreMessages.NOTE_SERVER_SHUTDOWN.get(className, reason);
        DirectoryServer.sendAlertNotification(DirectoryServer.directoryServer, "org.opends.server.DirectoryServerShutdown", message);
        ServerShutdownMonitor shutdownMonitor = new ServerShutdownMonitor();
        shutdownMonitor.start();
        for (ConnectionHandler connectionHandler : DirectoryServer.directoryServer.connectionHandlers) {
            try {
                connectionHandler.finalizeConnectionHandler(CoreMessages.INFO_CONNHANDLER_CLOSED_BY_SHUTDOWN.get());
            }
            catch (Exception exception) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, exception);
            }
        }
        DirectoryServer.directoryServer.connectionHandlers.clear();
        if (DirectoryServer.directoryServer.pluginConfigManager != null) {
            DirectoryServer.directoryServer.pluginConfigManager.invokeShutdownPlugins(reason);
            DirectoryServer.directoryServer.pluginConfigManager.finalizePlugins();
        }
        for (SynchronizationProvider synchronizationProvider : DirectoryServer.directoryServer.synchronizationProviders) {
            synchronizationProvider.finalizeSynchronizationProvider();
        }
        if (DirectoryServer.directoryServer.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(DirectoryServer.directoryServer.shutdownHook);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (DirectoryServer.directoryServer.workQueue != null) {
            DirectoryServer.directoryServer.workQueue.finalizeWorkQueue(reason);
        }
        for (ServerShutdownListener serverShutdownListener : DirectoryServer.directoryServer.shutdownListeners) {
            try {
                serverShutdownListener.processServerShutdown(reason);
            }
            catch (Exception exception) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, exception);
            }
        }
        for (AlertHandler alertHandler : DirectoryServer.directoryServer.alertHandlers) {
            alertHandler.finalizeAlertHandler();
        }
        if (DirectoryServer.directoryServer.mBeanServer != null) {
            Set<ObjectInstance> mBeanSet = DirectoryServer.directoryServer.mBeanServer.queryMBeans(null, null);
            for (ObjectInstance objectInstance : mBeanSet) {
                if (!(objectInstance instanceof DirectoryServerMBean)) continue;
                try {
                    DirectoryServerMBean mBean = (DirectoryServerMBean)((Object)objectInstance);
                    DirectoryServer.directoryServer.mBeanServer.unregisterMBean(mBean.getObjectName());
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        for (SASLMechanismHandler sASLMechanismHandler : DirectoryServer.directoryServer.saslMechanismHandlers.values()) {
            try {
                sASLMechanismHandler.finalizeSASLMechanismHandler();
            }
            catch (Exception exception) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, exception);
            }
        }
        for (ExtendedOperationHandler extendedOperationHandler : DirectoryServer.directoryServer.extendedOperationHandlers.values()) {
            try {
                extendedOperationHandler.finalizeExtendedOperationHandler();
            }
            catch (Exception exception) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, exception);
            }
        }
        for (DN dN : DirectoryServer.directoryServer.passwordPolicies.keySet()) {
            DirectoryServer.deregisterPasswordPolicy(dN);
        }
        if (DirectoryServer.directoryServer.passwordPolicyConfigManager != null) {
            DirectoryServer.directoryServer.passwordPolicyConfigManager.finalizePasswordPolicies();
        }
        if ((accessControlHandler = AccessControlConfigManager.getInstance().getAccessControlHandler()) != null) {
            accessControlHandler.finalizeAccessControlHandler();
        }
        if (DirectoryServer.directoryServer.groupManager != null) {
            DirectoryServer.directoryServer.groupManager.finalizeGroupManager();
        }
        if (DirectoryServer.directoryServer.subentryManager != null) {
            DirectoryServer.directoryServer.subentryManager.finalizeSubentryManager();
        }
        for (MonitorProvider<? extends MonitorProviderCfg> monitorProvider : DirectoryServer.directoryServer.monitorProviders.values()) {
            try {
                monitorProvider.finalizeMonitorProvider();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (Backend backend : DirectoryServer.directoryServer.backends.values()) {
            try {
                LocalBackendWorkflowElement.removeAll();
                for (BackendInitializationListener listener : DirectoryServer.directoryServer.backendInitializationListeners) {
                    listener.performBackendFinalizationProcessing(backend);
                }
                backend.finalizeBackend();
                try {
                    StringBuilder failureReason;
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    if (LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) continue;
                    message = CoreMessages.WARN_SHUTDOWN_CANNOT_RELEASE_SHARED_BACKEND_LOCK.get(backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message);
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    message = CoreMessages.WARN_SHUTDOWN_CANNOT_RELEASE_SHARED_BACKEND_LOCK.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e2));
                    ErrorLogger.logError(message);
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.finalizeEntryCache();
        }
        WorkflowImpl.deregisterAllOnShutdown();
        NetworkGroup.deregisterAllOnShutdown();
        InternalConnectionHandler.clearRootClientConnectionAtShutdown();
        ErrorLogger.logError(CoreMessages.NOTE_SERVER_STOPPED.get());
        AccessLogger.removeAllAccessLogPublishers();
        ErrorLogger.removeAllErrorLogPublishers();
        DebugLogger.removeAllDebugLogPublishers();
        TimeThread.stop();
        shutdownMonitor.waitForMonitor();
        DirectoryEnvironmentConfig directoryEnvironmentConfig = DirectoryServer.directoryServer.environmentConfig;
        DirectoryServer.directoryServer.destroy();
        DirectoryServer.directoryServer = DirectoryServer.getNewInstance(directoryEnvironmentConfig);
    }

    private void destroy() {
        this.checkSchema = true;
        this.isBootstrapped = false;
        this.isRunning = false;
        this.lockdownMode = true;
        this.rejectUnauthenticatedRequests = true;
        this.shuttingDown = true;
        this.configClass = null;
        this.configFile = null;
        this.configHandler = null;
        this.coreConfigManager = null;
        this.compressedSchema = null;
        this.cryptoManager = null;
        this.defaultBinarySyntax = null;
        this.defaultBooleanSyntax = null;
        this.defaultDNSyntax = null;
        this.defaultIntegerSyntax = null;
        this.defaultStringSyntax = null;
        this.defaultSyntax = null;
        this.entryCache = null;
        this.environmentConfig = null;
        this.objectClassAttributeType = null;
        this.schemaDN = null;
        this.shutdownHook = null;
        this.workQueue = null;
        if (this.baseDnRegistry != null) {
            this.baseDnRegistry.clear();
            this.baseDnRegistry = null;
        }
        if (this.backends != null) {
            this.backends.clear();
            this.backends = null;
        }
        if (this.schema != null) {
            this.schema.destroy();
            this.schema = null;
        }
    }

    public static void restart(String className, Message reason) {
        DirectoryServer.restart(className, reason, DirectoryServer.directoryServer.environmentConfig);
    }

    public static void restart(String className, Message reason, DirectoryEnvironmentConfig config) {
        try {
            DirectoryServer.shutDown(className, reason);
            DirectoryServer.reinitialize(config);
            directoryServer.startServer();
        }
        catch (Exception e) {
            System.err.println("ERROR:  Unable to perform an in-core restart:");
            e.printStackTrace();
            System.err.println("Halting the JVM so that it must be manually restarted.");
            Runtime.getRuntime().halt(1);
        }
    }

    public static DirectoryServer reinitialize() throws InitializationException {
        return DirectoryServer.reinitialize(DirectoryServer.directoryServer.environmentConfig);
    }

    public static DirectoryServer reinitialize(DirectoryEnvironmentConfig config) throws InitializationException {
        TimeThread.start();
        DirectoryServer.getNewInstance(config);
        LockManager.reinitializeLockTable();
        directoryServer.bootstrapServer();
        directoryServer.initializeConfiguration();
        return directoryServer;
    }

    public static long getMaxAllowedConnections() {
        return DirectoryServer.directoryServer.maxAllowedConnections;
    }

    public static void setMaxAllowedConnections(long maxAllowedConnections) {
        DirectoryServer.directoryServer.maxAllowedConnections = maxAllowedConnections > 0L ? maxAllowedConnections : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long newConnectionAccepted(ClientConnection clientConnection) {
        LinkedHashSet<ClientConnection> linkedHashSet = DirectoryServer.directoryServer.establishedConnections;
        synchronized (linkedHashSet) {
            InetAddress remoteAddress;
            if (DirectoryServer.directoryServer.lockdownMode && (remoteAddress = clientConnection.getRemoteAddress()) != null && !remoteAddress.isLoopbackAddress()) {
                return -1L;
            }
            if (DirectoryServer.directoryServer.maxAllowedConnections > 0L && DirectoryServer.directoryServer.currentConnections >= DirectoryServer.directoryServer.maxAllowedConnections) {
                return -1L;
            }
            DirectoryServer.directoryServer.establishedConnections.add(clientConnection);
            ++DirectoryServer.directoryServer.currentConnections;
            if (DirectoryServer.directoryServer.currentConnections > DirectoryServer.directoryServer.maxConnections) {
                DirectoryServer.directoryServer.maxConnections = DirectoryServer.directoryServer.currentConnections;
            }
            return DirectoryServer.directoryServer.totalConnections++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connectionClosed(ClientConnection clientConnection) {
        LinkedHashSet<ClientConnection> linkedHashSet = DirectoryServer.directoryServer.establishedConnections;
        synchronized (linkedHashSet) {
            DirectoryServer.directoryServer.establishedConnections.remove(clientConnection);
            --DirectoryServer.directoryServer.currentConnections;
        }
    }

    public static long getCurrentConnections() {
        return DirectoryServer.directoryServer.currentConnections;
    }

    public static long getMaxConnections() {
        return DirectoryServer.directoryServer.maxConnections;
    }

    public static long getTotalConnections() {
        return DirectoryServer.directoryServer.totalConnections;
    }

    public static String getVersionString() {
        return DynamicConstants.FULL_VERSION_STRING;
    }

    public static void printVersion(OutputStream outputStream) throws IOException {
        outputStream.write(DynamicConstants.PRINTABLE_VERSION_STRING.getBytes());
        String extensionInformation = ClassLoaderProvider.getInstance().printExtensionInformation();
        if (extensionInformation != null) {
            outputStream.write(extensionInformation.getBytes());
        }
    }

    public static int getSizeLimit() {
        return DirectoryServer.directoryServer.sizeLimit;
    }

    public static void setSizeLimit(int sizeLimit) {
        DirectoryServer.directoryServer.sizeLimit = sizeLimit;
    }

    public static int getLookthroughLimit() {
        return DirectoryServer.directoryServer.lookthroughLimit;
    }

    public static void setLookthroughLimit(int lookthroughLimit) {
        DirectoryServer.directoryServer.lookthroughLimit = lookthroughLimit;
    }

    public static int getTimeLimit() {
        return DirectoryServer.directoryServer.timeLimit;
    }

    public static void setTimeLimit(int timeLimit) {
        DirectoryServer.directoryServer.timeLimit = timeLimit;
    }

    public static void setUseNanoTime(boolean useNanoTime) {
        DirectoryServer.directoryServer.useNanoTime = useNanoTime;
    }

    public static boolean getUseNanoTime() {
        return DirectoryServer.directoryServer.useNanoTime;
    }

    public static WritabilityMode getWritabilityMode() {
        return DirectoryServer.directoryServer.writabilityMode;
    }

    public static void setWritabilityMode(WritabilityMode writabilityMode) {
        DirectoryServer.directoryServer.writabilityMode = writabilityMode;
    }

    public static boolean bindWithDNRequiresPassword() {
        return DirectoryServer.directoryServer.bindWithDNRequiresPassword;
    }

    public static void setBindWithDNRequiresPassword(boolean bindWithDNRequiresPassword) {
        DirectoryServer.directoryServer.bindWithDNRequiresPassword = bindWithDNRequiresPassword;
    }

    public static boolean rejectUnauthenticatedRequests() {
        return DirectoryServer.directoryServer.rejectUnauthenticatedRequests;
    }

    public static void setRejectUnauthenticatedRequests(boolean rejectUnauthenticatedRequests) {
        DirectoryServer.directoryServer.rejectUnauthenticatedRequests = rejectUnauthenticatedRequests;
    }

    public static boolean lockdownMode() {
        return DirectoryServer.directoryServer.lockdownMode;
    }

    public static void setLockdownMode(boolean lockdownMode) {
        DirectoryServer.directoryServer.lockdownMode = lockdownMode;
        if (lockdownMode) {
            Message message = CoreMessages.WARN_DIRECTORY_SERVER_ENTERING_LOCKDOWN_MODE.get();
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(directoryServer, "org.opends.server.EnteringLockdownMode", message);
        } else {
            Message message = CoreMessages.NOTE_DIRECTORY_SERVER_LEAVING_LOCKDOWN_MODE.get();
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(directoryServer, "org.opends.server.LeavingLockdownMode", message);
        }
    }

    public static void setToolDescription(Message msg) {
        toolDescription = msg;
    }

    @Override
    public DN getComponentEntryDN() {
        try {
            if (this.configHandler == null) {
                return DN.nullDN();
            }
            return this.configHandler.getConfigRootEntry().getDN();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return DN.nullDN();
        }
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.DirectoryServerStarted", "This alert type will be used to provide notification that the Directory Server has completed its startup process.");
        alerts.put("org.opends.server.DirectoryServerShutdown", "This alert type will be used to provide notification that the Directory Server has begun the process of shutting down.");
        alerts.put("org.opends.server.EnteringLockdownMode", "This alert type will be used to notify administrators that the Directory Server is entering lockdown mode, in which only root users will be allowed to perform operations and only over the loopback address.");
        alerts.put("org.opends.server.LeavingLockdownMode", "This alert type will be used to notify administrators that the Directory Server is leaving lockdown mode.");
        return alerts;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public static void main(String[] args) {
        Message message;
        DirectoryServer directoryServer;
        TextDebugLogPublisher startupDebugLogPublisher;
        TextErrorLogPublisher startupErrorLogPublisher;
        block50: {
            Message message2;
            Argument checkStartability = null;
            Argument quietMode = null;
            Argument timeout = null;
            BooleanArgument windowsNetStart = null;
            BooleanArgument displayUsage = null;
            Argument fullVersion = null;
            Argument noDetach = null;
            Argument systemInfo = null;
            Argument useLastKnownGoodConfig = null;
            StringArgument configClass = null;
            StringArgument configFile = null;
            Message toolDescription = DirectoryServer.toolDescription;
            ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
            try {
                configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, CoreMessages.INFO_DSCORE_DESCRIPTION_CONFIG_CLASS.get());
                configClass.setHidden(true);
                argParser.addArgument(configClass);
                configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, CoreMessages.INFO_DSCORE_DESCRIPTION_CONFIG_FILE.get());
                configFile.setHidden(true);
                argParser.addArgument(configFile);
                checkStartability = new BooleanArgument("checkstartability", null, "checkStartability", CoreMessages.INFO_DSCORE_DESCRIPTION_CHECK_STARTABILITY.get());
                checkStartability.setHidden(true);
                argParser.addArgument(checkStartability);
                windowsNetStart = new BooleanArgument("windowsnetstart", null, "windowsNetStart", CoreMessages.INFO_DSCORE_DESCRIPTION_WINDOWS_NET_START.get());
                windowsNetStart.setHidden(true);
                argParser.addArgument(windowsNetStart);
                fullVersion = new BooleanArgument("fullversion", Character.valueOf('F'), "fullVersion", CoreMessages.INFO_DSCORE_DESCRIPTION_FULLVERSION.get());
                fullVersion.setHidden(true);
                argParser.addArgument(fullVersion);
                systemInfo = new BooleanArgument("systeminfo", Character.valueOf('s'), "systemInfo", CoreMessages.INFO_DSCORE_DESCRIPTION_SYSINFO.get());
                argParser.addArgument(systemInfo);
                useLastKnownGoodConfig = new BooleanArgument("lastknowngoodconfig", Character.valueOf('L'), "useLastKnownGoodConfig", CoreMessages.INFO_DSCORE_DESCRIPTION_LASTKNOWNGOODCFG.get());
                argParser.addArgument(useLastKnownGoodConfig);
                noDetach = new BooleanArgument("nodetach", Character.valueOf('N'), "nodetach", CoreMessages.INFO_DSCORE_DESCRIPTION_NODETACH.get());
                argParser.addArgument(noDetach);
                quietMode = new BooleanArgument("quiet", Character.valueOf('Q'), "quiet", ToolMessages.INFO_DESCRIPTION_QUIET.get());
                argParser.addArgument(quietMode);
                timeout = new IntegerArgument("timeout", Character.valueOf('t'), "timeout", true, false, true, ToolMessages.INFO_SECONDS_PLACEHOLDER.get(), DEFAULT_TIMEOUT, null, true, 0, false, 0, CoreMessages.INFO_DSCORE_DESCRIPTION_TIMEOUT.get());
                argParser.addArgument(timeout);
                displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", CoreMessages.INFO_DSCORE_DESCRIPTION_USAGE.get());
                argParser.addArgument(displayUsage);
                argParser.setUsageArgument(displayUsage);
            }
            catch (ArgumentException ae) {
                message2 = CoreMessages.ERR_DSCORE_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
                System.err.println(message2);
                System.exit(1);
            }
            try {
                argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                message2 = CoreMessages.ERR_DSCORE_ERROR_PARSING_ARGS.get(ae.getMessage());
                System.err.println(message2);
                System.err.println(argParser.getUsage());
                System.exit(1);
            }
            if (checkStartability.isPresent()) {
                if (argParser.usageOrVersionDisplayed()) {
                    System.exit(NOTHING_TO_DO);
                } else if (fullVersion.isPresent() || systemInfo.isPresent()) {
                    LinkedList<String> newArgList = new LinkedList<String>();
                    for (String arg : args) {
                        if (arg.equalsIgnoreCase("--checkstartability")) continue;
                        newArgList.add(arg);
                    }
                    String[] newArgs = new String[newArgList.size()];
                    newArgList.toArray(newArgs);
                    DirectoryServer.main(newArgs);
                    System.exit(NOTHING_TO_DO);
                } else {
                    System.exit(DirectoryServer.checkStartability(argParser));
                }
            } else if (argParser.usageOrVersionDisplayed()) {
                System.exit(0);
            } else {
                if (fullVersion.isPresent()) {
                    DirectoryServer.printFullVersionInformation();
                    return;
                }
                if (systemInfo.isPresent()) {
                    RuntimeInformation.printInfo();
                    return;
                }
                if (noDetach.isPresent() && timeout.isPresent()) {
                    Message message3 = CoreMessages.ERR_DSCORE_ERROR_NODETACH_TIMEOUT.get();
                    System.err.println(message3);
                    System.err.println(argParser.getUsage());
                    System.exit(1);
                }
            }
            String lockFile = LockFileManager.getServerLockFileName();
            try {
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                    Message message4 = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, String.valueOf(failureReason));
                    System.err.println(message4);
                    System.exit(1);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message5 = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, StaticUtils.stackTraceToSingleLineString(e));
                System.err.println(message5);
                System.exit(1);
            }
            serverLocked = true;
            boolean pidFileMarkedForDeletion = false;
            boolean startingFileMarkedForDeletion = false;
            try {
                File startingFile;
                String startingFilePath;
                String pidFilePath;
                String serverRoot = System.getenv("INSTALL_ROOT");
                File instanceRoot = DirectoryEnvironmentConfig.getInstanceRootFromServerRoot(new File(serverRoot));
                if (instanceRoot == null) {
                    pidFilePath = "logs/server.pid";
                    startingFilePath = "logs/server.starting";
                } else {
                    pidFilePath = instanceRoot.getAbsolutePath() + File.separator + "logs" + File.separator + "server.pid";
                    startingFilePath = instanceRoot.getAbsolutePath() + File.separator + "logs" + File.separator + "server.starting";
                }
                File pidFile = new File(pidFilePath);
                if (pidFile.exists()) {
                    pidFile.deleteOnExit();
                    pidFileMarkedForDeletion = true;
                }
                if ((startingFile = new File(startingFilePath)).exists()) {
                    startingFile.deleteOnExit();
                    startingFileMarkedForDeletion = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String serverRoot = System.getenv("INSTALL_ROOT");
                if (serverRoot == null) {
                    serverRoot = new File(configFile.getValue()).getParentFile().getParentFile().getAbsolutePath();
                }
                if (serverRoot == null) {
                    System.err.println("WARNING:  Unable to determine server root in order to redirect standard output and standard error.");
                } else {
                    File instanceRoot = DirectoryEnvironmentConfig.getInstanceRootFromServerRoot(new File(serverRoot));
                    File logDir = new File(instanceRoot.getAbsolutePath() + File.separator + "logs");
                    if (logDir.exists()) {
                        File f;
                        FileOutputStream fos = new FileOutputStream(new File(logDir, "server.out"), true);
                        PrintStream serverOutStream = new PrintStream(fos);
                        if (noDetach.isPresent() && !quietMode.isPresent()) {
                            MultiOutputStream multiStream = new MultiOutputStream(System.out, serverOutStream);
                            serverOutStream = new PrintStream(multiStream);
                        }
                        System.setOut(serverOutStream);
                        System.setErr(serverOutStream);
                        if (!pidFileMarkedForDeletion && (f = new File(logDir, "server.pid")).exists()) {
                            f.deleteOnExit();
                        }
                        if (!startingFileMarkedForDeletion && (f = new File(logDir, "server.starting")).exists()) {
                            f.deleteOnExit();
                        }
                    } else {
                        System.err.println("WARNING:  Unable to redirect standard output and standard error because the logs directory " + logDir.getAbsolutePath() + " does not exist.");
                    }
                }
            }
            catch (Exception e) {
                System.err.println("WARNING:  Unable to redirect standard output and standard error:  " + StaticUtils.stackTraceToSingleLineString(e));
            }
            startupErrorLogPublisher = null;
            startupDebugLogPublisher = null;
            startupErrorLogPublisher = TextErrorLogPublisher.getStartupTextErrorPublisher(new TextWriter.STDOUT());
            ErrorLogger.addErrorLogPublisher(startupErrorLogPublisher);
            startupDebugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STDOUT());
            DebugLogger.addDebugLogPublisher(startupDebugLogPublisher);
            DirectoryEnvironmentConfig environmentConfig = new DirectoryEnvironmentConfig();
            try {
                environmentConfig.setProperty("org.opends.server.ConfigClass", configClass.getValue());
                environmentConfig.setProperty("org.opends.server.ConfigFile", configFile.getValue());
                environmentConfig.setProperty("org.opends.server.UseLastKnownGoodConfiguration", String.valueOf(useLastKnownGoodConfig.isPresent()));
            }
            catch (Exception e) {
                // empty catch block
            }
            directoryServer = DirectoryServer.getInstance();
            try {
                directoryServer.setEnvironmentConfig(environmentConfig);
                directoryServer.bootstrapServer();
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                message = CoreMessages.ERR_DSCORE_CANNOT_BOOTSTRAP.get(ie.getMessage());
                System.err.println(message);
                System.exit(1);
            }
            catch (Exception e) {
                message = CoreMessages.ERR_DSCORE_CANNOT_BOOTSTRAP.get(StaticUtils.stackTraceToSingleLineString(e));
                System.err.println(message);
                System.exit(1);
            }
            try {
                directoryServer.serviceTagRegistry = ServiceTagRegistration.getRegistrationService();
                directoryServer.serviceTagRegistry.registerServiceTags("Server");
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block50;
                TRACER.debugCaught(DebugLogLevel.WARNING, ex);
            }
        }
        try {
            directoryServer.startServer();
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            message = CoreMessages.ERR_DSCORE_CANNOT_START.get(ie.getMessage());
            DirectoryServer.shutDown(directoryServer.getClass().getName(), message);
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            message = CoreMessages.ERR_DSCORE_CANNOT_START.get(ce.getMessage() + (ce.getCause() != null ? " " + ce.getCause().getLocalizedMessage() : ""));
            DirectoryServer.shutDown(directoryServer.getClass().getName(), message);
        }
        catch (Exception e) {
            message = CoreMessages.ERR_DSCORE_CANNOT_START.get(StaticUtils.stackTraceToSingleLineString(e));
            DirectoryServer.shutDown(directoryServer.getClass().getName(), message);
        }
        ErrorLogger.removeErrorLogPublisher(startupErrorLogPublisher);
        DebugLogger.removeDebugLogPublisher(startupDebugLogPublisher);
    }

    public static DN getMonitorProviderDN(MonitorProvider provider) {
        DN monitorRootDN;
        String monitorName = provider.getMonitorInstanceName();
        DirectoryServer.getAttributeType("cn");
        try {
            monitorRootDN = DN.decode("cn=" + monitorName + "," + "cn=monitor");
        }
        catch (DirectoryException e) {
            throw new RuntimeException();
        }
        return monitorRootDN;
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderProvider.getInstance().getClassLoader();
    }

    public static Class<?> loadClass(String name) throws LinkageError, ExceptionInInitializerError, ClassNotFoundException {
        return Class.forName(name, true, DirectoryServer.getClassLoader());
    }

    private static int checkStartability(ArgumentParser argParser) {
        int returnValue;
        Message message;
        boolean isServerRunning;
        BooleanArgument noDetach = (BooleanArgument)argParser.getArgumentForLongID("nodetach");
        BooleanArgument quietMode = (BooleanArgument)argParser.getArgumentForLongID("quiet");
        BooleanArgument windowsNetStart = (BooleanArgument)argParser.getArgumentForLongID("windowsnetstart");
        boolean noDetachPresent = noDetach.isPresent();
        boolean windowsNetStartPresent = windowsNetStart.isPresent();
        String lockFile = LockFileManager.getServerLockFileName();
        try {
            StringBuilder failureReason = new StringBuilder();
            if (LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                LockFileManager.releaseLock(lockFile, failureReason);
                isServerRunning = false;
            } else {
                message = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, String.valueOf(failureReason));
                System.err.println(message);
                isServerRunning = true;
            }
        }
        catch (Exception e) {
            message = CoreMessages.ERR_CANNOT_ACQUIRE_EXCLUSIVE_SERVER_LOCK.get(lockFile, StaticUtils.getExceptionMessage(e));
            System.err.println(message);
            isServerRunning = true;
        }
        boolean configuredAsService = DirectoryServer.isRunningAsWindowsService();
        if (isServerRunning) {
            returnValue = configuredAsService && !windowsNetStartPresent ? START_AS_WINDOWS_SERVICE : SERVER_ALREADY_STARTED;
        } else if (configuredAsService) {
            if (noDetachPresent) {
                returnValue = CHECK_ERROR;
                message = CoreMessages.ERR_DSCORE_ERROR_NODETACH_AND_WINDOW_SERVICE.get();
                System.err.println(message);
            } else {
                returnValue = windowsNetStartPresent ? START_AS_DETACH_CALLED_FROM_WINDOWS_SERVICE : START_AS_WINDOWS_SERVICE;
            }
        } else {
            returnValue = noDetachPresent ? (quietMode.isPresent() ? START_AS_NON_DETACH_QUIET : START_AS_NON_DETACH) : (quietMode.isPresent() ? START_AS_DETACH_QUIET : START_AS_DETACH);
        }
        return returnValue;
    }

    public static boolean isRunningAsWindowsService() {
        boolean isRunningAsWindowsService = SetupUtils.isWindows() ? ConfigureWindowsService.serviceState(null, null) == 0 : false;
        return isRunningAsWindowsService;
    }

    public static void setWorkflowConfigurationMode(GlobalCfgDefn.WorkflowConfigurationMode workflowConfigurationMode) {
        DirectoryServer.directoryServer.workflowConfigurationMode = workflowConfigurationMode;
    }

    public static boolean workflowConfigurationModeIsAuto() {
        boolean isAuto = DirectoryServer.directoryServer.workflowConfigurationMode == GlobalCfgDefn.WorkflowConfigurationMode.AUTO;
        return isAuto;
    }

    public static GlobalCfgDefn.WorkflowConfigurationMode getWorkflowConfigurationMode() {
        return DirectoryServer.directoryServer.workflowConfigurationMode;
    }

    public static WorkflowElement getWorkflowElement(String workflowElementID) {
        return DirectoryServer.directoryServer.workflowElements.get(workflowElementID);
    }

    public static WorkflowElement getOrCreateWorkflowElement(String workflowElementID) throws ConfigException, InitializationException {
        WorkflowElement<?> we = DirectoryServer.directoryServer.workflowElements.get(workflowElementID);
        if (we == null) {
            we = DirectoryServer.directoryServer.workflowElementConfigManager.loadAndRegisterWorkflowElement(workflowElementID);
        }
        return we;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWorkflowElement(WorkflowElement we) throws DirectoryException {
        Validator.ensureNotNull(we);
        String workflowElementID = we.getWorkflowElementID();
        Validator.ensureNotNull(workflowElementID);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            if (DirectoryServer.directoryServer.workflowElements.containsKey(workflowElementID)) {
                CoreMessages.ERR_REGISTER_WORKFLOW_ELEMENT_ALREADY_EXISTS.get(workflowElementID);
            } else {
                DirectoryServer.directoryServer.workflowElements.put(workflowElementID, we);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterWorkflowElement(WorkflowElement we) {
        Validator.ensureNotNull(we);
        String workflowElementID = we.getWorkflowElementID();
        Validator.ensureNotNull(workflowElementID);
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer.workflowElements.remove(workflowElementID);
        }
    }

    public static boolean isWorkflowElementRegistered(String workflowElementID) {
        return DirectoryServer.directoryServer.workflowElements.containsKey(workflowElementID);
    }

    private static void printFullVersionInformation() {
        String separator = ": ";
        System.out.println(DirectoryServer.getVersionString());
        System.out.println("Build ID" + separator + DynamicConstants.BUILD_ID);
        System.out.println("Major Version" + separator + DynamicConstants.MAJOR_VERSION);
        System.out.println("Minor Version" + separator + DynamicConstants.MINOR_VERSION);
        System.out.println("Point Version" + separator + DynamicConstants.POINT_VERSION);
        System.out.println("Version Qualifier" + separator + DynamicConstants.VERSION_QUALIFIER);
        if (DynamicConstants.BUILD_NUMBER > 0) {
            System.out.println("Build Number" + separator + new DecimalFormat("000").format(DynamicConstants.BUILD_NUMBER));
        }
        System.out.println("Revision Number" + separator + DynamicConstants.REVISION_NUMBER);
        System.out.println("URL Repository" + separator + DynamicConstants.URL_REPOSITORY);
        System.out.println("Fix IDs" + separator + DynamicConstants.FIX_IDS);
        System.out.println("Debug Build" + separator + DynamicConstants.DEBUG_BUILD);
        System.out.println("Build OS" + separator + DynamicConstants.BUILD_OS);
        System.out.println("Build User" + separator + DynamicConstants.BUILD_USER);
        System.out.println("Build Java Version" + separator + DynamicConstants.BUILD_JAVA_VERSION);
        System.out.println("Build Java Vendor" + separator + DynamicConstants.BUILD_JAVA_VENDOR);
        System.out.println("Build JVM Version" + separator + DynamicConstants.BUILD_JVM_VERSION);
        System.out.println("Build JVM Vendor" + separator + DynamicConstants.BUILD_JVM_VENDOR);
        System.out.println("Upgrade Event IDs" + separator + StaticUtils.listToString(VersionCompatibilityIssue.getAllEvents(), ","));
        String extensionInformation = ClassLoaderProvider.getInstance().printExtensionInformation();
        if (extensionInformation != null) {
            System.out.print(extensionInformation);
        }
    }
}

