/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.opends.server.extensions.ConnectionSecurityProvider;

public class RedirectingByteChannel
implements ByteChannel {
    private final ByteChannel child;
    private volatile ByteChannel redirect = null;

    private RedirectingByteChannel(ByteChannel child) {
        this.child = child;
    }

    public static RedirectingByteChannel getRedirectingByteChannel(ByteChannel bc) {
        return new RedirectingByteChannel(bc);
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.redirect != null) {
            return this.redirect.read(buffer);
        }
        return this.child.read(buffer);
    }

    public void close() throws IOException {
        if (this.redirect != null) {
            this.redirect.close();
        } else {
            this.child.close();
        }
    }

    public boolean isOpen() {
        if (this.redirect != null) {
            return this.redirect.isOpen();
        }
        return this.child.isOpen();
    }

    public int write(ByteBuffer buffer) throws IOException {
        if (this.redirect != null) {
            return this.redirect.write(buffer);
        }
        return this.child.write(buffer);
    }

    public final void redirect(ConnectionSecurityProvider provider) {
        this.redirect = provider.wrapChannel(this.child);
    }

    public final void disable() {
        this.redirect = null;
    }
}

