/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.cert.Certificate;
import org.opends.server.api.ClientConnection;
import org.opends.server.extensions.ConnectionSecurityProvider;
import org.opends.server.extensions.RedirectingByteChannel;
import org.opends.server.extensions.SASLContext;

public class SASLByteChannel
implements ByteChannel,
ConnectionSecurityProvider {
    private ClientConnection connection;
    private SASLContext saslContext;
    private RedirectingByteChannel channel;
    private final int lengthSize = 4;
    private int bufLength;
    private String name;
    private ByteBuffer readBuffer;
    private ByteBuffer decodeBuffer;
    private int neededBytes = 0;
    private boolean reading = false;

    private SASLByteChannel(ClientConnection connection, String name, SASLContext saslContext) {
        this.connection = connection;
        this.name = name;
        this.saslContext = saslContext;
        this.channel = connection.getChannel();
        this.readBuffer = ByteBuffer.allocate(connection.getAppBufferSize());
        this.decodeBuffer = ByteBuffer.allocate(connection.getAppBufferSize() + 4);
    }

    public static SASLByteChannel getSASLByteChannel(ClientConnection c, String name, SASLContext context) {
        return new SASLByteChannel(c, name, context);
    }

    private int processPartial(int readResult, ByteBuffer clearDst) throws IOException {
        this.readBuffer.flip();
        if (this.neededBytes > readResult) {
            this.neededBytes -= readResult;
            this.decodeBuffer.put(this.readBuffer);
            this.readBuffer.clear();
            this.reading = false;
            return 0;
        }
        while (this.neededBytes > 0) {
            this.decodeBuffer.put(this.readBuffer.get());
            --this.neededBytes;
        }
        byte[] inBytes = this.decodeBuffer.array();
        byte[] clearBytes = this.saslContext.unwrap(inBytes, 4, this.bufLength);
        clearDst.put(clearBytes);
        this.decodeBuffer.clear();
        this.readBuffer.compact();
        if (this.readBuffer.position() != 0) {
            this.bufLength = this.getBufLength(this.readBuffer);
            this.reading = true;
        } else {
            this.reading = false;
        }
        return clearDst.position();
    }

    private int readAll(ByteBuffer byteBuf, int total) throws IOException {
        int count = 0;
        while (this.channel.isOpen() && total > 0) {
            count = this.channel.read(byteBuf);
            if (count == -1) {
                return -1;
            }
            if (count == 0) {
                return 0;
            }
            total -= count;
        }
        if (total > 0) {
            return -1;
        }
        return byteBuf.position();
    }

    private int getBufLength(ByteBuffer byteBuf) {
        int answer = 0;
        for (int i = 0; i < 4; ++i) {
            byte b = byteBuf.get(i);
            answer <<= 8;
            answer |= b & 0xFF;
        }
        return answer;
    }

    public synchronized int read(ByteBuffer clearDst) throws IOException {
        int readResult;
        int bytesToRead = 4;
        if (this.reading) {
            bytesToRead = this.neededBytes;
        }
        if ((readResult = this.readAll(this.readBuffer, bytesToRead)) == -1) {
            return -1;
        }
        if (this.neededBytes > 0 && readResult > 0) {
            return this.processPartial(readResult, clearDst);
        }
        if (readResult == 0 && !this.reading) {
            return 0;
        }
        if (!this.reading) {
            this.bufLength = this.getBufLength(this.readBuffer);
        }
        this.reading = false;
        if (this.bufLength > this.readBuffer.position()) {
            this.neededBytes = this.bufLength - this.readBuffer.position() + 4;
            this.readBuffer.flip();
            this.decodeBuffer.put(this.readBuffer);
            this.readBuffer.clear();
            return 0;
        }
        this.readBuffer.flip();
        this.decodeBuffer.put(this.readBuffer);
        byte[] inBytes = this.decodeBuffer.array();
        byte[] clearBytes = this.saslContext.unwrap(inBytes, 4, this.bufLength);
        this.decodeBuffer.clear();
        clearDst.put(clearBytes);
        this.readBuffer.clear();
        return clearDst.position();
    }

    private void writeBufLen(byte[] buf, int len) {
        for (int i = 3; i >= 0; --i) {
            buf[i] = (byte)(len & 0xFF);
            len >>>= 8;
        }
    }

    private ByteBuffer wrap(byte[] clearBytes, int len) throws IOException {
        byte[] wrapBytes = this.saslContext.wrap(clearBytes, 0, len);
        byte[] outBytes = new byte[wrapBytes.length + 4];
        this.writeBufLen(outBytes, wrapBytes.length);
        System.arraycopy(wrapBytes, 0, outBytes, 4, wrapBytes.length);
        return ByteBuffer.wrap(outBytes);
    }

    public synchronized int write(ByteBuffer clearSrc) throws IOException {
        int sendBufSize = this.getAppBufSize();
        int srcLen = clearSrc.remaining();
        ByteBuffer sendBuffer = ByteBuffer.allocate(sendBufSize);
        if (srcLen > sendBufSize) {
            int oldPos;
            int curPos = oldPos = clearSrc.position();
            int curLimit = oldPos + sendBufSize;
            while (curPos < srcLen) {
                clearSrc.position(curPos);
                clearSrc.limit(curLimit);
                sendBuffer.put(clearSrc);
                this.writeChannel(this.wrap(sendBuffer.array(), clearSrc.remaining()));
                curPos = curLimit;
                curLimit = Math.min(srcLen, curPos + sendBufSize);
            }
            return srcLen;
        }
        sendBuffer.put(clearSrc);
        return this.writeChannel(this.wrap(sendBuffer.array(), srcLen));
    }

    private int writeChannel(ByteBuffer buffer) throws IOException {
        return this.channel.write(buffer);
    }

    public synchronized void close() throws IOException {
        this.saslContext.dispose();
        this.saslContext = null;
    }

    public boolean isOpen() {
        return this.saslContext != null;
    }

    public int getAppBufSize() {
        return this.saslContext.getBufSize("javax.security.sasl.maxbuffer");
    }

    public Certificate[] getClientCertificateChain() {
        return new Certificate[0];
    }

    public int getSSF() {
        return this.saslContext.getSSF();
    }

    public ByteChannel wrapChannel(ByteChannel channel) {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSecure() {
        return true;
    }
}

