/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.StartTLSExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTLSExtendedOperation
extends ExtendedOperationHandler<StartTLSExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(StartTLSExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.1466.20037", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.1466.20037");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        operation.setResponseOID("1.3.6.1.4.1.1466.20037");
        ClientConnection clientConnection = operation.getClientConnection();
        if (clientConnection == null) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            operation.appendErrorMessage(ExtensionMessages.ERR_STARTTLS_NO_CLIENT_CONNECTION.get());
            return;
        }
        if (!(clientConnection instanceof TLSCapableConnection)) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            operation.appendErrorMessage(ExtensionMessages.ERR_STARTTLS_NOT_TLS_CAPABLE.get());
            return;
        }
        TLSCapableConnection tlsCapableConnection = (TLSCapableConnection)((Object)clientConnection);
        MessageBuilder unavailableReason = new MessageBuilder();
        if (!tlsCapableConnection.isTLSAvailable(unavailableReason)) {
            operation.setResultCode(ResultCode.UNAVAILABLE);
            operation.setErrorMessage(unavailableReason);
            return;
        }
        operation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public String getExtendedOperationName() {
        return "StartTLS";
    }
}

