/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DebugMessageFormatter {
    public static String format(String msg, Object[] msgArgs) {
        StringBuilder buffer = new StringBuilder();
        Object[] decoratedArgs = DebugMessageFormatter.decorateMessageArgs(msgArgs);
        if (msg == null) {
            DebugMessageFormatter.concatenateArgs(decoratedArgs, buffer);
            return buffer.toString();
        }
        try {
            return String.format(msg, decoratedArgs);
        }
        catch (IllegalFormatException e) {
            buffer.append(msg);
            DebugMessageFormatter.concatenateArgs(decoratedArgs, buffer);
            return buffer.toString();
        }
    }

    private static void concatenateArgs(Object[] args, StringBuilder buffer) {
        for (int i = 0; args != null && i < args.length; ++i) {
            buffer.append(" ").append(args[i]);
        }
    }

    private static Object[] decorateMessageArgs(Object[] undecoratedArgs) {
        Object[] args = null;
        if (undecoratedArgs != null) {
            args = new Object[undecoratedArgs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = DebugMessageFormatter.decorateArg(undecoratedArgs[i]);
            }
        }
        return args;
    }

    private static Object decorateArg(Object arg) {
        Object decoratedArg = arg;
        if (arg instanceof Map) {
            decoratedArg = DebugMessageFormatter.decorateMapArg((Map)arg);
        } else if (arg instanceof List) {
            decoratedArg = DebugMessageFormatter.decorateListArg((List)arg);
        } else if (arg instanceof Object[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((Object[])arg);
        } else if (arg instanceof boolean[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((boolean[])arg);
        } else if (arg instanceof byte[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((byte[])arg);
        } else if (arg instanceof char[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((char[])arg);
        } else if (arg instanceof double[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((double[])arg);
        } else if (arg instanceof float[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((float[])arg);
        } else if (arg instanceof int[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((int[])arg);
        } else if (arg instanceof long[]) {
            decoratedArg = DebugMessageFormatter.decorateArrayArg((long[])arg);
        }
        return decoratedArg;
    }

    private static String decorateArrayArg(Object[] array) {
        return DebugMessageFormatter.decorateListArg(Arrays.asList(array));
    }

    private static String decorateArrayArg(boolean[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(byte[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(char[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(double[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(float[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(int[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateArrayArg(long[] array) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ ");
        boolean firstElement = true;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(array[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateListArg(List list) {
        StringBuilder buffer = new StringBuilder();
        Iterator iter = list.iterator();
        buffer.append("[ ");
        boolean firstElement = true;
        while (iter.hasNext()) {
            Object lValue = iter.next();
            if (!firstElement) {
                buffer.append(", ");
            }
            buffer.append(DebugMessageFormatter.decorateArg(lValue));
            firstElement = false;
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private static String decorateMapArg(Map map) {
        StringBuilder buffer = new StringBuilder();
        Iterator iter = map.entrySet().iterator();
        buffer.append("{ ");
        boolean firstEntry = true;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!firstEntry) {
                buffer.append(", ");
            }
            buffer.append(DebugMessageFormatter.decorateArg(entry.getKey()));
            buffer.append("=");
            buffer.append(DebugMessageFormatter.decorateArg(entry.getValue()));
            firstEntry = false;
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

