/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import org.opends.server.admin.std.server.VersionMonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.InitializationException;
import org.opends.server.util.DynamicConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMonitorProvider
extends MonitorProvider<VersionMonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String ATTR_PRODUCT_NAME = "productName";
    public static final String ATTR_SHORT_NAME = "shortName";
    public static final String ATTR_MAJOR_VERSION = "majorVersion";
    public static final String ATTR_MINOR_VERSION = "minorVersion";
    public static final String ATTR_POINT_VERSION = "pointVersion";
    public static final String ATTR_VERSION_QUALIFIER = "versionQualifier";
    public static final String ATTR_BUILD_NUMBER = "buildNumber";
    public static final String ATTR_FIX_IDS = "fixIDs";
    public static final String ATTR_REVISION_NUMBER = "revisionNumber";
    public static final String ATTR_BUILD_ID = "buildID";
    public static final String ATTR_COMPACT_VERSION = "compactVersion";
    public static final String ATTR_FULL_VERSION = "fullVersion";

    public VersionMonitorProvider() {
        super("Version Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(VersionMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Version";
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        String fixIDs;
        int buildNumber;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(12);
        attrs.add(this.createAttribute(ATTR_PRODUCT_NAME, DynamicConstants.PRODUCT_NAME));
        attrs.add(this.createAttribute(ATTR_SHORT_NAME, DynamicConstants.SHORT_NAME));
        attrs.add(this.createAttribute(ATTR_MAJOR_VERSION, String.valueOf(DynamicConstants.MAJOR_VERSION)));
        attrs.add(this.createAttribute(ATTR_MINOR_VERSION, String.valueOf(DynamicConstants.MINOR_VERSION)));
        attrs.add(this.createAttribute(ATTR_POINT_VERSION, String.valueOf(DynamicConstants.POINT_VERSION)));
        String versionQualifier = DynamicConstants.VERSION_QUALIFIER;
        if (versionQualifier != null && versionQualifier.length() > 0) {
            attrs.add(this.createAttribute(ATTR_VERSION_QUALIFIER, versionQualifier));
        }
        if ((buildNumber = DynamicConstants.BUILD_NUMBER) > 0) {
            attrs.add(this.createAttribute(ATTR_BUILD_NUMBER, String.valueOf(buildNumber)));
        }
        if ((fixIDs = DynamicConstants.FIX_IDS) != null && fixIDs.length() > 0) {
            attrs.add(this.createAttribute(ATTR_FIX_IDS, fixIDs));
        }
        attrs.add(this.createAttribute(ATTR_REVISION_NUMBER, String.valueOf(DynamicConstants.REVISION_NUMBER)));
        attrs.add(this.createAttribute(ATTR_BUILD_ID, DynamicConstants.BUILD_ID));
        attrs.add(this.createAttribute(ATTR_COMPACT_VERSION, DynamicConstants.COMPACT_VERSION_STRING));
        attrs.add(this.createAttribute(ATTR_FULL_VERSION, DynamicConstants.FULL_VERSION_STRING));
        return attrs;
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.add(AttributeValues.create(attrType, value));
        return builder.toAttribute();
    }
}

