/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.ReferentialIntegrityPluginCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.SubordinateModifyDNOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferentialIntegrityPlugin
extends DirectoryServerPlugin<ReferentialIntegrityPluginCfg>
implements ConfigurationChangeListener<ReferentialIntegrityPluginCfg>,
ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReferentialIntegrityPluginCfg currentConfiguration;
    private LinkedHashSet<AttributeType> attributeTypes = new LinkedHashSet();
    private Set<DN> baseDNs = new LinkedHashSet<DN>();
    private long interval;
    private boolean stopRequested = false;
    private final String name = "Referential Integrity Background Update Thread";
    private String logFileName;
    private File logFile;
    private Thread backGroundThread = null;
    public static final String MODIFYDN_DNS = "modifyDNs";
    private BufferedReader reader;
    private BufferedWriter writer;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, ReferentialIntegrityPluginCfg pluginCfg) throws ConfigException {
        pluginCfg.addReferentialIntegrityChangeListener(this);
        this.currentConfiguration = pluginCfg;
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case POST_OPERATION_DELETE: 
                case POST_OPERATION_MODIFY_DN: 
                case SUBORDINATE_MODIFY_DN: {
                    continue block3;
                }
            }
            throw new ConfigException(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_PLUGIN_TYPE.get(t.toString()));
        }
        Set<DN> cfgBaseDNs = pluginCfg.getBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        } else {
            this.baseDNs.addAll(cfgBaseDNs);
        }
        for (AttributeType type : pluginCfg.getAttributeType()) {
            if (!this.isAttributeSyntaxValid(type)) {
                throw new ConfigException(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_ATTRIBUTE_SYNTAX.get(type.getNameOrOID(), type.getSyntax().getSyntaxName()));
            }
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(type, IndexType.EQUALITY)) continue;
                throw new ConfigException(PluginMessages.ERR_PLUGIN_REFERENT_ATTR_UNINDEXED.get(pluginCfg.dn().toString(), type.getNameOrOID(), b.getBackendID()));
            }
            this.attributeTypes.add(type);
        }
        this.setUpLogFile(pluginCfg.getLogFile());
        this.interval = pluginCfg.getUpdateInterval();
        if (this.interval > 0L) {
            this.setUpBackGroundProcessing();
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReferentialIntegrityPluginCfg newConfiguration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        LinkedHashSet<DN> newConfiguredBaseDNs = new LinkedHashSet<DN>();
        for (DN baseDN : newConfiguration.getBaseDN()) {
            newConfiguredBaseDNs.add(baseDN);
        }
        LinkedHashSet<AttributeType> newAttributeTypes = new LinkedHashSet<AttributeType>();
        for (AttributeType type : newConfiguration.getAttributeType()) {
            newAttributeTypes.add(type);
        }
        String newLogFileName = newConfiguration.getLogFile();
        if (!this.logFileName.equals(newLogFileName)) {
            adminActionRequired = true;
            messages.add(PluginMessages.INFO_PLUGIN_REFERENT_LOGFILE_CHANGE_REQUIRES_RESTART.get(this.logFileName, newLogFileName));
        }
        this.baseDNs = newConfiguredBaseDNs;
        this.attributeTypes = newAttributeTypes;
        long newInterval = newConfiguration.getUpdateInterval();
        if (newConfiguration.isEnabled() && newInterval != this.interval) {
            this.processIntervalChange(newInterval, messages);
        }
        this.currentConfiguration = newConfiguration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        ReferentialIntegrityPluginCfg cfg = (ReferentialIntegrityPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReferentialIntegrityPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case POSTOPERATIONDELETE: 
                case POSTOPERATIONMODIFYDN: 
                case SUBORDINATEMODIFYDN: {
                    continue block3;
                }
            }
            unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_PLUGIN_TYPE.get(pluginType.toString()));
            configAcceptable = false;
        }
        Set<DN> cfgBaseDNs = configuration.getBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        } else {
            this.baseDNs.addAll(cfgBaseDNs);
        }
        for (AttributeType type : configuration.getAttributeType()) {
            if (!this.isAttributeSyntaxValid(type)) {
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_ATTRIBUTE_SYNTAX.get(type.getNameOrOID(), type.getSyntax().getSyntaxName()));
                configAcceptable = false;
            }
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(type, IndexType.EQUALITY)) continue;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_ATTR_UNINDEXED.get(configuration.dn().toString(), type.getNameOrOID(), b.getBackendID()));
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        if (modifyDNOperation.getResultCode() != ResultCode.SUCCESS) {
            return PluginResult.PostOperation.continueOperationProcessing();
        }
        if (modifyDNOperation.getNewSuperior() == null) {
            DN oldEntryDN = modifyDNOperation.getOriginalEntry().getDN();
            DN newEntryDN = modifyDNOperation.getUpdatedEntry().getDN();
            LinkedHashMap<DN, DN> modDNmap = new LinkedHashMap<DN, DN>();
            modDNmap.put(oldEntryDN, newEntryDN);
            this.processModifyDN(modDNmap, this.interval != 0L);
        } else {
            Map modDNmap = (Map)modifyDNOperation.getAttachment(MODIFYDN_DNS);
            this.processModifyDN(modDNmap, this.interval != 0L);
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        if (deleteOperation.getResultCode() != ResultCode.SUCCESS) {
            return PluginResult.PostOperation.continueOperationProcessing();
        }
        this.processDelete(deleteOperation.getEntryDN(), this.interval != 0L);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.SubordinateModifyDN processSubordinateModifyDN(SubordinateModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry, List<Modification> modifications) {
        LinkedHashMap<DN, DN> modDNmap = (LinkedHashMap<DN, DN>)modifyDNOperation.getAttachment(MODIFYDN_DNS);
        if (modDNmap == null) {
            modDNmap = new LinkedHashMap<DN, DN>();
            modifyDNOperation.setAttachment(MODIFYDN_DNS, modDNmap);
        }
        modDNmap.put(oldEntry.getDN(), newEntry.getDN());
        return PluginResult.SubordinateModifyDN.continueOperationProcessing();
    }

    private boolean isAttributeSyntaxValid(AttributeType attribute) {
        return attribute.getSyntaxOID().equals("1.3.6.1.4.1.1466.115.121.1.12") || attribute.getSyntaxOID().equals("1.3.6.1.4.1.1466.115.121.1.34");
    }

    private void processIntervalChange(long newInterval, ArrayList<Message> msgs) {
        if (this.interval == 0L) {
            DirectoryServer.registerShutdownListener(this);
            this.interval = newInterval;
            msgs.add(PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_STARTING.get(Long.toString(this.interval)));
            this.setUpBackGroundProcessing();
        } else if (newInterval == 0L) {
            Message message = PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_STOPPING.get();
            msgs.add(message);
            this.processServerShutdown(message);
            this.interval = newInterval;
        } else {
            this.interval = newInterval;
            this.backGroundThread.interrupt();
            msgs.add(PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_UPDATE_INTERVAL_CHANGED.get(Long.toString(this.interval), Long.toString(newInterval)));
        }
    }

    private void processModifyDN(Map<DN, DN> modDNMap, boolean log) {
        if (modDNMap != null) {
            if (log) {
                this.writeLog(modDNMap);
            } else {
                for (DN baseDN : this.getBaseDNsToSearch()) {
                    this.doBaseDN(baseDN, modDNMap);
                }
            }
        }
    }

    private void processDelete(DN entryDN, boolean log) {
        if (log) {
            this.writeLog(entryDN);
        } else {
            for (DN baseDN : this.getBaseDNsToSearch()) {
                this.searchBaseDN(baseDN, entryDN, null);
            }
        }
    }

    private void processModifyDN(DN oldEntryDN, DN newEntryDN) {
        for (DN baseDN : this.getBaseDNsToSearch()) {
            this.searchBaseDN(baseDN, oldEntryDN, newEntryDN);
        }
    }

    private Set<DN> getBaseDNsToSearch() {
        if (this.baseDNs.isEmpty()) {
            return DirectoryServer.getPublicNamingContexts().keySet();
        }
        return this.baseDNs;
    }

    private void searchBaseDN(DN baseDN, DN oldEntryDN, DN newEntryDN) {
        HashSet<SearchFilter> componentFilters = new HashSet<SearchFilter>();
        for (AttributeType attributeType : this.attributeTypes) {
            componentFilters.add(SearchFilter.createEqualityFilter(attributeType, AttributeValues.create(attributeType, oldEntryDN.toString())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        InternalSearchOperation operation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createORFilter(componentFilters), null);
        switch (operation.getResultCode()) {
            case SUCCESS: {
                break;
            }
            case NO_SUCH_OBJECT: {
                ErrorLogger.logError(PluginMessages.INFO_PLUGIN_REFERENT_SEARCH_NO_SUCH_OBJECT.get(baseDN.toString()));
                return;
            }
            default: {
                Message message1 = PluginMessages.ERR_PLUGIN_REFERENT_SEARCH_FAILED.get(String.valueOf(operation.getErrorMessage()));
                ErrorLogger.logError(message1);
                return;
            }
        }
        for (SearchResultEntry entry : operation.getSearchEntries()) {
            this.deleteAddAttributesEntry(entry, oldEntryDN, newEntryDN);
        }
    }

    private void doBaseDN(DN baseDN, Map<DN, DN> modifyDNmap) {
        for (Map.Entry<DN, DN> mapEntry : modifyDNmap.entrySet()) {
            this.searchBaseDN(baseDN, mapEntry.getKey(), mapEntry.getValue());
        }
    }

    private void deleteAddAttributesEntry(Entry e, DN oldEntryDN, DN newEntryDN) {
        LinkedList<Modification> mods = new LinkedList<Modification>();
        DN entryDN = e.getDN();
        for (AttributeType type : this.attributeTypes) {
            AttributeValue value;
            if (!e.hasAttribute(type) || !e.hasValue(type, null, value = AttributeValues.create(type, oldEntryDN.toString()))) continue;
            mods.add(new Modification(ModificationType.DELETE, Attributes.create(type, value)));
            if (newEntryDN == null) continue;
            mods.add(new Modification(ModificationType.ADD, Attributes.create(type, newEntryDN.toString())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyOperation modifyOperation = conn.processModify(entryDN, mods);
        if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
            ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_MODIFY_FAILED.get(entryDN.toString(), String.valueOf(modifyOperation.getErrorMessage())));
        }
    }

    private void setUpLogFile(String logFileName) throws ConfigException {
        this.logFileName = logFileName;
        this.logFile = StaticUtils.getFileForPath(logFileName);
        try {
            if (!this.logFile.exists()) {
                this.logFile.createNewFile();
            }
        }
        catch (IOException io) {
            throw new ConfigException(PluginMessages.ERR_PLUGIN_REFERENT_CREATE_LOGFILE.get(io.getMessage()), (Throwable)io);
        }
    }

    private void setupWriter() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.logFile, true));
    }

    private void setupReader() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.logFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(Map<DN, DN> modDNmap) {
        File file = this.logFile;
        synchronized (file) {
            try {
                this.setupWriter();
                for (Map.Entry<DN, DN> mapEntry : modDNmap.entrySet()) {
                    this.writer.write(mapEntry.getKey().toNormalizedString() + "\t" + mapEntry.getValue().toNormalizedString());
                    this.writer.newLine();
                }
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_CLOSE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(DN deletedEntryDN) {
        File file = this.logFile;
        synchronized (file) {
            try {
                this.setupWriter();
                this.writer.write(deletedEntryDN.toNormalizedString());
                this.writer.newLine();
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_CLOSE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLog() {
        File file = this.logFile;
        synchronized (file) {
            try {
                String line;
                if (this.logFile.length() == 0L) {
                    return;
                }
                this.setupReader();
                while ((line = this.reader.readLine()) != null) {
                    try {
                        String[] a = line.split("[\t]");
                        DN origDn = DN.decode(a[0]);
                        if (a.length == 1) {
                            this.processDelete(origDn, false);
                            continue;
                        }
                        DN movedDN = DN.decode(a[1]);
                        this.processModifyDN(origDn, movedDN);
                    }
                    catch (DirectoryException ex) {
                        Message message = PluginMessages.ERR_PLUGIN_REFERENT_CANNOT_DECODE_STRING_AS_DN.get(ex.getMessage());
                        ErrorLogger.logError(message);
                    }
                }
                this.reader.close();
                this.logFile.delete();
                this.logFile.createNewFile();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_REPLACE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    @Override
    public String getShutdownListenerName() {
        return "Referential Integrity Background Update Thread";
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfiguration.removeReferentialIntegrityChangeListener(this);
        if (this.interval > 0L) {
            this.processServerShutdown(null);
        }
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.stopRequested = true;
        while (this.backGroundThread != null && this.backGroundThread.isAlive()) {
            try {
                this.backGroundThread.interrupt();
                this.backGroundThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DirectoryServer.deregisterShutdownListener(this);
        this.backGroundThread = null;
    }

    private long getInterval() {
        return this.interval * 1000L;
    }

    private void setUpBackGroundProcessing() {
        if (this.backGroundThread == null) {
            DirectoryServer.registerShutdownListener(this);
            this.stopRequested = false;
            this.backGroundThread = new BackGroundThread();
            this.backGroundThread.start();
        }
    }

    private boolean isShuttingDown() {
        return this.stopRequested;
    }

    private class BackGroundThread
    extends DirectoryThread {
        public BackGroundThread() {
            super("Referential Integrity Background Update Thread");
        }

        public void run() {
            while (!ReferentialIntegrityPlugin.this.isShuttingDown()) {
                block4: {
                    try {
                        BackGroundThread.sleep(ReferentialIntegrityPlugin.this.getInterval());
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block4;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                ReferentialIntegrityPlugin.this.processLog();
            }
        }
    }
}

