/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDIFConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.HostPort;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFConnectionHandler
extends ConnectionHandler<LDIFConnectionHandlerCfg>
implements ConfigurationChangeListener<LDIFConnectionHandlerCfg>,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile boolean isStopped = true;
    private volatile boolean stopRequested = false;
    private File ldifDirectory;
    private InternalClientConnection conn;
    private LDIFConnectionHandlerCfg currentConfig;
    private Thread connectionHandlerThread = null;
    private boolean alreadyWarn = false;

    public LDIFConnectionHandler() {
        super("LDIFConnectionHandler");
    }

    @Override
    public void initializeConnectionHandler(LDIFConnectionHandlerCfg configuration) {
        String ldifDirectoryPath = configuration.getLDIFDirectory();
        this.ldifDirectory = new File(ldifDirectoryPath);
        if (!this.ldifDirectory.isAbsolute()) {
            this.ldifDirectory = new File(DirectoryServer.getInstanceRoot() + File.separator + ldifDirectoryPath);
        }
        if (this.ldifDirectory.exists()) {
            if (!this.ldifDirectory.isDirectory()) {
                ErrorLogger.logError(ProtocolMessages.WARN_LDIF_CONNHANDLER_LDIF_DIRECTORY_NOT_DIRECTORY.get(this.ldifDirectory.getAbsolutePath(), configuration.dn().toString()));
            }
        } else {
            ErrorLogger.logError(ProtocolMessages.WARN_LDIF_CONNHANDLER_LDIF_DIRECTORY_MISSING.get(this.ldifDirectory.getAbsolutePath(), configuration.dn().toString()));
        }
        this.currentConfig = configuration;
        this.currentConfig.addLDIFChangeListener(this);
        DirectoryConfig.registerAlertGenerator(this);
        this.conn = InternalClientConnection.getRootConnection();
    }

    @Override
    public void finalizeConnectionHandler(Message finalizeReason) {
        this.stopRequested = true;
        for (int i = 0; i < 5; ++i) {
            if (this.isStopped) {
                return;
            }
            try {
                if (this.connectionHandlerThread == null || !this.connectionHandlerThread.isAlive()) {
                    return;
                }
                this.connectionHandlerThread.join(100L);
                this.connectionHandlerThread.interrupt();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getConnectionHandlerName() {
        return "LDIF Connection Handler";
    }

    @Override
    public String getProtocol() {
        return "LDIF";
    }

    @Override
    public Collection<HostPort> getListeners() {
        return Collections.emptySet();
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.isStopped = false;
        this.connectionHandlerThread = Thread.currentThread();
        try {
            while (!this.stopRequested) {
                try {
                    long startTime = System.currentTimeMillis();
                    File dir = this.ldifDirectory;
                    if (dir.exists() && dir.isDirectory()) {
                        File[] ldifFiles = dir.listFiles();
                        if (ldifFiles != null) {
                            for (File f : ldifFiles) {
                                if (!f.getName().endsWith(".ldif")) continue;
                                this.processLDIFFile(f);
                            }
                        }
                    } else if (!this.alreadyWarn && DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("LDIF connection handler directory " + dir.getAbsolutePath() + " doesn't exist or isn't a directory");
                        this.alreadyWarn = true;
                    }
                    if (this.stopRequested) continue;
                    long currentTime = System.currentTimeMillis();
                    long sleepTime = startTime + this.currentConfig.getPollInterval() - currentTime;
                    if (sleepTime <= 0L) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            return;
        }
        finally {
            this.connectionHandlerThread = null;
            this.isStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLDIFFile(File ldifFile) {
        Message m;
        Message m2;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Beginning processing on LDIF file " + ldifFile.getAbsolutePath());
        }
        boolean fullyProcessed = false;
        boolean errorEncountered = false;
        String inputPath = ldifFile.getAbsolutePath();
        LDIFImportConfig importConfig = new LDIFImportConfig(inputPath);
        importConfig.setInvokeImportPlugins(false);
        importConfig.setValidateSchema(true);
        String outputPath = inputPath + ".applied." + TimeThread.getGMTTime();
        if (new File(outputPath).exists()) {
            int i = 2;
            while (true) {
                if (!new File(outputPath + "." + i).exists()) {
                    outputPath = outputPath + "." + i;
                    break;
                }
                ++i;
            }
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(outputPath, ExistingFileBehavior.APPEND);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Creating applied file " + outputPath);
        }
        LDIFReader reader = null;
        LDIFWriter writer = null;
        try {
            reader = new LDIFReader(importConfig);
            writer = new LDIFWriter(exportConfig);
            while (true) {
                ChangeRecordEntry changeRecord;
                block58: {
                    try {
                        changeRecord = reader.readChangeRecord(false);
                        if (!DebugLogger.debugEnabled()) break block58;
                        TRACER.debugInfo("Read change record entry " + String.valueOf(changeRecord));
                    }
                    catch (LDIFException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        errorEncountered = true;
                        if (le.canContinueReading()) {
                            m2 = ProtocolMessages.ERR_LDIF_CONNHANDLER_CANNOT_READ_CHANGE_RECORD_NONFATAL.get(le.getMessageObject());
                            writer.writeComment(m2, 78);
                            continue;
                        }
                        m2 = ProtocolMessages.ERR_LDIF_CONNHANDLER_CANNOT_READ_CHANGE_RECORD_FATAL.get(le.getMessageObject());
                        writer.writeComment(m2, 78);
                        DirectoryConfig.sendAlertNotification(this, "org.opends.server.LDIFConnectionHandlerParseError", m2);
                        break;
                    }
                }
                Operation operation = null;
                if (changeRecord == null) {
                    fullyProcessed = true;
                    break;
                }
                if (changeRecord instanceof AddChangeRecordEntry) {
                    operation = this.conn.processAdd((AddChangeRecordEntry)changeRecord);
                } else if (changeRecord instanceof DeleteChangeRecordEntry) {
                    operation = this.conn.processDelete((DeleteChangeRecordEntry)changeRecord);
                } else if (changeRecord instanceof ModifyChangeRecordEntry) {
                    operation = this.conn.processModify((ModifyChangeRecordEntry)changeRecord);
                } else if (changeRecord instanceof ModifyDNChangeRecordEntry) {
                    operation = this.conn.processModifyDN((ModifyDNChangeRecordEntry)changeRecord);
                }
                if (operation == null) {
                    m2 = ProtocolMessages.INFO_LDIF_CONNHANDLER_UNKNOWN_CHANGETYPE.get(changeRecord.getChangeOperationType().getLDIFChangeType());
                    writer.writeComment(m2, 78);
                } else {
                    List<String> referralURLs;
                    DN matchedDN;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Result Code:  " + operation.getResultCode().toString());
                    }
                    m2 = ProtocolMessages.INFO_LDIF_CONNHANDLER_RESULT_CODE.get(operation.getResultCode().getIntValue(), operation.getResultCode().toString());
                    writer.writeComment(m2, 78);
                    MessageBuilder errorMessage = operation.getErrorMessage();
                    if (errorMessage != null && errorMessage.length() > 0) {
                        m2 = ProtocolMessages.INFO_LDIF_CONNHANDLER_ERROR_MESSAGE.get(errorMessage);
                        writer.writeComment(m2, 78);
                    }
                    if ((matchedDN = operation.getMatchedDN()) != null) {
                        m2 = ProtocolMessages.INFO_LDIF_CONNHANDLER_MATCHED_DN.get(matchedDN.toString());
                        writer.writeComment(m2, 78);
                    }
                    if ((referralURLs = operation.getReferralURLs()) != null && !referralURLs.isEmpty()) {
                        for (String url : referralURLs) {
                            m2 = ProtocolMessages.INFO_LDIF_CONNHANDLER_REFERRAL_URL.get(url);
                            writer.writeComment(m2, 78);
                        }
                    }
                }
                writer.writeChangeRecord(changeRecord);
            }
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            fullyProcessed = false;
            m = ProtocolMessages.ERR_LDIF_CONNHANDLER_IO_ERROR.get(inputPath, StaticUtils.getExceptionMessage(ioe));
            ErrorLogger.logError(m);
            DirectoryConfig.sendAlertNotification(this, "org.opends.server.LDIFConnectionHandlerParseError", m);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        if (errorEncountered || !fullyProcessed) {
            String renamedPath = inputPath + ".errors-encountered." + TimeThread.getGMTTime();
            if (new File(renamedPath).exists()) {
                int i = 2;
                while (true) {
                    if (!new File(renamedPath + "." + i).exists()) {
                        renamedPath = renamedPath + "." + i;
                    }
                    ++i;
                }
            }
            try {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Renaming source file to " + renamedPath);
                }
                ldifFile.renameTo(new File(renamedPath));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                m2 = ProtocolMessages.ERR_LDIF_CONNHANDLER_CANNOT_RENAME.get(inputPath, renamedPath, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(m2);
                DirectoryConfig.sendAlertNotification(this, "org.opends.server.LDIFConnectionHandlerIOError", m2);
            }
        } else {
            try {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Deleting source file");
                }
                ldifFile.delete();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                m = ProtocolMessages.ERR_LDIF_CONNHANDLER_CANNOT_DELETE.get(inputPath, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(m);
                DirectoryConfig.sendAlertNotification(this, "org.opends.server.LDIFConnectionHandlerIOError", m);
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDIFConnectionHandler(ldifDirectory=\"");
        buffer.append(this.ldifDirectory.getAbsolutePath());
        buffer.append("\", pollInterval=");
        buffer.append(this.currentConfig.getPollInterval());
        buffer.append("ms)");
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        LDIFConnectionHandlerCfg cfg = (LDIFConnectionHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDIFConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDIFConnectionHandlerCfg configuration) {
        File newLDIFDirectory;
        this.ldifDirectory = newLDIFDirectory = new File(configuration.getLDIFDirectory());
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getClassName() {
        return LDIFConnectionHandler.class.getName();
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.LDIFConnectionHandlerParseError", "This alert type will be used to provide notification that the LDIF connection handler encountered an unrecoverable error while attempting to parse an LDIF file.");
        alerts.put("org.opends.server.LDIFConnectionHandlerIOError", "This alert type will be used to provide notification that the LDIF connection handler encountered an I/O error that prevented it from completing its processing.");
        return alerts;
    }
}

