/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.protocols.asn1.ASN1OutputStreamWriter;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteSequence;

final class ASN1ByteChannelWriter
implements ASN1Writer {
    private final WritableByteChannel byteChannel;
    private final ASN1OutputStreamWriter writer;
    private final ByteBuffer byteBuffer;
    private final ReentrantLock flushLock;

    ASN1ByteChannelWriter(WritableByteChannel byteChannel, int writeBufferSize) {
        this.byteChannel = byteChannel;
        this.byteBuffer = ByteBuffer.allocate(writeBufferSize);
        this.flushLock = new ReentrantLock(false);
        ByteBufferOutputStream bufferStream = new ByteBufferOutputStream();
        this.writer = new ASN1OutputStreamWriter(bufferStream);
    }

    public ASN1Writer writeBoolean(boolean booleanValue) throws IOException {
        this.writer.writeBoolean(booleanValue);
        return this;
    }

    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.writer.writeBoolean(type, booleanValue);
        return this;
    }

    public ASN1Writer writeEndSet() throws IOException {
        this.writer.writeEndSet();
        return this;
    }

    public ASN1Writer writeEndSequence() throws IOException {
        this.writer.writeEndSequence();
        return this;
    }

    public ASN1Writer writeInteger(int intValue) throws IOException {
        this.writer.writeInteger(intValue);
        return this;
    }

    public ASN1Writer writeInteger(long longValue) throws IOException {
        this.writer.writeInteger(longValue);
        return this;
    }

    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.writer.writeInteger(type, intValue);
        return this;
    }

    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.writer.writeInteger(type, longValue);
        return this;
    }

    public ASN1Writer writeEnumerated(int intValue) throws IOException {
        this.writer.writeEnumerated(intValue);
        return this;
    }

    public ASN1Writer writeNull() throws IOException {
        this.writer.writeNull();
        return this;
    }

    public ASN1Writer writeNull(byte type) throws IOException {
        this.writer.writeNull(type);
        return this;
    }

    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.writer.writeOctetString(type, value, offset, length);
        return this;
    }

    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.writer.writeOctetString(type, value);
        return this;
    }

    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.writer.writeOctetString(type, value);
        return this;
    }

    public ASN1Writer writeOctetString(byte[] value, int offset, int length) throws IOException {
        this.writer.writeOctetString(value, offset, length);
        return this;
    }

    public ASN1Writer writeOctetString(ByteSequence value) throws IOException {
        this.writer.writeOctetString(value);
        return this;
    }

    public ASN1Writer writeOctetString(String value) throws IOException {
        this.writer.writeOctetString(value);
        return this;
    }

    public ASN1Writer writeStartSequence() throws IOException {
        this.writer.writeStartSequence();
        return this;
    }

    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.writer.writeStartSequence(type);
        return this;
    }

    public ASN1Writer writeStartSet() throws IOException {
        this.writer.writeStartSet();
        return this;
    }

    public ASN1Writer writeStartSet(byte type) throws IOException {
        this.writer.writeStartSet(type);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.byteBuffer.flip();
        try {
            if (!this.flushLock.isHeldByCurrentThread()) {
                this.flushLock.lock();
            }
            this.byteChannel.write(this.byteBuffer);
        }
        finally {
            this.flushLock.unlock();
        }
        this.byteBuffer.clear();
    }

    private void lockAndFlush() throws IOException {
        this.byteBuffer.flip();
        if (!this.flushLock.isHeldByCurrentThread()) {
            this.flushLock.lock();
        }
        while (this.byteBuffer.hasRemaining()) {
            this.byteChannel.write(this.byteBuffer);
        }
        this.byteBuffer.clear();
    }

    public void close() throws IOException {
        this.writer.close();
        this.flush();
        this.byteChannel.close();
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private ByteBufferOutputStream() {
        }

        public void write(int i) throws IOException {
            if (!ASN1ByteChannelWriter.this.byteBuffer.hasRemaining()) {
                ASN1ByteChannelWriter.this.lockAndFlush();
            }
            ASN1ByteChannelWriter.this.byteBuffer.put((byte)i);
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] bytes, int i, int i1) throws IOException {
            if (i < 0 || i1 < 0 || i + i1 > bytes.length) {
                throw new IndexOutOfBoundsException();
            }
            int bytesToWrite = i1;
            while (bytesToWrite > 0) {
                int len = ASN1ByteChannelWriter.this.byteBuffer.remaining();
                if (len < bytesToWrite) {
                    ASN1ByteChannelWriter.this.byteBuffer.put(bytes, i + i1 - bytesToWrite, len);
                    bytesToWrite -= len;
                    ASN1ByteChannelWriter.this.lockAndFlush();
                    continue;
                }
                ASN1ByteChannelWriter.this.byteBuffer.put(bytes, i + i1 - bytesToWrite, bytesToWrite);
                bytesToWrite = 0;
            }
        }
    }
}

