/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.internal.InternalLDAPSocket;
import org.opends.server.protocols.internal.NullLDAPMessage;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class InternalLDAPInputStream
extends InputStream {
    private final ArrayBlockingQueue<LDAPMessage> messageQueue;
    private boolean closed;
    private final ByteStringBuilder messageBuffer;
    private final ByteSequenceReader messageReader;
    private final ASN1Writer writer;
    private final InternalLDAPSocket socket;

    public InternalLDAPInputStream(InternalLDAPSocket socket) {
        this.socket = socket;
        this.messageQueue = new ArrayBlockingQueue(10);
        this.messageBuffer = new ByteStringBuilder();
        this.messageReader = this.messageBuffer.asReader();
        this.writer = ASN1.getWriter(this.messageBuffer);
        this.closed = false;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void addLDAPMessage(LDAPMessage message) {
        if (this.closed) {
            return;
        }
        try {
            this.messageQueue.put(message);
            return;
        }
        catch (Exception e) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.messageQueue.put(message);
                    break;
                }
                catch (Exception e2) {
                    continue;
                }
            }
            return;
        }
    }

    public synchronized int available() throws IOException {
        if (this.messageReader.remaining() < 1) {
            LDAPMessage message = this.messageQueue.poll();
            if (message == null || message instanceof NullLDAPMessage) {
                if (message != null) {
                    this.messageQueue.clear();
                    this.closed = true;
                }
                return 0;
            }
            this.messageBuffer.clear();
            this.messageReader.rewind();
            message.write(this.writer);
        }
        return this.messageReader.remaining();
    }

    public void close() {
        this.socket.close();
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void closeInternal() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        NullLDAPMessage nullMessage = new NullLDAPMessage();
        while (!this.messageQueue.offer(nullMessage)) {
            this.messageQueue.clear();
        }
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.messageReader.remaining() < 1) {
            LDAPMessage message;
            try {
                message = this.messageQueue.take();
            }
            catch (InterruptedException ie) {
                message = new NullLDAPMessage();
            }
            if (message == null || message instanceof NullLDAPMessage) {
                if (message instanceof NullLDAPMessage) {
                    this.messageQueue.clear();
                    this.closed = true;
                    return -1;
                }
                return 0;
            }
            this.messageBuffer.clear();
            this.messageReader.rewind();
            message.write(this.writer);
        }
        return 0xFF & this.messageReader.get();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.messageReader.remaining() < 1) {
            LDAPMessage message;
            try {
                message = this.messageQueue.take();
            }
            catch (InterruptedException ie) {
                message = new NullLDAPMessage();
            }
            if (message == null || message instanceof NullLDAPMessage) {
                if (message instanceof NullLDAPMessage) {
                    this.messageQueue.clear();
                    this.closed = true;
                    return -1;
                }
                return 0;
            }
            this.messageBuffer.clear();
            this.messageReader.rewind();
            message.write(this.writer);
        }
        int actualLen = Math.min(len, this.messageReader.remaining());
        this.messageReader.get(b, off, actualLen);
        return actualLen;
    }

    public void reset() {
    }

    public synchronized long skip(long n) throws IOException {
        long totalBytesRead;
        int bytesRead;
        byte[] b = n > 8192L ? new byte[8192] : new byte[(int)n];
        for (totalBytesRead = 0L; totalBytesRead < n; totalBytesRead += (long)bytesRead) {
            int maxLen = (int)Math.min(n - totalBytesRead, (long)b.length);
            bytesRead = this.read(b, 0, maxLen);
            if (bytesRead >= 0) continue;
            if (totalBytesRead > 0L) {
                return totalBytesRead;
            }
            return bytesRead;
        }
        return totalBytesRead;
    }

    public String toString() {
        return "InternalLDAPInputStream";
    }
}

