/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ProtocolElement;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.types.Control;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPMessage
implements ProtocolElement {
    private List<Control> controls;
    private final int messageID;
    private final ProtocolOp protocolOp;

    public LDAPMessage(int messageID, ProtocolOp protocolOp) {
        this(messageID, protocolOp, null);
    }

    public LDAPMessage(int messageID, ProtocolOp protocolOp, List<Control> controls) {
        this.messageID = messageID;
        this.protocolOp = protocolOp;
        this.controls = controls;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public ProtocolOp getProtocolOp() {
        return this.protocolOp;
    }

    public byte getProtocolOpType() {
        return this.protocolOp.getType();
    }

    public String getProtocolOpName() {
        return this.protocolOp.getProtocolOpName();
    }

    public AbandonRequestProtocolOp getAbandonRequestProtocolOp() throws ClassCastException {
        return (AbandonRequestProtocolOp)this.protocolOp;
    }

    public AddRequestProtocolOp getAddRequestProtocolOp() throws ClassCastException {
        return (AddRequestProtocolOp)this.protocolOp;
    }

    public AddResponseProtocolOp getAddResponseProtocolOp() throws ClassCastException {
        return (AddResponseProtocolOp)this.protocolOp;
    }

    public BindRequestProtocolOp getBindRequestProtocolOp() throws ClassCastException {
        return (BindRequestProtocolOp)this.protocolOp;
    }

    public BindResponseProtocolOp getBindResponseProtocolOp() throws ClassCastException {
        return (BindResponseProtocolOp)this.protocolOp;
    }

    public CompareRequestProtocolOp getCompareRequestProtocolOp() throws ClassCastException {
        return (CompareRequestProtocolOp)this.protocolOp;
    }

    public CompareResponseProtocolOp getCompareResponseProtocolOp() throws ClassCastException {
        return (CompareResponseProtocolOp)this.protocolOp;
    }

    public DeleteRequestProtocolOp getDeleteRequestProtocolOp() throws ClassCastException {
        return (DeleteRequestProtocolOp)this.protocolOp;
    }

    public DeleteResponseProtocolOp getDeleteResponseProtocolOp() throws ClassCastException {
        return (DeleteResponseProtocolOp)this.protocolOp;
    }

    public ExtendedRequestProtocolOp getExtendedRequestProtocolOp() throws ClassCastException {
        return (ExtendedRequestProtocolOp)this.protocolOp;
    }

    public ExtendedResponseProtocolOp getExtendedResponseProtocolOp() throws ClassCastException {
        return (ExtendedResponseProtocolOp)this.protocolOp;
    }

    public ModifyRequestProtocolOp getModifyRequestProtocolOp() throws ClassCastException {
        return (ModifyRequestProtocolOp)this.protocolOp;
    }

    public ModifyResponseProtocolOp getModifyResponseProtocolOp() throws ClassCastException {
        return (ModifyResponseProtocolOp)this.protocolOp;
    }

    public ModifyDNRequestProtocolOp getModifyDNRequestProtocolOp() throws ClassCastException {
        return (ModifyDNRequestProtocolOp)this.protocolOp;
    }

    public ModifyDNResponseProtocolOp getModifyDNResponseProtocolOp() throws ClassCastException {
        return (ModifyDNResponseProtocolOp)this.protocolOp;
    }

    public SearchRequestProtocolOp getSearchRequestProtocolOp() throws ClassCastException {
        return (SearchRequestProtocolOp)this.protocolOp;
    }

    public SearchResultDoneProtocolOp getSearchResultDoneProtocolOp() throws ClassCastException {
        return (SearchResultDoneProtocolOp)this.protocolOp;
    }

    public SearchResultEntryProtocolOp getSearchResultEntryProtocolOp() throws ClassCastException {
        return (SearchResultEntryProtocolOp)this.protocolOp;
    }

    public SearchResultReferenceProtocolOp getSearchResultReferenceProtocolOp() throws ClassCastException {
        return (SearchResultReferenceProtocolOp)this.protocolOp;
    }

    public UnbindRequestProtocolOp getUnbindRequestProtocolOp() throws ClassCastException {
        return (UnbindRequestProtocolOp)this.protocolOp;
    }

    public List<Control> getControls() {
        if (this.controls == null) {
            this.controls = new ArrayList<Control>(0);
        }
        return this.controls;
    }

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence();
        stream.writeInteger(this.messageID);
        this.protocolOp.write(stream);
        if (this.controls != null && !this.controls.isEmpty()) {
            stream.writeStartSequence((byte)-96);
            for (Control control : this.controls) {
                control.write(stream);
            }
            stream.writeEndSequence();
        }
        stream.writeEndSequence();
    }

    @Override
    public String getProtocolElementName() {
        return "LDAP";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPMessage(msgID=");
        buffer.append(this.messageID);
        buffer.append(", protocolOp=");
        if (this.protocolOp != null) {
            this.protocolOp.toString(buffer);
        } else {
            buffer.append("null");
        }
        if (this.controls != null && !this.controls.isEmpty()) {
            buffer.append(", controls={ ");
            Iterator<Control> iterator = this.controls.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
            buffer.append(" }");
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Message");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Message ID:  ");
        buffer.append(this.messageID);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Protocol Op:");
        buffer.append(ServerConstants.EOL);
        this.protocolOp.toString(buffer, indent + 4);
        if (this.controls != null && !this.controls.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Controls:");
            for (Control c : this.controls) {
                c.toString(buffer);
            }
        }
    }
}

