/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private Message errorMessage;

    public ModifyResponseProtocolOp(int resultCode) {
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public ModifyResponseProtocolOp(int resultCode, Message errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public ModifyResponseProtocolOp(int resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getType() {
        return 103;
    }

    @Override
    public String getProtocolOpName() {
        return "Modify Response";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)103);
        stream.writeEnumerated(this.resultCode);
        if (this.matchedDN == null) {
            stream.writeOctetString((String)null);
        } else {
            stream.writeOctetString(this.matchedDN.toString());
        }
        if (this.errorMessage == null) {
            stream.writeOctetString((String)null);
        } else {
            stream.writeOctetString(this.errorMessage.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stream.writeStartSequence((byte)-93);
            for (String s : this.referralURLs) {
                stream.writeOctetString(s);
            }
            stream.writeEndSequence();
        }
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyResponse(resultCode=");
        buffer.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            buffer.append(", errorMessage=");
            buffer.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN=");
            buffer.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            buffer.append("}");
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify Response");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Result Code:  ");
        buffer.append(this.resultCode);
        buffer.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Error Message:  ");
            buffer.append(this.errorMessage);
            buffer.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Matched DN:  ");
            this.matchedDN.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Referral URLs:  ");
            buffer.append(ServerConstants.EOL);
            for (String s : this.referralURLs) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  ");
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

