/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReferenceProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<String> referralURLs;

    public SearchResultReferenceProtocolOp(List<String> referralURLs) {
        this.referralURLs = referralURLs == null ? new ArrayList<String>() : referralURLs;
    }

    public SearchResultReferenceProtocolOp(SearchResultReference searchReference) {
        this.referralURLs = searchReference.getReferralURLs();
        if (this.referralURLs == null) {
            this.referralURLs = new ArrayList<String>();
        }
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getType() {
        return 115;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Result Reference";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)115);
        for (String url : this.referralURLs) {
            stream.writeOctetString(url);
        }
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchReference(referralURLs={");
        if (!this.referralURLs.isEmpty()) {
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Result Reference");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Referral URLs:");
        buffer.append(ServerConstants.EOL);
        for (String url : this.referralURLs) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("    ");
            buffer.append(url);
            buffer.append(ServerConstants.EOL);
        }
    }
}

