/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDomainServerState
implements Iterable<String> {
    private TreeMap<String, ServerState> list = new TreeMap();

    public MultiDomainServerState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MultiDomainServerState multiDomainServerState = this;
        synchronized (multiDomainServerState) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String serviceId, ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return false;
        }
        MultiDomainServerState multiDomainServerState = this;
        synchronized (multiDomainServerState) {
            int serverId = changeNumber.getServerId();
            ServerState oldServerState = this.list.get(serviceId);
            if (oldServerState == null) {
                oldServerState = new ServerState();
            }
            if (changeNumber.newer(oldServerState.getMaxChangeNumber(serverId))) {
                oldServerState.update(changeNumber);
                this.list.put(serviceId, oldServerState);
                return true;
            }
            return false;
        }
    }

    public void update(String serviceId, ServerState serverState) {
        this.list.put(serviceId, serverState.duplicate());
    }

    public MultiDomainServerState(String mdss) {
        if (mdss != null && mdss.length() > 0) {
            String[] domains;
            for (String domain : domains = mdss.split(";")) {
                String[] fields = domain.split(":");
                String name = fields[0];
                ServerState ss = new ServerState();
                if (fields.length > 1) {
                    String[] strCN;
                    String strState = fields[1].trim();
                    for (String sr : strCN = strState.split(" ")) {
                        ChangeNumber fromChangeNumber = new ChangeNumber(sr);
                        ss.update(fromChangeNumber);
                    }
                }
                this.list.put(name, ss);
            }
        }
    }

    public String toString() {
        String res = "";
        if (this.list != null && !this.list.isEmpty()) {
            for (String serviceId : this.list.keySet()) {
                ServerState ss = this.list.get(serviceId);
                res = res + serviceId + ":" + ss.toString();
                res = res + ";";
            }
        }
        return res;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.keySet().iterator();
    }

    public boolean equalsTo(MultiDomainServerState other) {
        return this.cover(other) && other.cover(this);
    }

    public boolean cover(MultiDomainServerState covered) {
        for (String serviceId : covered.list.keySet()) {
            ServerState state = this.list.get(serviceId);
            ServerState coveredState = covered.list.get(serviceId);
            if (state != null && coveredState != null && state.cover(coveredState)) continue;
            return false;
        }
        return true;
    }

    public static HashMap<String, ServerState> splitGenStateToServerStates(String multidomainserverstate) throws DirectoryException {
        HashMap<String, ServerState> startStates = new HashMap<String, ServerState>();
        try {
            String[] domains;
            for (String domain : domains = multidomainserverstate.split(";")) {
                ServerState serverStateByDomain = new ServerState();
                String[] fields = domain.split(":");
                String domainBaseDN = fields[0];
                if (fields.length > 1) {
                    String[] strCN;
                    String strState = fields[1];
                    for (String sr : strCN = strState.split(" ")) {
                        ChangeNumber fromChangeNumber = new ChangeNumber(sr);
                        serverStateByDomain.update(fromChangeNumber);
                    }
                }
                startStates.put(domainBaseDN, serverStateByDomain);
            }
        }
        catch (Exception e) {
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, Message.raw(Category.SYNC, Severity.INFORMATION, "Exception raised: ", new Object[0]), e);
        }
        return startStates;
    }
}

