/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.messages.Message;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.util.StaticUtils;

public class ErrorMsg
extends RoutableMsg {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int msgID;
    private Message details = null;
    private Long creationTime = System.currentTimeMillis();

    public ErrorMsg(int sender, int destination, Message details) {
        super(sender, destination);
        this.msgID = details.getDescriptor().getId();
        this.details = details;
        this.creationTime = System.currentTimeMillis();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(" Creating error message" + this.toString() + " " + StaticUtils.stackTraceToSingleLineString(new Exception("trace")));
        }
    }

    public ErrorMsg(int i, Message details) {
        super(-2, i);
        this.msgID = details.getDescriptor().getId();
        this.details = details;
        this.creationTime = System.currentTimeMillis();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.toString());
        }
    }

    public ErrorMsg(byte[] in, short version) throws DataFormatException {
        try {
            if (in[0] != 14) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(senderString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String msgIdString = new String(in, pos, length, "UTF-8");
            this.msgID = Integer.valueOf(msgIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.details = Message.raw(new String(in, pos, length, "UTF-8"), new Object[0]);
            pos += length + 1;
            if (version >= 4) {
                length = this.getNextLength(in, pos);
                String creationTimeString = new String(in, pos, length, "UTF-8");
                this.creationTime = Long.valueOf(creationTimeString);
                pos += length + 1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public Message getDetails() {
        return this.details;
    }

    public int getMsgID() {
        return this.msgID;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    public byte[] getBytes(short version) {
        try {
            byte[] byteSender = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] byteDestination = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] byteErrMsgId = String.valueOf(this.msgID).getBytes("UTF-8");
            byte[] byteDetails = this.details.toString().getBytes("UTF-8");
            byte[] byteCreationTime = null;
            int length = 1 + byteSender.length + 1 + byteDestination.length + 1 + byteErrMsgId.length + 1 + byteDetails.length + 1;
            if (version >= 4) {
                byteCreationTime = this.creationTime.toString().getBytes("UTF-8");
                length += byteCreationTime.length + 1;
            }
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 14;
            int pos = 1;
            pos = ErrorMsg.addByteArray(byteSender, resultByteArray, pos);
            pos = ErrorMsg.addByteArray(byteDestination, resultByteArray, pos);
            pos = ErrorMsg.addByteArray(byteErrMsgId, resultByteArray, pos);
            pos = ErrorMsg.addByteArray(byteDetails, resultByteArray, pos);
            if (version >= 4) {
                pos = ErrorMsg.addByteArray(byteCreationTime, resultByteArray, pos);
            }
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        return "ErrorMessage=[ sender=" + this.senderID + " destination=" + this.destination + " msgID=" + this.msgID + " details=" + this.details + " creationTime=" + this.creationTime + "]";
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }
}

