/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.RoutableMsg;

public class InitializeRcvAckMsg
extends RoutableMsg {
    private final int numAck;

    public InitializeRcvAckMsg(int sender, int destination, int numAck) {
        super(sender, destination);
        this.numAck = numAck;
    }

    public InitializeRcvAckMsg(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 36) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(senderString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String numAckStr = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            this.numAck = Integer.parseInt(numAckStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public byte[] getBytes() {
        try {
            byte[] byteSender = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] byteDestination = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] byteNumAck = String.valueOf(this.numAck).getBytes("UTF-8");
            int length = 1 + byteSender.length + 1 + byteDestination.length + 1 + byteNumAck.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 36;
            int pos = 1;
            pos = InitializeRcvAckMsg.addByteArray(byteSender, resultByteArray, pos);
            pos = InitializeRcvAckMsg.addByteArray(byteDestination, resultByteArray, pos);
            pos = InitializeRcvAckMsg.addByteArray(byteNumAck, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "=[" + " sender=" + this.senderID + " destination=" + this.destination + " msgID=" + this.numAck + "]";
    }

    public int getNumAck() {
        return this.numAck;
    }
}

