/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

public class InitializeRequestMsg
extends RoutableMsg {
    private String baseDn = null;
    private int initWindow = 0;

    public InitializeRequestMsg(String baseDn, int serverID, int destination, int initWindow) {
        super(serverID, destination);
        this.baseDn = baseDn;
        this.initWindow = initWindow;
    }

    public InitializeRequestMsg(byte[] in, short version) throws DataFormatException {
        try {
            if (in[0] != 10) {
                throw new DataFormatException("input is not a valid InitializeRequestMessage");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String sourceServerIdString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(sourceServerIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String destinationServerIdString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(destinationServerIdString);
            pos += length + 1;
            if (version >= 4) {
                length = this.getNextLength(in, pos);
                String initWindowString = new String(in, pos, length, "UTF-8");
                this.initWindow = Integer.valueOf(initWindowString);
                pos += length + 1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public DN getBaseDn() {
        if (this.baseDn == null) {
            return null;
        }
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    public byte[] getBytes(short version) {
        try {
            byte[] baseDNBytes = this.baseDn.getBytes("UTF-8");
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] initWindowBytes = null;
            int length = 1 + baseDNBytes.length + 1 + senderBytes.length + 1 + destinationBytes.length + 1;
            if (version >= 4) {
                initWindowBytes = String.valueOf(this.initWindow).getBytes("UTF-8");
                length += initWindowBytes.length + 1;
            }
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 10;
            int pos = 1;
            pos = InitializeRequestMsg.addByteArray(baseDNBytes, resultByteArray, pos);
            pos = InitializeRequestMsg.addByteArray(senderBytes, resultByteArray, pos);
            pos = InitializeRequestMsg.addByteArray(destinationBytes, resultByteArray, pos);
            if (version >= 4) {
                pos = InitializeRequestMsg.addByteArray(initWindowBytes, resultByteArray, pos);
            }
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        return "InitializeRequestMessage: baseDn=" + this.baseDn + " senderId=" + this.senderID + " destination=" + this.destination + " initWindow=" + this.initWindow;
    }

    public int getInitWindow() {
        return this.initWindow;
    }

    public void setInitWindow(int initWindow) {
        this.initWindow = initWindow;
    }
}

