/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ModifyCommonMsg;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.RawModification;
import org.opends.server.types.operation.PostOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyMsg
extends ModifyCommonMsg {
    public ModifyMsg(PostOperationModifyOperation op) {
        super((OperationContext)op.getAttachment("replicationContext"), op.getRawEntryDN().toString());
        this.encodedMods = this.encodeMods(op.getModifications());
    }

    public ModifyMsg(ChangeNumber changeNumber, DN dn, List<Modification> mods, String entryuuid) {
        super(new ModifyContext(changeNumber, entryuuid), dn.toNormalizedString());
        this.encodedMods = this.encodeMods(mods);
    }

    public ModifyMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{22, 1};
        int pos = this.decodeHeader(allowedPduTypes, in);
        if (this.protocolVersion <= 3) {
            this.decodeBody_V123(in, pos);
        } else {
            this.decodeBody_V4(in, pos);
        }
        if (this.protocolVersion == ProtocolVersion.getCurrentVersion()) {
            this.bytes = in;
        }
    }

    public static ModifyMsg createV1(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        ModifyMsg msg = new ModifyMsg(in);
        msg.bytes = null;
        return msg;
    }

    @Override
    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception, DataFormatException {
        if (newDn == null) {
            newDn = this.getDn();
        }
        ArrayList<RawModification> ldapmods = this.decodeRawMods(this.encodedMods);
        ModifyOperationBasis mod = new ModifyOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, ByteString.valueOf(newDn), ldapmods);
        ModifyContext ctx = new ModifyContext(this.getChangeNumber(), this.getUniqueId());
        mod.setAttachment("replicationContext", ctx);
        return mod;
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "ModifyMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.uniqueId + " assuredFlag: " + this.assuredFlag;
        }
        if (this.protocolVersion >= 2) {
            String mods = "";
            try {
                ArrayList<RawModification> ldapmods = this.decodeRawMods(this.encodedMods);
                for (RawModification mod : ldapmods) {
                    mods = mods + mod.toString();
                }
            }
            catch (LDAPException e) {
            }
            catch (ASN1Exception aSN1Exception) {
                // empty catch block
            }
            return "ModifyMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.uniqueId + " assuredFlag: " + this.assuredFlag + " assuredMode: " + (Object)((Object)this.assuredMode) + " safeDataLevel: " + this.safeDataLevel + " size: " + this.encodedMods.length + mods;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    @Override
    public int size() {
        return this.encodedMods.length + this.encodedEclIncludes.length + this.headerSize();
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        byte[] encodedMsg = this.encodeHeader_V1((byte)1, this.encodedMods.length + 1);
        int pos = encodedMsg.length - (this.encodedMods.length + 1);
        ModifyMsg.addByteArray(this.encodedMods, encodedMsg, pos);
        return encodedMsg;
    }

    @Override
    public byte[] getBytes_V23() throws UnsupportedEncodingException {
        byte[] encodedMsg = this.encodeHeader((byte)22, this.encodedMods.length + 1, (short)3);
        int pos = encodedMsg.length - (this.encodedMods.length + 1);
        ModifyMsg.addByteArray(this.encodedMods, encodedMsg, pos);
        return encodedMsg;
    }

    @Override
    public byte[] getBytes_V4() throws UnsupportedEncodingException {
        int bodyLength = 0;
        byte[] byteModsLen = String.valueOf(this.encodedMods.length).getBytes("UTF-8");
        bodyLength += byteModsLen.length + 1;
        bodyLength += this.encodedMods.length + 1;
        byte[] byteEntryAttrLen = String.valueOf(this.encodedEclIncludes.length).getBytes("UTF-8");
        bodyLength += byteEntryAttrLen.length + 1;
        byte[] encodedMsg = this.encodeHeader((byte)22, bodyLength += this.encodedEclIncludes.length + 1, (short)4);
        int pos = encodedMsg.length - bodyLength;
        pos = ModifyMsg.addByteArray(byteModsLen, encodedMsg, pos);
        pos = ModifyMsg.addByteArray(this.encodedMods, encodedMsg, pos);
        pos = ModifyMsg.addByteArray(byteEntryAttrLen, encodedMsg, pos);
        pos = ModifyMsg.addByteArray(this.encodedEclIncludes, encodedMsg, pos);
        return encodedMsg;
    }

    private void decodeBody_V123(byte[] in, int pos) throws DataFormatException {
        int length = in.length - pos - 1;
        this.encodedMods = new byte[length];
        try {
            System.arraycopy(in, pos, this.encodedMods, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    private void decodeBody_V4(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = this.getNextLength(in, pos);
        int modsLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedMods = new byte[modsLen];
        try {
            System.arraycopy(in, pos, this.encodedMods, 0, modsLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
        length = this.getNextLength(in, pos += modsLen + 1);
        int eclAttrLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedEclIncludes = new byte[eclAttrLen];
        try {
            System.arraycopy(in, pos, this.encodedEclIncludes, 0, eclAttrLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }
}

