/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.StartMsg;

public class ReplServerStartDSMsg
extends StartMsg {
    private int serverId;
    private String serverURL;
    private String baseDn = null;
    private int windowSize;
    private ServerState serverState;
    private boolean sslEncryption;
    private int degradedStatusThreshold = -1;
    private int weight = -1;
    private int connectedDSNumber = -1;

    public ReplServerStartDSMsg(int serverId, String serverURL, String baseDn, int windowSize, ServerState serverState, short protocolVersion, long generationId, boolean sslEncryption, byte groupId, int degradedStatusThreshold, int weight, int connectedDSNumber) {
        super(protocolVersion, generationId);
        this.serverId = serverId;
        this.serverURL = serverURL;
        this.baseDn = baseDn != null ? baseDn : null;
        this.windowSize = windowSize;
        this.serverState = serverState;
        this.sslEncryption = sslEncryption;
        this.groupId = groupId;
        this.degradedStatusThreshold = degradedStatusThreshold;
        this.weight = weight;
        this.connectedDSNumber = connectedDSNumber;
    }

    public ReplServerStartDSMsg(byte[] in) throws DataFormatException {
        byte[] allowedPduTypes = new byte[]{34};
        this.headerLength = this.decodeHeader(allowedPduTypes, in);
        try {
            int pos = this.headerLength;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Integer.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.degradedStatusThreshold = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String weightString = new String(in, pos, length, "UTF-8");
            this.weight = Integer.valueOf(weightString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String connectedDSNumberString = new String(in, pos, length, "UTF-8");
            this.connectedDSNumber = Integer.valueOf(connectedDSNumberString);
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    public byte[] getBytes(short protocolVersion) throws UnsupportedEncodingException {
        byte[] byteDn = this.baseDn.getBytes("UTF-8");
        byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
        byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
        byte[] byteServerState = this.serverState.getBytes();
        byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
        byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
        byte[] byteDegradedStatusThreshold = String.valueOf(this.degradedStatusThreshold).getBytes("UTF-8");
        byte[] byteWeight = String.valueOf(this.weight).getBytes("UTF-8");
        byte[] byteConnectedDSNumber = String.valueOf(this.connectedDSNumber).getBytes("UTF-8");
        int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteSSLEncryption.length + 1 + byteDegradedStatusThreshold.length + 1 + byteWeight.length + 1 + byteConnectedDSNumber.length + 1 + byteServerState.length + 1;
        byte[] resultByteArray = this.encodeHeader((byte)34, length, protocolVersion);
        int pos = this.headerLength;
        pos = ReplServerStartDSMsg.addByteArray(byteDn, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteServerId, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteServerUrl, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteWindowSize, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteSSLEncryption, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteDegradedStatusThreshold, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteWeight, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteConnectedDSNumber, resultByteArray, pos);
        pos = ReplServerStartDSMsg.addByteArray(byteServerState, resultByteArray, pos);
        return resultByteArray;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean getSSLEncryption() {
        return this.sslEncryption;
    }

    public int getDegradedStatusThreshold() {
        return this.degradedStatusThreshold;
    }

    public void setDegradedStatusThreshold(int degradedStatusThreshold) {
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    public String toString() {
        return "ReplServerStartDSMsg content: \nprotocolVersion: " + this.protocolVersion + "\ngenerationId: " + this.generationId + "\nbaseDn: " + this.baseDn + "\ngroupId: " + this.groupId + "\nserverId: " + this.serverId + "\nserverState: " + this.serverState + "\nserverURL: " + this.serverURL + "\nsslEncryption: " + this.sslEncryption + "\ndegradedStatusThreshold: " + this.degradedStatusThreshold + "\nwindowSize: " + this.windowSize + "\nweight: " + this.weight + "\nconnectedDSNumber: " + this.connectedDSNumber;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getConnectedDSNumber() {
        return this.connectedDSNumber;
    }
}

