/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseEntry;
import java.io.UnsupportedEncodingException;
import org.opends.messages.Message;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.server.ReplicationDBException;

public class DraftCNData
extends DatabaseEntry {
    private static final String FIELD_SEPARATOR = "!";
    String value;
    String serviceID;
    ChangeNumber changeNumber;

    public DraftCNData(int draftCN, String value, String serviceID, ChangeNumber changeNumber) throws UnsupportedEncodingException {
        String record = value + FIELD_SEPARATOR + serviceID + FIELD_SEPARATOR + changeNumber;
        try {
            byte[] byteValue = record.getBytes("UTF-8");
            this.setData(byteValue);
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
    }

    public DraftCNData(byte[] data) throws Exception {
        this.decodeData(data);
    }

    public void decodeData(byte[] data) throws Exception {
        try {
            String stringData = new String(data, "UTF-8");
            String[] str = stringData.split(FIELD_SEPARATOR, 3);
            this.value = str[0];
            this.serviceID = str[1];
            this.changeNumber = new ChangeNumber(str[2]);
        }
        catch (UnsupportedEncodingException e) {
            throw new ReplicationDBException(Message.raw("need UTF-8 support", new Object[0]));
        }
    }

    public String getValue() throws Exception {
        if (this.value == null) {
            this.decodeData(this.getData());
        }
        return this.value;
    }

    public String getServiceID() throws Exception {
        if (this.value == null) {
            this.decodeData(this.getData());
        }
        return this.serviceID;
    }

    public ChangeNumber getChangeNumber() throws Exception {
        if (this.value == null) {
            this.decodeData(this.getData());
        }
        return this.changeNumber;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DraftCNData : [value=" + this.value);
        buffer.append("] [serviceID=" + this.serviceID);
        buffer.append("] [changeNumber=" + this.changeNumber + "]");
    }
}

