/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.VirtualAttributeCfgDefn;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.admin.std.server.UserDefinedVirtualAttributeCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackupTaskListener;
import org.opends.server.api.ExportTaskListener;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.RestoreTaskListener;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangelogBaseDNVirtualAttributeProvider;
import org.opends.server.replication.common.ExternalChangeLogSession;
import org.opends.server.replication.common.FirstChangeNumberVirtualAttributeProvider;
import org.opends.server.replication.common.LastChangeNumberVirtualAttributeProvider;
import org.opends.server.replication.common.LastCookieVirtualProvider;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartECLMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.DraftCNDbHandler;
import org.opends.server.replication.server.ECLServerHandler;
import org.opends.server.replication.server.ExternalChangeLogSessionImpl;
import org.opends.server.replication.server.ReplicationBackend;
import org.opends.server.replication.server.ReplicationDBException;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationServerConnectThread;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ReplicationServerHandler;
import org.opends.server.replication.server.ReplicationServerListenThread;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServer
implements ConfigurationChangeListener<ReplicationServerCfg>,
BackupTaskListener,
RestoreTaskListener,
ImportTaskListener,
ExportTaskListener {
    private int serverId;
    private String serverURL;
    private ServerSocket listenSocket;
    private Thread listenThread;
    private Thread connectThread;
    private Collection<String> replicationServers;
    private ConcurrentHashMap<String, ReplicationServerDomain> baseDNs = new ConcurrentHashMap();
    private String localURL = "null";
    private boolean shutdown = false;
    private ReplicationDbEnv dbEnv;
    private int rcvWindow;
    private int queueSize;
    private String dbDirname = null;
    private long purgeDelay;
    private int replicationPort;
    private boolean stopListen = false;
    private ReplSessionSecurity replSessionSecurity;
    private DN backendConfigEntryDN;
    private static final String backendId = "replicationChanges";
    private boolean connectedInTopology = false;
    private final Object connectedInTopologyLock = new Object();
    private long assuredTimeout = 1000L;
    private byte groupId = 1;
    private int degradedStatusThreshold = 5000;
    private long monitoringPublisherPeriod = 3000L;
    private DraftCNDbHandler draftCNDbHandler;
    private int lastGeneratedDraftCN = 0;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static String externalChangeLogWorkflowID = "External Changelog Workflow ID";
    ECLWorkflowElement eclwe;
    WorkflowImpl externalChangeLogWorkflowImpl = null;
    private static HashSet<Integer> localPorts = new HashSet();
    private final Object domainMonitor = new Object();
    private ArrayList<String> excludedServiceIDs = new ArrayList();
    private int weight = 1;
    private static List<ReplicationServer> allInstances = new ArrayList<ReplicationServer>();
    private long monitorDataLifeTime = 500L;
    private long monitorDataLastBuildDate = 0L;
    private List<GlobalServerId> expectedMonitoringMsg = null;

    public ReplicationServer(ReplicationServerCfg configuration) throws ConfigException {
        this.replicationPort = configuration.getReplicationPort();
        this.serverId = configuration.getReplicationServerId();
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        this.purgeDelay = configuration.getReplicationPurgeDelay();
        this.dbDirname = configuration.getReplicationDBDirectory();
        this.rcvWindow = configuration.getWindowSize();
        if (this.dbDirname == null) {
            this.dbDirname = "changelogDb";
        }
        File f = StaticUtils.getFileForPath(this.dbDirname);
        try {
            if (!f.exists()) {
                f.mkdir();
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            mb.append(" ");
            mb.append(String.valueOf(StaticUtils.getFileForPath(this.dbDirname)));
            Message msg = ReplicationMessages.ERR_FILE_CHECK_CREATE_FAILED.get(mb.toString());
            throw new ConfigException(msg, (Throwable)e);
        }
        this.groupId = (byte)configuration.getGroupId();
        this.weight = configuration.getWeight();
        this.assuredTimeout = configuration.getAssuredTimeout();
        this.degradedStatusThreshold = configuration.getDegradedStatusThreshold();
        this.monitoringPublisherPeriod = configuration.getMonitoringPeriod();
        this.replSessionSecurity = new ReplSessionSecurity();
        this.initialize(this.replicationPort);
        configuration.addChangeListener(this);
        try {
            this.backendConfigEntryDN = DN.decode("ds-cfg-backend-id=replicationChanges,cn=Backends,cn=config");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createBackend();
        DirectoryServer.registerBackupTaskListener(this);
        DirectoryServer.registerRestoreTaskListener(this);
        DirectoryServer.registerExportTaskListener(this);
        DirectoryServer.registerImportTaskListener(this);
        localPorts.add(this.replicationPort);
        allInstances.add(this);
    }

    public static List<ReplicationServer> getAllInstances() {
        return allInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runListen() {
        Object object = this.connectedInTopologyLock;
        synchronized (object) {
            if (!this.connectedInTopology) {
                try {
                    this.connectedInTopologyLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        while (!this.shutdown && !this.stopListen) {
            Socket newSocket = null;
            try {
                ServerHandler handler;
                ProtocolSession session;
                block16: {
                    try {
                        newSocket = this.listenSocket.accept();
                        newSocket.setTcpNoDelay(true);
                        newSocket.setKeepAlive(true);
                        session = this.replSessionSecurity.createServerSession(newSocket, 4000);
                        if (session == null) {
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        if (newSocket == null) continue;
                        newSocket.close();
                    }
                    continue;
                }
                ReplicationMsg msg = session.receive();
                if (msg instanceof ServerStartMsg) {
                    session.setProtocolVersion(((StartMsg)msg).getVersion());
                    handler = new DataServerHandler(session, this.queueSize, this.serverURL, this.serverId, this, this.rcvWindow);
                    ((DataServerHandler)handler).startFromRemoteDS((ServerStartMsg)msg);
                    continue;
                }
                if (msg instanceof ReplServerStartMsg) {
                    session.setProtocolVersion(((StartMsg)msg).getVersion());
                    handler = new ReplicationServerHandler(session, this.queueSize, this.serverURL, this.serverId, this, this.rcvWindow);
                    ((ReplicationServerHandler)handler).startFromRemoteRS((ReplServerStartMsg)msg);
                    continue;
                }
                if (msg instanceof ServerStartECLMsg) {
                    session.setProtocolVersion(((StartMsg)msg).getVersion());
                    handler = new ECLServerHandler(session, this.queueSize, this.serverURL, this.serverId, this, this.rcvWindow);
                    ((ECLServerHandler)handler).startFromRemoteServer((ServerStartECLMsg)msg);
                    continue;
                }
                ServerHandler.closeSession(session, null, null);
                return;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (this.shutdown) continue;
                Message message = ReplicationMessages.ERR_EXCEPTION_LISTENING.get(e.getLocalizedMessage());
                ErrorLogger.logError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runConnect() {
        while (!this.shutdown) {
            for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
                Set<String> connectedReplServers = replicationServerDomain.getChangelogs();
                for (String serverURL : this.replicationServers) {
                    int separator = serverURL.lastIndexOf(58);
                    String port = serverURL.substring(separator + 1);
                    String hostname = serverURL.substring(0, separator);
                    try {
                        InetAddress inetAddress = InetAddress.getByName(hostname);
                        String serverAddress = inetAddress.getHostAddress() + ":" + port;
                        String alternServerAddress = null;
                        if (hostname.equalsIgnoreCase("localhost")) {
                            alternServerAddress = InetAddress.getLocalHost().getHostAddress() + ":" + port;
                        }
                        if (inetAddress.equals(InetAddress.getLocalHost())) {
                            alternServerAddress = "127.0.0.1:" + port;
                        }
                        if (serverAddress.compareTo("127.0.0.1:" + this.replicationPort) == 0 || serverAddress.compareTo(this.localURL) == 0 || connectedReplServers.contains(serverAddress) || alternServerAddress != null && connectedReplServers.contains(alternServerAddress)) continue;
                        this.connect(serverURL, replicationServerDomain.getBaseDn());
                    }
                    catch (IOException e) {
                        Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_HOSTNAME.get(hostname);
                        ErrorLogger.logError(message);
                    }
                }
            }
            Object i$ = this.connectedInTopologyLock;
            synchronized (i$) {
                if (!this.connectedInTopology) {
                    this.connectedInTopologyLock.notify();
                    this.connectedInTopology = true;
                }
            }
            try {
                i$ = this.domainMonitor;
                synchronized (i$) {
                    this.domainMonitor.notifyAll();
                }
                i$ = this;
                synchronized (i$) {
                    int randomizer = (int)(Math.random() * 100.0);
                    this.wait(1000 + randomizer);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void connect(String remoteServerURL, String baseDn) {
        int separator = remoteServerURL.lastIndexOf(58);
        String port = remoteServerURL.substring(separator + 1);
        String hostname = remoteServerURL.substring(0, separator);
        boolean sslEncryption = this.replSessionSecurity.isSslEncryption(remoteServerURL);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " connects to " + remoteServerURL);
        }
        try {
            InetSocketAddress ServerAddr = new InetSocketAddress(InetAddress.getByName(hostname), Integer.parseInt(port));
            Socket socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.connect(ServerAddr, 500);
            ReplicationServerHandler handler = new ReplicationServerHandler(this.replSessionSecurity.createClientSession(remoteServerURL, socket, 4000), this.queueSize, this.serverURL, this.serverId, this, this.rcvWindow);
            handler.connect(baseDn, sslEncryption);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void initialize(int changelogPort) {
        this.shutdown = false;
        try {
            this.dbEnv = new ReplicationDbEnv(StaticUtils.getFileForPath(this.dbDirname).getAbsolutePath(), this);
            String localhostname = InetAddress.getLocalHost().getHostName();
            String localAdddress = InetAddress.getLocalHost().getHostAddress();
            this.serverURL = localhostname + ":" + String.valueOf(changelogPort);
            this.localURL = localAdddress + ":" + String.valueOf(changelogPort);
            this.listenSocket = new ServerSocket();
            this.listenSocket.bind(new InetSocketAddress(changelogPort));
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " creates connect thread");
            }
            this.connectThread = new ReplicationServerConnectThread("Replication Server Connect " + this.serverId, this);
            this.connectThread.start();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " creates listen thread");
            }
            this.listenThread = new ReplicationServerListenThread("Replication Server Listener " + this.serverId, this);
            this.listenThread.start();
            if (WorkflowImpl.getWorkflow(externalChangeLogWorkflowID) != null) {
                return;
            }
            this.eclwe = new ECLWorkflowElement(this);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " successfully initialized");
            }
        }
        catch (DatabaseException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_INITIALIZE_DB.get(StaticUtils.getFileForPath(this.dbDirname).getAbsolutePath());
            ErrorLogger.logError(message);
        }
        catch (ReplicationDBException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_READ_DB.get(this.dbDirname, e.getLocalizedMessage());
            ErrorLogger.logError(message);
        }
        catch (UnknownHostException e) {
            Message message = ReplicationMessages.ERR_UNKNOWN_HOSTNAME.get();
            ErrorLogger.logError(message);
        }
        catch (IOException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(changelogPort, e.getMessage());
            ErrorLogger.logError(message);
        }
        catch (DirectoryException e) {
            Message message = Message.raw(Category.SYNC, Severity.SEVERE_ERROR, "Directory Exception raised by ECL initialization: " + e.getMessage(), new Object[0]);
            ErrorLogger.logError(message);
        }
    }

    public void enableECL() throws DirectoryException {
        if (this.externalChangeLogWorkflowImpl != null) {
            return;
        }
        this.externalChangeLogWorkflowImpl = new WorkflowImpl(externalChangeLogWorkflowID, DN.decode("cn=changelog"), this.eclwe.getWorkflowElementID(), this.eclwe);
        this.externalChangeLogWorkflowImpl.register();
        NetworkGroup defaultNetworkGroup = NetworkGroup.getDefaultNetworkGroup();
        defaultNetworkGroup.registerWorkflow(this.externalChangeLogWorkflowImpl);
        NetworkGroup adminNetworkGroup = NetworkGroup.getAdminNetworkGroup();
        adminNetworkGroup.registerWorkflow(this.externalChangeLogWorkflowImpl);
        NetworkGroup internalNetworkGroup = NetworkGroup.getInternalNetworkGroup();
        internalNetworkGroup.registerWorkflow(this.externalChangeLogWorkflowImpl);
        ReplicationServer.enableECLVirtualAttr("lastexternalchangelogcookie", new LastCookieVirtualProvider());
        ReplicationServer.enableECLVirtualAttr("firstchangenumber", new FirstChangeNumberVirtualAttributeProvider());
        ReplicationServer.enableECLVirtualAttr("lastchangenumber", new LastChangeNumberVirtualAttributeProvider());
        ReplicationServer.enableECLVirtualAttr("changelog", new ChangelogBaseDNVirtualAttributeProvider());
    }

    private static void enableECLVirtualAttr(String attrName, VirtualAttributeProvider<UserDefinedVirtualAttributeCfg> provider) throws DirectoryException {
        HashSet<DN> baseDNs = new HashSet<DN>(0);
        HashSet<DN> groupDNs = new HashSet<DN>(0);
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>(0);
        VirtualAttributeCfgDefn.ConflictBehavior conflictBehavior = VirtualAttributeCfgDefn.ConflictBehavior.VIRTUAL_OVERRIDES_REAL;
        try {
            provider.initializeVirtualAttributeProvider(null);
            AttributeType attributeType = DirectoryServer.getAttributeType(attrName, false);
            SearchFilter filter = SearchFilter.createFilterFromString("objectclass=*");
            filters.add(filter);
            baseDNs.add(DN.decode(""));
            VirtualAttributeRule rule = new VirtualAttributeRule(attributeType, provider, baseDNs, groupDNs, filters, conflictBehavior);
            DirectoryServer.registerVirtualAttribute(rule);
        }
        catch (Exception e) {
            Message message = ReplicationMessages.NOTE_ERR_UNABLE_TO_ENABLE_ECL_VIRTUAL_ATTR.get(attrName, e.toString());
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, message, e);
        }
    }

    private void shutdownECL() {
        WorkflowImpl eclwf = (WorkflowImpl)WorkflowImpl.getWorkflow(externalChangeLogWorkflowID);
        if (eclwf != null) {
            NetworkGroup internalNetworkGroup = NetworkGroup.getInternalNetworkGroup();
            internalNetworkGroup.deregisterWorkflow(externalChangeLogWorkflowID);
            NetworkGroup adminNetworkGroup = NetworkGroup.getAdminNetworkGroup();
            adminNetworkGroup.deregisterWorkflow(externalChangeLogWorkflowID);
            NetworkGroup defaultNetworkGroup = NetworkGroup.getDefaultNetworkGroup();
            defaultNetworkGroup.deregisterWorkflow(externalChangeLogWorkflowID);
            eclwf.deregister();
            eclwf.finalizeWorkflow();
        }
        this.eclwe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
        if (this.eclwe != null) {
            DirectoryServer.deregisterWorkflowElement(this.eclwe);
            this.eclwe.finalizeWorkflowElement();
        }
        if (this.draftCNDbHandler != null) {
            this.draftCNDbHandler.shutdown();
        }
    }

    public ReplicationServerDomain getReplicationServerDomain(String baseDn, boolean create) {
        return this.getReplicationServerDomain(baseDn, create, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationServerDomain getReplicationServerDomain(String baseDn, boolean create, boolean waitConnections) {
        ReplicationServerDomain replicationServerDomain;
        ConcurrentHashMap<String, ReplicationServerDomain> concurrentHashMap = this.baseDNs;
        synchronized (concurrentHashMap) {
            replicationServerDomain = this.baseDNs.get(baseDn);
            if (replicationServerDomain == null && create) {
                replicationServerDomain = new ReplicationServerDomain(baseDn, this);
                this.baseDNs.put(baseDn, replicationServerDomain);
                Object object = this.domainMonitor;
                synchronized (object) {
                    if (waitConnections) {
                        ReplicationServer replicationServer = this;
                        synchronized (replicationServer) {
                            this.notify();
                        }
                        try {
                            this.domainMonitor.wait(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return replicationServerDomain;
    }

    public void shutdown() {
        localPorts.remove(this.replicationPort);
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.connectThread != null) {
            this.connectThread.interrupt();
        }
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.listenThread != null) {
            this.listenThread.interrupt();
        }
        for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
            replicationServerDomain.shutdown();
        }
        this.shutdownECL();
        if (this.dbEnv != null) {
            this.dbEnv.shutdown();
        }
        allInstances.remove(this);
    }

    public DbHandler newDbHandler(int id, String baseDn) throws DatabaseException {
        return new DbHandler(id, baseDn, this, this.dbEnv, this.queueSize);
    }

    public void clearGenerationId(String baseDn) throws DatabaseException {
        block6: {
            try {
                this.dbEnv.clearGenerationId(baseDn);
                if (this.draftCNDbHandler == null) break block6;
                try {
                    try {
                        this.draftCNDbHandler.clear(baseDn);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.lastGeneratedDraftCN = this.draftCNDbHandler.getLastKey();
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                TRACER.debugCaught(LogLevel.ALL, e);
            }
        }
    }

    long getTrimage() {
        return this.purgeDelay * 1000L;
    }

    public static boolean isConfigurationAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        int port = configuration.getReplicationPort();
        try {
            ServerSocket tmpSocket = new ServerSocket();
            tmpSocket.bind(new InetSocketAddress(port));
            tmpSocket.close();
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(port, e.getMessage());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationServerCfg configuration) {
        byte newGroupId;
        this.disconnectRemovedReplicationServers(configuration.getReplicationServer());
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        long newPurgeDelay = configuration.getReplicationPurgeDelay();
        if (newPurgeDelay != this.purgeDelay) {
            this.purgeDelay = newPurgeDelay;
            for (ReplicationServerDomain domain : this.baseDNs.values()) {
                domain.setPurgeDelay(this.purgeDelay * 1000L);
            }
        }
        this.rcvWindow = configuration.getWindowSize();
        this.assuredTimeout = configuration.getAssuredTimeout();
        int newPort = configuration.getReplicationPort();
        if (newPort != this.replicationPort) {
            Message message;
            this.stopListen = true;
            try {
                this.listenSocket.close();
                this.listenThread.join();
                this.stopListen = false;
                this.replicationPort = newPort;
                String localhostname = InetAddress.getLocalHost().getHostName();
                String localAdddress = InetAddress.getLocalHost().getHostAddress();
                this.serverURL = localhostname + ":" + String.valueOf(this.replicationPort);
                this.localURL = localAdddress + ":" + String.valueOf(this.replicationPort);
                this.listenSocket = new ServerSocket();
                this.listenSocket.bind(new InetSocketAddress(this.replicationPort));
                this.listenThread = new ReplicationServerListenThread("Replication Server Listener", this);
                this.listenThread.start();
            }
            catch (IOException e) {
                message = ReplicationMessages.ERR_COULD_NOT_CLOSE_THE_SOCKET.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
            }
            catch (InterruptedException e) {
                message = ReplicationMessages.ERR_COULD_NOT_STOP_LISTEN_THREAD.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
            }
        }
        if (this.degradedStatusThreshold != configuration.getDegradedStatusThreshold()) {
            int oldThresholdValue = this.degradedStatusThreshold;
            this.degradedStatusThreshold = configuration.getDegradedStatusThreshold();
            for (ReplicationServerDomain rsd : this.baseDNs.values()) {
                if (this.degradedStatusThreshold == 0) {
                    rsd.stopStatusAnalyzer();
                    continue;
                }
                if (rsd.isRunningStatusAnalyzer()) {
                    rsd.updateStatusAnalyzer(this.degradedStatusThreshold);
                    continue;
                }
                if (oldThresholdValue != 0 || rsd.getConnectedDSs().size() <= 0) continue;
                rsd.startStatusAnalyzer();
            }
        }
        if (this.monitoringPublisherPeriod != configuration.getMonitoringPeriod()) {
            long oldMonitoringPeriod = this.monitoringPublisherPeriod;
            this.monitoringPublisherPeriod = configuration.getMonitoringPeriod();
            for (ReplicationServerDomain rsd : this.baseDNs.values()) {
                if (this.monitoringPublisherPeriod == 0L) {
                    rsd.stopMonitoringPublisher();
                    continue;
                }
                if (rsd.isRunningMonitoringPublisher()) {
                    rsd.updateMonitoringPublisher(this.monitoringPublisherPeriod);
                    continue;
                }
                if (oldMonitoringPeriod != 0L || rsd.getConnectedDSs().size() <= 0 && rsd.getConnectedRSs().size() <= 0) continue;
                rsd.startMonitoringPublisher();
            }
        }
        if ((newGroupId = (byte)configuration.getGroupId()) != this.groupId) {
            this.groupId = newGroupId;
            for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
                replicationServerDomain.stopAllServers(true);
            }
        }
        if (this.weight != configuration.getWeight()) {
            this.weight = configuration.getWeight();
            this.broadcastConfigChange();
        }
        if (configuration.getReplicationDBDirectory() != null && !this.dbDirname.equals(configuration.getReplicationDBDirectory())) {
            return new ConfigChangeResult(ResultCode.SUCCESS, true);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private void broadcastConfigChange() {
        for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
            replicationServerDomain.buildAndSendTopoInfoToDSs(null);
            replicationServerDomain.buildAndSendTopoInfoToRSs();
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public long getGenerationId(String baseDN) {
        ReplicationServerDomain rsd = this.getReplicationServerDomain(baseDN, false);
        if (rsd != null) {
            return rsd.getGenerationId();
        }
        return -1L;
    }

    public int getServerId() {
        return this.serverId;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    private void createBackend() throws ConfigException {
        try {
            String ldif = ReplicationServer.makeLdif("dn: ds-cfg-backend-id=replicationChanges,cn=Backends,cn=config", "objectClass: top", "objectClass: ds-cfg-backend", "ds-cfg-base-dn: dc=replicationChanges", "ds-cfg-enabled: true", "ds-cfg-writability-mode: enabled", "ds-cfg-java-class: org.opends.server.replication.server.ReplicationBackend", "ds-cfg-backend-id: replicationChanges");
            LDIFImportConfig ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            Entry backendConfigEntry = reader.readEntry();
            if (!DirectoryServer.getConfigHandler().entryExists(this.backendConfigEntryDN)) {
                DirectoryServer.getConfigHandler().addEntry(backendConfigEntry, null);
            }
            ldifImportConfig.close();
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            Message msg = ReplicationMessages.ERR_CHECK_CREATE_REPL_BACKEND_FAILED.get(mb.toString());
            throw new ConfigException(msg, (Throwable)e);
        }
    }

    private static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    public void remove() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " starts removing");
        }
        this.shutdown();
        this.removeBackend();
        DirectoryServer.deregisterBackupTaskListener(this);
        DirectoryServer.deregisterRestoreTaskListener(this);
        DirectoryServer.deregisterExportTaskListener(this);
        DirectoryServer.deregisterImportTaskListener(this);
    }

    protected void removeBackend() {
        try {
            if (DirectoryServer.getConfigHandler().entryExists(this.backendConfigEntryDN)) {
                DirectoryServer.getConfigHandler().deleteEntry(this.backendConfigEntryDN, null);
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            Message msg = ReplicationMessages.ERR_DELETE_REPL_BACKEND_FAILED.get(mb.toString());
            ErrorLogger.logError(msg);
        }
    }

    @Override
    public void processBackupBegin(Backend backend, BackupConfig config) {
    }

    @Override
    public void processBackupEnd(Backend backend, BackupConfig config, boolean successful) {
    }

    @Override
    public void processRestoreBegin(Backend backend, RestoreConfig config) {
        if (backend.getBackendID().equals(backendId)) {
            this.shutdown();
        }
    }

    @Override
    public void processRestoreEnd(Backend backend, RestoreConfig config, boolean successful) {
        if (backend.getBackendID().equals(backendId)) {
            this.initialize(this.replicationPort);
        }
    }

    @Override
    public void processImportBegin(Backend backend, LDIFImportConfig config) {
    }

    @Override
    public void processImportEnd(Backend backend, LDIFImportConfig config, boolean successful) {
    }

    @Override
    public void processExportBegin(Backend backend, LDIFExportConfig config) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("RS " + this.getMonitorInstanceName() + " Export starts");
        }
        if (backend.getBackendID().equals(backendId)) {
            ReplicationBackend b = (ReplicationBackend)DirectoryServer.getBackend(backendId);
            b.setServer(this);
        }
    }

    @Override
    public void processExportEnd(Backend backend, LDIFExportConfig config, boolean successful) {
    }

    public Iterator<ReplicationServerDomain> getDomainIterator() {
        if (!this.baseDNs.isEmpty()) {
            return this.baseDNs.values().iterator();
        }
        return null;
    }

    public void clearDb() {
        Iterator<ReplicationServerDomain> rcachei = this.getDomainIterator();
        if (rcachei != null) {
            while (rcachei.hasNext()) {
                ReplicationServerDomain rsd = rcachei.next();
                rsd.clearDbs();
            }
        }
        if (this.draftCNDbHandler != null) {
            try {
                try {
                    this.draftCNDbHandler.clear();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.draftCNDbHandler.shutdown();
                this.lastGeneratedDraftCN = 0;
                this.draftCNDbHandler = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getAssuredTimeout() {
        return this.assuredTimeout;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public int getDegradedStatusThreshold() {
        return this.degradedStatusThreshold;
    }

    public long getMonitoringPublisherPeriod() {
        return this.monitoringPublisherPeriod;
    }

    private void disconnectRemovedReplicationServers(Collection<String> newReplServers) {
        ArrayList<String> serversToDisconnect = new ArrayList<String>();
        for (String server : this.replicationServers) {
            if (newReplServers.contains(server)) continue;
            try {
                String[] host = server.split(":");
                serversToDisconnect.add(InetAddress.getByName(host[0]).getHostAddress() + ":" + host[1]);
            }
            catch (IOException e) {
                Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_HOSTNAME.get(server);
                ErrorLogger.logError(message);
            }
        }
        if (serversToDisconnect.isEmpty()) {
            return;
        }
        for (ReplicationServerDomain replicationServerDomain : this.baseDNs.values()) {
            replicationServerDomain.stopReplicationServers(serversToDisconnect);
        }
    }

    public String getMonitorInstanceName() {
        return "Replication Server " + this.replicationPort + " " + this.serverId;
    }

    public int getReplicationPort() {
        return this.replicationPort;
    }

    public synchronized void computeMonitorData() throws DirectoryException {
        if (this.monitorDataLastBuildDate + this.monitorDataLifeTime > TimeThread.getTime()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.getMonitorInstanceName() + " getRemoteMonitorData in cache");
            }
            return;
        }
        this.expectedMonitoringMsg = Collections.synchronizedList(new ArrayList());
        ArrayList<ReplicationServerDomain> rsdList = new ArrayList<ReplicationServerDomain>(this.baseDNs.values());
        for (ReplicationServerDomain domain : rsdList) {
            domain.initializeMonitorData(this.expectedMonitoringMsg);
        }
        this.waitMonitorDataResponses();
        for (ReplicationServerDomain domain : rsdList) {
            domain.completeMonitorData();
        }
    }

    private void waitMonitorDataResponses() throws DirectoryException {
        try {
            long startTime;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.getMonitorInstanceName() + " waiting for " + this.expectedMonitoringMsg.size() + " expected monitor messages");
            }
            boolean allReceived = false;
            long curTime = startTime = TimeThread.getTime();
            int maxTime = 5000;
            while (curTime - startTime < (long)maxTime) {
                if (this.expectedMonitoringMsg.size() == 0) {
                    allReceived = true;
                    break;
                }
                Thread.sleep(100L);
                curTime = TimeThread.getTime();
            }
            this.monitorDataLastBuildDate = TimeThread.getTime();
            if (!allReceived) {
                ErrorLogger.logError(ReplicationMessages.ERR_MISSING_REMOTE_MONITOR_DATA.get());
            } else if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.getMonitorInstanceName() + " Successfully received all expected monitor messages");
            }
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage()));
        }
    }

    public void responseReceived(GlobalServerId globalServerId) {
        this.expectedMonitoringMsg.remove(globalServerId);
    }

    public void responseReceivedAll() {
        this.expectedMonitoringMsg.clear();
    }

    public int getCacheSize() {
        return this.baseDNs.size();
    }

    public ExternalChangeLogSession createECLSession(StartECLSessionMsg msg) throws DirectoryException {
        ExternalChangeLogSessionImpl session = new ExternalChangeLogSessionImpl(this, msg);
        return session;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public static void onlyForTestsAddlocalReplicationServer(String server) {
        int separator = server.lastIndexOf(58);
        if (separator == -1) {
            return;
        }
        int port = Integer.parseInt(server.substring(separator + 1));
        localPorts.add(port);
    }

    public static void onlyForTestsClearLocalReplicationServerList() {
        localPorts.clear();
    }

    public static boolean isLocalReplicationServer(String server) {
        int separator = server.lastIndexOf(58);
        if (separator == -1) {
            return false;
        }
        int port = Integer.parseInt(server.substring(separator + 1));
        String hostname = server.substring(0, separator);
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            return localPorts.contains(port) && (InetAddress.getByName(hostname).isLoopbackAddress() || InetAddress.getByName(hostname).equals(localAddr));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public void disableEligibility(ArrayList<String> excludedServiceIDs) {
        this.excludedServiceIDs = excludedServiceIDs;
    }

    public ChangeNumber getEligibleCN() {
        String debugLog = "";
        ChangeNumber eligibleCN = null;
        Iterator<ReplicationServerDomain> rsdi = this.getDomainIterator();
        if (rsdi != null) {
            while (rsdi.hasNext()) {
                ReplicationServerDomain domain = rsdi.next();
                if (this.excludedServiceIDs != null && this.excludedServiceIDs.contains(domain.getBaseDn())) continue;
                ChangeNumber domainEligibleCN = domain.getEligibleCN();
                String dates = "";
                if (domainEligibleCN != null) {
                    if (eligibleCN == null || domainEligibleCN.older(eligibleCN).booleanValue()) {
                        eligibleCN = domainEligibleCN;
                    }
                    dates = new Date(domainEligibleCN.getTime()).toString();
                }
                debugLog = debugLog + "[dn=" + domain.getBaseDn() + "] [eligibleCN=" + domainEligibleCN + ", " + dates + "]";
            }
        }
        if (eligibleCN == null) {
            eligibleCN = new ChangeNumber(TimeThread.getTime(), 0, 0);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this + " getEligibleCN() ends with " + " the following domainEligibleCN for each domain :" + debugLog + " thus CrossDomainEligibleCN=" + eligibleCN + "  ts=" + (eligibleCN != null ? new Date(eligibleCN.getTime()).toString() : null));
        }
        return eligibleCN;
    }

    public synchronized DraftCNDbHandler getDraftCNDbHandler() throws DirectoryException {
        try {
            if (this.draftCNDbHandler == null) {
                this.draftCNDbHandler = new DraftCNDbHandler(this, this.dbEnv);
                if (this.draftCNDbHandler == null) {
                    return null;
                }
                this.lastGeneratedDraftCN = this.getLastDraftChangeNumber();
            }
            return this.draftCNDbHandler;
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_DRAFT_CHANGENUMBER_DATABASE.get(""));
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, mb.toMessage(), e);
        }
    }

    public int getFirstDraftChangeNumber() {
        int first = 0;
        if (this.draftCNDbHandler != null) {
            first = this.draftCNDbHandler.getFirstKey();
        }
        return first;
    }

    public int getLastDraftChangeNumber() {
        int last = 0;
        if (this.draftCNDbHandler != null) {
            last = this.draftCNDbHandler.getLastKey();
        }
        return last;
    }

    public synchronized int getNewDraftCN() {
        return ++this.lastGeneratedDraftCN;
    }

    public int[] getECLDraftCNLimits(ChangeNumber crossDomainEligibleCN, ArrayList<String> excludedServiceIDs) throws DirectoryException {
        int lastDraftCN;
        boolean DraftCNdbIsEmpty;
        DraftCNDbHandler draftCNDbH = this.getDraftCNDbHandler();
        int firstDraftCN = draftCNDbH.getFirstKey();
        HashMap<String, ServerState> domainsServerStateForLastSeqnum = null;
        if (firstDraftCN < 1) {
            DraftCNdbIsEmpty = true;
            firstDraftCN = 0;
            lastDraftCN = 0;
        } else {
            DraftCNdbIsEmpty = false;
            lastDraftCN = draftCNDbH.getLastKey();
            String lastSeqnumGenState = draftCNDbH.getValue(lastDraftCN);
            if (lastSeqnumGenState != null && lastSeqnumGenState.length() > 0) {
                domainsServerStateForLastSeqnum = MultiDomainServerState.splitGenStateToServerStates(lastSeqnumGenState);
            }
        }
        Iterator<ReplicationServerDomain> rsdi = this.getDomainIterator();
        if (rsdi != null) {
            while (rsdi.hasNext()) {
                ServerState domainServerStateForLastSeqnum;
                ReplicationServerDomain rsd = rsdi.next();
                if (excludedServiceIDs.contains(rsd.getBaseDn())) continue;
                long ec = 0L;
                if (domainsServerStateForLastSeqnum == null || domainsServerStateForLastSeqnum.get(rsd.getBaseDn()) == null) {
                    domainServerStateForLastSeqnum = new ServerState();
                } else {
                    domainServerStateForLastSeqnum = domainsServerStateForLastSeqnum.get(rsd.getBaseDn());
                    --ec;
                }
                ec = rsd.getEligibleCount(domainServerStateForLastSeqnum, crossDomainEligibleCN);
                if (ec > 0L && !DraftCNdbIsEmpty) {
                    --ec;
                }
                lastDraftCN = (int)((long)lastDraftCN + ec);
                if (ec <= 0L || firstDraftCN != 0) continue;
                firstDraftCN = 1;
            }
        }
        return new int[]{firstDraftCN, lastDraftCN};
    }

    public MultiDomainServerState getLastECLCookie(ArrayList<String> excludedServiceIDs) {
        this.disableEligibility(excludedServiceIDs);
        MultiDomainServerState result = new MultiDomainServerState();
        Iterator<ReplicationServerDomain> rsdk = this.getDomainIterator();
        if (rsdk != null) {
            while (rsdk.hasNext()) {
                ReplicationServerDomain rsd = rsdk.next();
                if (excludedServiceIDs != null && excludedServiceIDs.contains(rsd.getBaseDn()) || rsd.getDbServerState().isEmpty()) continue;
                result.update(rsd.getBaseDn(), rsd.getEligibleState(this.getEligibleCN(), false));
            }
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public static class GlobalServerId {
        private int serverId = -1;
        private String baseDn = null;

        public GlobalServerId(String baseDn, int serverId) {
            this.baseDn = baseDn;
            this.serverId = serverId;
        }

        public int getServerId() {
            return this.serverId;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + this.serverId;
            hash = 43 * hash + (this.baseDn != null ? this.baseDn.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof GlobalServerId)) {
                return false;
            }
            GlobalServerId globalServerId = (GlobalServerId)obj;
            return globalServerId.baseDn.equals(this.baseDn) && globalServerId.serverId == this.serverId;
        }
    }
}

