/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.server.LightweightServerHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServerHandler
extends ServerHandler {
    private String serverAddressURL;
    private final Map<Integer, LightweightServerHandler> remoteDirectoryServers = new ConcurrentHashMap<Integer, LightweightServerHandler>();

    public boolean processStartFromRemote(ReplServerStartMsg inReplServerStartMsg) throws DirectoryException {
        try {
            this.protocolVersion = ProtocolVersion.minWithCurrent(inReplServerStartMsg.getVersion());
            this.session.setProtocolVersion(this.protocolVersion);
            this.generationId = inReplServerStartMsg.getGenerationId();
            this.serverId = inReplServerStartMsg.getServerId();
            this.serverURL = inReplServerStartMsg.getServerURL();
            int separator = this.serverURL.lastIndexOf(58);
            this.serverAddressURL = this.session.getRemoteAddress() + ":" + this.serverURL.substring(separator + 1);
            this.setServiceIdAndDomain(inReplServerStartMsg.getBaseDn(), false);
            this.setInitialServerState(inReplServerStartMsg.getServerState());
            this.setSendWindowSize(inReplServerStartMsg.getWindowSize());
            if (this.protocolVersion > 1) {
                this.groupId = inReplServerStartMsg.getGroupId();
            }
            this.oldGenerationId = -100L;
        }
        catch (Exception e) {
            Message message = Message.raw(e.getLocalizedMessage(), new Object[0]);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return inReplServerStartMsg.getSSLEncryption();
    }

    private ReplServerStartMsg sendStartToRemote(short requestedProtocolVersion) throws IOException {
        ReplServerStartMsg outReplServerStartMsg = new ReplServerStartMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, this.replicationServerDomain.getDbServerState(), this.protocolVersion, this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold());
        this.session.publish(outReplServerStartMsg, requestedProtocolVersion);
        return outReplServerStartMsg;
    }

    public ReplicationServerHandler(ProtocolSession session, int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, int rcvWindowSize) {
        super(session, queueSize, replicationServerURL, replicationServerId, replicationServer, rcvWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String serviceId, boolean sslEncryption) throws DirectoryException {
        this.sslEncryption = sslEncryption;
        this.setServiceIdAndDomain(serviceId, false);
        this.oldGenerationId = this.localGenerationId = this.replicationServerDomain.getGenerationId();
        try {
            this.lockDomain(false);
            ReplServerStartMsg outReplServerStartMsg = this.sendStartToRemote(ProtocolVersion.getCurrentVersion());
            ReplicationMsg msg = this.session.receive();
            if (!(msg instanceof ReplServerStartMsg)) {
                Message message = ReplicationMessages.ERR_REPLICATION_PROTOCOL_MESSAGE_TYPE.get(msg.getClass().getCanonicalName(), "ReplServerStartMsg");
                this.abortStart(message);
                return;
            }
            this.processStartFromRemote((ReplServerStartMsg)msg);
            if (!this.replicationServerDomain.checkForDuplicateRS(this)) {
                this.abortStart(null);
                return;
            }
            this.logStartHandshakeSNDandRCV(outReplServerStartMsg, (ReplServerStartMsg)msg);
            if (!this.sslEncryption) {
                this.session.stopEncryption();
            }
            if (this.protocolVersion > 1) {
                TopologyMsg outTopoMsg = this.sendTopoToRemoteRS();
                TopologyMsg inTopoMsg = this.waitAndProcessTopoFromRemoteRS();
                this.logTopoHandshakeSNDandRCV(outTopoMsg, inTopoMsg);
                this.createMonitoringPublisher();
                this.registerIntoDomain();
                this.replicationServerDomain.receiveTopoInfoFromRS(inTopoMsg, this, false);
            }
            super.finalizeStart();
        }
        catch (IOException ioe) {
        }
        catch (Exception exception) {
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFromRemoteRS(ReplServerStartMsg inReplServerStartMsg) {
        this.localGenerationId = -1L;
        this.oldGenerationId = -100L;
        try {
            this.sslEncryption = this.processStartFromRemote(inReplServerStartMsg);
            this.lockDomain(true);
            if (!this.replicationServerDomain.checkForDuplicateRS(this)) {
                this.abortStart(null);
                return;
            }
            this.localGenerationId = this.replicationServerDomain.getGenerationId();
            ReplServerStartMsg outReplServerStartMsg = this.sendStartToRemote(this.protocolVersion);
            this.logStartHandshakeRCVandSND(inReplServerStartMsg, outReplServerStartMsg);
            if (!this.sslEncryption) {
                this.session.stopEncryption();
            }
            TopologyMsg inTopoMsg = null;
            if (this.protocolVersion > 1) {
                inTopoMsg = this.waitAndProcessTopoFromRemoteRS();
                TopologyMsg outTopoMsg = this.sendTopoToRemoteRS();
                this.logTopoHandshakeRCVandSND(inTopoMsg, outTopoMsg);
            } else if (this.generationId == this.localGenerationId) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + this + " RS V1 with serverID=" + this.serverId + " is connected with the right generation ID");
                }
            } else if (this.localGenerationId > 0L) {
                if (this.generationId > 0L && this.generationId != this.localGenerationId) {
                    if (this.replicationServerDomain.getGenerationIdSavedStatus()) {
                        Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.getServiceId(), Integer.toString(this.serverId), Long.toString(this.generationId), Long.toString(this.localGenerationId));
                        ErrorLogger.logError(message);
                    } else {
                        Message message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.getServiceId(), Integer.toString(this.serverId), Long.toString(this.generationId), Long.toString(this.localGenerationId));
                        ErrorLogger.logError(message);
                    }
                }
            } else {
                this.oldGenerationId = this.replicationServerDomain.changeGenerationId(this.generationId, false);
            }
            this.createMonitoringPublisher();
            this.registerIntoDomain();
            if (inTopoMsg != null) {
                this.replicationServerDomain.receiveTopoInfoFromRS(inTopoMsg, this, false);
            }
            super.finalizeStart();
        }
        catch (IOException ioe) {
            Message errMessage = ReplicationMessages.ERR_RS_DISCONNECTED_DURING_HANDSHAKE.get(Integer.toString(inReplServerStartMsg.getServerId()), Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            ErrorLogger.logError(errMessage);
            this.abortStart(errMessage);
        }
        catch (DirectoryException de) {
            this.abortStart(de.getMessageObject());
        }
        catch (Exception e) {
            this.abortStart(Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    private void registerIntoDomain() {
        Map<Integer, ReplicationServerHandler> connectedRSs = this.replicationServerDomain.getConnectedRSs();
        connectedRSs.put(this.serverId, this);
    }

    private TopologyMsg sendTopoToRemoteRS() throws IOException {
        TopologyMsg outTopoMsg = this.replicationServerDomain.createTopologyMsgForRS();
        this.session.publish(outTopoMsg, this.protocolVersion);
        return outTopoMsg;
    }

    private TopologyMsg waitAndProcessTopoFromRemoteRS() throws DirectoryException, IOException {
        ReplicationMsg msg = null;
        try {
            msg = this.session.receive();
        }
        catch (Exception e) {
            Message message = Message.raw(e.getLocalizedMessage(), new Object[0]);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        if (!(msg instanceof TopologyMsg)) {
            Message message = ReplicationMessages.ERR_REPLICATION_PROTOCOL_MESSAGE_TYPE.get(msg.getClass().getCanonicalName(), "TopologyMsg");
            this.abortStart(message);
        }
        TopologyMsg inTopoMsg = (TopologyMsg)msg;
        if (this.protocolVersion >= 4) {
            RSInfo rsInfo = inTopoMsg.getRsList().get(0);
            this.weight = rsInfo.getWeight();
        }
        if (this.generationId == this.localGenerationId) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " RS with serverID=" + this.serverId + " is connected with the right generation ID, same as local =" + this.generationId);
            }
        } else if (this.localGenerationId > 0L) {
            if (this.generationId > 0L && this.generationId != this.localGenerationId) {
                Message message;
                if (this.replicationServerDomain.getGenerationIdSavedStatus()) {
                    message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.getServiceId(), Integer.toString(this.serverId), Long.toString(this.generationId), Long.toString(this.localGenerationId));
                    ErrorLogger.logError(message);
                } else {
                    message = ReplicationMessages.NOTE_BAD_GENERATION_ID_FROM_RS.get(this.getServiceId(), Integer.toString(this.serverId), Long.toString(this.generationId), Long.toString(this.localGenerationId));
                    ErrorLogger.logError(message);
                }
            }
        } else {
            this.oldGenerationId = this.replicationServerDomain.changeGenerationId(this.generationId, false);
        }
        return inTopoMsg;
    }

    @Override
    public boolean isDataServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDSInfos(List<DSInfo> dsInfos) {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler ls : this.remoteDirectoryServers.values()) {
                dsInfos.add(ls.toDSInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler lsh : this.remoteDirectoryServers.values()) {
                lsh.stopHandler();
            }
            this.remoteDirectoryServers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTopoInfoFromRS(TopologyMsg topoMsg) {
        List<RSInfo> rsInfos = topoMsg.getRsList();
        RSInfo rsInfo = rsInfos.get(0);
        this.generationId = rsInfo.getGenerationId();
        this.groupId = rsInfo.getGroupId();
        this.weight = rsInfo.getWeight();
        List<DSInfo> dsInfos = topoMsg.getDsList();
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler lsh : this.remoteDirectoryServers.values()) {
                lsh.stopHandler();
            }
            this.remoteDirectoryServers.clear();
            for (DSInfo dsInfo : dsInfos) {
                LightweightServerHandler lsh = new LightweightServerHandler(this, this.serverId, dsInfo.getDsId(), dsInfo.getGenerationId(), dsInfo.getGroupId(), dsInfo.getStatus(), dsInfo.getRefUrls(), dsInfo.isAssured(), dsInfo.getAssuredMode(), dsInfo.getSafeDataLevel(), dsInfo.getEclIncludes(), dsInfo.getProtocolVersion());
                lsh.startHandler();
                this.remoteDirectoryServers.put(lsh.getServerId(), lsh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteLDAPServer(int wantedServer) {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler server : this.remoteDirectoryServers.values()) {
                if (wantedServer != server.getServerId()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteLDAPServers() {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            return !this.remoteDirectoryServers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getConnectedDirectoryServerIds() {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            return this.remoteDirectoryServers.keySet();
        }
    }

    @Override
    public String getMonitorInstanceName() {
        String str = this.serverURL + " " + String.valueOf(this.serverId);
        return "Connected Replication Server " + str + ",cn=" + this.replicationServerDomain.getMonitorInstanceName();
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        List attributes = super.getMonitorData();
        ((ArrayList)attributes).add(Attributes.create("Replication-Server", this.serverURL));
        try {
            MonitorData md = this.replicationServerDomain.computeMonitorData(true);
            long missingChanges = md.getMissingChangesRS(this.serverId);
            ((ArrayList)attributes).add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
            AttributeBuilder builder = new AttributeBuilder("server-state");
            ServerState state = md.getRSStates(this.serverId);
            if (state != null) {
                for (String str : state.toStringSet()) {
                    builder.add(str);
                }
                ((ArrayList)attributes).add(builder.toAttribute());
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_ERROR_RETRIEVING_MONITOR_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
            ((ArrayList)attributes).add(Attributes.create("error", message.toString()));
        }
        return attributes;
    }

    @Override
    public String toString() {
        String localString;
        if (this.serverId != 0) {
            localString = "Replication Server ";
            localString = localString + this.serverId + " " + this.serverURL + " " + this.getServiceId();
        } else {
            localString = "Unknown server";
        }
        return localString;
    }

    @Override
    public ServerStatus getStatus() {
        return ServerStatus.INVALID_STATUS;
    }

    public String getServerAddressURL() {
        return this.serverAddressURL;
    }

    public void receiveTopoInfoFromRS(TopologyMsg topoMsg) throws DirectoryException, IOException {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.receiveTopoInfoFromRS(topoMsg, this, true);
        }
    }
}

