/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthPasswordSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.4203.1.2.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("authPasswordExactMatch", "AuthenticationPasswordSyntax"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "AuthenticationPasswordSyntax";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    @Override
    public String getDescription() {
        return "Authentication Password Syntax";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        try {
            AuthPasswordSyntax.decodeAuthPassword(((Object)value).toString());
            return true;
        }
        catch (DirectoryException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    public static StringBuilder[] decodeAuthPassword(String authPasswordValue) throws DirectoryException {
        char c;
        int pos;
        StringBuilder scheme = new StringBuilder();
        StringBuilder authInfo = new StringBuilder();
        StringBuilder authValue = new StringBuilder();
        int length = authPasswordValue.length();
        for (pos = 0; pos < length && authPasswordValue.charAt(pos) == ' '; ++pos) {
        }
        block5: while (pos < length) {
            c = authPasswordValue.charAt(pos);
            switch (c) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': {
                    scheme.append(c);
                    ++pos;
                    break;
                }
                case ' ': 
                case '$': {
                    break block5;
                }
                default: {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_SCHEME_CHAR.get(pos);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
        if (scheme.length() == 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_SEPARATOR.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableString.isPrintableCharacter(c)) {
                authInfo.append(c);
                ++pos;
                continue;
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_INFO_CHAR.get(pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (scheme.length() == 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_SEPARATOR.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableString.isPrintableCharacter(c)) {
                authValue.append(c);
                ++pos;
                continue;
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_VALUE_CHAR.get(pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (scheme.length() == 0) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length) {
            c = authPasswordValue.charAt(pos);
            if (c == ' ') {
                ++pos;
                continue;
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_TRAILING_CHAR.get(pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return new StringBuilder[]{scheme, authInfo, authValue};
    }

    public static boolean isEncoded(ByteSequence value) {
        try {
            AuthPasswordSyntax.decodeAuthPassword(((Object)value).toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

