/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeneralizedTimeEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "generalizedTimeMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.27";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        try {
            long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value);
            return ByteString.valueOf(GeneralizedTimeSyntax.format(timestamp));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw de;
                }
                case WARN: {
                    ErrorLogger.logError(de.getMessageObject());
                    return value.toByteString();
                }
            }
            return value.toByteString();
        }
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        try {
            long time1 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value1);
            long time2 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value2);
            return time1 == time2;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return false;
        }
    }
}

